/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.system.products.teleport;

import com.mcmlr.blocks.api.Resources;
import com.mcmlr.blocks.api.data.Repository;
import com.mcmlr.system.dagger.AppScope;
import com.mcmlr.system.products.data.CooldownRepository;
import com.mcmlr.system.products.teleport.PlayerTeleportModel;
import com.mcmlr.system.products.teleport.TeleportConfigRepository;
import com.mcmlr.system.products.teleport.TeleportRequestModel;
import java.util.Date;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@AppScope
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B)\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lcom/mcmlr/system/products/teleport/PlayerTeleportRepository;", "Lcom/mcmlr/blocks/api/data/Repository;", "Lcom/mcmlr/system/products/teleport/PlayerTeleportModel;", "resources", "Lcom/mcmlr/blocks/api/Resources;", "player", "Lorg/bukkit/entity/Player;", "cooldownRepository", "Lcom/mcmlr/system/products/data/CooldownRepository;", "teleportConfigRepository", "Lcom/mcmlr/system/products/teleport/TeleportConfigRepository;", "<init>", "(Lcom/mcmlr/blocks/api/Resources;Lorg/bukkit/entity/Player;Lcom/mcmlr/system/products/data/CooldownRepository;Lcom/mcmlr/system/products/teleport/TeleportConfigRepository;)V", "selectedPlayer", "getSelectedPlayer", "()Lorg/bukkit/entity/Player;", "setSelectedPlayer", "(Lorg/bukkit/entity/Player;)V", "selectedRequest", "Lcom/mcmlr/system/products/teleport/TeleportRequestModel;", "getSelectedRequest", "()Lcom/mcmlr/system/products/teleport/TeleportRequestModel;", "setSelectedRequest", "(Lcom/mcmlr/system/products/teleport/TeleportRequestModel;)V", "teleport", "", "destination", "canTeleport", "", "system"})
public final class PlayerTeleportRepository
extends Repository<PlayerTeleportModel> {
    @NotNull
    private final Player player;
    @NotNull
    private final CooldownRepository cooldownRepository;
    @NotNull
    private final TeleportConfigRepository teleportConfigRepository;
    @Nullable
    private Player selectedPlayer;
    @Nullable
    private TeleportRequestModel selectedRequest;

    @Inject
    public PlayerTeleportRepository(@NotNull Resources resources, @NotNull Player player2, @NotNull CooldownRepository cooldownRepository, @NotNull TeleportConfigRepository teleportConfigRepository) {
        Intrinsics.checkNotNullParameter(resources, "resources");
        Intrinsics.checkNotNullParameter(player2, "player");
        Intrinsics.checkNotNullParameter(cooldownRepository, "cooldownRepository");
        Intrinsics.checkNotNullParameter(teleportConfigRepository, "teleportConfigRepository");
        super(resources.dataFolder());
        this.player = player2;
        this.cooldownRepository = cooldownRepository;
        this.teleportConfigRepository = teleportConfigRepository;
        Repository repository = this;
        String string = this.player.getUniqueId().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        Repository.loadModel$default(repository, "Spawn/Players", string, new PlayerTeleportModel(false, null, 3, null), null, 8, null);
    }

    @Nullable
    public final Player getSelectedPlayer() {
        return this.selectedPlayer;
    }

    public final void setSelectedPlayer(@Nullable Player player2) {
        this.selectedPlayer = player2;
    }

    @Nullable
    public final TeleportRequestModel getSelectedRequest() {
        return this.selectedRequest;
    }

    public final void setSelectedRequest(@Nullable TeleportRequestModel teleportRequestModel) {
        this.selectedRequest = teleportRequestModel;
    }

    public final void teleport(@NotNull Player player2, @NotNull Player destination) {
        Intrinsics.checkNotNullParameter(player2, "player");
        Intrinsics.checkNotNullParameter(destination, "destination");
        player2.teleport(destination.getLocation());
        this.cooldownRepository.addPlayerLastTeleportTime(player2);
    }

    public final long canTeleport(@NotNull Player player2) {
        Intrinsics.checkNotNullParameter(player2, "player");
        long lastTeleport = this.cooldownRepository.getPlayerLastTeleportTime(player2);
        return lastTeleport + (long)(this.teleportConfigRepository.cooldown() * 1000) - new Date().getTime();
    }
}

