/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.system.products.teleport;

import com.mcmlr.blocks.api.block.Interactor;
import com.mcmlr.system.products.teleport.PlayerTeleportRepository;
import com.mcmlr.system.products.teleport.TeleportPresenter;
import com.mcmlr.system.products.teleport.TeleportRepository;
import com.mcmlr.system.products.teleport.TeleportRequestBlock;
import com.mcmlr.system.products.teleport.TeleportRequestModel;
import com.mcmlr.system.products.teleport.TeleportResponseBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/mcmlr/system/products/teleport/TeleportInteractor;", "Lcom/mcmlr/blocks/api/block/Interactor;", "player", "Lorg/bukkit/entity/Player;", "presenter", "Lcom/mcmlr/system/products/teleport/TeleportPresenter;", "teleportRequestBlock", "Lcom/mcmlr/system/products/teleport/TeleportRequestBlock;", "teleportResponseBlock", "Lcom/mcmlr/system/products/teleport/TeleportResponseBlock;", "teleportRepository", "Lcom/mcmlr/system/products/teleport/TeleportRepository;", "playerTeleportRepository", "Lcom/mcmlr/system/products/teleport/PlayerTeleportRepository;", "<init>", "(Lorg/bukkit/entity/Player;Lcom/mcmlr/system/products/teleport/TeleportPresenter;Lcom/mcmlr/system/products/teleport/TeleportRequestBlock;Lcom/mcmlr/system/products/teleport/TeleportResponseBlock;Lcom/mcmlr/system/products/teleport/TeleportRepository;Lcom/mcmlr/system/products/teleport/PlayerTeleportRepository;)V", "onCreate", "", "gotoRequestList", "gotoPlayerList", "system"})
@SourceDebugExtension(value={"SMAP\nTeleportBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeleportBlock.kt\ncom/mcmlr/system/products/teleport/TeleportInteractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,295:1\n1563#2:296\n1634#2,3:297\n*S KotlinDebug\n*F\n+ 1 TeleportBlock.kt\ncom/mcmlr/system/products/teleport/TeleportInteractor\n*L\n280#1:296\n280#1:297,3\n*E\n"})
public final class TeleportInteractor
extends Interactor {
    @NotNull
    private final Player player;
    @NotNull
    private final TeleportPresenter presenter;
    @NotNull
    private final TeleportRequestBlock teleportRequestBlock;
    @NotNull
    private final TeleportResponseBlock teleportResponseBlock;
    @NotNull
    private final TeleportRepository teleportRepository;
    @NotNull
    private final PlayerTeleportRepository playerTeleportRepository;

    public TeleportInteractor(@NotNull Player player2, @NotNull TeleportPresenter presenter, @NotNull TeleportRequestBlock teleportRequestBlock, @NotNull TeleportResponseBlock teleportResponseBlock, @NotNull TeleportRepository teleportRepository, @NotNull PlayerTeleportRepository playerTeleportRepository) {
        Intrinsics.checkNotNullParameter(player2, "player");
        Intrinsics.checkNotNullParameter(presenter, "presenter");
        Intrinsics.checkNotNullParameter(teleportRequestBlock, "teleportRequestBlock");
        Intrinsics.checkNotNullParameter(teleportResponseBlock, "teleportResponseBlock");
        Intrinsics.checkNotNullParameter(teleportRepository, "teleportRepository");
        Intrinsics.checkNotNullParameter(playerTeleportRepository, "playerTeleportRepository");
        super(presenter);
        this.player = player2;
        this.presenter = presenter;
        this.teleportRequestBlock = teleportRequestBlock;
        this.teleportResponseBlock = teleportResponseBlock;
        this.teleportRepository = teleportRepository;
        this.playerTeleportRepository = playerTeleportRepository;
    }

    @Override
    public void onCreate() {
        super.onCreate();
        this.gotoPlayerList();
        this.presenter.setPlayersButtonCallback(() -> TeleportInteractor.onCreate$lambda$0(this));
        this.presenter.setRequestsButtonCallback(() -> TeleportInteractor.onCreate$lambda$1(this));
    }

    private final void gotoRequestList() {
        UUID uUID = this.player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        List<TeleportRequestModel> requests = this.teleportRepository.getRequests(uUID);
        this.presenter.setRequestList(requests, arg_0 -> TeleportInteractor.gotoRequestList$lambda$2(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final void gotoPlayerList() {
        void $this$mapTo$iv$iv;
        UUID uUID = this.player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        Iterable $this$map$iv = this.teleportRepository.getOnlinePlayers(uUID);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Player player2 = (Player)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ItemStack head = new ItemStack(Material.PLAYER_HEAD);
            ItemMeta itemMeta = head.getItemMeta();
            Intrinsics.checkNotNull(itemMeta, "null cannot be cast to non-null type org.bukkit.inventory.meta.SkullMeta");
            SkullMeta headMeta = (SkullMeta)itemMeta;
            headMeta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)it.getUniqueId()));
            head.setItemMeta((ItemMeta)headMeta);
            collection.add(new Pair<void, ItemStack>(it, head));
        }
        List players = (List)destination$iv$iv;
        this.presenter.setPlayerList(players, arg_0 -> TeleportInteractor.gotoPlayerList$lambda$4(this, arg_0));
    }

    private static final Unit onCreate$lambda$0(TeleportInteractor this$0) {
        this$0.gotoPlayerList();
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$1(TeleportInteractor this$0) {
        this$0.gotoRequestList();
        return Unit.INSTANCE;
    }

    private static final Unit gotoRequestList$lambda$2(TeleportInteractor this$0, TeleportRequestModel it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.playerTeleportRepository.setSelectedRequest(it);
        Interactor.routeTo$default(this$0, this$0.teleportResponseBlock, null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit gotoPlayerList$lambda$4(TeleportInteractor this$0, Player it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.playerTeleportRepository.setSelectedPlayer(it);
        Interactor.routeTo$default(this$0, this$0.teleportRequestBlock, null, 2, null);
        return Unit.INSTANCE;
    }
}

