/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.system.products.announcements;

import com.mcmlr.apps.app.block.data.Bundle;
import com.mcmlr.blocks.api.block.Interactor;
import com.mcmlr.blocks.core.StringExtKt;
import com.mcmlr.system.placeholder.PlaceholderAPIWrapperKt;
import com.mcmlr.system.products.announcements.AnnouncementCTAType;
import com.mcmlr.system.products.announcements.AnnouncementEditorPresenter;
import com.mcmlr.system.products.announcements.AnnouncementEditorResult;
import com.mcmlr.system.products.announcements.AnnouncementModel;
import com.mcmlr.system.products.announcements.AnnouncementsRepository;
import com.mcmlr.system.products.support.TextEditorBlock;
import com.mcmlr.system.products.support.TextModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.Job;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u000e\u0010\u001a\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/mcmlr/system/products/announcements/AnnouncementEditorInteractor;", "Lcom/mcmlr/blocks/api/block/Interactor;", "player", "Lorg/bukkit/entity/Player;", "presenter", "Lcom/mcmlr/system/products/announcements/AnnouncementEditorPresenter;", "announcementsRepository", "Lcom/mcmlr/system/products/announcements/AnnouncementsRepository;", "textEditorBlock", "Lcom/mcmlr/system/products/support/TextEditorBlock;", "<init>", "(Lorg/bukkit/entity/Player;Lcom/mcmlr/system/products/announcements/AnnouncementEditorPresenter;Lcom/mcmlr/system/products/announcements/AnnouncementsRepository;Lcom/mcmlr/system/products/support/TextEditorBlock;)V", "builder", "Lcom/mcmlr/system/products/announcements/AnnouncementModel$Builder;", "getBuilder", "()Lcom/mcmlr/system/products/announcements/AnnouncementModel$Builder;", "setBuilder", "(Lcom/mcmlr/system/products/announcements/AnnouncementModel$Builder;)V", "isUpdating", "", "()Z", "setUpdating", "(Z)V", "savePost", "getSavePost", "setSavePost", "ctaEnabled", "onCreate", "", "system"})
@SourceDebugExtension(value={"SMAP\nAnnouncementEditorBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnouncementEditorBlock.kt\ncom/mcmlr/system/products/announcements/AnnouncementEditorInteractor\n+ 2 Bundle.kt\ncom/mcmlr/apps/app/block/data/Bundle\n*L\n1#1,577:1\n14#2:578\n13#2,4:579\n*S KotlinDebug\n*F\n+ 1 AnnouncementEditorBlock.kt\ncom/mcmlr/system/products/announcements/AnnouncementEditorInteractor\n*L\n543#1:578\n543#1:579,4\n*E\n"})
public final class AnnouncementEditorInteractor
extends Interactor {
    @NotNull
    private final Player player;
    @NotNull
    private final AnnouncementEditorPresenter presenter;
    @NotNull
    private final AnnouncementsRepository announcementsRepository;
    @NotNull
    private final TextEditorBlock textEditorBlock;
    @NotNull
    private AnnouncementModel.Builder builder;
    private boolean isUpdating;
    private boolean savePost;
    private boolean ctaEnabled;

    public AnnouncementEditorInteractor(@NotNull Player player2, @NotNull AnnouncementEditorPresenter presenter, @NotNull AnnouncementsRepository announcementsRepository, @NotNull TextEditorBlock textEditorBlock) {
        Intrinsics.checkNotNullParameter(player2, "player");
        Intrinsics.checkNotNullParameter(presenter, "presenter");
        Intrinsics.checkNotNullParameter(announcementsRepository, "announcementsRepository");
        Intrinsics.checkNotNullParameter(textEditorBlock, "textEditorBlock");
        super(presenter);
        this.player = player2;
        this.presenter = presenter;
        this.announcementsRepository = announcementsRepository;
        this.textEditorBlock = textEditorBlock;
        this.builder = new AnnouncementModel.Builder();
        this.savePost = true;
    }

    @NotNull
    public final AnnouncementModel.Builder getBuilder() {
        return this.builder;
    }

    public final void setBuilder(@NotNull AnnouncementModel.Builder builder) {
        Intrinsics.checkNotNullParameter(builder, "<set-?>");
        this.builder = builder;
    }

    public final boolean isUpdating() {
        return this.isUpdating;
    }

    public final void setUpdating(boolean bl) {
        this.isUpdating = bl;
    }

    public final boolean getSavePost() {
        return this.savePost;
    }

    public final void setSavePost(boolean bl) {
        this.savePost = bl;
    }

    @Override
    public void onCreate() {
        super.onCreate();
        AnnouncementEditorPresenter.setEditorFeed$default(this.presenter, this.builder, false, 2, null);
        this.presenter.setIsUpdating(this.isUpdating);
        if (this.builder.getAuthorId() == null) {
            this.builder.setAuthorId(this.player.getUniqueId().toString());
        }
        this.presenter.setCreatePostListener(() -> AnnouncementEditorInteractor.onCreate$lambda$0(this));
        this.presenter.setDeletePostListener(() -> AnnouncementEditorInteractor.onCreate$lambda$1(this));
        this.presenter.setTitleListener(arg_0 -> AnnouncementEditorInteractor.onCreate$lambda$2(this, arg_0));
        this.presenter.setMessageListener(() -> AnnouncementEditorInteractor.onCreate$lambda$4(this));
        this.presenter.setCTATextListener(arg_0 -> AnnouncementEditorInteractor.onCreate$lambda$5(this, arg_0));
        this.presenter.setCTAActionListener(arg_0 -> AnnouncementEditorInteractor.onCreate$lambda$6(this, arg_0));
        this.presenter.setCTAActionTypeListener(() -> AnnouncementEditorInteractor.onCreate$lambda$7(this));
        this.presenter.setEnableCTAListener(() -> AnnouncementEditorInteractor.onCreate$lambda$8(this));
    }

    private static final Unit onCreate$lambda$0(AnnouncementEditorInteractor this$0) {
        String errorMessage;
        String string = this$0.builder.getTitle() == null ? "You need to set a title first!" : (this$0.builder.getMessage() == null ? "You need to set a message first!" : (this$0.ctaEnabled && this$0.builder.getCtaText() == null ? "You need to set the CTA text first or disable the CTA!" : (errorMessage = this$0.ctaEnabled && this$0.builder.getCta() == null ? "You need to set the CTA action first or disable the CTA!" : null)));
        if (errorMessage == null) {
            AnnouncementModel announcementModel = this$0.builder.build();
            if (announcementModel == null) {
                return Unit.INSTANCE;
            }
            AnnouncementModel announcement = announcementModel;
            if (this$0.savePost) {
                Job job = this$0.isUpdating ? this$0.announcementsRepository.updateAnnouncement(announcement) : this$0.announcementsRepository.addAnnouncement(announcement);
                this$0.addBundleData("announcement", (Object)(this$0.isUpdating ? AnnouncementEditorResult.UPDATE : AnnouncementEditorResult.CREATE));
            } else {
                this$0.addBundleData("announcement", announcement);
            }
            this$0.routeBack();
        } else {
            this$0.presenter.setErrorMessage(ChatColor.RED + errorMessage);
        }
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$1(AnnouncementEditorInteractor this$0) {
        AnnouncementModel announcementModel = this$0.builder.build();
        if (announcementModel == null) {
            return Unit.INSTANCE;
        }
        AnnouncementModel announcement = announcementModel;
        this$0.announcementsRepository.removeAnnouncement(announcement);
        this$0.addBundleData("announcement", (Object)AnnouncementEditorResult.DELETE);
        this$0.routeBack();
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$2(AnnouncementEditorInteractor this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String title = StringExtKt.colorize(PlaceholderAPIWrapperKt.placeholders(it, this$0.player));
        this$0.presenter.setTitleText(title);
        this$0.builder.setTitle(title);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit onCreate$lambda$4$lambda$3(AnnouncementEditorInteractor this$0, Bundle bundle) {
        TextModel textModel;
        void this_$iv;
        Intrinsics.checkNotNullParameter(bundle, "bundle");
        Bundle bundle2 = bundle;
        String key$iv = "text";
        boolean $i$f$getData = false;
        Object object = this_$iv.getMap().get(key$iv);
        if (object == null) {
            textModel = null;
        } else {
            Object datum$iv = object;
            Object object2 = datum$iv;
            if (!(object2 instanceof TextModel)) {
                object2 = null;
            }
            TextModel textModel2 = (TextModel)object2;
            if (textModel2 != null) {
                TextModel it$iv = textModel2;
                boolean bl = false;
                textModel = it$iv;
            } else {
                textModel = null;
            }
        }
        if (textModel == null) {
            return Unit.INSTANCE;
        }
        TextModel model = textModel;
        this$0.builder.setMessage(model);
        this$0.presenter.setEditorFeed(this$0.builder, this$0.ctaEnabled);
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$4(AnnouncementEditorInteractor this$0) {
        this$0.textEditorBlock.setTextModel(this$0.builder.getMessage());
        this$0.routeTo(this$0.textEditorBlock, arg_0 -> AnnouncementEditorInteractor.onCreate$lambda$4$lambda$3(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$5(AnnouncementEditorInteractor this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String message = StringExtKt.colorize(PlaceholderAPIWrapperKt.placeholders(it, this$0.player));
        this$0.builder.setCtaText(message);
        this$0.presenter.setCTAText(message);
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$6(AnnouncementEditorInteractor this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.builder.setCta(it);
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$7(AnnouncementEditorInteractor this$0) {
        AnnouncementCTAType newType = (AnnouncementCTAType)((Object)AnnouncementCTAType.getEntries().get((this$0.builder.getCtaType().ordinal() + 1) % AnnouncementCTAType.getEntries().size()));
        this$0.builder.setCtaType(newType);
        this$0.presenter.setCTAActionType(ChatColor.GOLD + StringExtKt.titlecase(newType.toString()));
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$8(AnnouncementEditorInteractor this$0) {
        this$0.ctaEnabled = !this$0.ctaEnabled;
        this$0.presenter.setEditorFeed(this$0.builder, this$0.ctaEnabled);
        return Unit.INSTANCE;
    }
}

