/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.system.products.teleport;

import com.mcmlr.blocks.api.block.Interactor;
import com.mcmlr.system.products.data.NotificationManager;
import com.mcmlr.system.products.teleport.PlayerTeleportRepository;
import com.mcmlr.system.products.teleport.TeleportRepository;
import com.mcmlr.system.products.teleport.TeleportRequestPresenter;
import com.mcmlr.system.products.teleport.TeleportRequestType;
import com.mcmlr.system.products.teleport.TeleportStatus;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/mcmlr/system/products/teleport/TeleportRequestInteractor;", "Lcom/mcmlr/blocks/api/block/Interactor;", "player", "Lorg/bukkit/entity/Player;", "presenter", "Lcom/mcmlr/system/products/teleport/TeleportRequestPresenter;", "teleportRepository", "Lcom/mcmlr/system/products/teleport/TeleportRepository;", "playerTeleportRepository", "Lcom/mcmlr/system/products/teleport/PlayerTeleportRepository;", "notificationManager", "Lcom/mcmlr/system/products/data/NotificationManager;", "<init>", "(Lorg/bukkit/entity/Player;Lcom/mcmlr/system/products/teleport/TeleportRequestPresenter;Lcom/mcmlr/system/products/teleport/TeleportRepository;Lcom/mcmlr/system/products/teleport/PlayerTeleportRepository;Lcom/mcmlr/system/products/data/NotificationManager;)V", "onCreate", "", "system"})
public final class TeleportRequestInteractor
extends Interactor {
    @NotNull
    private final Player player;
    @NotNull
    private final TeleportRequestPresenter presenter;
    @NotNull
    private final TeleportRepository teleportRepository;
    @NotNull
    private final PlayerTeleportRepository playerTeleportRepository;
    @NotNull
    private final NotificationManager notificationManager;

    public TeleportRequestInteractor(@NotNull Player player2, @NotNull TeleportRequestPresenter presenter, @NotNull TeleportRepository teleportRepository, @NotNull PlayerTeleportRepository playerTeleportRepository, @NotNull NotificationManager notificationManager) {
        Intrinsics.checkNotNullParameter(player2, "player");
        Intrinsics.checkNotNullParameter(presenter, "presenter");
        Intrinsics.checkNotNullParameter(teleportRepository, "teleportRepository");
        Intrinsics.checkNotNullParameter(playerTeleportRepository, "playerTeleportRepository");
        Intrinsics.checkNotNullParameter(notificationManager, "notificationManager");
        super(presenter);
        this.player = player2;
        this.presenter = presenter;
        this.teleportRepository = teleportRepository;
        this.playerTeleportRepository = playerTeleportRepository;
        this.notificationManager = notificationManager;
    }

    @Override
    public void onCreate() {
        super.onCreate();
        Player player2 = this.playerTeleportRepository.getSelectedPlayer();
        if (player2 == null) {
            return;
        }
        Player player3 = player2;
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        ItemMeta itemMeta = head.getItemMeta();
        Intrinsics.checkNotNull(itemMeta, "null cannot be cast to non-null type org.bukkit.inventory.meta.SkullMeta");
        SkullMeta headMeta = (SkullMeta)itemMeta;
        headMeta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)player3.getUniqueId()));
        head.setItemMeta((ItemMeta)headMeta);
        String string = player3.getDisplayName();
        Intrinsics.checkNotNullExpressionValue(string, "getDisplayName(...)");
        this.presenter.setPlayer(head, string);
        this.presenter.setTpaCallback(() -> TeleportRequestInteractor.onCreate$lambda$0(this, player3));
        this.presenter.setTpaHereCallback(() -> TeleportRequestInteractor.onCreate$lambda$1(this, player3));
    }

    private static final Unit onCreate$lambda$0(TeleportRequestInteractor this$0, Player $player) {
        TeleportStatus status = this$0.teleportRepository.sendRequest(this$0.player, $player, TeleportRequestType.GOTO);
        this$0.presenter.updateRequestStatus(status);
        if (status != TeleportStatus.FAILED) {
            this$0.notificationManager.sendCTAMessage($player, ChatColor.GRAY + ChatColor.ITALIC + this$0.player.getDisplayName() + " requested to teleport to you", "Open the teleport menu", "Click to respond", "/. teleport://");
        }
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$1(TeleportRequestInteractor this$0, Player $player) {
        TeleportStatus status = this$0.teleportRepository.sendRequest(this$0.player, $player, TeleportRequestType.COME);
        this$0.presenter.updateRequestStatus(status);
        if (status != TeleportStatus.FAILED) {
            this$0.notificationManager.sendCTAMessage($player, ChatColor.GRAY + ChatColor.ITALIC + this$0.player.getDisplayName() + " requested you to teleport to them", "Open the teleport menu", "Click to respond", "/. teleport://");
        }
        return Unit.INSTANCE;
    }
}

