/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.apps;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.mcmlr.apps.Apps;
import com.mcmlr.apps.Apps_MembersInjector;
import com.mcmlr.apps.EventHandlerFactory;
import com.mcmlr.apps.EventHandlerFactory_Factory;
import com.mcmlr.apps.ManagerComponent;
import com.mcmlr.apps.ManagerModule_CursorRepositoryFactory;
import com.mcmlr.apps.ManagerModule_DataFolderFactory;
import com.mcmlr.apps.ManagerModule_InputRepositoryFactory;
import com.mcmlr.apps.ManagerModule_PlayerChatRepositoryFactory;
import com.mcmlr.apps.ManagerModule_PluginFactory;
import com.mcmlr.apps.ManagerModule_ResourcesFactory;
import com.mcmlr.apps.ManagerModule_ServerFactory;
import com.mcmlr.apps.PacketManager;
import com.mcmlr.apps.PacketManager_Factory;
import com.mcmlr.apps.PlayerCursorCaptureTask;
import com.mcmlr.apps.PlayerCursorCaptureTask_Factory;
import com.mcmlr.blocks.api.Resources;
import com.mcmlr.blocks.api.data.CursorRepository;
import com.mcmlr.blocks.api.data.InputRepository;
import com.mcmlr.blocks.api.data.PlayerChatRepository;
import com.mcmlr.system.CommandRepository;
import com.mcmlr.system.CommandRepository_Factory;
import com.mcmlr.system.PlayerEventRepository;
import com.mcmlr.system.PlayerEventRepository_Factory;
import com.mcmlr.system.SystemConfigRepository;
import com.mcmlr.system.SystemConfigRepository_Factory;
import com.mcmlr.system.products.data.NotificationManager;
import com.mcmlr.system.products.data.NotificationManager_Factory;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import java.io.File;
import org.bukkit.Server;
import org.bukkit.plugin.java.JavaPlugin;

@DaggerGenerated
public final class DaggerManagerComponent {
    private DaggerManagerComponent() {
    }

    public static ManagerComponent.Builder builder() {
        return new Builder();
    }

    private static final class Builder
    implements ManagerComponent.Builder {
        private Apps plugin;

        private Builder() {
        }

        @Override
        public Builder plugin(Apps plugin) {
            this.plugin = Preconditions.checkNotNull(plugin);
            return this;
        }

        @Override
        public ManagerComponent build() {
            Preconditions.checkBuilderRequirement(this.plugin, Apps.class);
            return new ManagerComponentImpl(this.plugin);
        }
    }

    private static final class ManagerComponentImpl
    implements ManagerComponent {
        private final ManagerComponentImpl managerComponentImpl = this;
        Provider<CommandRepository> commandRepositoryProvider;
        Provider<CursorRepository> cursorRepositoryProvider;
        Provider<PlayerChatRepository> playerChatRepositoryProvider;
        Provider<PlayerEventRepository> playerEventRepositoryProvider;
        Provider<InputRepository> inputRepositoryProvider;
        Provider<EventHandlerFactory> eventHandlerFactoryProvider;
        Provider<PacketManager> packetManagerProvider;
        Provider<PlayerCursorCaptureTask> playerCursorCaptureTaskProvider;
        Provider<Apps> pluginProvider;
        Provider<Server> serverProvider;
        Provider<JavaPlugin> pluginProvider2;
        Provider<File> dataFolderProvider;
        Provider<Resources> resourcesProvider;
        Provider<NotificationManager> notificationManagerProvider;
        Provider<SystemConfigRepository> systemConfigRepositoryProvider;

        ManagerComponentImpl(Apps pluginParam) {
            this.initialize(pluginParam);
        }

        private void initialize(Apps pluginParam) {
            this.commandRepositoryProvider = DoubleCheck.provider(CommandRepository_Factory.create());
            this.cursorRepositoryProvider = DoubleCheck.provider(ManagerModule_CursorRepositoryFactory.create());
            this.playerChatRepositoryProvider = DoubleCheck.provider(ManagerModule_PlayerChatRepositoryFactory.create());
            this.playerEventRepositoryProvider = DoubleCheck.provider(PlayerEventRepository_Factory.create());
            this.inputRepositoryProvider = DoubleCheck.provider(ManagerModule_InputRepositoryFactory.create());
            this.eventHandlerFactoryProvider = DoubleCheck.provider(EventHandlerFactory_Factory.create(this.commandRepositoryProvider, this.cursorRepositoryProvider, this.playerChatRepositoryProvider, this.playerEventRepositoryProvider, this.inputRepositoryProvider));
            this.packetManagerProvider = DoubleCheck.provider(PacketManager_Factory.create(this.cursorRepositoryProvider));
            this.playerCursorCaptureTaskProvider = DoubleCheck.provider(PlayerCursorCaptureTask_Factory.create(this.inputRepositoryProvider));
            this.pluginProvider = InstanceFactory.create(pluginParam);
            this.serverProvider = ManagerModule_ServerFactory.create(this.pluginProvider);
            this.pluginProvider2 = ManagerModule_PluginFactory.create(this.pluginProvider);
            this.dataFolderProvider = ManagerModule_DataFolderFactory.create(this.pluginProvider);
            this.resourcesProvider = DoubleCheck.provider(ManagerModule_ResourcesFactory.create(this.serverProvider, this.pluginProvider2, this.dataFolderProvider));
            this.notificationManagerProvider = DoubleCheck.provider(NotificationManager_Factory.create());
            this.systemConfigRepositoryProvider = DoubleCheck.provider(SystemConfigRepository_Factory.create(this.resourcesProvider));
        }

        @Override
        public void inject(Apps plugin) {
            this.injectApps(plugin);
        }

        @CanIgnoreReturnValue
        private Apps injectApps(Apps instance) {
            Apps_MembersInjector.injectEventHandler(instance, (EventHandlerFactory)this.eventHandlerFactoryProvider.get());
            Apps_MembersInjector.injectCommandRepository(instance, (CommandRepository)this.commandRepositoryProvider.get());
            Apps_MembersInjector.injectPlayerChatRepository(instance, (PlayerChatRepository)this.playerChatRepositoryProvider.get());
            Apps_MembersInjector.injectPlayerEventRepository(instance, (PlayerEventRepository)this.playerEventRepositoryProvider.get());
            Apps_MembersInjector.injectInputRepository(instance, (InputRepository)this.inputRepositoryProvider.get());
            Apps_MembersInjector.injectPacketManager(instance, (PacketManager)this.packetManagerProvider.get());
            Apps_MembersInjector.injectPlayerCursorCaptureTask(instance, (PlayerCursorCaptureTask)((Object)this.playerCursorCaptureTaskProvider.get()));
            Apps_MembersInjector.injectResources(instance, (Resources)this.resourcesProvider.get());
            Apps_MembersInjector.injectNotificationManager(instance, (NotificationManager)this.notificationManagerProvider.get());
            Apps_MembersInjector.injectSystemConfigRepository(instance, (SystemConfigRepository)this.systemConfigRepositoryProvider.get());
            return instance;
        }
    }
}

