/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.blocks.api.app;

import com.mcmlr.blocks.api.Resources;
import com.mcmlr.blocks.api.app.BaseApp;
import com.mcmlr.blocks.core.FlowDisposer;
import java.net.URL;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010\u000e\u001a\u00020\rH&J\u0015\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u0011H&\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H&J\b\u0010\u0015\u001a\u00020\u0014H&J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0014H&J\b\u0010\u0017\u001a\u00020\u0014H&J\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0014H\u0002R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/mcmlr/blocks/api/app/BaseEnvironment;", "T", "Lcom/mcmlr/blocks/api/app/BaseApp;", "Lcom/mcmlr/blocks/core/FlowDisposer;", "<init>", "()V", "resources", "Lcom/mcmlr/blocks/api/Resources;", "getResources", "()Lcom/mcmlr/blocks/api/Resources;", "setResources", "(Lcom/mcmlr/blocks/api/Resources;)V", "configure", "", "build", "getInstance", "player", "Lorg/bukkit/entity/Player;", "(Lorg/bukkit/entity/Player;)Lcom/mcmlr/blocks/api/app/BaseApp;", "name", "", "icon", "permission", "summary", "getAppIcon", "Lorg/bukkit/inventory/ItemStack;", "getProfile", "Lorg/bukkit/profile/PlayerProfile;", "url", "block"})
public abstract class BaseEnvironment<T extends BaseApp>
extends FlowDisposer {
    public Resources resources;

    @NotNull
    public final Resources getResources() {
        Resources resources = this.resources;
        if (resources != null) {
            return resources;
        }
        Intrinsics.throwUninitializedPropertyAccessException("resources");
        return null;
    }

    public final void setResources(@NotNull Resources resources) {
        Intrinsics.checkNotNullParameter(resources, "<set-?>");
        this.resources = resources;
    }

    public final void configure(@NotNull Resources resources) {
        Intrinsics.checkNotNullParameter(resources, "resources");
        this.setResources(resources);
    }

    public abstract void build();

    @NotNull
    public abstract T getInstance(@NotNull Player var1);

    @NotNull
    public abstract String name();

    @NotNull
    public abstract String icon();

    @Nullable
    public abstract String permission();

    @NotNull
    public abstract String summary();

    @NotNull
    public final ItemStack getAppIcon() {
        ItemStack item = new ItemStack(Material.PLAYER_HEAD);
        ItemMeta itemMeta = item.getItemMeta();
        Intrinsics.checkNotNull(itemMeta, "null cannot be cast to non-null type org.bukkit.inventory.meta.SkullMeta");
        SkullMeta meta = (SkullMeta)itemMeta;
        meta.setOwnerProfile(this.getProfile(this.icon()));
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    private final PlayerProfile getProfile(String url) {
        PlayerProfile playerProfile = Bukkit.createPlayerProfile((UUID)UUID.randomUUID());
        Intrinsics.checkNotNullExpressionValue(playerProfile, "createPlayerProfile(...)");
        PlayerProfile profile = playerProfile;
        PlayerTextures playerTextures = profile.getTextures();
        Intrinsics.checkNotNullExpressionValue(playerTextures, "getTextures(...)");
        PlayerTextures textures = playerTextures;
        textures.setSkin(new URL(url));
        profile.setTextures(textures);
        return profile;
    }
}

