/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.system.products.kits;

import com.mcmlr.blocks.api.block.Interactor;
import com.mcmlr.blocks.core.DudeDispatcher;
import com.mcmlr.blocks.core.FlowExtKt;
import com.mcmlr.system.products.data.VaultRepository;
import com.mcmlr.system.products.kits.CreateKitBlock;
import com.mcmlr.system.products.kits.KitModel;
import com.mcmlr.system.products.kits.KitRepository;
import com.mcmlr.system.products.kits.KitsPagerAdapter;
import com.mcmlr.system.products.kits.KitsPresenter;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.Flow;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/mcmlr/system/products/kits/KitsInteractor;", "Lcom/mcmlr/blocks/api/block/Interactor;", "player", "Lorg/bukkit/entity/Player;", "presenter", "Lcom/mcmlr/system/products/kits/KitsPresenter;", "createKitBlock", "Lcom/mcmlr/system/products/kits/CreateKitBlock;", "kitRepository", "Lcom/mcmlr/system/products/kits/KitRepository;", "vaultRepository", "Lcom/mcmlr/system/products/data/VaultRepository;", "<init>", "(Lorg/bukkit/entity/Player;Lcom/mcmlr/system/products/kits/KitsPresenter;Lcom/mcmlr/system/products/kits/CreateKitBlock;Lcom/mcmlr/system/products/kits/KitRepository;Lcom/mcmlr/system/products/data/VaultRepository;)V", "selectedKit", "Lcom/mcmlr/system/products/kits/KitModel;", "clockJob", "Lkotlinx/coroutines/Job;", "onCreate", "", "updateSelectedKit", "startClockJob", "time", "", "system"})
public final class KitsInteractor
extends Interactor {
    @NotNull
    private final Player player;
    @NotNull
    private final KitsPresenter presenter;
    @NotNull
    private final CreateKitBlock createKitBlock;
    @NotNull
    private final KitRepository kitRepository;
    @NotNull
    private final VaultRepository vaultRepository;
    @Nullable
    private KitModel selectedKit;
    @Nullable
    private Job clockJob;

    public KitsInteractor(@NotNull Player player2, @NotNull KitsPresenter presenter, @NotNull CreateKitBlock createKitBlock, @NotNull KitRepository kitRepository, @NotNull VaultRepository vaultRepository) {
        Intrinsics.checkNotNullParameter(player2, "player");
        Intrinsics.checkNotNullParameter(presenter, "presenter");
        Intrinsics.checkNotNullParameter(createKitBlock, "createKitBlock");
        Intrinsics.checkNotNullParameter(kitRepository, "kitRepository");
        Intrinsics.checkNotNullParameter(vaultRepository, "vaultRepository");
        super(presenter);
        this.player = player2;
        this.presenter = presenter;
        this.createKitBlock = createKitBlock;
        this.kitRepository = kitRepository;
        this.vaultRepository = vaultRepository;
        this.selectedKit = CollectionsKt.firstOrNull(this.kitRepository.getKits());
    }

    @Override
    public void onCreate() {
        super.onCreate();
        this.presenter.setCreateKitListener(() -> KitsInteractor.onCreate$lambda$0(this));
        KitModel kitModel = this.selectedKit = CollectionsKt.firstOrNull(this.kitRepository.getKits());
        if (kitModel == null) {
            return;
        }
        KitModel selectedKit = kitModel;
        this.presenter.setKitAdapter(new KitsPagerAdapter(this.kitRepository));
        this.updateSelectedKit();
        this.presenter.setGetKitListener(() -> KitsInteractor.onCreate$lambda$2(this, selectedKit));
        this.presenter.setPagerListener(arg_0 -> KitsInteractor.onCreate$lambda$3(this, arg_0));
        this.presenter.setEditKitListener(() -> KitsInteractor.onCreate$lambda$4(this, selectedKit));
    }

    private final void updateSelectedKit() {
        KitModel kitModel = this.selectedKit;
        if (kitModel == null) {
            return;
        }
        KitModel selectedKit = kitModel;
        Job job = this.clockJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default(job, null, 1, null);
        }
        this.presenter.clearErrorMessage();
        this.presenter.setName(selectedKit.getName());
        String string = "%.2f";
        Object[] objectArray = new Object[]{Float.valueOf((float)selectedKit.getKitPrice() / 100.0f)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        this.presenter.setPrice("$" + string2);
        this.presenter.setDescription(selectedKit.getDescription());
        this.presenter.setKitContents(selectedKit.getItems(), selectedKit.getCommands());
        FlowExtKt.collectFirst(this.kitRepository.getCooldown(this.player, selectedKit), new DudeDispatcher(), (arg_0, arg_1) -> KitsInteractor.updateSelectedKit$lambda$5(selectedKit, this, arg_0, arg_1));
    }

    private final void startClockJob(long time) {
        this.clockJob = BuildersKt.launch$default(CoroutineScopeKt.CoroutineScope(Dispatchers.getIO()), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(time, this, null){
            long J$0;
            long J$1;
            long J$2;
            long J$3;
            long J$4;
            long J$5;
            Object L$0;
            int label;
            final /* synthetic */ long $time;
            final /* synthetic */ KitsInteractor this$0;
            {
                this.$time = $time;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var17_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        countdown = this.$time;
lbl7:
                        // 2 sources

                        while (true) {
                            timeRemainder = countdown;
                            days = timeRemainder / (long)86400;
                            hours = (timeRemainder %= (long)86400) / (long)3600;
                            minutes = (timeRemainder %= (long)3600) / (long)60;
                            seconds = timeRemainder %= (long)60;
                            clockTextBuilder = new StringBuilder(ChatColor.GRAY + "Available in ");
                            if (days > 0L) {
                                clockTextBuilder.append(days + " days ");
                            }
                            if (hours > 0L || days > 0L) {
                                clockTextBuilder.append(hours + " hours ");
                            }
                            if (minutes > 0L || days > 0L || hours > 0L) {
                                clockTextBuilder.append(minutes + " minutes ");
                            }
                            clockTextBuilder.append(seconds + " seconds.");
                            BuildersKt.launch$default(CoroutineScopeKt.CoroutineScope(new DudeDispatcher()), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, clockTextBuilder, null){
                                int label;
                                final /* synthetic */ KitsInteractor this$0;
                                final /* synthetic */ StringBuilder $clockTextBuilder;
                                {
                                    this.this$0 = $receiver;
                                    this.$clockTextBuilder = $clockTextBuilder;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure($result);
                                            KitsPresenter kitsPresenter = KitsInteractor.access$getPresenter$p(this.this$0);
                                            String string = this.$clockTextBuilder.toString();
                                            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                                            kitsPresenter.setCooldown(string);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 3, null);
                            var15_10 = countdown;
                            countdown = var15_10 + -1L;
                            this.L$0 = SpillingKt.nullOutSpilledVariable(clockTextBuilder);
                            this.J$0 = countdown;
                            this.J$1 = timeRemainder;
                            this.J$2 = days;
                            this.J$3 = hours;
                            this.J$4 = minutes;
                            this.J$5 = seconds;
                            this.label = 1;
                            v0 = DelayKt.delay-VtjQ1oo(DurationKt.toDuration(1, DurationUnit.SECONDS), this);
                            if (v0 != var17_2) continue;
                            return var17_2;
                        }
                    }
                    case 1: {
                        seconds = this.J$5;
                        minutes = this.J$4;
                        hours = this.J$3;
                        days = this.J$2;
                        timeRemainder = this.J$1;
                        countdown = this.J$0;
                        clockTextBuilder = (StringBuilder)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
                        ** continue;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    private static final Unit onCreate$lambda$0(KitsInteractor this$0) {
        this$0.createKitBlock.setSelectedKit(null);
        Interactor.routeTo$default(this$0, this$0.createKitBlock, null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$2$lambda$1(KitsInteractor this$0, KitModel $selectedKit, Flow $this$collectFirst, Long it) {
        double balance;
        Intrinsics.checkNotNullParameter($this$collectFirst, "$this$collectFirst");
        Long l = it;
        long cooldown = l != null ? l : 0L;
        Economy economy = this$0.vaultRepository.getEconomy();
        double d = balance = economy != null ? economy.getBalance((OfflinePlayer)this$0.player) : 0.0;
        if (cooldown > 0L) {
            this$0.presenter.setErrorMessage(ChatColor.RED + "You need to wait for the cooldown to finish before collecting this kit again!");
        } else if (balance < (double)$selectedKit.getKitPrice() / 100.0) {
            this$0.presenter.setErrorMessage(ChatColor.RED + "You don't have enough money to buy this kit!");
        } else {
            KitRepository.givePlayerKit$default(this$0.kitRepository, this$0.player, $selectedKit, false, 4, null);
            this$0.updateSelectedKit();
        }
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$2(KitsInteractor this$0, KitModel $selectedKit) {
        FlowExtKt.collectFirst(this$0.kitRepository.getCooldown(this$0.player, $selectedKit), new DudeDispatcher(), (arg_0, arg_1) -> KitsInteractor.onCreate$lambda$2$lambda$1(this$0, $selectedKit, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$3(KitsInteractor this$0, int it) {
        this$0.selectedKit = this$0.kitRepository.getKits().get(it);
        this$0.updateSelectedKit();
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$4(KitsInteractor this$0, KitModel $selectedKit) {
        this$0.createKitBlock.setSelectedKit($selectedKit);
        Interactor.routeTo$default(this$0, this$0.createKitBlock, null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit updateSelectedKit$lambda$5(KitModel $selectedKit, KitsInteractor this$0, Flow $this$collectFirst, Long cooldown) {
        Intrinsics.checkNotNullParameter($this$collectFirst, "$this$collectFirst");
        if ($selectedKit.getKitCooldown() < 0) {
            if (cooldown != null) {
                this$0.presenter.setCooldown("Single Use");
            } else {
                this$0.presenter.setCooldown(ChatColor.GRAY + "Kit Claimed");
            }
        } else {
            Long l = cooldown;
            if ((l != null ? l : 0L) > 0L) {
                Long l2 = cooldown;
                long cooldownSeconds = (l2 != null ? l2 : 0L) / (long)1000;
                this$0.startClockJob(cooldownSeconds);
            } else {
                this$0.presenter.setCooldown(ChatColor.GREEN + "Available now");
            }
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ KitsPresenter access$getPresenter$p(KitsInteractor $this) {
        return $this.presenter;
    }
}

