/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.system.products.market;

import com.mcmlr.blocks.api.block.Interactor;
import com.mcmlr.blocks.core.StringExtKt;
import com.mcmlr.system.products.data.VaultRepository;
import com.mcmlr.system.products.market.MarketRepository;
import com.mcmlr.system.products.market.Order;
import com.mcmlr.system.products.market.OrderRepository;
import com.mcmlr.system.products.market.PurchasePresenter;
import java.util.Arrays;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/mcmlr/system/products/market/PurchaseInteractor;", "Lcom/mcmlr/blocks/api/block/Interactor;", "player", "Lorg/bukkit/entity/Player;", "presenter", "Lcom/mcmlr/system/products/market/PurchasePresenter;", "orderRepository", "Lcom/mcmlr/system/products/market/OrderRepository;", "marketRepository", "Lcom/mcmlr/system/products/market/MarketRepository;", "vaultRepository", "Lcom/mcmlr/system/products/data/VaultRepository;", "<init>", "(Lorg/bukkit/entity/Player;Lcom/mcmlr/system/products/market/PurchasePresenter;Lcom/mcmlr/system/products/market/OrderRepository;Lcom/mcmlr/system/products/market/MarketRepository;Lcom/mcmlr/system/products/data/VaultRepository;)V", "quantity", "", "onCreate", "", "updateOrder", "updateQuantityText", "checkValidBalance", "", "checkValidQuantity", "system"})
public final class PurchaseInteractor
extends Interactor {
    @NotNull
    private final Player player;
    @NotNull
    private final PurchasePresenter presenter;
    @NotNull
    private final OrderRepository orderRepository;
    @NotNull
    private final MarketRepository marketRepository;
    @NotNull
    private final VaultRepository vaultRepository;
    private int quantity;

    public PurchaseInteractor(@NotNull Player player2, @NotNull PurchasePresenter presenter, @NotNull OrderRepository orderRepository, @NotNull MarketRepository marketRepository, @NotNull VaultRepository vaultRepository) {
        Intrinsics.checkNotNullParameter(player2, "player");
        Intrinsics.checkNotNullParameter(presenter, "presenter");
        Intrinsics.checkNotNullParameter(orderRepository, "orderRepository");
        Intrinsics.checkNotNullParameter(marketRepository, "marketRepository");
        Intrinsics.checkNotNullParameter(vaultRepository, "vaultRepository");
        super(presenter);
        this.player = player2;
        this.presenter = presenter;
        this.orderRepository = orderRepository;
        this.marketRepository = marketRepository;
        this.vaultRepository = vaultRepository;
    }

    @Override
    public void onCreate() {
        super.onCreate();
        Pair<Material, Order> order = this.orderRepository.getPurchaseOrder();
        this.quantity = 0;
        this.presenter.setQuantityListener(arg_0 -> PurchaseInteractor.onCreate$lambda$0(this, arg_0));
        this.presenter.setZeroListener(() -> PurchaseInteractor.onCreate$lambda$1(this));
        this.presenter.setSubtractListener(() -> PurchaseInteractor.onCreate$lambda$2(this));
        this.presenter.setAddListener(() -> PurchaseInteractor.onCreate$lambda$3(this));
        this.presenter.setMaxListener(() -> PurchaseInteractor.onCreate$lambda$4(this, order));
        this.presenter.setPurchaseListener(() -> PurchaseInteractor.onCreate$lambda$7(this, order));
        if (order != null) {
            this.presenter.setOrder(order.getFirst(), order.getSecond());
        } else {
            this.routeBack();
        }
    }

    private final void updateOrder() {
        this.updateQuantityText();
        if (this.checkValidBalance() && this.checkValidQuantity()) {
            this.presenter.hideMessage();
        }
    }

    private final void updateQuantityText() {
        Object object;
        Pair<Material, Order> pair = this.orderRepository.getPurchaseOrder();
        int cost = (pair != null && (pair = pair.getSecond()) != null ? ((Order)((Object)pair)).getPrice() : 0) * this.quantity;
        if (this.quantity == 0) {
            object = "0";
        } else {
            String string = "%.2f";
            Object[] objectArray = new Object[]{Float.valueOf((float)cost / 100.0f)};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            object = this.quantity + " ($" + string2 + ")";
        }
        String quantityString = object;
        this.presenter.updateQuantityText(quantityString);
    }

    private final boolean checkValidBalance() {
        double playerBalance;
        Pair<Material, Order> pair = this.orderRepository.getPurchaseOrder();
        int cost = (pair != null && (pair = pair.getSecond()) != null ? ((Order)((Object)pair)).getPrice() : 0) * this.quantity;
        Economy economy = this.vaultRepository.getEconomy();
        double d = playerBalance = economy != null ? economy.getBalance((OfflinePlayer)this.player) : 0.0;
        if (playerBalance < (double)cost / 100.0) {
            Object object = this.orderRepository.getPurchaseOrder();
            this.presenter.setMessage(ChatColor.YELLOW + "You don't have enough money to purchase this much " + (object != null && (object = object.getFirst()) != null && (object = object.name()) != null ? StringExtKt.fromMCItem((String)object) : null));
        }
        return playerBalance >= (double)cost / 100.0;
    }

    private final boolean checkValidQuantity() {
        Pair<Material, Order> pair = this.orderRepository.getPurchaseOrder();
        if (pair == null || (pair = pair.getSecond()) == null) {
            return false;
        }
        int quantity = ((Order)((Object)pair)).getQuantity();
        if (this.quantity > quantity) {
            Object object = this.orderRepository.getPurchaseOrder();
            this.presenter.setMessage(ChatColor.YELLOW + "There's not enough " + (object != null && (object = object.getFirst()) != null && (object = object.name()) != null ? StringExtKt.fromMCItem((String)object) : null) + " in stock!");
        }
        return this.quantity <= quantity;
    }

    private static final Unit onCreate$lambda$0(PurchaseInteractor this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Integer quantityInput = StringsKt.toIntOrNull(it);
        if (quantityInput == null) {
            this$0.presenter.updateQuantityText("0");
            this$0.presenter.setMessage(ChatColor.RED + "Quantities must be a valid, whole number!");
        } else {
            this$0.quantity = quantityInput;
            this$0.updateOrder();
        }
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$1(PurchaseInteractor this$0) {
        this$0.quantity = 0;
        this$0.updateOrder();
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$2(PurchaseInteractor this$0) {
        this$0.quantity = Math.max(this$0.quantity - 1, 0);
        this$0.updateOrder();
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$3(PurchaseInteractor this$0) {
        int n = this$0.quantity;
        this$0.quantity = n + 1;
        this$0.updateOrder();
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$4(PurchaseInteractor this$0, Pair $order) {
        Object object = $order;
        this$0.quantity = object != null && (object = (Order)((Pair)object).getSecond()) != null ? ((Order)object).getQuantity() : 0;
        this$0.updateOrder();
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$7$lambda$6$lambda$5(PurchaseInteractor this$0) {
        this$0.routeBack();
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$7$lambda$6(PurchaseInteractor this$0, Material $material, Order $purchaseOrder, boolean it) {
        this$0.presenter.setPurchaseResult(it, $material, $purchaseOrder, () -> PurchaseInteractor.onCreate$lambda$7$lambda$6$lambda$5(this$0));
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$7(PurchaseInteractor this$0, Pair $order) {
        if (this$0.checkValidQuantity() && this$0.checkValidBalance()) {
            if (this$0.quantity < 1) {
                this$0.presenter.setMessage(ChatColor.RED + "Quantities must be above zero!");
            } else {
                Pair pair = $order;
                if (pair == null || (pair = (Material)pair.getFirst()) == null) {
                    return Unit.INSTANCE;
                }
                Pair material = pair;
                UUID playerId = ((Order)$order.getSecond()).getPlayerId();
                int price = ((Order)$order.getSecond()).getPrice();
                String meta = ((Order)$order.getSecond()).getMeta();
                Order purchaseOrder = new Order(playerId, this$0.quantity, price, meta);
                this$0.marketRepository.queuePurchase(this$0.player, (Material)material, purchaseOrder, arg_0 -> PurchaseInteractor.onCreate$lambda$7$lambda$6(this$0, (Material)material, purchaseOrder, arg_0));
            }
        }
        return Unit.INSTANCE;
    }
}

