/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.system.products.warps;

import com.mcmlr.blocks.api.Resources;
import com.mcmlr.blocks.api.data.Repository;
import com.mcmlr.system.dagger.AppScope;
import com.mcmlr.system.products.data.CooldownRepository;
import com.mcmlr.system.products.warps.ServerWarpsModel;
import com.mcmlr.system.products.warps.WarpModel;
import com.mcmlr.system.products.warps.WarpsConfigRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.Job;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@AppScope
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\fJ\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0018\u001a\u00020\fJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001e\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/mcmlr/system/products/warps/WarpsRepository;", "Lcom/mcmlr/blocks/api/data/Repository;", "Lcom/mcmlr/system/products/warps/ServerWarpsModel;", "resources", "Lcom/mcmlr/blocks/api/Resources;", "cooldownRepository", "Lcom/mcmlr/system/products/data/CooldownRepository;", "warpsConfigRepository", "Lcom/mcmlr/system/products/warps/WarpsConfigRepository;", "<init>", "(Lcom/mcmlr/blocks/api/Resources;Lcom/mcmlr/system/products/data/CooldownRepository;Lcom/mcmlr/system/products/warps/WarpsConfigRepository;)V", "updatingWarp", "Lcom/mcmlr/system/products/warps/WarpModel;", "teleport", "", "player", "Lorg/bukkit/entity/Player;", "location", "Lorg/bukkit/Location;", "canTeleport", "", "getWarps", "", "updateWarp", "warpModel", "getUpdateBuilder", "Lcom/mcmlr/system/products/warps/WarpModel$Builder;", "saveWarp", "Lkotlinx/coroutines/Job;", "deleteWarp", "homeModel", "system"})
@SourceDebugExtension(value={"SMAP\nWarpsRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WarpsRepository.kt\ncom/mcmlr/system/products/warps/WarpsRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n774#2:140\n865#2,2:141\n774#2:143\n865#2,2:144\n*S KotlinDebug\n*F\n+ 1 WarpsRepository.kt\ncom/mcmlr/system/products/warps/WarpsRepository\n*L\n63#1:140\n63#1:141,2\n70#1:143\n70#1:144,2\n*E\n"})
public final class WarpsRepository
extends Repository<ServerWarpsModel> {
    @NotNull
    private final Resources resources;
    @NotNull
    private final CooldownRepository cooldownRepository;
    @NotNull
    private final WarpsConfigRepository warpsConfigRepository;
    @Nullable
    private WarpModel updatingWarp;

    @Inject
    public WarpsRepository(@NotNull Resources resources, @NotNull CooldownRepository cooldownRepository, @NotNull WarpsConfigRepository warpsConfigRepository) {
        Intrinsics.checkNotNullParameter(resources, "resources");
        Intrinsics.checkNotNullParameter(cooldownRepository, "cooldownRepository");
        Intrinsics.checkNotNullParameter(warpsConfigRepository, "warpsConfigRepository");
        super(resources.dataFolder());
        this.resources = resources;
        this.cooldownRepository = cooldownRepository;
        this.warpsConfigRepository = warpsConfigRepository;
        Repository.loadModel$default(this, "Warps", "warps", new ServerWarpsModel(CollectionsKt.emptyList()), null, 8, null);
    }

    public final void teleport(@NotNull Player player2, @NotNull Location location) {
        Intrinsics.checkNotNullParameter(player2, "player");
        Intrinsics.checkNotNullParameter(location, "location");
        player2.teleport(location);
        this.cooldownRepository.addPlayerLastWarpTime(player2);
    }

    public final long canTeleport(@NotNull Player player2) {
        Intrinsics.checkNotNullParameter(player2, "player");
        long lastTeleport = this.cooldownRepository.getPlayerLastWarpTime(player2);
        return lastTeleport + (long)(this.warpsConfigRepository.cooldown() * 1000) - new Date().getTime();
    }

    @NotNull
    public final List<WarpModel> getWarps() {
        return ((ServerWarpsModel)this.getModel()).getWarps();
    }

    public final void updateWarp(@Nullable WarpModel warpModel) {
        this.updatingWarp = warpModel;
    }

    @Nullable
    public final WarpModel.Builder getUpdateBuilder() {
        WarpModel warpModel = this.updatingWarp;
        if (warpModel == null) {
            return null;
        }
        WarpModel update = warpModel;
        return new WarpModel.Builder().name(update.getName()).icon(update.getIcon()).uuid(update.getUuid()).location(new Location(Bukkit.getWorld((String)update.getWorld()), update.getX(), update.getY(), update.getZ(), update.getYaw(), update.getPitch()));
    }

    @Nullable
    public final Job saveWarp(@NotNull WarpModel warpModel) {
        Intrinsics.checkNotNullParameter(warpModel, "warpModel");
        return this.save(() -> WarpsRepository.saveWarp$lambda$1(this, warpModel));
    }

    @Nullable
    public final Job deleteWarp(@NotNull WarpModel homeModel) {
        Intrinsics.checkNotNullParameter(homeModel, "homeModel");
        return this.save(() -> WarpsRepository.deleteWarp$lambda$3(this, homeModel));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit saveWarp$lambda$1(WarpsRepository this$0, WarpModel $warpModel) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = ((ServerWarpsModel)this$0.getModel()).getWarps();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            WarpModel it = (WarpModel)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it.getUuid(), $warpModel.getUuid()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List existingWarps = (List)destination$iv$iv;
        WarpModel[] warpModelArray = new WarpModel[]{$warpModel};
        List<WarpModel> warpsList = CollectionsKt.mutableListOf(warpModelArray);
        warpsList.addAll(existingWarps);
        ((ServerWarpsModel)this$0.getModel()).setWarps(warpsList);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit deleteWarp$lambda$3(WarpsRepository this$0, WarpModel $homeModel) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = ((ServerWarpsModel)this$0.getModel()).getWarps();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            WarpModel it = (WarpModel)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it.getUuid(), $homeModel.getUuid()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List updatedWarps = (List)destination$iv$iv;
        ((ServerWarpsModel)this$0.getModel()).setWarps(updatedWarps);
        return Unit.INSTANCE;
    }
}

