/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.blocks.api.views;

import com.mcmlr.blocks.api.views.Alignment;
import com.mcmlr.blocks.api.views.Area;
import com.mcmlr.blocks.api.views.Axis;
import com.mcmlr.blocks.api.views.Coordinates;
import com.mcmlr.blocks.api.views.Edge;
import com.mcmlr.blocks.api.views.Modifier;
import com.mcmlr.blocks.api.views.View;
import com.mcmlr.blocks.api.views.Viewable;
import com.mcmlr.blocks.font.TextMeasurementFactoryKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Color;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001Bo\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\t\u0012\b\b\u0002\u0010\r\u001a\u00020\t\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\t\u0012\b\b\u0002\u0010\u0013\u001a\u00020\t\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010$\u001a\u00020#H\u0016J\b\u0010%\u001a\u00020#H\u0016J\u0010\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020(H\u0014J\u0010\u0010)\u001a\u00020\t2\u0006\u0010'\u001a\u00020(H\u0014J\u0010\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020,H\u0014R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001bR\u0011\u0010\r\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001bR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006-"}, d2={"Lcom/mcmlr/blocks/api/views/TextView;", "Lcom/mcmlr/blocks/api/views/View;", "modifier", "Lcom/mcmlr/blocks/api/views/Modifier;", "parent", "Lcom/mcmlr/blocks/api/views/Viewable;", "text", "", "size", "", "alignment", "Lcom/mcmlr/blocks/api/views/Alignment;", "maxLength", "lineWidth", "background", "Lorg/bukkit/Color;", "visible", "", "teleportDuration", "height", "<init>", "(Lcom/mcmlr/blocks/api/views/Modifier;Lcom/mcmlr/blocks/api/views/Viewable;Ljava/lang/String;ILcom/mcmlr/blocks/api/views/Alignment;IILorg/bukkit/Color;ZII)V", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "getSize", "()I", "getAlignment", "()Lcom/mcmlr/blocks/api/views/Alignment;", "getMaxLength", "getLineWidth", "getBackground", "()Lorg/bukkit/Color;", "setTextView", "", "render", "updateDisplay", "getWrappedDimension", "dimension", "Lcom/mcmlr/blocks/api/views/Area;", "getAlignedDimension", "getAlignedPosition", "axis", "Lcom/mcmlr/blocks/api/views/Axis;", "block"})
@SourceDebugExtension(value={"SMAP\nTextView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextView.kt\ncom/mcmlr/blocks/api/views/TextView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1869#2,2:88\n*S KotlinDebug\n*F\n+ 1 TextView.kt\ncom/mcmlr/blocks/api/views/TextView\n*L\n31#1:88,2\n*E\n"})
public class TextView
extends View {
    @NotNull
    private String text;
    private final int size;
    @NotNull
    private final Alignment alignment;
    private final int maxLength;
    private final int lineWidth;
    @NotNull
    private final Color background;

    public TextView(@NotNull Modifier modifier, @NotNull Viewable parent, @NotNull String text, int size, @NotNull Alignment alignment, int maxLength, int lineWidth, @NotNull Color background, boolean visible, int teleportDuration, int height) {
        Intrinsics.checkNotNullParameter(modifier, "modifier");
        Intrinsics.checkNotNullParameter(parent, "parent");
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter((Object)alignment, "alignment");
        Intrinsics.checkNotNullParameter(background, "background");
        super(modifier, visible, teleportDuration, height, 0, 16, null);
        this.text = text;
        this.size = size;
        this.alignment = alignment;
        this.maxLength = maxLength;
        this.lineWidth = lineWidth;
        this.background = background;
        this.text = TextMeasurementFactoryKt.reduceToLength(this.text, this.maxLength);
    }

    public /* synthetic */ TextView(Modifier modifier, Viewable viewable, String string, int n, Alignment alignment, int n2, int n3, Color color, boolean bl, int n4, int n5, int n6, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n6 & 8) != 0) {
            n = 10;
        }
        if ((n6 & 0x10) != 0) {
            alignment = Alignment.LEFT;
        }
        if ((n6 & 0x20) != 0) {
            n2 = 0;
        }
        if ((n6 & 0x40) != 0) {
            n3 = 200;
        }
        if ((n6 & 0x80) != 0) {
            Color color2 = Color.fromARGB((int)0);
            Intrinsics.checkNotNullExpressionValue(color2, "fromARGB(...)");
            color = color2;
        }
        if ((n6 & 0x100) != 0) {
            bl = true;
        }
        if ((n6 & 0x200) != 0) {
            n4 = 3;
        }
        if ((n6 & 0x400) != 0) {
            n5 = 0;
        }
        this(modifier, viewable, string, n, alignment, n2, n3, color, bl, n4, n5);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final void setText(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.text = string;
    }

    public final int getSize() {
        return this.size;
    }

    @NotNull
    public final Alignment getAlignment() {
        return this.alignment;
    }

    public final int getMaxLength() {
        return this.maxLength;
    }

    public final int getLineWidth() {
        return this.lineWidth;
    }

    @NotNull
    public final Color getBackground() {
        return this.background;
    }

    public void setTextView(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        this.text = TextMeasurementFactoryKt.reduceToLength(text, this.maxLength);
        this.getParent().updateTextDisplay(this);
        Iterable $this$forEach$iv = this.getDependants();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Viewable it = (Viewable)element$iv;
            boolean bl = false;
            it.updatePosition();
        }
    }

    @Override
    public void render() {
        this.setDudeDisplay(this.getParent().addTextDisplay(this));
    }

    @Override
    public void updateDisplay() {
        this.getParent().updateTextDisplay(this);
    }

    @Override
    protected int getWrappedDimension(@NotNull Area dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, "dimension");
        return dimension == Area.WIDTH ? (int)((double)TextMeasurementFactoryKt.getMCTextWidth(this.text, this.lineWidth) * (0.4 * (double)this.size)) : TextMeasurementFactoryKt.getMCTextLines(this.text, this.lineWidth) * (int)((double)7 * ((double)this.size + 1.0));
    }

    @Override
    protected int getAlignedDimension(@NotNull Area dimension) {
        int n;
        Intrinsics.checkNotNullParameter((Object)dimension, "dimension");
        if (dimension == Area.WIDTH) {
            Edge edge = this.getModifier().getStart();
            if (edge == null) {
                throw new Exception("TODO: add error messages");
            }
            int start = edge.getP();
            Edge edge2 = this.getModifier().getEnd();
            if (edge2 == null) {
                throw new Exception("TODO: add error messages");
            }
            int end = edge2.getP();
            n = (end - start) / 2;
        } else {
            Edge edge = this.getModifier().getTop();
            if (edge == null) {
                throw new Exception("TODO: add error messages");
            }
            int top = edge.getP();
            Edge edge3 = this.getModifier().getBottom();
            if (edge3 == null) {
                throw new Exception("TODO: add error messages");
            }
            int bottom = edge3.getP();
            n = top - bottom;
        }
        return n;
    }

    @Override
    protected int getAlignedPosition(@NotNull Axis axis) {
        Intrinsics.checkNotNullParameter((Object)axis, "axis");
        if (axis == Axis.Y) {
            int n;
            if (this.getModifier().getTop() == null && this.getModifier().getBottom() == null) {
                throw new Exception("TODO: add error messages");
            }
            if (this.getModifier().getTop() == null) {
                int n2;
                Edge edge = this.getModifier().getBottom();
                if (Intrinsics.areEqual(edge != null ? edge.getView() : null, this.getParent())) {
                    Object object;
                    Object object2;
                    Edge edge2 = this.getModifier().getBottom();
                    if (edge2 == null) {
                        return 0;
                    }
                    n2 = edge2.getP() - ((object2 = this.getModifier().getBottom()) != null && (object2 = ((Edge)object2).getView()) != null && (object2 = object2.getPosition()) != null ? ((Coordinates)object2).getY() : 0) + 80 * ((object = this.getModifier().getBottom()) != null && (object = ((Edge)object).getView()) != null ? object.getOffset() : 0);
                } else {
                    Edge edge3 = this.getModifier().getBottom();
                    if (edge3 != null) {
                        n2 = edge3.getP();
                    } else {
                        return 0;
                    }
                }
                int p = n2;
                n = p + this.getModifier().getM().getBottom() + this.getDimensions().getHeight() / 2;
            } else if (this.getModifier().getBottom() == null) {
                int n3;
                Edge edge = this.getModifier().getTop();
                if (Intrinsics.areEqual(edge != null ? edge.getView() : null, this.getParent())) {
                    Object object;
                    Object object3;
                    Edge edge4 = this.getModifier().getTop();
                    if (edge4 == null) {
                        return 0;
                    }
                    n3 = edge4.getP() - ((object3 = this.getModifier().getTop()) != null && (object3 = ((Edge)object3).getView()) != null && (object3 = object3.getPosition()) != null ? ((Coordinates)object3).getY() : 0) + 80 * ((object = this.getModifier().getTop()) != null && (object = ((Edge)object).getView()) != null ? object.getOffset() : 0);
                } else {
                    Edge edge5 = this.getModifier().getTop();
                    if (edge5 != null) {
                        n3 = edge5.getP();
                    } else {
                        return 0;
                    }
                }
                int p = n3;
                n = p - this.getModifier().getM().getTop() - this.getDimensions().getHeight() / 2;
            } else {
                return super.getAlignedPosition(axis);
            }
            return n;
        }
        return super.getAlignedPosition(axis);
    }
}

