/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.system;

import com.mcmlr.system.dagger.EnvironmentScope;
import com.mcmlr.system.products.data.ServerEventsRepository;
import com.mcmlr.system.products.teleport.GlobalTeleportRepository;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jetbrains.annotations.NotNull;

@EnvironmentScope
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0015H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/mcmlr/system/DefaultEventHandlerFactory;", "Lorg/bukkit/event/Listener;", "serverEventsRepository", "Lcom/mcmlr/system/products/data/ServerEventsRepository;", "teleportRepository", "Lcom/mcmlr/system/products/teleport/GlobalTeleportRepository;", "<init>", "(Lcom/mcmlr/system/products/data/ServerEventsRepository;Lcom/mcmlr/system/products/teleport/GlobalTeleportRepository;)V", "playerClickEvent", "", "e", "Lorg/bukkit/event/player/PlayerInteractEvent;", "playerTeleportEvent", "Lorg/bukkit/event/player/PlayerTeleportEvent;", "playerJoinedServerEvent", "Lorg/bukkit/event/player/PlayerJoinEvent;", "playerQuitServerEvent", "Lorg/bukkit/event/player/PlayerQuitEvent;", "playerRespawnEvent", "Lorg/bukkit/event/player/PlayerRespawnEvent;", "playerDeathEvent", "Lorg/bukkit/event/entity/PlayerDeathEvent;", "system"})
public final class DefaultEventHandlerFactory
implements Listener {
    @NotNull
    private final ServerEventsRepository serverEventsRepository;
    @NotNull
    private final GlobalTeleportRepository teleportRepository;

    @Inject
    public DefaultEventHandlerFactory(@NotNull ServerEventsRepository serverEventsRepository, @NotNull GlobalTeleportRepository teleportRepository) {
        Intrinsics.checkNotNullParameter(serverEventsRepository, "serverEventsRepository");
        Intrinsics.checkNotNullParameter(teleportRepository, "teleportRepository");
        this.serverEventsRepository = serverEventsRepository;
        this.teleportRepository = teleportRepository;
    }

    @EventHandler
    public final void playerClickEvent(@NotNull PlayerInteractEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        this.serverEventsRepository.emitPlayerInteractEvent(e);
        Player player2 = e.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player2, "getPlayer(...)");
        if (this.serverEventsRepository.cancelBlockEvent(player2) && (e.getAction() == Action.LEFT_CLICK_BLOCK || e.getAction() == Action.RIGHT_CLICK_BLOCK)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public final void playerTeleportEvent(@NotNull PlayerTeleportEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        switch (WhenMappings.$EnumSwitchMapping$0[e.getCause().ordinal()]) {
            case 1: 
            case 2: {
                Player player2 = e.getPlayer();
                Intrinsics.checkNotNullExpressionValue(player2, "getPlayer(...)");
                Location location = e.getFrom();
                Intrinsics.checkNotNullExpressionValue(location, "getFrom(...)");
                this.teleportRepository.setBackLocation(player2, location);
            }
        }
    }

    @EventHandler
    public final void playerJoinedServerEvent(@NotNull PlayerJoinEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        this.teleportRepository.playerJoinedServer(e);
    }

    @EventHandler
    public final void playerQuitServerEvent(@NotNull PlayerQuitEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        this.teleportRepository.playerLeftServer(e);
    }

    @EventHandler
    public final void playerRespawnEvent(@NotNull PlayerRespawnEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        this.teleportRepository.playerRespawn(e);
    }

    @EventHandler
    public final void playerDeathEvent(@NotNull PlayerDeathEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        Player player2 = e.getEntity();
        Intrinsics.checkNotNullExpressionValue(player2, "getEntity(...)");
        Location location = e.getEntity().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        this.teleportRepository.setBackLocation(player2, location);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PlayerTeleportEvent.TeleportCause.values().length];
            try {
                nArray[PlayerTeleportEvent.TeleportCause.PLUGIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlayerTeleportEvent.TeleportCause.COMMAND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

