/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.system.products.homes;

import com.google.gson.Gson;
import com.mcmlr.blocks.api.Resources;
import com.mcmlr.blocks.api.data.Repository;
import com.mcmlr.system.dagger.EnvironmentScope;
import com.mcmlr.system.products.homes.PlayerHomesModel;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@EnvironmentScope
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/mcmlr/system/products/homes/HomeListRepository;", "Lcom/mcmlr/blocks/api/data/Repository;", "Lcom/mcmlr/system/products/homes/PlayerHomesModel;", "resources", "Lcom/mcmlr/blocks/api/Resources;", "<init>", "(Lcom/mcmlr/blocks/api/Resources;)V", "getHomes", "player", "Lorg/bukkit/entity/Player;", "system"})
@SourceDebugExtension(value={"SMAP\nHomesRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HomesRepository.kt\ncom/mcmlr/system/products/homes/HomeListRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n1#2:219\n*E\n"})
public final class HomeListRepository
extends Repository<PlayerHomesModel> {
    @NotNull
    private final Resources resources;

    @Inject
    public HomeListRepository(@NotNull Resources resources) {
        Intrinsics.checkNotNullParameter(resources, "resources");
        super(resources.dataFolder());
        this.resources = resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final PlayerHomesModel getHomes(@NotNull Player player2) {
        InputStream homeInputStream;
        Intrinsics.checkNotNullParameter(player2, "player");
        File homes = new File(this.resources.dataFolder(), "Homes/Players/" + player2.getUniqueId() + ".json");
        if (!homes.exists()) {
            return null;
        }
        Closeable closeable = homeInputStream = (InputStream)new FileInputStream(homes);
        Object object = Charsets.UTF_8;
        Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        object = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            object2 = TextStreamsKt.readText(it);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally(closeable, (Throwable)object);
        }
        Object homeInputString = object2;
        return (PlayerHomesModel)new Gson().fromJson((String)homeInputString, PlayerHomesModel.class);
    }
}

