/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.system.products.market;

import com.mcmlr.apps.app.block.data.Bundle;
import com.mcmlr.blocks.api.block.Interactor;
import com.mcmlr.blocks.core.DudeDispatcher;
import com.mcmlr.blocks.core.FlowExtKt;
import com.mcmlr.blocks.core.InventoryExtKt;
import com.mcmlr.blocks.core.StringExtKt;
import com.mcmlr.system.IconSelectionBlock;
import com.mcmlr.system.products.market.OfferCreatorPresenter;
import com.mcmlr.system.products.market.Order;
import com.mcmlr.system.products.market.OrderRepository;
import com.mcmlr.system.products.market.OrderStatus;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.Flow;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/mcmlr/system/products/market/OfferCreatorInteractor;", "Lcom/mcmlr/blocks/api/block/Interactor;", "player", "Lorg/bukkit/entity/Player;", "presenter", "Lcom/mcmlr/system/products/market/OfferCreatorPresenter;", "iconSelectionBlock", "Lcom/mcmlr/system/IconSelectionBlock;", "orderRepository", "Lcom/mcmlr/system/products/market/OrderRepository;", "<init>", "(Lorg/bukkit/entity/Player;Lcom/mcmlr/system/products/market/OfferCreatorPresenter;Lcom/mcmlr/system/IconSelectionBlock;Lcom/mcmlr/system/products/market/OrderRepository;)V", "builder", "Lcom/mcmlr/system/products/market/Order$Builder;", "selectedMaterial", "Lorg/bukkit/inventory/ItemStack;", "onCreate", "", "checkValidQuantity", "", "system"})
@SourceDebugExtension(value={"SMAP\nOfferCreatorBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OfferCreatorBlock.kt\ncom/mcmlr/system/products/market/OfferCreatorInteractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Bundle.kt\ncom/mcmlr/apps/app/block/data/Bundle\n*L\n1#1,493:1\n1869#2,2:494\n1869#2,2:501\n14#3:496\n13#3,4:497\n*S KotlinDebug\n*F\n+ 1 OfferCreatorBlock.kt\ncom/mcmlr/system/products/market/OfferCreatorInteractor\n*L\n475#1:494,2\n422#1:501,2\n373#1:496\n373#1:497,4\n*E\n"})
public final class OfferCreatorInteractor
extends Interactor {
    @NotNull
    private final Player player;
    @NotNull
    private final OfferCreatorPresenter presenter;
    @NotNull
    private final IconSelectionBlock iconSelectionBlock;
    @NotNull
    private final OrderRepository orderRepository;
    @NotNull
    private Order.Builder builder;
    @Nullable
    private ItemStack selectedMaterial;

    public OfferCreatorInteractor(@NotNull Player player2, @NotNull OfferCreatorPresenter presenter, @NotNull IconSelectionBlock iconSelectionBlock, @NotNull OrderRepository orderRepository) {
        Intrinsics.checkNotNullParameter(player2, "player");
        Intrinsics.checkNotNullParameter(presenter, "presenter");
        Intrinsics.checkNotNullParameter(iconSelectionBlock, "iconSelectionBlock");
        Intrinsics.checkNotNullParameter(orderRepository, "orderRepository");
        super(presenter);
        this.player = player2;
        this.presenter = presenter;
        this.iconSelectionBlock = iconSelectionBlock;
        this.orderRepository = orderRepository;
        this.builder = new Order.Builder();
    }

    @Override
    public void onCreate() {
        super.onCreate();
        this.builder = new Order.Builder();
        this.selectedMaterial = null;
        this.presenter.setItemListener(() -> OfferCreatorInteractor.onCreate$lambda$1(this));
        this.presenter.setPriceListener(arg_0 -> OfferCreatorInteractor.onCreate$lambda$2(this, arg_0));
        this.presenter.setQuantityListener(arg_0 -> OfferCreatorInteractor.onCreate$lambda$3(this, arg_0));
        this.presenter.setZeroListener(() -> OfferCreatorInteractor.onCreate$lambda$4(this));
        this.presenter.setSubtractListener(() -> OfferCreatorInteractor.onCreate$lambda$6(this));
        this.presenter.setMaxListener(() -> OfferCreatorInteractor.onCreate$lambda$8(this));
        this.presenter.setAddListener(() -> OfferCreatorInteractor.onCreate$lambda$9(this));
        this.presenter.setCreateListener(() -> OfferCreatorInteractor.onCreate$lambda$13(this));
    }

    private final boolean checkValidQuantity() {
        if (this.selectedMaterial != null) {
            int count2 = 0;
            PlayerInventory playerInventory = this.player.getInventory();
            Intrinsics.checkNotNullExpressionValue(playerInventory, "getInventory(...)");
            Iterable $this$forEach$iv = CollectionsKt.filterNotNull((Iterable)playerInventory);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ItemStack it = (ItemStack)element$iv;
                boolean bl = false;
                ItemStack itemStack = this.selectedMaterial;
                if (it.getType() != (itemStack != null ? itemStack.getType() : null)) continue;
                ItemStack itemStack2 = this.selectedMaterial;
                if (!Intrinsics.areEqual(it.getItemMeta(), itemStack2 != null ? itemStack2.getItemMeta() : null)) continue;
                count2 += it.getAmount();
            }
            Integer n = this.builder.getQuantity();
            if ((n != null ? n : 0) > count2) {
                Object object = this.selectedMaterial;
                this.presenter.setMessage(ChatColor.YELLOW + "You don't have enough " + (object != null && (object = object.getType()) != null && (object = object.name()) != null ? StringExtKt.fromMCItem((String)object) : null) + " in your inventory!");
                return false;
            }
            this.presenter.hideMessage();
            return true;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit onCreate$lambda$1$lambda$0(OfferCreatorInteractor this$0, Bundle bundle) {
        ItemStack itemStack;
        void this_$iv;
        Intrinsics.checkNotNullParameter(bundle, "bundle");
        Bundle bundle2 = bundle;
        String key$iv = "material";
        boolean $i$f$getData = false;
        Object object = this_$iv.getMap().get(key$iv);
        if (object == null) {
            itemStack = null;
        } else {
            Object datum$iv = object;
            Object object2 = datum$iv;
            if (!(object2 instanceof ItemStack)) {
                object2 = null;
            }
            ItemStack itemStack2 = (ItemStack)object2;
            if (itemStack2 != null) {
                ItemStack it$iv = itemStack2;
                boolean bl = false;
                itemStack = it$iv;
            } else {
                itemStack = null;
            }
        }
        if (itemStack == null) {
            return Unit.INSTANCE;
        }
        ItemStack item = itemStack;
        this$0.presenter.setItem(item);
        this$0.selectedMaterial = item;
        ItemMeta itemMeta = item.getItemMeta();
        this$0.builder.meta(itemMeta != null ? itemMeta.getAsComponentString() : null);
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$1(OfferCreatorInteractor this$0) {
        IconSelectionBlock iconSelectionBlock = this$0.iconSelectionBlock;
        PlayerInventory playerInventory = this$0.player.getInventory();
        Intrinsics.checkNotNullExpressionValue(playerInventory, "getInventory(...)");
        iconSelectionBlock.setInventory((Inventory)playerInventory);
        this$0.routeTo(this$0.iconSelectionBlock, arg_0 -> OfferCreatorInteractor.onCreate$lambda$1$lambda$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$2(OfferCreatorInteractor this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (StringsKt.toDoubleOrNull(it) == null) {
            this$0.presenter.updatePriceText("$0");
            this$0.presenter.setMessage(ChatColor.RED + "Prices must be a valid number!");
            v0 = this$0.builder.price(0);
        } else {
            this$0.presenter.updatePriceText("$" + StringExtKt.priceFormat(it));
            int price = (int)(Double.parseDouble(it) * (double)100 + 0.5);
            v0 = this$0.builder.price(price);
        }
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$3(OfferCreatorInteractor this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (StringsKt.toIntOrNull(it) == null) {
            this$0.presenter.updateQuantityText("0");
            this$0.presenter.setMessage(ChatColor.RED + "Quantities must be a valid, whole number!");
            v0 = this$0.builder.quantity(0);
        } else {
            this$0.builder.quantity(Integer.parseInt(it));
            v0 = this$0.checkValidQuantity();
        }
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$4(OfferCreatorInteractor this$0) {
        this$0.presenter.updateQuantityText("0");
        this$0.builder.quantity(0);
        this$0.checkValidQuantity();
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$6(OfferCreatorInteractor this$0) {
        block1: {
            Integer n = this$0.builder.getQuantity();
            if (n == null) break block1;
            int quantity = ((Number)n).intValue();
            boolean bl = false;
            if (quantity > 0) {
                this$0.builder.quantity(quantity - 1);
                this$0.presenter.updateQuantityText(String.valueOf(this$0.builder.getQuantity()));
                this$0.checkValidQuantity();
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$8(OfferCreatorInteractor this$0) {
        int count2 = 0;
        PlayerInventory playerInventory = this$0.player.getInventory();
        Intrinsics.checkNotNullExpressionValue(playerInventory, "getInventory(...)");
        Iterable $this$forEach$iv = CollectionsKt.filterNotNull((Iterable)playerInventory);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemStack it = (ItemStack)element$iv;
            boolean bl = false;
            ItemStack itemStack = this$0.selectedMaterial;
            if (it.getType() != (itemStack != null ? itemStack.getType() : null)) continue;
            ItemStack itemStack2 = this$0.selectedMaterial;
            if (!Intrinsics.areEqual(it.getItemMeta(), itemStack2 != null ? itemStack2.getItemMeta() : null)) continue;
            count2 += it.getAmount();
        }
        this$0.builder.quantity(count2);
        this$0.presenter.updateQuantityText(String.valueOf(this$0.builder.getQuantity()));
        this$0.checkValidQuantity();
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$9(OfferCreatorInteractor this$0) {
        Integer n = this$0.builder.getQuantity();
        this$0.builder.quantity((n != null ? n : 0) + 1);
        this$0.presenter.updateQuantityText(String.valueOf(this$0.builder.getQuantity()));
        this$0.checkValidQuantity();
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$13$lambda$12$lambda$11$lambda$10(OfferCreatorInteractor this$0) {
        this$0.routeBack();
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$13$lambda$12$lambda$11(ItemStack $material, OfferCreatorInteractor this$0, Order $order, Flow $this$collectFirst, OrderStatus it) {
        Intrinsics.checkNotNullParameter($this$collectFirst, "$this$collectFirst");
        Intrinsics.checkNotNullParameter((Object)it, "it");
        Material material = $material.getType();
        Intrinsics.checkNotNullExpressionValue(material, "getType(...)");
        Material type = material;
        PlayerInventory playerInventory = this$0.player.getInventory();
        Intrinsics.checkNotNullExpressionValue(playerInventory, "getInventory(...)");
        ItemMeta itemMeta = $material.getItemMeta();
        InventoryExtKt.remove((Inventory)playerInventory, type, itemMeta != null ? itemMeta.getAsComponentString() : null, $order.getQuantity());
        this$0.presenter.animateOrderSuccess(type, $order, () -> OfferCreatorInteractor.onCreate$lambda$13$lambda$12$lambda$11$lambda$10(this$0));
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$13(OfferCreatorInteractor this$0) {
        block6: {
            if (this$0.selectedMaterial == null) {
                this$0.presenter.setMessage(ChatColor.RED + "You need to select an item to sell first!");
                return Unit.INSTANCE;
            }
            if (this$0.builder.getPrice() == null) {
                Object object = this$0.selectedMaterial;
                this$0.presenter.setMessage(ChatColor.RED + "You need to specify the price of the " + (object != null && (object = object.getType()) != null && (object = object.name()) != null ? StringExtKt.fromMCItem((String)object) : null) + " you want to sell!");
                return Unit.INSTANCE;
            }
            if (this$0.builder.getQuantity() == null) {
                Object object = this$0.selectedMaterial;
                this$0.presenter.setMessage(ChatColor.RED + "You need to specify the amount of the " + (object != null && (object = object.getType()) != null && (object = object.name()) != null ? StringExtKt.fromMCItem((String)object) : null) + " you want to sell!");
                return Unit.INSTANCE;
            }
            ItemStack itemStack = this$0.selectedMaterial;
            if (itemStack == null) break block6;
            ItemStack material = itemStack;
            boolean bl = false;
            Order.Builder builder = this$0.builder;
            UUID uUID = this$0.player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            Order order = builder.playerId(uUID).build();
            if (order == null) {
                return Unit.INSTANCE;
            }
            Order order2 = order;
            if (this$0.checkValidQuantity()) {
                FlowExtKt.collectFirst(this$0.orderRepository.setOrder(material, order2), new DudeDispatcher(), (arg_0, arg_1) -> OfferCreatorInteractor.onCreate$lambda$13$lambda$12$lambda$11(material, this$0, order2, arg_0, arg_1));
            } else {
                Object object = this$0.selectedMaterial;
                this$0.presenter.setMessage(ChatColor.RED + "You don't have enough " + (object != null && (object = object.getType()) != null && (object = object.name()) != null ? StringExtKt.fromMCItem((String)object) : null) + " in your inventory!");
            }
        }
        return Unit.INSTANCE;
    }
}

