/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.system.products.market;

import com.mcmlr.blocks.api.block.Interactor;
import com.mcmlr.blocks.core.DudeDispatcher;
import com.mcmlr.blocks.core.FlowExtKt;
import com.mcmlr.blocks.core.InventoryExtKt;
import com.mcmlr.blocks.core.StringExtKt;
import com.mcmlr.system.IconSelectionBlock;
import com.mcmlr.system.products.market.OfferEditorPresenter;
import com.mcmlr.system.products.market.Order;
import com.mcmlr.system.products.market.OrderRepository;
import com.mcmlr.system.products.market.OrderStatus;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.Flow;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/mcmlr/system/products/market/OfferEditorInteractor;", "Lcom/mcmlr/blocks/api/block/Interactor;", "player", "Lorg/bukkit/entity/Player;", "presenter", "Lcom/mcmlr/system/products/market/OfferEditorPresenter;", "iconSelectionBlock", "Lcom/mcmlr/system/IconSelectionBlock;", "orderRepository", "Lcom/mcmlr/system/products/market/OrderRepository;", "<init>", "(Lorg/bukkit/entity/Player;Lcom/mcmlr/system/products/market/OfferEditorPresenter;Lcom/mcmlr/system/IconSelectionBlock;Lcom/mcmlr/system/products/market/OrderRepository;)V", "builder", "Lcom/mcmlr/system/products/market/Order$Builder;", "selectedMaterial", "Lorg/bukkit/Material;", "onCreate", "", "checkValidQuantity", "", "existingOrder", "Lcom/mcmlr/system/products/market/Order;", "system"})
@SourceDebugExtension(value={"SMAP\nOfferEditorBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OfferEditorBlock.kt\ncom/mcmlr/system/products/market/OfferEditorInteractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,589:1\n1869#2,2:590\n1869#2,2:592\n*S KotlinDebug\n*F\n+ 1 OfferEditorBlock.kt\ncom/mcmlr/system/products/market/OfferEditorInteractor\n*L\n571#1:590,2\n466#1:592,2\n*E\n"})
public final class OfferEditorInteractor
extends Interactor {
    @NotNull
    private final Player player;
    @NotNull
    private final OfferEditorPresenter presenter;
    @NotNull
    private final IconSelectionBlock iconSelectionBlock;
    @NotNull
    private final OrderRepository orderRepository;
    @NotNull
    private Order.Builder builder;
    @Nullable
    private Material selectedMaterial;

    public OfferEditorInteractor(@NotNull Player player2, @NotNull OfferEditorPresenter presenter, @NotNull IconSelectionBlock iconSelectionBlock, @NotNull OrderRepository orderRepository) {
        Intrinsics.checkNotNullParameter(player2, "player");
        Intrinsics.checkNotNullParameter(presenter, "presenter");
        Intrinsics.checkNotNullParameter(iconSelectionBlock, "iconSelectionBlock");
        Intrinsics.checkNotNullParameter(orderRepository, "orderRepository");
        super(presenter);
        this.player = player2;
        this.presenter = presenter;
        this.iconSelectionBlock = iconSelectionBlock;
        this.orderRepository = orderRepository;
        this.builder = new Order.Builder();
    }

    @Override
    public void onCreate() {
        super.onCreate();
        this.builder = new Order.Builder();
        this.selectedMaterial = this.orderRepository.getSelectedMaterial();
        Order order = this.orderRepository.getUpdatingOrder();
        if (order == null) {
            return;
        }
        Order updatingOrder = order;
        this.builder.quantity(updatingOrder.getQuantity());
        this.builder.price(updatingOrder.getPrice());
        this.builder.meta(updatingOrder.getMeta());
        this.presenter.updatePriceText("$" + StringExtKt.priceFormat(String.valueOf((float)updatingOrder.getPrice() / 100.0f)));
        this.presenter.updateQuantityText(String.valueOf(updatingOrder.getQuantity()));
        Material material = this.selectedMaterial;
        if (material != null) {
            Material it = material;
            boolean bl = false;
            this.presenter.setItem(it);
        }
        this.presenter.setPriceListener(arg_0 -> OfferEditorInteractor.onCreate$lambda$1(this, arg_0));
        this.presenter.setQuantityListener(arg_0 -> OfferEditorInteractor.onCreate$lambda$2(this, updatingOrder, arg_0));
        this.presenter.setZeroListener(() -> OfferEditorInteractor.onCreate$lambda$3(this, updatingOrder));
        this.presenter.setSubtractListener(() -> OfferEditorInteractor.onCreate$lambda$5(this, updatingOrder));
        this.presenter.setMaxListener(() -> OfferEditorInteractor.onCreate$lambda$7(updatingOrder, this));
        this.presenter.setAddListener(() -> OfferEditorInteractor.onCreate$lambda$8(this, updatingOrder));
        this.presenter.setDeleteListener(() -> OfferEditorInteractor.onCreate$lambda$12(this, updatingOrder));
        this.presenter.setUpdateListener(() -> OfferEditorInteractor.onCreate$lambda$20(this, updatingOrder));
    }

    private final boolean checkValidQuantity(Order existingOrder) {
        if (this.selectedMaterial != null) {
            int count2 = 0;
            count2 = existingOrder.getQuantity();
            PlayerInventory playerInventory = this.player.getInventory();
            Intrinsics.checkNotNullExpressionValue(playerInventory, "getInventory(...)");
            Iterable $this$forEach$iv = CollectionsKt.filterNotNull((Iterable)playerInventory);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ItemStack it = (ItemStack)element$iv;
                boolean bl = false;
                if (it.getType() != this.selectedMaterial) continue;
                ItemMeta itemMeta = it.getItemMeta();
                if (!Intrinsics.areEqual(this.builder.getMeta(), itemMeta != null ? itemMeta.getAsComponentString() : null)) continue;
                count2 += it.getAmount();
            }
            Integer n = this.builder.getQuantity();
            if ((n != null ? n : 0) > count2) {
                Object object = this.selectedMaterial;
                this.presenter.setMessage(ChatColor.YELLOW + "You don't have enough " + (object != null && (object = object.name()) != null ? StringExtKt.fromMCItem((String)object) : null) + " in your inventory!");
                return false;
            }
            this.presenter.hideMessage();
            return true;
        }
        return true;
    }

    private static final Unit onCreate$lambda$1(OfferEditorInteractor this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (StringsKt.toDoubleOrNull(it) == null) {
            this$0.presenter.updatePriceText("$0");
            this$0.presenter.setMessage(ChatColor.RED + "Prices must be a valid number!");
            v0 = this$0.builder.price(0);
        } else {
            this$0.presenter.updatePriceText("$" + StringExtKt.priceFormat(it));
            int price = (int)(Double.parseDouble(it) * (double)100 + 0.5);
            v0 = this$0.builder.price(price);
        }
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$2(OfferEditorInteractor this$0, Order $updatingOrder, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (StringsKt.toIntOrNull(it) == null) {
            this$0.presenter.updateQuantityText("0");
            this$0.presenter.setMessage(ChatColor.RED + "Quantities must be a valid, whole number!");
            v0 = this$0.builder.quantity(0);
        } else {
            this$0.builder.quantity(Integer.parseInt(it));
            v0 = this$0.checkValidQuantity($updatingOrder);
        }
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$3(OfferEditorInteractor this$0, Order $updatingOrder) {
        this$0.presenter.updateQuantityText("0");
        this$0.builder.quantity(0);
        this$0.checkValidQuantity($updatingOrder);
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$5(OfferEditorInteractor this$0, Order $updatingOrder) {
        block1: {
            Integer n = this$0.builder.getQuantity();
            if (n == null) break block1;
            int quantity = ((Number)n).intValue();
            boolean bl = false;
            if (quantity > 0) {
                this$0.builder.quantity(quantity - 1);
                this$0.presenter.updateQuantityText(String.valueOf(this$0.builder.getQuantity()));
                this$0.checkValidQuantity($updatingOrder);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$7(Order $updatingOrder, OfferEditorInteractor this$0) {
        int count2 = 0;
        count2 = $updatingOrder.getQuantity();
        PlayerInventory playerInventory = this$0.player.getInventory();
        Intrinsics.checkNotNullExpressionValue(playerInventory, "getInventory(...)");
        Iterable $this$forEach$iv = CollectionsKt.filterNotNull((Iterable)playerInventory);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemStack it = (ItemStack)element$iv;
            boolean bl = false;
            if (it.getType() != this$0.selectedMaterial) continue;
            ItemMeta itemMeta = it.getItemMeta();
            if (!Intrinsics.areEqual(itemMeta != null ? itemMeta.getAsComponentString() : null, this$0.builder.getMeta())) continue;
            count2 += it.getAmount();
        }
        this$0.builder.quantity(count2);
        this$0.presenter.updateQuantityText(String.valueOf(this$0.builder.getQuantity()));
        this$0.checkValidQuantity($updatingOrder);
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$8(OfferEditorInteractor this$0, Order $updatingOrder) {
        Integer n = this$0.builder.getQuantity();
        this$0.builder.quantity((n != null ? n : 0) + 1);
        this$0.presenter.updateQuantityText(String.valueOf(this$0.builder.getQuantity()));
        this$0.checkValidQuantity($updatingOrder);
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$12$lambda$11$lambda$10$lambda$9(OfferEditorInteractor this$0) {
        this$0.routeBack();
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$12$lambda$11$lambda$10(OfferEditorInteractor this$0, Material $it, Order $updatingOrder, Flow $this$collectFirst, OrderStatus orderResponse) {
        Intrinsics.checkNotNullParameter($this$collectFirst, "$this$collectFirst");
        Intrinsics.checkNotNullParameter((Object)orderResponse, "orderResponse");
        if (orderResponse == OrderStatus.ERROR) {
            this$0.presenter.setMessage(ChatColor.RED + "Something went wrong, please try again later...");
        } else {
            NamespacedKey namespacedKey = $it.getKey();
            Intrinsics.checkNotNullExpressionValue(namespacedKey, "getKey(...)");
            NamespacedKey key = namespacedKey;
            ItemStack itemStack = Bukkit.getItemFactory().createItemStack(key + $updatingOrder.getMeta());
            Intrinsics.checkNotNullExpressionValue(itemStack, "createItemStack(...)");
            ItemStack item = itemStack;
            item.setAmount($updatingOrder.getQuantity());
            PlayerInventory playerInventory = this$0.player.getInventory();
            Intrinsics.checkNotNullExpressionValue(playerInventory, "getInventory(...)");
            Inventory inventory = (Inventory)playerInventory;
            Location location = this$0.player.getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            InventoryExtKt.add(inventory, location, item);
            this$0.presenter.animateOrderDeleteSuccess($it, $updatingOrder, () -> OfferEditorInteractor.onCreate$lambda$12$lambda$11$lambda$10$lambda$9(this$0));
        }
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$12(OfferEditorInteractor this$0, Order $updatingOrder) {
        block0: {
            Material material = this$0.orderRepository.getSelectedMaterial();
            if (material == null) break block0;
            Material it = material;
            boolean bl = false;
            FlowExtKt.collectFirst(this$0.orderRepository.deleteOrder(it, $updatingOrder), new DudeDispatcher(), (arg_0, arg_1) -> OfferEditorInteractor.onCreate$lambda$12$lambda$11$lambda$10(this$0, it, $updatingOrder, arg_0, arg_1));
        }
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$20$lambda$19$lambda$14$lambda$13(OfferEditorInteractor this$0) {
        this$0.routeBack();
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$20$lambda$19$lambda$14(OfferEditorInteractor this$0, Material $material, Order $order, Flow $this$collectFirst, OrderStatus it) {
        Intrinsics.checkNotNullParameter($this$collectFirst, "$this$collectFirst");
        Intrinsics.checkNotNullParameter((Object)it, "it");
        PlayerInventory playerInventory = this$0.player.getInventory();
        Intrinsics.checkNotNullExpressionValue(playerInventory, "getInventory(...)");
        InventoryExtKt.remove((Inventory)playerInventory, $material, $order.getMeta(), $order.getQuantity());
        this$0.presenter.animateOrderSuccess($material, $order, () -> OfferEditorInteractor.onCreate$lambda$20$lambda$19$lambda$14$lambda$13(this$0));
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$20$lambda$19$lambda$16$lambda$15(OfferEditorInteractor this$0) {
        this$0.routeBack();
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$20$lambda$19$lambda$16(Material $material, Order $updatingOrder, Order $order, OfferEditorInteractor this$0, Flow $this$collectFirst, OrderStatus it) {
        Intrinsics.checkNotNullParameter($this$collectFirst, "$this$collectFirst");
        Intrinsics.checkNotNullParameter((Object)it, "it");
        NamespacedKey namespacedKey = $material.getKey();
        Intrinsics.checkNotNullExpressionValue(namespacedKey, "getKey(...)");
        NamespacedKey key = namespacedKey;
        ItemStack itemStack = Bukkit.getItemFactory().createItemStack(key + $updatingOrder.getMeta());
        Intrinsics.checkNotNullExpressionValue(itemStack, "createItemStack(...)");
        ItemStack item = itemStack;
        item.setAmount(-$order.getQuantity());
        PlayerInventory playerInventory = this$0.player.getInventory();
        Intrinsics.checkNotNullExpressionValue(playerInventory, "getInventory(...)");
        Inventory inventory = (Inventory)playerInventory;
        Location location = this$0.player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        InventoryExtKt.add(inventory, location, item);
        this$0.presenter.animateOrderSuccess($material, $order, () -> OfferEditorInteractor.onCreate$lambda$20$lambda$19$lambda$16$lambda$15(this$0));
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$20$lambda$19$lambda$18$lambda$17(OfferEditorInteractor this$0) {
        this$0.routeBack();
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$20$lambda$19$lambda$18(OfferEditorInteractor this$0, Material $material, Order $order, Flow $this$collectFirst, OrderStatus it) {
        Intrinsics.checkNotNullParameter($this$collectFirst, "$this$collectFirst");
        Intrinsics.checkNotNullParameter((Object)it, "it");
        this$0.presenter.animateOrderSuccess($material, $order, () -> OfferEditorInteractor.onCreate$lambda$20$lambda$19$lambda$18$lambda$17(this$0));
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$20(OfferEditorInteractor this$0, Order $updatingOrder) {
        block10: {
            if (this$0.selectedMaterial == null) {
                this$0.presenter.setMessage(ChatColor.RED + "You need to select an item to sell first!");
                return Unit.INSTANCE;
            }
            if (this$0.builder.getPrice() == null) {
                Object object = this$0.selectedMaterial;
                this$0.presenter.setMessage(ChatColor.RED + "You need to specify the price of the " + (object != null && (object = object.name()) != null ? StringExtKt.fromMCItem((String)object) : null) + " you want to sell!");
                return Unit.INSTANCE;
            }
            if (this$0.builder.getQuantity() == null) {
                Object object = this$0.selectedMaterial;
                this$0.presenter.setMessage(ChatColor.RED + "You need to specify the amount of the " + (object != null && (object = object.name()) != null ? StringExtKt.fromMCItem((String)object) : null) + " you want to sell!");
                return Unit.INSTANCE;
            }
            Material material = this$0.selectedMaterial;
            if (material == null) break block10;
            Material material2 = material;
            boolean bl = false;
            Order.Builder builder = this$0.builder;
            UUID uUID = this$0.player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            Order order = builder.playerId(uUID).build();
            if (order == null) {
                return Unit.INSTANCE;
            }
            Order order2 = order;
            order2.setQuantity(order2.getQuantity() - $updatingOrder.getQuantity());
            if (this$0.checkValidQuantity($updatingOrder)) {
                if (order2.getQuantity() > 0) {
                    FlowExtKt.collectFirst(this$0.orderRepository.updateOrder(material2, $updatingOrder, order2), new DudeDispatcher(), (arg_0, arg_1) -> OfferEditorInteractor.onCreate$lambda$20$lambda$19$lambda$14(this$0, material2, order2, arg_0, arg_1));
                } else if (order2.getQuantity() < 0) {
                    FlowExtKt.collectFirst(this$0.orderRepository.updateOrder(material2, $updatingOrder, order2), new DudeDispatcher(), (arg_0, arg_1) -> OfferEditorInteractor.onCreate$lambda$20$lambda$19$lambda$16(material2, $updatingOrder, order2, this$0, arg_0, arg_1));
                } else {
                    FlowExtKt.collectFirst(this$0.orderRepository.updateOrder(material2, $updatingOrder, order2), new DudeDispatcher(), (arg_0, arg_1) -> OfferEditorInteractor.onCreate$lambda$20$lambda$19$lambda$18(this$0, material2, order2, arg_0, arg_1));
                }
            } else {
                Object object = this$0.selectedMaterial;
                this$0.presenter.setMessage(ChatColor.RED + "You don't have enough " + (object != null && (object = object.name()) != null ? StringExtKt.fromMCItem((String)object) : null) + " in your inventory!");
            }
        }
        return Unit.INSTANCE;
    }
}

