/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.system.products.recipe;

import com.mcmlr.blocks.api.block.Interactor;
import com.mcmlr.blocks.core.StringExtKt;
import com.mcmlr.system.products.recipe.RecipesPresenter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/mcmlr/system/products/recipe/RecipesInteractor;", "Lcom/mcmlr/blocks/api/block/Interactor;", "presenter", "Lcom/mcmlr/system/products/recipe/RecipesPresenter;", "<init>", "(Lcom/mcmlr/system/products/recipe/RecipesPresenter;)V", "recipes", "", "Lorg/bukkit/inventory/Recipe;", "feedCallback", "Lkotlin/Function1;", "", "onCreate", "system"})
@SourceDebugExtension(value={"SMAP\nRecipesBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecipesBlock.kt\ncom/mcmlr/system/products/recipe/RecipesInteractor\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,269:1\n32#2,2:270\n774#3:272\n865#3,2:273\n*S KotlinDebug\n*F\n+ 1 RecipesBlock.kt\ncom/mcmlr/system/products/recipe/RecipesInteractor\n*L\n259#1:270,2\n264#1:272\n264#1:273,2\n*E\n"})
public final class RecipesInteractor
extends Interactor {
    @NotNull
    private final RecipesPresenter presenter;
    @NotNull
    private final List<Recipe> recipes;
    @NotNull
    private final Function1<Recipe, Unit> feedCallback;

    public RecipesInteractor(@NotNull RecipesPresenter presenter) {
        Intrinsics.checkNotNullParameter(presenter, "presenter");
        super(presenter);
        this.presenter = presenter;
        this.recipes = new ArrayList();
        this.feedCallback = arg_0 -> RecipesInteractor.feedCallback$lambda$0(this, arg_0);
    }

    @Override
    public void onCreate() {
        super.onCreate();
        this.recipes.clear();
        Iterator iterator2 = Bukkit.getServer().recipeIterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "recipeIterator(...)");
        Iterator $this$forEach$iv = iterator2;
        boolean $i$f$forEach = false;
        Iterator iterator3 = $this$forEach$iv;
        while (iterator3.hasNext()) {
            Object element$iv = iterator3.next();
            Recipe it = (Recipe)element$iv;
            boolean bl = false;
            if (!(it instanceof ShapedRecipe) && !(it instanceof ShapelessRecipe)) continue;
            this.recipes.add(it);
        }
        this.presenter.addSearchListener(arg_0 -> RecipesInteractor.onCreate$lambda$3(this, arg_0));
        this.presenter.setFeed(this.recipes, this.feedCallback);
    }

    private static final Unit feedCallback$lambda$0(RecipesInteractor this$0, Recipe recipe) {
        Intrinsics.checkNotNullParameter(recipe, "recipe");
        Recipe recipe2 = recipe;
        if (recipe2 instanceof ShapedRecipe) {
            RecipesPresenter recipesPresenter = this$0.presenter;
            String[] stringArray = ((ShapedRecipe)recipe).getShape();
            Intrinsics.checkNotNullExpressionValue(stringArray, "getShape(...)");
            Map map2 = ((ShapedRecipe)recipe).getIngredientMap();
            Intrinsics.checkNotNullExpressionValue(map2, "getIngredientMap(...)");
            recipesPresenter.setShapedRecipe(stringArray, map2);
        } else if (recipe2 instanceof ShapelessRecipe) {
            RecipesPresenter recipesPresenter = this$0.presenter;
            List list = ((ShapelessRecipe)recipe).getIngredientList();
            Intrinsics.checkNotNullExpressionValue(list, "getIngredientList(...)");
            recipesPresenter.setShapelessRecipe(list);
        } else if (recipe2 instanceof FurnaceRecipe) {
            // empty if block
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit onCreate$lambda$3(RecipesInteractor this$0, String searchTerm) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(searchTerm, "searchTerm");
        Iterable iterable = this$0.recipes;
        RecipesPresenter recipesPresenter = this$0.presenter;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Recipe it = (Recipe)element$iv$iv;
            boolean bl = false;
            String string = StringExtKt.fromMCItem(it.getResult().getType().name()).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            CharSequence charSequence = string;
            String string2 = searchTerm.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            if (!StringsKt.contains$default(charSequence, string2, false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        recipesPresenter.setFeed((List)destination$iv$iv, this$0.feedCallback);
        return Unit.INSTANCE;
    }
}

