/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.system.products.settings;

import com.mcmlr.blocks.api.block.Interactor;
import com.mcmlr.system.products.market.MarketConfigRepository;
import com.mcmlr.system.products.settings.MarketConfigPresenter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/mcmlr/system/products/settings/MarketConfigInteractor;", "Lcom/mcmlr/blocks/api/block/Interactor;", "presenter", "Lcom/mcmlr/system/products/settings/MarketConfigPresenter;", "marketConfigRepository", "Lcom/mcmlr/system/products/market/MarketConfigRepository;", "<init>", "(Lcom/mcmlr/system/products/settings/MarketConfigPresenter;Lcom/mcmlr/system/products/market/MarketConfigRepository;)V", "onCreate", "", "system"})
public final class MarketConfigInteractor
extends Interactor {
    @NotNull
    private final MarketConfigPresenter presenter;
    @NotNull
    private final MarketConfigRepository marketConfigRepository;

    public MarketConfigInteractor(@NotNull MarketConfigPresenter presenter, @NotNull MarketConfigRepository marketConfigRepository) {
        Intrinsics.checkNotNullParameter(presenter, "presenter");
        Intrinsics.checkNotNullParameter(marketConfigRepository, "marketConfigRepository");
        super(presenter);
        this.presenter = presenter;
        this.marketConfigRepository = marketConfigRepository;
    }

    @Override
    public void onCreate() {
        super.onCreate();
        int defaultOrders = this.marketConfigRepository.maxOrders();
        this.presenter.updateMaxOrdersText(defaultOrders + " Order" + (defaultOrders != 1 ? "s" : ""));
        this.presenter.setMaxOrdersListener(arg_0 -> MarketConfigInteractor.onCreate$lambda$0(this, arg_0));
    }

    private static final Unit onCreate$lambda$0(MarketConfigInteractor this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Integer maxOrders = StringsKt.toIntOrNull(it);
        if (maxOrders == null) {
            int defaultMaxOrders = this$0.marketConfigRepository.maxOrders();
            this$0.presenter.setMessage(ChatColor.RED + "Max order values must be whole numbers!");
            this$0.presenter.updateMaxOrdersText(defaultMaxOrders + " Order" + (defaultMaxOrders != 1 ? "s" : ""));
            return Unit.INSTANCE;
        }
        int orders = Math.max(0, maxOrders);
        this$0.marketConfigRepository.updateMarketMaxOrders(orders);
        this$0.presenter.updateMaxOrdersText(orders + " Order" + (orders != 1 ? "s" : ""));
        this$0.presenter.setMessage("");
        return Unit.INSTANCE;
    }
}

