/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.system.products.spawn;

import com.mcmlr.blocks.api.Resources;
import com.mcmlr.blocks.api.data.ConfigModel;
import com.mcmlr.blocks.api.data.Repository;
import com.mcmlr.system.dagger.EnvironmentScope;
import com.mcmlr.system.products.data.LocationModelKt;
import com.mcmlr.system.products.kits.KitModel;
import com.mcmlr.system.products.settings.PriorityDirection;
import com.mcmlr.system.products.spawn.RespawnType;
import com.mcmlr.system.products.spawn.SpawnModel;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Job;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@EnvironmentScope
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u0004\u0018\u00010\b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0019\u001a\u00020\u0017J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0019\u001a\u00020\u0017J\u0016\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001f\u001a\u00020\nJ\u0010\u0010 \u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010!\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\"\u001a\u0004\u0018\u00010\b2\u0006\u0010#\u001a\u00020$J\u0010\u0010%\u001a\u0004\u0018\u00010\b2\u0006\u0010&\u001a\u00020$\u00a8\u0006'"}, d2={"Lcom/mcmlr/system/products/spawn/SpawnRepository;", "Lcom/mcmlr/blocks/api/data/Repository;", "Lcom/mcmlr/system/products/spawn/SpawnModel;", "resources", "Lcom/mcmlr/blocks/api/Resources;", "<init>", "(Lcom/mcmlr/blocks/api/Resources;)V", "setEnabled", "Lkotlinx/coroutines/Job;", "enabled", "", "setSpawn", "location", "Lorg/bukkit/Location;", "setWelcomeMessage", "message", "", "setSpawnKit", "kit", "Lcom/mcmlr/system/products/kits/KitModel;", "setRespawnPriorities", "respawnLocation", "", "Lcom/mcmlr/system/products/spawn/RespawnType;", "addRespawnLocation", "respawnType", "removeRespawnLocation", "updateRespawnPriority", "priorityDirection", "Lcom/mcmlr/system/products/settings/PriorityDirection;", "setSpawnOnJoin", "spawnOnJoin", "setPlayerJoinMessage", "setPlayerQuitMessage", "setCooldown", "cooldown", "", "setDelay", "delay", "system"})
public final class SpawnRepository
extends Repository<SpawnModel> {
    @Inject
    public SpawnRepository(@NotNull Resources resources) {
        Intrinsics.checkNotNullParameter(resources, "resources");
        super(resources.dataFolder());
        Repository.loadModel$default(this, "Spawn", "config", new SpawnModel(false, null, null, null, null, false, null, null, 0, 0, 1023, null), null, 8, null);
    }

    @Nullable
    public final Job setEnabled(boolean enabled) {
        return this.save(() -> SpawnRepository.setEnabled$lambda$0(this, enabled));
    }

    @Nullable
    public final Job setSpawn(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        return this.save(() -> SpawnRepository.setSpawn$lambda$1(this, location));
    }

    @Nullable
    public final Job setWelcomeMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        return this.save(() -> SpawnRepository.setWelcomeMessage$lambda$2(this, message));
    }

    @Nullable
    public final Job setSpawnKit(@NotNull KitModel kit) {
        Intrinsics.checkNotNullParameter(kit, "kit");
        return this.save(() -> SpawnRepository.setSpawnKit$lambda$3(this, kit));
    }

    @Nullable
    public final Job setRespawnPriorities(@NotNull List<RespawnType> respawnLocation) {
        Intrinsics.checkNotNullParameter(respawnLocation, "respawnLocation");
        return this.save(() -> SpawnRepository.setRespawnPriorities$lambda$4(this, respawnLocation));
    }

    @Nullable
    public final Job addRespawnLocation(@NotNull RespawnType respawnType) {
        Intrinsics.checkNotNullParameter((Object)respawnType, "respawnType");
        return this.save(() -> SpawnRepository.addRespawnLocation$lambda$5(this, respawnType));
    }

    @Nullable
    public final Job removeRespawnLocation(@NotNull RespawnType respawnType) {
        Intrinsics.checkNotNullParameter((Object)respawnType, "respawnType");
        return this.save(() -> SpawnRepository.removeRespawnLocation$lambda$6(this, respawnType));
    }

    public final boolean updateRespawnPriority(@NotNull RespawnType respawnType, @NotNull PriorityDirection priorityDirection) {
        Intrinsics.checkNotNullParameter((Object)respawnType, "respawnType");
        Intrinsics.checkNotNullParameter((Object)priorityDirection, "priorityDirection");
        int index = ((SpawnModel)this.getModel()).getRespawnLocation().indexOf((Object)respawnType);
        int updatedIndex = index + (priorityDirection == PriorityDirection.UP ? -1 : 1);
        boolean bl = 0 <= updatedIndex ? updatedIndex < ((SpawnModel)this.getModel()).getRespawnLocation().size() : false;
        if (bl) {
            RespawnType replacedEntity = ((SpawnModel)this.getModel()).getRespawnLocation().get(updatedIndex);
            ((SpawnModel)this.getModel()).save(arg_0 -> SpawnRepository.updateRespawnPriority$lambda$7(this, updatedIndex, respawnType, index, replacedEntity, arg_0));
            return true;
        }
        return false;
    }

    @Nullable
    public final Job setSpawnOnJoin(boolean spawnOnJoin) {
        return this.save(() -> SpawnRepository.setSpawnOnJoin$lambda$8(this, spawnOnJoin));
    }

    @Nullable
    public final Job setPlayerJoinMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        return this.save(() -> SpawnRepository.setPlayerJoinMessage$lambda$9(this, message));
    }

    @Nullable
    public final Job setPlayerQuitMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        return this.save(() -> SpawnRepository.setPlayerQuitMessage$lambda$10(this, message));
    }

    @Nullable
    public final Job setCooldown(int cooldown) {
        return this.save(() -> SpawnRepository.setCooldown$lambda$11(this, cooldown));
    }

    @Nullable
    public final Job setDelay(int delay2) {
        return this.save(() -> SpawnRepository.setDelay$lambda$12(this, delay2));
    }

    private static final Unit setEnabled$lambda$0(SpawnRepository this$0, boolean $enabled) {
        ((SpawnModel)this$0.getModel()).setEnabled($enabled);
        return Unit.INSTANCE;
    }

    private static final Unit setSpawn$lambda$1(SpawnRepository this$0, Location $location) {
        ((SpawnModel)this$0.getModel()).setSpawnLocation(LocationModelKt.toLocationModel($location));
        return Unit.INSTANCE;
    }

    private static final Unit setWelcomeMessage$lambda$2(SpawnRepository this$0, String $message) {
        ((SpawnModel)this$0.getModel()).setWelcomeMessage($message);
        return Unit.INSTANCE;
    }

    private static final Unit setSpawnKit$lambda$3(SpawnRepository this$0, KitModel $kit) {
        ((SpawnModel)this$0.getModel()).setSpawnKit($kit.getUuid());
        return Unit.INSTANCE;
    }

    private static final Unit setRespawnPriorities$lambda$4(SpawnRepository this$0, List $respawnLocation) {
        ((SpawnModel)this$0.getModel()).setRespawnLocation($respawnLocation);
        return Unit.INSTANCE;
    }

    private static final Unit addRespawnLocation$lambda$5(SpawnRepository this$0, RespawnType $respawnType) {
        ((SpawnModel)this$0.getModel()).getRespawnLocation().add($respawnType);
        return Unit.INSTANCE;
    }

    private static final Unit removeRespawnLocation$lambda$6(SpawnRepository this$0, RespawnType $respawnType) {
        ((SpawnModel)this$0.getModel()).getRespawnLocation().remove((Object)$respawnType);
        return Unit.INSTANCE;
    }

    private static final Unit updateRespawnPriority$lambda$7(SpawnRepository this$0, int $updatedIndex, RespawnType $respawnType, int $index, RespawnType $replacedEntity, ConfigModel $this$save) {
        Intrinsics.checkNotNullParameter($this$save, "$this$save");
        ((SpawnModel)this$0.getModel()).getRespawnLocation().set($updatedIndex, $respawnType);
        ((SpawnModel)this$0.getModel()).getRespawnLocation().set($index, $replacedEntity);
        return Unit.INSTANCE;
    }

    private static final Unit setSpawnOnJoin$lambda$8(SpawnRepository this$0, boolean $spawnOnJoin) {
        ((SpawnModel)this$0.getModel()).setSpawnOnJoin($spawnOnJoin);
        return Unit.INSTANCE;
    }

    private static final Unit setPlayerJoinMessage$lambda$9(SpawnRepository this$0, String $message) {
        ((SpawnModel)this$0.getModel()).setJoinMessage($message);
        return Unit.INSTANCE;
    }

    private static final Unit setPlayerQuitMessage$lambda$10(SpawnRepository this$0, String $message) {
        ((SpawnModel)this$0.getModel()).setQuitMessage($message);
        return Unit.INSTANCE;
    }

    private static final Unit setCooldown$lambda$11(SpawnRepository this$0, int $cooldown) {
        ((SpawnModel)this$0.getModel()).setCooldown($cooldown);
        return Unit.INSTANCE;
    }

    private static final Unit setDelay$lambda$12(SpawnRepository this$0, int $delay) {
        ((SpawnModel)this$0.getModel()).setDelay($delay);
        return Unit.INSTANCE;
    }
}

