/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.system.products.support;

import com.mcmlr.blocks.api.ScrollEvent;
import com.mcmlr.blocks.api.ScrollModel;
import com.mcmlr.blocks.api.block.Interactor;
import com.mcmlr.blocks.core.StringExtKt;
import com.mcmlr.system.products.support.TextEditorPresenter;
import com.mcmlr.system.products.support.TextModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0016\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/mcmlr/system/products/support/TextEditorInteractor;", "Lcom/mcmlr/blocks/api/block/Interactor;", "presenter", "Lcom/mcmlr/system/products/support/TextEditorPresenter;", "<init>", "(Lcom/mcmlr/system/products/support/TextEditorPresenter;)V", "model", "Lcom/mcmlr/system/products/support/TextModel;", "getModel", "()Lcom/mcmlr/system/products/support/TextModel;", "setModel", "(Lcom/mcmlr/system/products/support/TextModel;)V", "editLines", "", "editingLine", "", "input", "", "messageScrollListener", "Lkotlin/Function1;", "Lcom/mcmlr/blocks/api/ScrollModel;", "", "onCreate", "system"})
public final class TextEditorInteractor
extends Interactor {
    @NotNull
    private final TextEditorPresenter presenter;
    @NotNull
    private TextModel model;
    private boolean editLines;
    private int editingLine;
    @NotNull
    private String input;
    @NotNull
    private Function1<? super ScrollModel, Unit> messageScrollListener;

    public TextEditorInteractor(@NotNull TextEditorPresenter presenter) {
        Intrinsics.checkNotNullParameter(presenter, "presenter");
        super(presenter);
        this.presenter = presenter;
        this.model = new TextModel(null, 1, null);
        this.editingLine = -1;
        this.input = "";
        this.messageScrollListener = arg_0 -> TextEditorInteractor.messageScrollListener$lambda$0(this, arg_0);
    }

    @NotNull
    public final TextModel getModel() {
        return this.model;
    }

    public final void setModel(@NotNull TextModel textModel) {
        Intrinsics.checkNotNullParameter(textModel, "<set-?>");
        this.model = textModel;
    }

    @Override
    public void onCreate() {
        super.onCreate();
        this.editLines = false;
        TextEditorPresenter.setMessage$default(this.presenter, this.model, 0, 2, null);
        this.presenter.setTextInputListener(arg_0 -> TextEditorInteractor.onCreate$lambda$1(this, arg_0));
        this.presenter.setEditingLineListener(arg_0 -> TextEditorInteractor.onCreate$lambda$2(this, arg_0));
        this.presenter.setSendListener(() -> TextEditorInteractor.onCreate$lambda$3(this));
        this.presenter.setEditLinesListener(() -> TextEditorInteractor.onCreate$lambda$4(this));
        this.presenter.addFinishListener(() -> TextEditorInteractor.onCreate$lambda$5(this));
    }

    private static final Unit messageScrollListener$lambda$0(TextEditorInteractor this$0, ScrollModel event) {
        Intrinsics.checkNotNullParameter(event, "event");
        int newLine = this$0.editingLine + (event.getEvent() == ScrollEvent.UP ? -1 : 1);
        this$0.editingLine = Math.max(0, Math.min(this$0.model.getLines().size() - 1, newLine));
        this$0.presenter.setMessage(this$0.model, this$0.editingLine);
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$1(TextEditorInteractor this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.input = StringExtKt.colorize(StringsKt.replace$default(it, "\\n", "\n", false, 4, null));
        this$0.presenter.setFormattedInput(this$0.input);
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$2(TextEditorInteractor this$0, int it) {
        this$0.editingLine = it;
        this$0.presenter.setMessage(this$0.model, this$0.editingLine);
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$3(TextEditorInteractor this$0) {
        if (((CharSequence)this$0.input).length() == 0) {
            return Unit.INSTANCE;
        }
        if (this$0.editLines) {
            this$0.model.getLines().set(this$0.editingLine, this$0.input);
        } else {
            this$0.model.getLines().add(this$0.input);
        }
        this$0.presenter.setMessage(this$0.model, this$0.editingLine);
        this$0.presenter.resetInput();
        this$0.input = "";
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$4(TextEditorInteractor this$0) {
        boolean bl = this$0.editLines = !this$0.editLines;
        if (this$0.editLines) {
            this$0.editingLine = 0;
            this$0.presenter.addScrollListener(this$0.messageScrollListener);
        } else {
            this$0.editingLine = -1;
            this$0.presenter.removeScrollListener(this$0.messageScrollListener);
        }
        this$0.presenter.setMessage(this$0.model, this$0.editingLine);
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$5(TextEditorInteractor this$0) {
        this$0.addBundleData("text", this$0.model);
        this$0.routeBack();
        return Unit.INSTANCE;
    }
}

