/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.system.products.teleport;

import com.mcmlr.system.dagger.EnvironmentScope;
import com.mcmlr.system.products.teleport.TeleportRequestModel;
import com.mcmlr.system.products.teleport.TeleportRequestType;
import com.mcmlr.system.products.teleport.TeleportStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@EnvironmentScope
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0006J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\r\u001a\u00020\u0006J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\bR6\u0010\u0004\u001a*\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005j\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/mcmlr/system/products/teleport/TeleportRepository;", "", "<init>", "()V", "requestsMap", "Ljava/util/HashMap;", "Ljava/util/UUID;", "", "Lcom/mcmlr/system/products/teleport/TeleportRequestModel;", "Lkotlin/collections/HashMap;", "getOnlinePlayers", "", "Lorg/bukkit/entity/Player;", "playerId", "sendRequest", "Lcom/mcmlr/system/products/teleport/TeleportStatus;", "sender", "receiver", "type", "Lcom/mcmlr/system/products/teleport/TeleportRequestType;", "getRequests", "deleteRequest", "", "request", "Companion", "system"})
@SourceDebugExtension(value={"SMAP\nTeleportRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeleportRepository.kt\ncom/mcmlr/system/products/teleport/TeleportRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n774#2:70\n865#2,2:71\n774#2:74\n865#2,2:75\n1#3:73\n*S KotlinDebug\n*F\n+ 1 TeleportRepository.kt\ncom/mcmlr/system/products/teleport/TeleportRepository\n*L\n18#1:70\n18#1:71,2\n42#1:74\n42#1:75,2\n*E\n"})
public final class TeleportRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<UUID, List<TeleportRequestModel>> requestsMap = new HashMap();
    private static final int TWO_MINUTES_IN_MILLISECONDS = 120000;

    @Inject
    public TeleportRepository() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Player> getOnlinePlayers(@NotNull UUID playerId) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Collection collection = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Player it = (Player)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it.getUniqueId(), playerId))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((List)destination$iv$iv);
    }

    @NotNull
    public final TeleportStatus sendRequest(@NotNull Player sender, @NotNull Player receiver, @NotNull TeleportRequestType type) {
        Object v0;
        List<TeleportRequestModel> requestList;
        TeleportRequestModel model;
        block4: {
            Intrinsics.checkNotNullParameter(sender, "sender");
            Intrinsics.checkNotNullParameter(receiver, "receiver");
            Intrinsics.checkNotNullParameter((Object)type, "type");
            model = new TeleportRequestModel(sender, type, new Date().getTime() + (long)120000);
            requestList = this.requestsMap.get(receiver.getUniqueId());
            if (requestList == null) {
                Map map2 = this.requestsMap;
                UUID uUID = receiver.getUniqueId();
                Object object = new TeleportRequestModel[]{model};
                object = CollectionsKt.mutableListOf(object);
                map2.put(uUID, object);
                return TeleportStatus.NEW;
            }
            Iterable iterable = requestList;
            for (Object t : iterable) {
                TeleportRequestModel it = (TeleportRequestModel)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getSender().getUniqueId(), sender.getUniqueId())) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        TeleportRequestModel existingRequest = v0;
        if (existingRequest == null) {
            requestList.add(model);
            return TeleportStatus.NEW;
        }
        if (existingRequest.getType() != type) {
            requestList.remove(existingRequest);
            requestList.add(model);
            return TeleportStatus.UPDATE;
        }
        return TeleportStatus.FAILED;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TeleportRequestModel> getRequests(@NotNull UUID playerId) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        List<TeleportRequestModel> list = this.requestsMap.get(playerId);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List<TeleportRequestModel> requests = list;
        Iterable $this$filter$iv = requests;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TeleportRequestModel it = (TeleportRequestModel)element$iv$iv;
            boolean bl = false;
            if (!(it.getTimeout() > new Date().getTime())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List<TeleportRequestModel> validRequests = CollectionsKt.toMutableList((List)destination$iv$iv);
        ((Map)this.requestsMap).put(playerId, validRequests);
        return validRequests;
    }

    public final void deleteRequest(@NotNull UUID playerId, @NotNull TeleportRequestModel request) {
        block0: {
            Intrinsics.checkNotNullParameter(playerId, "playerId");
            Intrinsics.checkNotNullParameter(request, "request");
            List<TeleportRequestModel> list = this.requestsMap.get(playerId);
            if (list == null) break block0;
            list.remove(request);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/mcmlr/system/products/teleport/TeleportRepository$Companion;", "", "<init>", "()V", "TWO_MINUTES_IN_MILLISECONDS", "", "system"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

