/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.system.products.warps;

import com.mcmlr.blocks.api.block.NavigationViewController;
import com.mcmlr.blocks.api.views.ButtonView;
import com.mcmlr.blocks.api.views.FeedView;
import com.mcmlr.blocks.api.views.Modifier;
import com.mcmlr.blocks.api.views.TextView;
import com.mcmlr.blocks.api.views.View;
import com.mcmlr.blocks.api.views.ViewContainer;
import com.mcmlr.system.products.data.PermissionNode;
import com.mcmlr.system.products.data.PermissionsRepository;
import com.mcmlr.system.products.warps.WarpActionListener;
import com.mcmlr.system.products.warps.WarpModel;
import com.mcmlr.system.products.warps.WarpsPresenter;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J&\u0010\u0014\u001a\u00020\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010\u001c\u001a\u00020\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u001dH\u0016J\u0016\u0010\u001e\u001a\u00020\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u001dH\u0016J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/mcmlr/system/products/warps/WarpsViewController;", "Lcom/mcmlr/blocks/api/block/NavigationViewController;", "Lcom/mcmlr/system/products/warps/WarpsPresenter;", "player", "Lorg/bukkit/entity/Player;", "origin", "Lorg/bukkit/Location;", "permissionsRepository", "Lcom/mcmlr/system/products/data/PermissionsRepository;", "<init>", "(Lorg/bukkit/entity/Player;Lorg/bukkit/Location;Lcom/mcmlr/system/products/data/PermissionsRepository;)V", "container", "Lcom/mcmlr/blocks/api/views/FeedView;", "messageView", "Lcom/mcmlr/blocks/api/views/TextView;", "newWarpButton", "Lcom/mcmlr/blocks/api/views/ButtonView;", "removeWarpButton", "createView", "", "setWarps", "warps", "", "Lcom/mcmlr/system/products/warps/WarpModel;", "deleteMode", "", "listener", "Lcom/mcmlr/system/products/warps/WarpActionListener;", "addNewWarpListener", "Lkotlin/Function0;", "addRemoveWarpListener", "setMessage", "message", "", "system"})
@SourceDebugExtension(value={"SMAP\nWarpsBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WarpsBlock.kt\ncom/mcmlr/system/products/warps/WarpsViewController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,288:1\n1869#2,2:289\n*S KotlinDebug\n*F\n+ 1 WarpsBlock.kt\ncom/mcmlr/system/products/warps/WarpsViewController\n*L\n128#1:289,2\n*E\n"})
public final class WarpsViewController
extends NavigationViewController
implements WarpsPresenter {
    @NotNull
    private final Player player;
    @NotNull
    private final PermissionsRepository permissionsRepository;
    private FeedView container;
    private TextView messageView;
    @Nullable
    private ButtonView newWarpButton;
    @Nullable
    private ButtonView removeWarpButton;

    public WarpsViewController(@NotNull Player player2, @NotNull Location origin, @NotNull PermissionsRepository permissionsRepository) {
        Intrinsics.checkNotNullParameter(player2, "player");
        Intrinsics.checkNotNullParameter(origin, "origin");
        Intrinsics.checkNotNullParameter(permissionsRepository, "permissionsRepository");
        super(player2, origin);
        this.player = player2;
        this.permissionsRepository = permissionsRepository;
    }

    @Override
    public void createView() {
        super.createView();
        ViewContainer viewContainer = this;
        Modifier modifier = new Modifier().size(-1, -1).alignTopToTopOf(this);
        ButtonView buttonView = this.getBackButton();
        Intrinsics.checkNotNull(buttonView);
        TextView title = ViewContainer.addTextView$default(viewContainer, Modifier.margins$default(modifier.alignStartToEndOf(buttonView), 400, 250, 0, 0, 12, null), ChatColor.BOLD + ChatColor.ITALIC + ChatColor.UNDERLINE + "Warps", 16, null, 0, 0, null, false, 0, 0, 1016, null);
        this.container = ViewContainer.addFeedView$default(this, Modifier.margins$default(new Modifier().alignTopToBottomOf(title).centerHorizontally().size(700, 400), 0, 100, 0, 0, 13, null), null, 0, null, 14, null);
        if (this.permissionsRepository.checkPermission(this.player, PermissionNode.ADMIN)) {
            ViewContainer viewContainer2 = this;
            Modifier modifier2 = new Modifier().size(-1, -1).position(-600, 0);
            FeedView feedView = this.container;
            if (feedView == null) {
                Intrinsics.throwUninitializedPropertyAccessException("container");
                feedView = null;
            }
            this.newWarpButton = ViewContainer.addButtonView$default(viewContainer2, Modifier.margins$default(modifier2.alignTopToBottomOf(feedView), 0, 50, 0, 0, 13, null), ChatColor.GOLD + "Add new warp", ChatColor.GOLD + ChatColor.BOLD + "Add new warp", 0, null, 0, 0, null, 0, 0, null, 2040, null);
            ViewContainer viewContainer3 = this;
            Modifier modifier3 = new Modifier().size(-1, -1).position(600, 0);
            FeedView feedView2 = this.container;
            if (feedView2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("container");
                feedView2 = null;
            }
            this.removeWarpButton = ViewContainer.addButtonView$default(viewContainer3, Modifier.margins$default(modifier3.alignTopToBottomOf(feedView2), 0, 50, 0, 0, 13, null), ChatColor.GOLD + "Remove warp", ChatColor.GOLD + ChatColor.BOLD + "Remove warp", 0, null, 0, 0, null, 0, 0, null, 2040, null);
        }
        Modifier modifier4 = new Modifier().size(-1, -1);
        View view = this.newWarpButton;
        if (view == null && (view = this.container) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("container");
            view = null;
        }
        Modifier modifier5 = Modifier.margins$default(modifier4.alignTopToBottomOf(view).centerHorizontally(), 0, 100, 0, 0, 13, null);
        this.messageView = ViewContainer.addTextView$default(this, modifier5, "", 4, null, 0, 0, null, false, 0, 0, 1016, null);
    }

    @Override
    public void setWarps(@NotNull List<WarpModel> warps, boolean deleteMode, @NotNull WarpActionListener listener) {
        FeedView feedView;
        Intrinsics.checkNotNullParameter(warps, "warps");
        Intrinsics.checkNotNullParameter(listener, "listener");
        if (deleteMode) {
            ButtonView buttonView = this.removeWarpButton;
            if (buttonView != null) {
                buttonView.setText(ChatColor.GOLD + "Cancel");
            }
            ButtonView buttonView2 = this.removeWarpButton;
            if (buttonView2 != null) {
                buttonView2.setHighlightedText(ChatColor.GOLD + ChatColor.BOLD + "Cancel");
            }
        } else {
            ButtonView buttonView = this.removeWarpButton;
            if (buttonView != null) {
                buttonView.setText(ChatColor.GOLD + "Remove warp");
            }
            ButtonView buttonView3 = this.removeWarpButton;
            if (buttonView3 != null) {
                buttonView3.setHighlightedText(ChatColor.GOLD + ChatColor.BOLD + "Remove warp");
            }
        }
        if ((feedView = this.container) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("container");
            feedView = null;
        }
        feedView.updateView(arg_0 -> WarpsViewController.setWarps$lambda$4(warps, this, deleteMode, listener, arg_0));
    }

    @Override
    public void addNewWarpListener(@NotNull Function0<Unit> listener) {
        block0: {
            Intrinsics.checkNotNullParameter(listener, "listener");
            ButtonView buttonView = this.newWarpButton;
            if (buttonView == null) break block0;
            buttonView.addListener(listener);
        }
    }

    @Override
    public void addRemoveWarpListener(@NotNull Function0<Unit> listener) {
        block0: {
            Intrinsics.checkNotNullParameter(listener, "listener");
            ButtonView buttonView = this.removeWarpButton;
            if (buttonView == null) break block0;
            buttonView.addListener(listener);
        }
    }

    @Override
    public void setMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        TextView textView = this.messageView;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException("messageView");
            textView = null;
        }
        textView.setText(message);
        TextView textView2 = this.messageView;
        if (textView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("messageView");
            textView2 = null;
        }
        this.updateTextDisplay(textView2);
    }

    private static final Unit setWarps$lambda$4$lambda$3$lambda$1(WarpActionListener $listener, WarpModel $home) {
        $listener.teleport($home);
        return Unit.INSTANCE;
    }

    private static final Unit setWarps$lambda$4$lambda$3$lambda$2(WarpActionListener $listener, WarpModel $home, boolean $deleteMode) {
        $listener.edit($home, $deleteMode);
        return Unit.INSTANCE;
    }

    private static final Unit setWarps$lambda$4(List $warps, WarpsViewController this$0, boolean $deleteMode, WarpActionListener $listener, ViewContainer $this$updateView) {
        Intrinsics.checkNotNullParameter($this$updateView, "$this$updateView");
        if ($warps.isEmpty()) {
            ViewContainer.addTextView$default($this$updateView, Modifier.margins$default(new Modifier().size(-1, -1).alignTopToTopOf($this$updateView).centerHorizontally(), 0, 10, 0, 0, 13, null), ChatColor.GRAY + ChatColor.ITALIC + "There are no warps\nset yet...", 8, null, 0, 0, null, false, 0, 0, 1016, null);
            return Unit.INSTANCE;
        }
        ButtonView homeView = null;
        Iterable $this$forEach$iv = $warps;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Modifier modifier;
            WarpModel home = (WarpModel)element$iv;
            boolean bl = false;
            if (homeView == null) {
                modifier = Modifier.margins$default(new Modifier().size(-1, -1).alignTopToTopOf($this$updateView).centerHorizontally(), 0, 10, 0, 0, 13, null);
            } else {
                ButtonView it = homeView;
                boolean bl2 = false;
                modifier = Modifier.margins$default(new Modifier().size(-1, -1).alignTopToBottomOf(it).centerHorizontally(), 0, 25, 0, 0, 13, null);
            }
            if (modifier == null) continue;
            Modifier modifier2 = modifier;
            homeView = ViewContainer.addButtonView$default($this$updateView, modifier2, home.getName(), ChatColor.BOLD + home.getName(), 0, null, 0, 0, null, 0, 0, () -> WarpsViewController.setWarps$lambda$4$lambda$3$lambda$1($listener, home), 1016, null);
            Modifier modifier3 = new Modifier().size(-1, -1);
            ButtonView buttonView = homeView;
            Intrinsics.checkNotNull(buttonView);
            ViewContainer.addItemView$default($this$updateView, Modifier.margins$default(modifier3.alignEndToStartOf(buttonView).alignTopToTopOf(homeView).alignBottomToBottomOf(homeView), 0, 0, 64, 0, 11, null), home.getIcon(), 0, 0, 12, null);
            if (!this$0.permissionsRepository.checkPermission(this$0.player, PermissionNode.ADMIN)) continue;
            ViewContainer.addButtonView$default($this$updateView, Modifier.margins$default(new Modifier().size(-1, -1).alignStartToEndOf(homeView).alignTopToTopOf(homeView).alignBottomToBottomOf(homeView), 64, 0, 0, 0, 14, null), (String)($deleteMode ? ChatColor.RED + "\ud83d\uddd1" : "\u270e"), $deleteMode ? ChatColor.RED + ChatColor.BOLD + "\ud83d\uddd1" : ChatColor.BOLD + "\u270e", 0, null, 0, 0, null, 0, 0, () -> WarpsViewController.setWarps$lambda$4$lambda$3$lambda$2($listener, home, $deleteMode), 1016, null);
        }
        return Unit.INSTANCE;
    }
}

