/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.apps;

import com.mcmlr.apps.Apps;
import com.mcmlr.blocks.api.Resources;
import com.mcmlr.blocks.api.data.CursorRepository;
import com.mcmlr.blocks.api.data.InputRepository;
import com.mcmlr.blocks.api.data.PlayerChatRepository;
import com.mcmlr.system.SystemCursorRepository;
import com.mcmlr.system.SystemInputRepository;
import com.mcmlr.system.SystemPlayerChatRepository;
import com.mcmlr.system.SystemResources;
import dagger.Module;
import dagger.Provides;
import java.io.File;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Server;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Module
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0006H\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0006H\u0007J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0007J\b\u0010\u0013\u001a\u00020\u0014H\u0007J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u0017"}, d2={"Lcom/mcmlr/apps/ManagerModule;", "", "<init>", "()V", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "Lcom/mcmlr/apps/Apps;", "server", "Lorg/bukkit/Server;", "dataFolder", "Ljava/io/File;", "economy", "Lnet/milkbowl/vault/economy/Economy;", "permission", "Lnet/milkbowl/vault/permission/Permission;", "cursorRepository", "Lcom/mcmlr/blocks/api/data/CursorRepository;", "playerChatRepository", "Lcom/mcmlr/blocks/api/data/PlayerChatRepository;", "inputRepository", "Lcom/mcmlr/blocks/api/data/InputRepository;", "resources", "Lcom/mcmlr/blocks/api/Resources;", "apps"})
public final class ManagerModule {
    @NotNull
    public static final ManagerModule INSTANCE = new ManagerModule();

    private ManagerModule() {
    }

    @Provides
    @NotNull
    public final JavaPlugin plugin(@NotNull Apps plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        return plugin;
    }

    @Provides
    @NotNull
    public final Server server(@NotNull Apps plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Server server = plugin.getServer();
        Intrinsics.checkNotNullExpressionValue(server, "getServer(...)");
        return server;
    }

    @Provides
    @NotNull
    public final File dataFolder(@NotNull Apps plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        File file = plugin.getDataFolder();
        Intrinsics.checkNotNullExpressionValue(file, "getDataFolder(...)");
        return file;
    }

    @Provides
    @Nullable
    public final Economy economy(@NotNull Server server) {
        Intrinsics.checkNotNullParameter(server, "server");
        RegisteredServiceProvider registeredServiceProvider = server.getServicesManager().getRegistration(Economy.class);
        return registeredServiceProvider != null ? (Economy)registeredServiceProvider.getProvider() : null;
    }

    @Provides
    @Nullable
    public final Permission permission(@NotNull Server server) {
        Intrinsics.checkNotNullParameter(server, "server");
        RegisteredServiceProvider registeredServiceProvider = server.getServicesManager().getRegistration(Permission.class);
        return registeredServiceProvider != null ? (Permission)registeredServiceProvider.getProvider() : null;
    }

    @Singleton
    @Provides
    @NotNull
    public final CursorRepository cursorRepository() {
        return new SystemCursorRepository();
    }

    @Singleton
    @Provides
    @NotNull
    public final PlayerChatRepository playerChatRepository() {
        return new SystemPlayerChatRepository();
    }

    @Singleton
    @Provides
    @NotNull
    public final InputRepository inputRepository() {
        return new SystemInputRepository();
    }

    @Singleton
    @Provides
    @NotNull
    public final Resources resources(@NotNull Server server, @NotNull JavaPlugin plugin, @NotNull File dataFolder) {
        Intrinsics.checkNotNullParameter(server, "server");
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(dataFolder, "dataFolder");
        return new SystemResources(server, dataFolder, plugin);
    }
}

