/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.blocks.api.block;

import com.mcmlr.apps.app.block.data.Bundle;
import com.mcmlr.blocks.api.CursorEvent;
import com.mcmlr.blocks.api.ScrollModel;
import com.mcmlr.blocks.api.app.App;
import com.mcmlr.blocks.api.app.Environment;
import com.mcmlr.blocks.api.block.Context;
import com.mcmlr.blocks.api.block.EmptyInteractor;
import com.mcmlr.blocks.api.block.EmptyViewController;
import com.mcmlr.blocks.api.block.Interactor;
import com.mcmlr.blocks.api.block.Router;
import com.mcmlr.blocks.api.block.ViewController;
import com.mcmlr.blocks.api.views.Coordinates;
import com.mcmlr.blocks.api.views.ViewContainer;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0016J\b\u0010\u001d\u001a\u00020\u001bH\u0016J\u0012\u0010\u001e\u001a\u00020\u001b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010 \u001a\u00020\u001bH\u0016J\n\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u001c\u0010#\u001a\u00020\u001b2\u0014\u0010$\u001a\u0010\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u001b\u0018\u00010%J\b\u0010'\u001a\u00020(H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\u0000H\u0016J\b\u0010-\u001a\u00020\u0019H\u0016J \u0010.\u001a\u00020\u001b2\f\u0010/\u001a\b\u0012\u0004\u0012\u000201002\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J&\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u00020\u00002\u0014\u0010$\u001a\u0010\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u001b\u0018\u00010%H\u0016J\b\u00104\u001a\u00020\u001bH\u0016J\b\u00105\u001a\u00020\u001bH\u0016J\b\u00106\u001a\u00020\u001bH\u0016J\b\u00107\u001a\u00020\u001bH\u0016J\b\u00108\u001a\u00020\u0000H\u0016J\u0010\u00109\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020\u0019H\u0016J\u0010\u0010;\u001a\u00020\u001b2\u0006\u0010<\u001a\u00020\u0019H\u0016J\u000e\u0010=\u001a\u00020\u001b2\u0006\u0010>\u001a\u00020?J\u001a\u0010@\u001a\u00020\u001b2\u0006\u0010>\u001a\u00020A2\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u0010B\u001a\u00020\u001b2\u0006\u0010C\u001a\u00020D2\u0006\u0010>\u001a\u00020EJ$\u0010F\u001a\u00020\u001b2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020I0H2\u0006\u0010J\u001a\u00020\u00052\u0006\u0010>\u001a\u00020EJ\u000e\u0010K\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0005J\u0016\u0010L\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010M\u001a\u00020NR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0001X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/mcmlr/blocks/api/block/Block;", "Lcom/mcmlr/blocks/api/block/Context;", "player", "Lorg/bukkit/entity/Player;", "origin", "Lorg/bukkit/Location;", "<init>", "(Lorg/bukkit/entity/Player;Lorg/bukkit/Location;)V", "getPlayer", "()Lorg/bukkit/entity/Player;", "getOrigin", "()Lorg/bukkit/Location;", "context", "getContext", "()Lcom/mcmlr/blocks/api/block/Context;", "setContext", "(Lcom/mcmlr/blocks/api/block/Context;)V", "parent", "getParent", "()Lcom/mcmlr/blocks/api/block/Block;", "setParent", "(Lcom/mcmlr/blocks/api/block/Block;)V", "router", "Lcom/mcmlr/blocks/api/block/Router;", "isChild", "", "onCreate", "", "child", "onPause", "onResume", "newOrigin", "onClose", "deeplink", "", "setResultCallback", "callback", "Lkotlin/Function1;", "Lcom/mcmlr/apps/app/block/data/Bundle;", "interactor", "Lcom/mcmlr/blocks/api/block/Interactor;", "view", "Lcom/mcmlr/blocks/api/block/ViewController;", "setHeadBlock", "head", "hasParent", "launchApp", "app", "Lcom/mcmlr/blocks/api/app/Environment;", "Lcom/mcmlr/blocks/api/app/App;", "routeTo", "block", "routeBack", "close", "minimize", "maximize", "getBlock", "setScrollState", "isScrolling", "setInputState", "getInput", "textInputEvent", "event", "Lorg/bukkit/event/player/AsyncPlayerChatEvent;", "scrollEvent", "Lcom/mcmlr/blocks/api/ScrollModel;", "cursorEventV2", "position", "Lcom/mcmlr/blocks/api/views/Coordinates;", "Lcom/mcmlr/blocks/api/CursorEvent;", "cursorEvent", "displays", "", "Lorg/bukkit/entity/Entity;", "cursor", "moveEventChild", "attach", "parentView", "Lcom/mcmlr/blocks/api/views/ViewContainer;"})
public abstract class Block
implements Context {
    @NotNull
    private final Player player;
    @NotNull
    private final Location origin;
    public Context context;
    @Nullable
    private Block parent;
    @NotNull
    private final Router router;
    private boolean isChild;

    public Block(@NotNull Player player2, @NotNull Location origin) {
        Intrinsics.checkNotNullParameter(player2, "player");
        Intrinsics.checkNotNullParameter(origin, "origin");
        this.player = player2;
        Location location = origin.clone();
        Intrinsics.checkNotNullExpressionValue(location, "clone(...)");
        this.origin = location;
        this.router = new Router();
    }

    @NotNull
    protected final Player getPlayer() {
        return this.player;
    }

    @NotNull
    public final Location getOrigin() {
        return this.origin;
    }

    @NotNull
    public final Context getContext() {
        Context context = this.context;
        if (context != null) {
            return context;
        }
        Intrinsics.throwUninitializedPropertyAccessException("context");
        return null;
    }

    public final void setContext(@NotNull Context context) {
        Intrinsics.checkNotNullParameter(context, "<set-?>");
        this.context = context;
    }

    @Nullable
    public final Block getParent() {
        return this.parent;
    }

    public final void setParent(@Nullable Block block) {
        this.parent = block;
    }

    @Override
    public void onCreate(boolean child) {
        this.isChild = child;
        this.router().configure(this);
        this.interactor().configure(this.router(), this.isChild);
        this.view().configure(this.isChild, this.router(), this);
        this.interactor().onCreate();
    }

    @Override
    public void onPause() {
        this.interactor().onPause();
        this.router().onPause();
        this.view().clear();
    }

    @Override
    public void onResume(@Nullable Location newOrigin) {
        if (newOrigin != null) {
            newOrigin.setYaw(this.origin.getYaw());
            newOrigin.setPitch(0.0f);
            Vector vector = newOrigin.getDirection().normalize();
            Intrinsics.checkNotNullExpressionValue(vector, "normalize(...)");
            Vector direction = vector;
            Location location = newOrigin.clone().add(direction.multiply(0.15));
            Intrinsics.checkNotNullExpressionValue(location, "add(...)");
            Location o = location;
            this.origin.setX(o.getX());
            this.origin.setY(o.getY());
            this.origin.setZ(o.getZ());
        }
        this.router().onResume(newOrigin);
        this.interactor().onResume(newOrigin);
    }

    @Override
    public void onClose() {
        this.interactor().onClose();
        this.view().clear();
        this.router().clear();
    }

    @Override
    @Nullable
    public String deeplink() {
        return this.getContext().deeplink();
    }

    public final void setResultCallback(@Nullable Function1<? super Bundle, Unit> callback) {
        this.router().setCallback(callback);
    }

    @NotNull
    public Interactor interactor() {
        return new EmptyInteractor();
    }

    @NotNull
    public Router router() {
        return this.router;
    }

    @NotNull
    public ViewController view() {
        return new EmptyViewController(this.player, this.origin);
    }

    @Override
    public void setHeadBlock(@NotNull Block head) {
        Intrinsics.checkNotNullParameter(head, "head");
        this.getContext().setHeadBlock(head);
    }

    @Override
    public boolean hasParent() {
        return this.parent != null || this.getContext().hasParent();
    }

    @Override
    public void launchApp(@NotNull Environment<? extends App> app, @Nullable String deeplink) {
        Intrinsics.checkNotNullParameter(app, "app");
        this.getContext().launchApp(app, deeplink);
    }

    @Override
    public void routeTo(@NotNull Block block, @Nullable Function1<? super Bundle, Unit> callback) {
        Intrinsics.checkNotNullParameter(block, "block");
        this.getContext().routeTo(block, callback);
    }

    @Override
    public void routeBack() {
        this.getContext().routeBack();
    }

    @Override
    public void close() {
        this.getContext().close();
    }

    @Override
    public void minimize() {
        this.getContext().minimize();
    }

    @Override
    public void maximize() {
        this.getContext().maximize();
    }

    @Override
    @NotNull
    public Block getBlock() {
        return this;
    }

    @Override
    public void setScrollState(boolean isScrolling) {
        this.getContext().setScrollState(isScrolling);
    }

    @Override
    public void setInputState(boolean getInput) {
        this.getContext().setInputState(getInput);
    }

    public final void textInputEvent(@NotNull AsyncPlayerChatEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.view().textInputEvent(event);
    }

    public void scrollEvent(@NotNull ScrollModel event, boolean isChild) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.view().scrollEvent(event, isChild);
        this.router().scrollEvent(event);
    }

    public static /* synthetic */ void scrollEvent$default(Block block, ScrollModel scrollModel, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: scrollEvent");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        block.scrollEvent(scrollModel, bl);
    }

    public final void cursorEventV2(@NotNull Coordinates position, @NotNull CursorEvent event) {
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter((Object)event, "event");
        this.view().cursorEventV2(position, event);
        this.router().cursorEventV2(position, event);
    }

    public final void cursorEvent(@NotNull List<? extends Entity> displays, @NotNull Location cursor, @NotNull CursorEvent event) {
        Intrinsics.checkNotNullParameter(displays, "displays");
        Intrinsics.checkNotNullParameter(cursor, "cursor");
        Intrinsics.checkNotNullParameter((Object)event, "event");
        this.view().cursorEvent(displays, cursor, event);
        this.router().cursorEvent(displays, cursor, event);
    }

    public final void moveEventChild(@NotNull Location newOrigin) {
        Intrinsics.checkNotNullParameter(newOrigin, "newOrigin");
        newOrigin.setYaw(this.origin.getYaw());
        newOrigin.setPitch(0.0f);
        Location location = newOrigin.clone();
        Intrinsics.checkNotNullExpressionValue(location, "clone(...)");
        Location o = location;
        this.view().moveEvent(this.origin, o);
        this.router().moveEvent(o);
        this.origin.setX(o.getX());
        this.origin.setY(o.getY());
        this.origin.setZ(o.getZ());
    }

    public final void attach(@NotNull Context context, @NotNull ViewContainer parentView) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(parentView, "parentView");
        this.parent = context.getBlock();
        this.setContext(context);
        this.view().attach(parentView);
    }
}

