/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.blocks.api.block;

import com.mcmlr.blocks.api.CursorEvent;
import com.mcmlr.blocks.api.ScrollModel;
import com.mcmlr.blocks.api.block.Context;
import com.mcmlr.blocks.api.block.RootView;
import com.mcmlr.blocks.api.block.Router;
import com.mcmlr.blocks.api.views.ButtonView;
import com.mcmlr.blocks.api.views.Coordinates;
import com.mcmlr.blocks.api.views.DudeDisplay;
import com.mcmlr.blocks.api.views.FeedView;
import com.mcmlr.blocks.api.views.Modifier;
import com.mcmlr.blocks.api.views.View;
import com.mcmlr.blocks.api.views.ViewContainer;
import com.mcmlr.blocks.api.views.Viewable;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0005J\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u0012H\u0016J\u0016\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 J$\u0010!\u001a\u00020\u00122\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 J\u0018\u0010&\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020'2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u000bH\u0016J\u0010\u0010*\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020\u0012H\u0004J\b\u0010.\u001a\u00020\u0012H\u0004J\b\u0010/\u001a\u00020\u000bH\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/mcmlr/blocks/api/block/ViewController;", "Lcom/mcmlr/blocks/api/views/ViewContainer;", "player", "Lorg/bukkit/entity/Player;", "origin", "Lorg/bukkit/Location;", "background", "Lorg/bukkit/Color;", "<init>", "(Lorg/bukkit/entity/Player;Lorg/bukkit/Location;Lorg/bukkit/Color;)V", "isChild", "", "isScrolling", "router", "Lcom/mcmlr/blocks/api/block/Router;", "context", "Lcom/mcmlr/blocks/api/block/Context;", "updateOrigin", "", "configure", "render", "setFocus", "view", "Lcom/mcmlr/blocks/api/views/Viewable;", "updateFocus", "getPosition", "Lcom/mcmlr/blocks/api/views/Coordinates;", "getAbsolutePosition", "clear", "cursorEventV2", "position", "event", "Lcom/mcmlr/blocks/api/CursorEvent;", "cursorEvent", "displays", "", "Lorg/bukkit/entity/Entity;", "cursor", "scrollEvent", "Lcom/mcmlr/blocks/api/ScrollModel;", "setTextInput", "getInput", "setScrolling", "level", "", "routeBack", "close", "hasParent", "block"})
@SourceDebugExtension(value={"SMAP\nViewController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewController.kt\ncom/mcmlr/blocks/api/block/ViewController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n1869#2,2:132\n1869#2,2:134\n1869#2,2:136\n1869#2,2:138\n*S KotlinDebug\n*F\n+ 1 ViewController.kt\ncom/mcmlr/blocks/api/block/ViewController\n*L\n52#1:132,2\n72#1:134,2\n89#1:136,2\n90#1:138,2\n*E\n"})
public class ViewController
extends ViewContainer {
    @NotNull
    private final Player player;
    @NotNull
    private final Location origin;
    private boolean isChild;
    private boolean isScrolling;
    private Router router;
    private Context context;

    public ViewController(@NotNull Player player2, @NotNull Location origin, @NotNull Color background) {
        Intrinsics.checkNotNullParameter(player2, "player");
        Intrinsics.checkNotNullParameter(origin, "origin");
        Intrinsics.checkNotNullParameter(background, "background");
        super(new Modifier().size(-2, -2), false, background, null, null, false, 0, 0, 250, null);
        this.player = player2;
        this.origin = origin;
        this.attach(new RootView(this.player, this.origin, 0, 4, null));
    }

    public /* synthetic */ ViewController(Player player2, Location location, Color color, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Color color2 = Color.fromARGB((int)192, (int)0, (int)0, (int)0);
            Intrinsics.checkNotNullExpressionValue(color2, "fromARGB(...)");
            color = color2;
        }
        this(player2, location, color);
    }

    public final void updateOrigin(@NotNull Location origin) {
        Intrinsics.checkNotNullParameter(origin, "origin");
        Vector vector = origin.getDirection().normalize();
        Intrinsics.checkNotNullExpressionValue(vector, "normalize(...)");
        Vector direction = vector;
        Location location = origin.clone().add(direction.multiply(0.15));
        Intrinsics.checkNotNullExpressionValue(location, "add(...)");
        Location o = location;
        this.origin.setX(o.getX());
        this.origin.setY(o.getY());
        this.origin.setZ(o.getZ());
    }

    public final void configure(boolean isChild, @NotNull Router router, @NotNull Context context) {
        Intrinsics.checkNotNullParameter(router, "router");
        Intrinsics.checkNotNullParameter(context, "context");
        this.isChild = isChild;
        this.router = router;
        this.context = context;
        this.getChildren().clear();
        this.getButtonMap().clear();
    }

    @Override
    public void render() {
        if (!this.isChild) {
            this.setDudeDisplay(this.getParent().addContainerDisplay(this));
        }
        Iterable $this$forEach$iv = this.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Viewable it = (Viewable)element$iv;
            boolean bl = false;
            it.render();
            Object object = it instanceof View ? (View)it : null;
            if (object == null || (object = ((View)object).getDudeDisplay()) == null) continue;
            Object display = object;
            if (it instanceof ButtonView) {
                ((Map)this.getButtonMap()).put(((DudeDisplay)display).getUniqueId(), it);
                continue;
            }
            if (!(it instanceof FeedView)) continue;
            ((Map)this.getScrollMap()).put(((DudeDisplay)display).getUniqueId(), it);
        }
    }

    @Override
    public void setFocus(@NotNull Viewable view) {
        Intrinsics.checkNotNullParameter(view, "view");
        if (this.isChild) {
            super.setFocus(view);
        } else {
            this.updateFocus(view);
        }
    }

    @Override
    public void updateFocus(@NotNull Viewable view) {
        Intrinsics.checkNotNullParameter(view, "view");
        Iterable $this$forEach$iv = this.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Viewable it = (Viewable)element$iv;
            boolean bl = false;
            it.updateFocus(view);
        }
    }

    @Override
    @NotNull
    public Coordinates getPosition() {
        return super.getPosition().offset(this.getParent().getAbsolutePosition());
    }

    @Override
    @NotNull
    public Coordinates getAbsolutePosition() {
        return this.getPosition();
    }

    @Override
    public void clear() {
        Object it;
        super.clear();
        if (!this.isChild) {
            DudeDisplay dudeDisplay = this.getDudeDisplay();
            if (dudeDisplay != null) {
                dudeDisplay.remove();
            }
            this.getParent().clear();
        }
        Iterable $this$forEach$iv = this.getCorners();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (BlockDisplay)element$iv;
            boolean bl = false;
            it.remove();
        }
        $this$forEach$iv = this.getChildren();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Viewable)element$iv;
            boolean bl = false;
            it.clear();
        }
    }

    public final void cursorEventV2(@NotNull Coordinates position, @NotNull CursorEvent event) {
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter((Object)event, "event");
        Viewable viewable = this.getParent();
        RootView rootView = viewable instanceof RootView ? (RootView)viewable : null;
        if (rootView == null) {
            return;
        }
        RootView root = rootView;
        root.cursorEventV2(position, event);
    }

    public final void cursorEvent(@NotNull List<? extends Entity> displays, @NotNull Location cursor, @NotNull CursorEvent event) {
        Intrinsics.checkNotNullParameter(displays, "displays");
        Intrinsics.checkNotNullParameter(cursor, "cursor");
        Intrinsics.checkNotNullParameter((Object)event, "event");
        Viewable viewable = this.getParent();
        RootView rootView = viewable instanceof RootView ? (RootView)viewable : null;
        if (rootView == null) {
            return;
        }
        RootView root = rootView;
        root.cursorEvent(displays, cursor, event);
    }

    @Override
    public void scrollEvent(@NotNull ScrollModel event, boolean isChild) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.isScrolling && !isChild) {
            return;
        }
        super.scrollEvent(event, isChild);
    }

    @Override
    public void setTextInput(boolean getInput) {
        Context context = this.context;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException("context");
            context = null;
        }
        context.setInputState(getInput);
    }

    @Override
    public void setScrolling(boolean isScrolling) {
        if (isScrolling) {
            this.player.getInventory().setHeldItemSlot(4);
        }
        this.isScrolling = isScrolling;
        Context context = this.context;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException("context");
            context = null;
        }
        context.setScrollState(isScrolling);
    }

    @Override
    public int level() {
        return this.getParent().level() + (this.isChild ? 0 : 1);
    }

    protected final void routeBack() {
        Router router = this.router;
        if (router == null) {
            Intrinsics.throwUninitializedPropertyAccessException("router");
            router = null;
        }
        router.routeBack();
    }

    protected final void close() {
        Router router = this.router;
        if (router == null) {
            Intrinsics.throwUninitializedPropertyAccessException("router");
            router = null;
        }
        router.close();
    }

    protected final boolean hasParent() {
        Router router = this.router;
        if (router == null) {
            Intrinsics.throwUninitializedPropertyAccessException("router");
            router = null;
        }
        return router.hasParent();
    }
}

