/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.system;

import com.mcmlr.blocks.api.CursorModel;
import com.mcmlr.blocks.api.ScrollEvent;
import com.mcmlr.blocks.api.ScrollModel;
import com.mcmlr.blocks.api.data.CursorRepository;
import com.mcmlr.blocks.core.FlowExtKt;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.StateFlowKt;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bH\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0016J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0018H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u001a2\u0006\u0010\u001b\u001a\u00020\u0006H\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001a2\u0006\u0010\u001b\u001a\u00020\u0006H\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\u001a2\u0006\u0010\u001b\u001a\u00020\u0006H\u0016J\u0018\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0012H\u0016J\u0018\u0010 \u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0012H\u0016R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/mcmlr/system/SystemCursorRepository;", "Lcom/mcmlr/blocks/api/data/CursorRepository;", "<init>", "()V", "cursorFlowMap", "Ljava/util/HashMap;", "Ljava/util/UUID;", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/mcmlr/blocks/api/CursorModel;", "playerMoveFlowMap", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lorg/bukkit/event/player/PlayerMoveEvent;", "cursorScrollMap", "Lcom/mcmlr/blocks/api/ScrollModel;", "scrollingUsers", "Ljava/util/HashSet;", "activeUsers", "updateStream", "", "data", "updateMoveStream", "", "event", "updateScrollStream", "Lorg/bukkit/event/player/PlayerItemHeldEvent;", "cursorStream", "Lkotlinx/coroutines/flow/Flow;", "playerId", "playerMoveStream", "scrollStream", "updateActivePlayer", "isActive", "updateUserScrollState", "isScrolling", "system"})
public final class SystemCursorRepository
implements CursorRepository {
    @NotNull
    private final HashMap<UUID, MutableStateFlow<CursorModel>> cursorFlowMap = new HashMap();
    @NotNull
    private final HashMap<UUID, MutableSharedFlow<PlayerMoveEvent>> playerMoveFlowMap = new HashMap();
    @NotNull
    private final HashMap<UUID, MutableSharedFlow<ScrollModel>> cursorScrollMap = new HashMap();
    @NotNull
    private final HashSet<UUID> scrollingUsers = new HashSet();
    @NotNull
    private final HashSet<UUID> activeUsers = new HashSet();

    @Override
    public boolean updateStream(@NotNull CursorModel data) {
        Intrinsics.checkNotNullParameter(data, "data");
        MutableStateFlow<CursorModel> mapEntry = this.cursorFlowMap.get(data.getPlayerId());
        if (mapEntry == null) {
            ((Map)this.cursorFlowMap).put(data.getPlayerId(), StateFlowKt.MutableStateFlow(data));
        } else {
            FlowExtKt.emitBackground(mapEntry, data);
        }
        return this.activeUsers.contains(data.getPlayerId());
    }

    @Override
    public void updateMoveStream(@NotNull PlayerMoveEvent event) {
        block3: {
            Intrinsics.checkNotNullParameter(event, "event");
            Location location = event.getTo();
            if (location == null) break block3;
            Location it = location;
            boolean bl = false;
            if (Math.abs(it.getX() - event.getFrom().getX()) > 0.05 || Math.abs(it.getY() - event.getFrom().getY()) > 0.05 || Math.abs(it.getZ() - event.getFrom().getZ()) > 0.05) {
                MutableSharedFlow<PlayerMoveEvent> mapEntry = this.playerMoveFlowMap.get(event.getPlayer().getUniqueId());
                if (mapEntry == null) {
                    MutableSharedFlow flow = SharedFlowKt.MutableSharedFlow$default(0, 0, null, 7, null);
                    ((Map)this.playerMoveFlowMap).put(event.getPlayer().getUniqueId(), flow);
                    FlowExtKt.emitBackground(flow, event);
                } else {
                    FlowExtKt.emitBackground(mapEntry, event);
                }
            }
        }
    }

    @Override
    public void updateScrollStream(@NotNull PlayerItemHeldEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        ScrollEvent e = event.getNewSlot() < 4 ? ScrollEvent.UP : ScrollEvent.DOWN;
        MutableSharedFlow<ScrollModel> mutableSharedFlow = this.cursorScrollMap.get(event.getPlayer().getUniqueId());
        if (mutableSharedFlow != null) {
            FlowExtKt.emitBackground(mutableSharedFlow, new ScrollModel(e));
        }
        if (this.scrollingUsers.contains(event.getPlayer().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @Override
    @NotNull
    public Flow<CursorModel> cursorStream(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        MutableStateFlow<CursorModel> mutableStateFlow = this.cursorFlowMap.get(playerId);
        return mutableStateFlow != null ? (Flow)mutableStateFlow : FlowKt.flow((Function2)new Function2<FlowCollector<? super CursorModel>, Continuation<? super Unit>, Object>(null){
            int label;

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(FlowCollector<? super CursorModel> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Override
    @NotNull
    public Flow<PlayerMoveEvent> playerMoveStream(@NotNull UUID playerId) {
        Flow flow;
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        if (this.playerMoveFlowMap.containsKey(playerId)) {
            MutableSharedFlow<PlayerMoveEvent> mutableSharedFlow = this.playerMoveFlowMap.get(playerId);
            flow = mutableSharedFlow != null ? (Flow)mutableSharedFlow : FlowKt.flow((Function2)new Function2<FlowCollector<? super PlayerMoveEvent>, Continuation<? super Unit>, Object>(null){
                int label;

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure($result);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(FlowCollector<? super PlayerMoveEvent> p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            });
        } else {
            Player player2 = Bukkit.getPlayer((UUID)playerId);
            if (player2 == null) {
                return FlowKt.flow((Function2)new Function2<FlowCollector<? super PlayerMoveEvent>, Continuation<? super Unit>, Object>(null){
                    int label;

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure($result);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    public final Object invoke(FlowCollector<? super PlayerMoveEvent> p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                });
            }
            Player player3 = player2;
            ((Map)this.playerMoveFlowMap).put(playerId, StateFlowKt.MutableStateFlow(new PlayerMoveEvent(player3, player3.getLocation(), null)));
            MutableSharedFlow<PlayerMoveEvent> mutableSharedFlow = this.playerMoveFlowMap.get(playerId);
            flow = mutableSharedFlow != null ? (Flow)mutableSharedFlow : FlowKt.flow((Function2)new Function2<FlowCollector<? super PlayerMoveEvent>, Continuation<? super Unit>, Object>(null){
                int label;

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure($result);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(FlowCollector<? super PlayerMoveEvent> p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            });
        }
        return flow;
    }

    @Override
    @NotNull
    public Flow<ScrollModel> scrollStream(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        MutableSharedFlow flow = SharedFlowKt.MutableSharedFlow$default(0, 0, null, 7, null);
        ((Map)this.cursorScrollMap).put(playerId, flow);
        return flow;
    }

    @Override
    public void updateActivePlayer(@NotNull UUID playerId, boolean isActive) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        boolean bl = isActive ? this.activeUsers.add(playerId) : this.activeUsers.remove(playerId);
    }

    @Override
    public void updateUserScrollState(@NotNull UUID playerId, boolean isScrolling) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        boolean bl = isScrolling ? this.scrollingUsers.add(playerId) : this.scrollingUsers.remove(playerId);
    }
}

