/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.system.products.data;

import com.mcmlr.blocks.core.FlowExtKt;
import com.mcmlr.system.dagger.EnvironmentScope;
import java.util.HashSet;
import java.util.UUID;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;

@EnvironmentScope
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/mcmlr/system/products/data/ServerEventsRepository;", "", "<init>", "()V", "cancelBlockEventPlayers", "Ljava/util/HashSet;", "Ljava/util/UUID;", "Lkotlin/collections/HashSet;", "playerInteractEventFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lorg/bukkit/event/player/PlayerInteractEvent;", "emitPlayerInteractEvent", "", "event", "getPlayerInteractEventStream", "Lkotlinx/coroutines/flow/Flow;", "setCancelBlock", "", "player", "Lorg/bukkit/entity/Player;", "removeCancelBlock", "cancelBlockEvent", "system"})
public final class ServerEventsRepository {
    @NotNull
    private final HashSet<UUID> cancelBlockEventPlayers = new HashSet();
    @NotNull
    private final MutableSharedFlow<PlayerInteractEvent> playerInteractEventFlow = SharedFlowKt.MutableSharedFlow$default(0, 0, null, 7, null);

    @Inject
    public ServerEventsRepository() {
    }

    public final void emitPlayerInteractEvent(@NotNull PlayerInteractEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        FlowExtKt.emitBackground(this.playerInteractEventFlow, event);
    }

    @NotNull
    public final Flow<PlayerInteractEvent> getPlayerInteractEventStream() {
        return FlowKt.filterNotNull((Flow)this.playerInteractEventFlow);
    }

    public final boolean setCancelBlock(@NotNull Player player2) {
        Intrinsics.checkNotNullParameter(player2, "player");
        return this.cancelBlockEventPlayers.add(player2.getUniqueId());
    }

    public final boolean removeCancelBlock(@NotNull Player player2) {
        Intrinsics.checkNotNullParameter(player2, "player");
        return this.cancelBlockEventPlayers.remove(player2.getUniqueId());
    }

    public final boolean cancelBlockEvent(@NotNull Player player2) {
        Intrinsics.checkNotNullParameter(player2, "player");
        return this.cancelBlockEventPlayers.contains(player2.getUniqueId());
    }
}

