/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.system.products.landing;

import com.mcmlr.blocks.api.block.Block;
import com.mcmlr.blocks.api.block.Interactor;
import com.mcmlr.blocks.api.block.ViewController;
import com.mcmlr.system.products.announcements.AnnouncementModel;
import com.mcmlr.system.products.announcements.AnnouncementsRepository;
import com.mcmlr.system.products.landing.FeedInteractor;
import com.mcmlr.system.products.landing.FeedViewController;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000eH\u0016J\b\u0010\f\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u0014\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/mcmlr/system/products/landing/FeedBlock;", "Lcom/mcmlr/blocks/api/block/Block;", "player", "Lorg/bukkit/entity/Player;", "origin", "Lorg/bukkit/Location;", "announcementsRepository", "Lcom/mcmlr/system/products/announcements/AnnouncementsRepository;", "<init>", "(Lorg/bukkit/entity/Player;Lorg/bukkit/Location;Lcom/mcmlr/system/products/announcements/AnnouncementsRepository;)V", "view", "Lcom/mcmlr/system/products/landing/FeedViewController;", "interactor", "Lcom/mcmlr/system/products/landing/FeedInteractor;", "Lcom/mcmlr/blocks/api/block/ViewController;", "Lcom/mcmlr/blocks/api/block/Interactor;", "enableCTA", "", "enabled", "", "setCustomFeed", "announcements", "", "Lcom/mcmlr/system/products/announcements/AnnouncementModel;", "system"})
public final class FeedBlock
extends Block {
    @NotNull
    private final FeedViewController view;
    @NotNull
    private final FeedInteractor interactor;

    @Inject
    public FeedBlock(@NotNull Player player2, @NotNull Location origin, @NotNull AnnouncementsRepository announcementsRepository) {
        Intrinsics.checkNotNullParameter(player2, "player");
        Intrinsics.checkNotNullParameter(origin, "origin");
        Intrinsics.checkNotNullParameter(announcementsRepository, "announcementsRepository");
        super(player2, origin);
        this.view = new FeedViewController(false, player2, origin, 1, null);
        this.interactor = new FeedInteractor(this.view, announcementsRepository);
    }

    @Override
    @NotNull
    public ViewController view() {
        return this.view;
    }

    @Override
    @NotNull
    public Interactor interactor() {
        return this.interactor;
    }

    public final void enableCTA(boolean enabled) {
        this.view.setEnableCTA(enabled);
    }

    public final void setCustomFeed(@NotNull List<AnnouncementModel> announcements) {
        Intrinsics.checkNotNullParameter(announcements, "announcements");
        this.interactor.updateFeed(announcements);
    }
}

