/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.system.products.settings;

import com.mcmlr.blocks.api.block.Interactor;
import com.mcmlr.system.products.homes.HomesConfigRepository;
import com.mcmlr.system.products.settings.HomeConfigPresenter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/mcmlr/system/products/settings/HomeConfigInteractor;", "Lcom/mcmlr/blocks/api/block/Interactor;", "presenter", "Lcom/mcmlr/system/products/settings/HomeConfigPresenter;", "homesConfigRepository", "Lcom/mcmlr/system/products/homes/HomesConfigRepository;", "<init>", "(Lcom/mcmlr/system/products/settings/HomeConfigPresenter;Lcom/mcmlr/system/products/homes/HomesConfigRepository;)V", "onCreate", "", "system"})
public final class HomeConfigInteractor
extends Interactor {
    @NotNull
    private final HomeConfigPresenter presenter;
    @NotNull
    private final HomesConfigRepository homesConfigRepository;

    public HomeConfigInteractor(@NotNull HomeConfigPresenter presenter, @NotNull HomesConfigRepository homesConfigRepository) {
        Intrinsics.checkNotNullParameter(presenter, "presenter");
        Intrinsics.checkNotNullParameter(homesConfigRepository, "homesConfigRepository");
        super(presenter);
        this.presenter = presenter;
        this.homesConfigRepository = homesConfigRepository;
    }

    @Override
    public void onCreate() {
        super.onCreate();
        int maxHomes = this.homesConfigRepository.maxHomes();
        int teleportDelay = this.homesConfigRepository.delay();
        int cooldown = this.homesConfigRepository.cooldown();
        this.presenter.updateMaxHomesText(maxHomes + " Home" + (maxHomes != 1 ? "s" : ""));
        this.presenter.updateDelayText(teleportDelay + " Second" + (teleportDelay != 1 ? "s" : ""));
        this.presenter.updateCooldownText(cooldown + " Second" + (cooldown != 1 ? "s" : ""));
        this.presenter.setMaxHomesListener(arg_0 -> HomeConfigInteractor.onCreate$lambda$0(this, arg_0));
        this.presenter.setDelayListener(arg_0 -> HomeConfigInteractor.onCreate$lambda$1(this, arg_0));
        this.presenter.setCooldownListener(arg_0 -> HomeConfigInteractor.onCreate$lambda$2(this, arg_0));
    }

    private static final Unit onCreate$lambda$0(HomeConfigInteractor this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Integer max = StringsKt.toIntOrNull(it);
        if (max == null) {
            int homes = this$0.homesConfigRepository.maxHomes();
            this$0.presenter.setMessage(ChatColor.RED + "Max home values must be whole numbers!");
            this$0.presenter.updateMaxHomesText(homes + " Home" + (homes != 1 ? "s" : ""));
            return Unit.INSTANCE;
        }
        int homes = Math.max(1, max);
        this$0.homesConfigRepository.updateMaxHomes(Math.max(1, max));
        this$0.presenter.updateMaxHomesText(homes + " Home" + (homes != 1 ? "s" : ""));
        this$0.presenter.setMessage("");
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$1(HomeConfigInteractor this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Integer delay2 = StringsKt.toIntOrNull(it);
        if (delay2 == null) {
            int defaultDelay = this$0.homesConfigRepository.delay();
            this$0.presenter.setMessage(ChatColor.RED + "Teleport delay values must be whole numbers!");
            this$0.presenter.updateDelayText(defaultDelay + " Second" + (defaultDelay != 1 ? "s" : ""));
            return Unit.INSTANCE;
        }
        int delaySeconds = Math.max(0, delay2);
        this$0.homesConfigRepository.updateHomesDelay(delaySeconds);
        this$0.presenter.updateDelayText(delaySeconds + " Second" + (delaySeconds != 1 ? "s" : ""));
        this$0.presenter.setMessage("");
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$2(HomeConfigInteractor this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Integer delay2 = StringsKt.toIntOrNull(it);
        if (delay2 == null) {
            int defaultCooldown = this$0.homesConfigRepository.cooldown();
            this$0.presenter.setMessage(ChatColor.RED + "Teleport cooldown values must be whole numbers!");
            this$0.presenter.updateCooldownText(defaultCooldown + " Second" + (defaultCooldown != 1 ? "s" : ""));
            return Unit.INSTANCE;
        }
        int delaySeconds = Math.max(0, delay2);
        this$0.homesConfigRepository.updateHomesCooldown(delaySeconds);
        this$0.presenter.updateCooldownText(delaySeconds + " Second" + (delaySeconds != 1 ? "s" : ""));
        this$0.presenter.setMessage("");
        return Unit.INSTANCE;
    }
}

