/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.system.products.spawn;

import com.mcmlr.blocks.api.block.NavigationViewController;
import com.mcmlr.blocks.api.views.ButtonView;
import com.mcmlr.blocks.api.views.Modifier;
import com.mcmlr.blocks.api.views.TextView;
import com.mcmlr.blocks.api.views.ViewContainer;
import com.mcmlr.system.products.spawn.SpawnModel;
import com.mcmlr.system.products.spawn.SpawnPresenter;
import com.mcmlr.system.products.spawn.SpawnRepository;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011H\u0016J\u0016\u0010\u0012\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/mcmlr/system/products/spawn/SpawnViewController;", "Lcom/mcmlr/blocks/api/block/NavigationViewController;", "Lcom/mcmlr/system/products/spawn/SpawnPresenter;", "player", "Lorg/bukkit/entity/Player;", "origin", "Lorg/bukkit/Location;", "spawnRepository", "Lcom/mcmlr/system/products/spawn/SpawnRepository;", "<init>", "(Lorg/bukkit/entity/Player;Lorg/bukkit/Location;Lcom/mcmlr/system/products/spawn/SpawnRepository;)V", "teleportBackButton", "Lcom/mcmlr/blocks/api/views/ButtonView;", "spawnButton", "setSpawnListener", "", "listener", "Lkotlin/Function0;", "setBackListener", "createView", "system"})
public final class SpawnViewController
extends NavigationViewController
implements SpawnPresenter {
    @NotNull
    private final Player player;
    @NotNull
    private final SpawnRepository spawnRepository;
    private ButtonView teleportBackButton;
    @Nullable
    private ButtonView spawnButton;

    public SpawnViewController(@NotNull Player player2, @NotNull Location origin, @NotNull SpawnRepository spawnRepository) {
        Intrinsics.checkNotNullParameter(player2, "player");
        Intrinsics.checkNotNullParameter(origin, "origin");
        Intrinsics.checkNotNullParameter(spawnRepository, "spawnRepository");
        super(player2, origin);
        this.player = player2;
        this.spawnRepository = spawnRepository;
    }

    @Override
    public void setSpawnListener(@NotNull Function0<Unit> listener) {
        block0: {
            Intrinsics.checkNotNullParameter(listener, "listener");
            ButtonView buttonView = this.spawnButton;
            if (buttonView == null) break block0;
            buttonView.addListener(listener);
        }
    }

    @Override
    public void setBackListener(@NotNull Function0<Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        ButtonView buttonView = this.teleportBackButton;
        if (buttonView == null) {
            Intrinsics.throwUninitializedPropertyAccessException("teleportBackButton");
            buttonView = null;
        }
        buttonView.addListener(listener);
    }

    @Override
    public void createView() {
        super.createView();
        ViewContainer viewContainer = this;
        Modifier modifier = new Modifier().size(-1, -1).alignTopToTopOf(this);
        ButtonView buttonView = this.getBackButton();
        Intrinsics.checkNotNull(buttonView);
        TextView title = ViewContainer.addTextView$default(viewContainer, Modifier.margins$default(modifier.alignStartToEndOf(buttonView), 400, 250, 0, 0, 12, null), ChatColor.BOLD + ChatColor.ITALIC + ChatColor.UNDERLINE + "Spawn", 16, null, 0, 0, null, false, 0, 0, 1016, null);
        if (((SpawnModel)this.spawnRepository.getModel()).getEnabled()) {
            Modifier modifier2 = new Modifier().size(-1, -1).x(-400).centerVertically();
            String string = ChatColor.GOLD + "Spawn";
            String string2 = ChatColor.GOLD + ChatColor.BOLD + "Spawn";
            this.spawnButton = ViewContainer.addButtonView$default(this, modifier2, string, string2, 20, null, 0, 0, null, 0, 0, null, 2032, null);
            modifier2 = new Modifier().size(-1, -1).x(400).centerVertically();
            string = ChatColor.GOLD + "Back";
            string2 = ChatColor.GOLD + ChatColor.BOLD + "Back";
            this.teleportBackButton = ViewContainer.addButtonView$default(this, modifier2, string, string2, 20, null, 0, 0, null, 0, 0, null, 2032, null);
        } else {
            Modifier modifier3 = new Modifier().size(-1, -1).center();
            String string = ChatColor.GOLD + "Back";
            String string3 = ChatColor.GOLD + ChatColor.BOLD + "Back";
            this.teleportBackButton = ViewContainer.addButtonView$default(this, modifier3, string, string3, 20, null, 0, 0, null, 0, 0, null, 2032, null);
        }
    }
}

