/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.blocks.font;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u0012\u0010\u0004\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u0012\u0010\u0005\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0002\"!\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\"!\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\"-\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\u0012j\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0001`\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"getMCTextLines", "", "", "maxLength", "getMCTextWidth", "reduceToLength", "length", "getWordLength", "word", "accentedCharacters", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "getAccentedCharacters", "()Ljava/util/HashSet;", "nonLatinCharacters", "getNonLatinCharacters", "asciiCharacters", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getAsciiCharacters", "()Ljava/util/HashMap;", "block"})
@SourceDebugExtension(value={"SMAP\nTextMeasurementFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextMeasurementFactory.kt\ncom/mcmlr/blocks/font/TextMeasurementFactoryKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,374:1\n1869#2:375\n1878#2,3:376\n1870#2:379\n1179#3,2:380\n1179#3,2:382\n1179#3,2:384\n*S KotlinDebug\n*F\n+ 1 TextMeasurementFactory.kt\ncom/mcmlr/blocks/font/TextMeasurementFactoryKt\n*L\n11#1:375\n13#1:376,3\n11#1:379\n48#1:380,2\n132#1:382,2\n190#1:384,2\n*E\n"})
public final class TextMeasurementFactoryKt {
    @NotNull
    private static final HashSet<Character> accentedCharacters;
    @NotNull
    private static final HashSet<Character> nonLatinCharacters;
    @NotNull
    private static final HashMap<Character, Integer> asciiCharacters;

    /*
     * WARNING - void declaration
     */
    public static final int getMCTextLines(@NotNull String $this$getMCTextLines, int maxLength) {
        Intrinsics.checkNotNullParameter($this$getMCTextLines, "<this>");
        if (maxLength < 0) {
            return 1;
        }
        int lines = 0;
        lines = 1;
        int length = 0;
        String[] stringArray = new String[]{" "};
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)$this$getMCTextLines, stringArray, false, 0, 6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String w = (String)element$iv;
            boolean bl = false;
            String[] stringArray2 = new String[]{"\n"};
            List words = StringsKt.split$default((CharSequence)w, stringArray2, false, 0, 6, null);
            Iterable $this$forEachIndexed$iv = words;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void word;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv;
                int i = n;
                boolean bl2 = false;
                int wordLength = TextMeasurementFactoryKt.getWordLength((String)word);
                if (i > 0) {
                    ++lines;
                    length = 0;
                }
                if (length + wordLength > maxLength) {
                    if (length > 0) {
                        ++lines;
                    }
                    if (wordLength > maxLength) {
                        lines += wordLength / maxLength;
                    }
                    length = wordLength % maxLength;
                    continue;
                }
                length += wordLength + 4;
            }
        }
        return lines;
    }

    public static final int getMCTextWidth(@NotNull String $this$getMCTextWidth, int maxLength) {
        Intrinsics.checkNotNullParameter($this$getMCTextWidth, "<this>");
        int maxLineLength = 0;
        int currentLength = 0;
        int wordLength = 0;
        boolean skip = false;
        boolean escape = false;
        boolean bold = false;
        CharSequence $this$forEach$iv = $this$getMCTextWidth;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            int charLength;
            char element$iv;
            char c = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            if (c == '\u00a7') {
                skip = true;
                continue;
            }
            if (c == '\\') {
                escape = true;
                continue;
            }
            if (skip) {
                switch (c) {
                    case 'l': {
                        bold = true;
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'r': {
                        bold = false;
                    }
                }
                skip = false;
                continue;
            }
            if (escape) {
                escape = false;
                maxLineLength = Math.max(maxLineLength, currentLength + wordLength);
                currentLength = 0;
                wordLength = 0;
                continue;
            }
            if (c == ' ') {
                if (currentLength + wordLength <= maxLength) {
                    Integer n = asciiCharacters.get(Character.valueOf(c));
                    wordLength = 0;
                    if ((currentLength += wordLength + (n != null ? n : 0) + 1) < maxLength) continue;
                    maxLineLength = maxLength;
                    currentLength = 0;
                    wordLength = 0;
                    continue;
                }
                maxLineLength = Math.max(maxLineLength, currentLength);
                currentLength = wordLength;
                wordLength = 0;
                continue;
            }
            if (asciiCharacters.get(Character.valueOf(c)) != null) {
                Integer n = asciiCharacters.get(Character.valueOf(c));
                v2 = n != null ? n : 0;
            } else {
                v2 = charLength = nonLatinCharacters.contains(Character.valueOf(c)) || accentedCharacters.contains(Character.valueOf(c)) ? 5 : 8;
            }
            if (bold) {
                ++charLength;
            }
            if (wordLength + charLength > maxLength) {
                maxLineLength = Math.max(maxLineLength, wordLength);
                currentLength = charLength + 1;
                wordLength = 0;
                continue;
            }
            wordLength += charLength + 1;
        }
        maxLineLength = currentLength + wordLength <= maxLength ? Math.max(maxLineLength, currentLength += wordLength) : Math.max(maxLineLength, Math.max(currentLength, wordLength));
        return maxLineLength;
    }

    @NotNull
    public static final String reduceToLength(@NotNull String $this$reduceToLength, int length) {
        Intrinsics.checkNotNullParameter($this$reduceToLength, "<this>");
        if (length < 1) {
            return $this$reduceToLength;
        }
        Object newString = null;
        newString = "";
        int currentLength = 0;
        boolean skip = false;
        boolean escape = false;
        boolean bold = false;
        CharSequence $this$forEach$iv = $this$reduceToLength;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            char element$iv;
            char c = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            if (c == '\u00a7') {
                skip = true;
            } else if (c == '\\') {
                escape = true;
            } else if (skip) {
                switch (c) {
                    case 'l': {
                        bold = true;
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'r': {
                        bold = false;
                    }
                }
                skip = false;
            } else if (escape) {
                escape = false;
            } else {
                int charLength;
                if (asciiCharacters.get(Character.valueOf(c)) != null) {
                    Integer n = asciiCharacters.get(Character.valueOf(c));
                    v1 = n != null ? n : 0;
                } else {
                    v1 = charLength = nonLatinCharacters.contains(Character.valueOf(c)) || accentedCharacters.contains(Character.valueOf(c)) ? 5 : 8;
                }
                if (bold) {
                    ++charLength;
                }
                if (currentLength + charLength > length - 10) {
                    newString = ((Object)StringsKt.trim((CharSequence)newString)).toString();
                    newString = newString + " ...";
                    return newString;
                }
                currentLength += charLength;
            }
            newString = "" + newString + c;
        }
        return newString;
    }

    public static final int getWordLength(@NotNull String word) {
        Intrinsics.checkNotNullParameter(word, "word");
        int length = 0;
        boolean skip = false;
        boolean escape = false;
        boolean bold = false;
        CharSequence $this$forEach$iv = word;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            int n;
            char element$iv;
            char c = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            if (c == '\u00a7') {
                skip = true;
                continue;
            }
            if (c == '\\') {
                escape = true;
                continue;
            }
            if (skip) {
                switch (c) {
                    case 'l': {
                        bold = true;
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'r': {
                        bold = false;
                    }
                }
                skip = false;
                continue;
            }
            if (escape) {
                escape = false;
                continue;
            }
            if (asciiCharacters.get(Character.valueOf(c)) != null) {
                Integer n2 = asciiCharacters.get(Character.valueOf(c));
                n = n2 != null ? n2 : 0;
            } else {
                n = nonLatinCharacters.contains(Character.valueOf(c)) || accentedCharacters.contains(Character.valueOf(c)) ? 5 : 8;
            }
            length += n;
            length += bold ? 2 : 1;
        }
        return length;
    }

    @NotNull
    public static final HashSet<Character> getAccentedCharacters() {
        return accentedCharacters;
    }

    @NotNull
    public static final HashSet<Character> getNonLatinCharacters() {
        return nonLatinCharacters;
    }

    @NotNull
    public static final HashMap<Character, Integer> getAsciiCharacters() {
        return asciiCharacters;
    }

    static {
        Serializable[] serializableArray = new Character[]{Character.valueOf('\u1e60'), Character.valueOf('\u0149'), Character.valueOf('\u0490'), Character.valueOf('\u0407'), Character.valueOf('\u0390'), Character.valueOf('\u017e'), Character.valueOf('\u016e'), Character.valueOf('\u014e'), Character.valueOf('\u013d'), Character.valueOf('\u012a'), Character.valueOf('\u011c'), Character.valueOf('\u010c'), Character.valueOf('\u00fb'), Character.valueOf('\u00e4'), Character.valueOf('\u00d0'), Character.valueOf('\u00c0'), Character.valueOf('\u1f21'), Character.valueOf('\u1f12'), Character.valueOf('\u1f85'), Character.valueOf('\u1e61'), Character.valueOf('\u01e7'), Character.valueOf('\u0491'), Character.valueOf('\u040c'), Character.valueOf('\u03aa'), Character.valueOf('\u01fc'), Character.valueOf('\u016f'), Character.valueOf('\u014f'), Character.valueOf('\u013e'), Character.valueOf('\u012b'), Character.valueOf('\u011d'), Character.valueOf('\u010d'), Character.valueOf('\u00fc'), Character.valueOf('\u00e5'), Character.valueOf('\u00d1'), Character.valueOf('\u00c1'), Character.valueOf('\u1f2a'), Character.valueOf('\u1f1b'), Character.valueOf('\u1f8e'), Character.valueOf('\u1e6a'), Character.valueOf('\u01eb'), Character.valueOf('\u1e02'), Character.valueOf('\u040d'), Character.valueOf('\u03ab'), Character.valueOf('\u01fd'), Character.valueOf('\u0170'), Character.valueOf('\u0150'), Character.valueOf('\u013f'), Character.valueOf('\u012c'), Character.valueOf('\u1e20'), Character.valueOf('\u010e'), Character.valueOf('\u00fd'), Character.valueOf('\u00e6'), Character.valueOf('\u00d2'), Character.valueOf('\u00c2'), Character.valueOf('\u1f22'), Character.valueOf('\u1f13'), Character.valueOf('\u1f86'), Character.valueOf('\u1e6b'), Character.valueOf('\u040f'), Character.valueOf('\u1e03'), Character.valueOf('\u040e'), Character.valueOf('\u03ac'), Character.valueOf('\u01fe'), Character.valueOf('\u0171'), Character.valueOf('\u0151'), Character.valueOf('\u0140'), Character.valueOf('\u012d'), Character.valueOf('\u1e21'), Character.valueOf('\u010f'), Character.valueOf('\u00ff'), Character.valueOf('\u00e7'), Character.valueOf('\u00d3'), Character.valueOf('\u00c3'), Character.valueOf('\u1f2b'), Character.valueOf('\u1f1c'), Character.valueOf('\u1f8f'), Character.valueOf('\u1e80'), Character.valueOf('\u1e0d'), Character.valueOf('\u1e0a'), Character.valueOf('\u0419'), Character.valueOf('\u03ad'), Character.valueOf('\u01ff'), Character.valueOf('\u0172'), Character.valueOf('\u0152'), Character.valueOf('\u0141'), Character.valueOf('\u012e'), Character.valueOf('\u011e'), Character.valueOf('\u0110'), Character.valueOf('\u0100'), Character.valueOf('\u00ec'), Character.valueOf('\u00d4'), Character.valueOf('\u00c4'), Character.valueOf('\u1f23'), Character.valueOf('\u1f14'), Character.valueOf('\u1f87'), Character.valueOf('\u1e81'), Character.valueOf('\u1e25'), Character.valueOf('\u1e0b'), Character.valueOf('\u0439'), Character.valueOf('\u03ae'), Character.valueOf('\u0218'), Character.valueOf('\u0173'), Character.valueOf('\u0153'), Character.valueOf('\u0142'), Character.valueOf('\u012f'), Character.valueOf('\u011f'), Character.valueOf('\u0111'), Character.valueOf('\u0101'), Character.valueOf('\u00ed'), Character.valueOf('\u00d5'), Character.valueOf('\u00c5'), Character.valueOf('\u1f2c'), Character.valueOf('\u1f1d'), Character.valueOf('\u1fbc'), Character.valueOf('\u1e82'), Character.valueOf('\u1e5b'), Character.valueOf('\u1e1e'), Character.valueOf('\u0450'), Character.valueOf('\u03af'), Character.valueOf('\u0219'), Character.valueOf('\u0174'), Character.valueOf('\u0154'), Character.valueOf('\u0143'), Character.valueOf('\u0130'), Character.valueOf('\u0120'), Character.valueOf('\u0112'), Character.valueOf('\u0102'), Character.valueOf('\u00ee'), Character.valueOf('\u00d6'), Character.valueOf('\u00c6'), Character.valueOf('\u1f24'), Character.valueOf('\u1f15'), Character.valueOf('\u1fb4'), Character.valueOf('\u1e83'), Character.valueOf('\u1e6d'), Character.valueOf('\u1e1f'), Character.valueOf('\u0451'), Character.valueOf('\u03b0'), Character.valueOf('\u021a'), Character.valueOf('\u0175'), Character.valueOf('\u0155'), Character.valueOf('\u0144'), Character.valueOf('\u0131'), Character.valueOf('\u0121'), Character.valueOf('\u0113'), Character.valueOf('\u0103'), Character.valueOf('\u00ef'), Character.valueOf('\u00d9'), Character.valueOf('\u00c7'), Character.valueOf('\u1f2d'), Character.valueOf('\u1fc8'), Character.valueOf('\u1fb6'), Character.valueOf('\u1e84'), Character.valueOf('\u1e92'), Character.valueOf('\u1e22'), Character.valueOf('\u0452'), Character.valueOf('\u03ca'), Character.valueOf('\u021b'), Character.valueOf('\u0176'), Character.valueOf('\u0156'), Character.valueOf('\u0145'), Character.valueOf('\u0134'), Character.valueOf('\u0122'), Character.valueOf('\u0114'), Character.valueOf('\u0104'), Character.valueOf('\u00f1'), Character.valueOf('\u00da'), Character.valueOf('\u00c8'), Character.valueOf('\u1f25'), Character.valueOf('\u1fc9'), Character.valueOf('\u1fb7'), Character.valueOf('\u1e85'), Character.valueOf('\u1eca'), Character.valueOf('\u1e23'), Character.valueOf('\u0453'), Character.valueOf('\u03cb'), Character.valueOf('\u0386'), Character.valueOf('\u0177'), Character.valueOf('\u0157'), Character.valueOf('\u0146'), Character.valueOf('\u0135'), Character.valueOf('\u0123'), Character.valueOf('\u0115'), Character.valueOf('\u0105'), Character.valueOf('\u00f2'), Character.valueOf('\u00db'), Character.valueOf('\u00c9'), Character.valueOf('\u1f2e'), Character.valueOf('\u1f72'), Character.valueOf('\u1fb2'), Character.valueOf('\u1ef2'), Character.valueOf('\u1ecb'), Character.valueOf('\u1e30'), Character.valueOf('\u0457'), Character.valueOf('\u03cc'), Character.valueOf('\u0388'), Character.valueOf('\u0178'), Character.valueOf('\u0158'), Character.valueOf('\u0147'), Character.valueOf('\u0136'), Character.valueOf('\u0124'), Character.valueOf('\u0116'), Character.valueOf('\u0106'), Character.valueOf('\u00f3'), Character.valueOf('\u00dc'), Character.valueOf('\u00ca'), Character.valueOf('\u1f26'), Character.valueOf('\u1f73'), Character.valueOf('\u1fb3'), Character.valueOf('\u1ef3'), Character.valueOf('\u1ecc'), Character.valueOf('\u1e31'), Character.valueOf('\u045b'), Character.valueOf('\u03cd'), Character.valueOf('\u0389'), Character.valueOf('\u0179'), Character.valueOf('\u0159'), Character.valueOf('\u0148'), Character.valueOf('\u0137'), Character.valueOf('\u0125'), Character.valueOf('\u0117'), Character.valueOf('\u0107'), Character.valueOf('\u00f4'), Character.valueOf('\u00dd'), Character.valueOf('\u00cb'), Character.valueOf('\u1f2f'), Character.valueOf('\u1f28'), Character.valueOf('\u1f18'), Character.valueOf('\u00e8'), Character.valueOf('\u1ecd'), Character.valueOf('\u1e40'), Character.valueOf('\u045c'), Character.valueOf('\u03ce'), Character.valueOf('\u038a'), Character.valueOf('\u017a'), Character.valueOf('\u015a'), Character.valueOf('\u014a'), Character.valueOf('\u0139'), Character.valueOf('\u0126'), Character.valueOf('\u0118'), Character.valueOf('\u0108'), Character.valueOf('\u00f5'), Character.valueOf('\u00e0'), Character.valueOf('\u00cc'), Character.valueOf('\u1f27'), Character.valueOf('\u1f20'), Character.valueOf('\u1f10'), Character.valueOf('\u00e9'), Character.valueOf('\u1ee4'), Character.valueOf('\u1e41'), Character.valueOf('\u045d'), Character.valueOf('\u0400'), Character.valueOf('\u038c'), Character.valueOf('\u017b'), Character.valueOf('\u015b'), Character.valueOf('\u014b'), Character.valueOf('\u013a'), Character.valueOf('\u0127'), Character.valueOf('\u0119'), Character.valueOf('\u0109'), Character.valueOf('\u00f6'), Character.valueOf('\u00e1'), Character.valueOf('\u00cd'), Character.valueOf('\u1f98'), Character.valueOf('\u1fca'), Character.valueOf('\u1f19'), Character.valueOf('\u00ea'), Character.valueOf('\u1ee5'), Character.valueOf('\u1e56'), Character.valueOf('\u045e'), Character.valueOf('\u0401'), Character.valueOf('\u038e'), Character.valueOf('\u017c'), Character.valueOf('\u015c'), Character.valueOf('\u014c'), Character.valueOf('\u013b'), Character.valueOf('\u0128'), Character.valueOf('\u011a'), Character.valueOf('\u010a'), Character.valueOf('\u00f9'), Character.valueOf('\u00e2'), Character.valueOf('\u00ce'), Character.valueOf('\u1f90'), Character.valueOf('\u1f74'), Character.valueOf('\u1f11'), Character.valueOf('\u00eb'), Character.valueOf('\u2116'), Character.valueOf('\u1e57'), Character.valueOf('\u045f'), Character.valueOf('\u0403'), Character.valueOf('\u038f'), Character.valueOf('\u017d'), Character.valueOf('\u015d'), Character.valueOf('\u014d'), Character.valueOf('\u013c'), Character.valueOf('\u0129'), Character.valueOf('\u011b'), Character.valueOf('\u010b'), Character.valueOf('\u00fa'), Character.valueOf('\u00e3'), Character.valueOf('\u00cf'), Character.valueOf('\u1f99'), Character.valueOf('\u1f29'), Character.valueOf('\u1f1a'), Character.valueOf('\u1e35'), Character.valueOf('\u1e45'), Character.valueOf('\u1e2f'), Character.valueOf('\u0206'), Character.valueOf('\u1e0c'), Character.valueOf('\u1e01'), Character.valueOf('\u0282'), Character.valueOf('\u24db'), Character.valueOf('\u24cb'), Character.valueOf('\u24bb'), Character.valueOf('\u2469'), Character.valueOf('\u04a0'), Character.valueOf('\u261c'), Character.valueOf('\u1ed8'), Character.valueOf('\u1ee6'), Character.valueOf('\u1edb'), Character.valueOf('\u1eb2'), Character.valueOf('\ufb04'), Character.valueOf('\u0207'), Character.valueOf('\u1e3a'), Character.valueOf('\u1e46'), Character.valueOf('\u020a'), Character.valueOf('\u1d6e'), Character.valueOf('\u1d6d'), Character.valueOf('\u0200'), Character.valueOf('\u0290'), Character.valueOf('\u24dc'), Character.valueOf('\u24cc'), Character.valueOf('\u24bc'), Character.valueOf('\u246a'), Character.valueOf('\u04a1'), Character.valueOf('\u262e'), Character.valueOf('\u1ed9'), Character.valueOf('\u1ee7'), Character.valueOf('\u1ee8'), Character.valueOf('\u1eb3'), Character.valueOf('\ufb06'), Character.valueOf('\u0194'), Character.valueOf('\u1e3b'), Character.valueOf('\u1e47'), Character.valueOf('\u020b'), Character.valueOf('\u01f4'), Character.valueOf('\u1e14'), Character.valueOf('\u0201'), Character.valueOf('\u0276'), Character.valueOf('\u24dd'), Character.valueOf('\u24cd'), Character.valueOf('\u24bd'), Character.valueOf('\u246b'), Character.valueOf('\u04aa'), Character.valueOf('\u1eb4'), Character.valueOf('\u1ee2'), Character.valueOf('\u1eec'), Character.valueOf('\u1ee9'), Character.valueOf('\u1ea8'), Character.valueOf('\u16a1'), Character.valueOf('\u0263'), Character.valueOf('\u1e3c'), Character.valueOf('\u1e4a'), Character.valueOf('\u01cf'), Character.valueOf('\u01f5'), Character.valueOf('\u1e15'), Character.valueOf('\u1e06'), Character.valueOf('\u01cd'), Character.valueOf('\u24de'), Character.valueOf('\u24ce'), Character.valueOf('\u24be'), Character.valueOf('\u246c'), Character.valueOf('\u04ab'), Character.valueOf('\u1eb5'), Character.valueOf('\u1ee3'), Character.valueOf('\u1eed'), Character.valueOf('\u1eb0'), Character.valueOf('\u1ea9'), Character.valueOf('\u16b5'), Character.valueOf('\u0283'), Character.valueOf('\u1e3d'), Character.valueOf('\u1e4b'), Character.valueOf('\u01d0'), Character.valueOf('\u01e6'), Character.valueOf('\u1e16'), Character.valueOf('\u1e07'), Character.valueOf('\u01ce'), Character.valueOf('\u24df'), Character.valueOf('\u24cf'), Character.valueOf('\u24bf'), Character.valueOf('\u246d'), Character.valueOf('\u01f6'), Character.valueOf('\u1ebc'), Character.valueOf('\u1ef0'), Character.valueOf('\u1ef6'), Character.valueOf('\u1eb1'), Character.valueOf('\u1eba'), Character.valueOf('\u01a0'), Character.valueOf('\u2047'), Character.valueOf('\u1e36'), Character.valueOf('\u01f8'), Character.valueOf('\u0208'), Character.valueOf('\u1e26'), Character.valueOf('\u1e17'), Character.valueOf('\u1e04'), Character.valueOf('\u01de'), Character.valueOf('\u24e0'), Character.valueOf('\u24d0'), Character.valueOf('\u24c0'), Character.valueOf('\u246e'), Character.valueOf('\u26a0'), Character.valueOf('\u1ebd'), Character.valueOf('\u1ef1'), Character.valueOf('\u1ef7'), Character.valueOf('\u1ea6'), Character.valueOf('\u1ebb'), Character.valueOf('\u01a1'), Character.valueOf('\u01f1'), Character.valueOf('\u1e37'), Character.valueOf('\u01f9'), Character.valueOf('\u0209'), Character.valueOf('\u1e27'), Character.valueOf('\u1e18'), Character.valueOf('\u1e05'), Character.valueOf('\u01df'), Character.valueOf('\u24e1'), Character.valueOf('\u24d1'), Character.valueOf('\u24c1'), Character.valueOf('\u246f'), Character.valueOf('\u24ea'), Character.valueOf('\u1ec4'), Character.valueOf('\u1ef4'), Character.valueOf('\u1ea0'), Character.valueOf('\u1ea7'), Character.valueOf('\u1ed5'), Character.valueOf('\u01af'), Character.valueOf('\u01f2'), Character.valueOf('\u1e38'), Character.valueOf('\u1e48'), Character.valueOf('\u1e2c'), Character.valueOf('\u1e28'), Character.valueOf('\u1e19'), Character.valueOf('\u1d6c'), Character.valueOf('\u01fa'), Character.valueOf('\u24e2'), Character.valueOf('\u24d2'), Character.valueOf('\u24c2'), Character.valueOf('\u2470'), Character.valueOf('\u2460'), Character.valueOf('\u1ec5'), Character.valueOf('\u1ef5'), Character.valueOf('\u1ea1'), Character.valueOf('\u1ec0'), Character.valueOf('\u1ede'), Character.valueOf('\u01b0'), Character.valueOf('\u01f3'), Character.valueOf('\u1e39'), Character.valueOf('\u1e49'), Character.valueOf('\u1e2d'), Character.valueOf('\u1e29'), Character.valueOf('\u1e1c'), Character.valueOf('\u1e08'), Character.valueOf('\u01fb'), Character.valueOf('\u24e3'), Character.valueOf('\u24d3'), Character.valueOf('\u24c3'), Character.valueOf('\u2471'), Character.valueOf('\u2461'), Character.valueOf('\u1ed2'), Character.valueOf('\u1ed0'), Character.valueOf('\u1eb6'), Character.valueOf('\u1ec1'), Character.valueOf('\u1ec2'), Character.valueOf('\u1eae'), Character.valueOf('\u01c4'), Character.valueOf('\u2c62'), Character.valueOf('\u1d70'), Character.valueOf('\u01f0'), Character.valueOf('\u1e2a'), Character.valueOf('\u1e1d'), Character.valueOf('\u1e09'), Character.valueOf('\u0202'), Character.valueOf('\u24e4'), Character.valueOf('\u24d4'), Character.valueOf('\u24c4'), Character.valueOf('\u2472'), Character.valueOf('\u2462'), Character.valueOf('\u1ee0'), Character.valueOf('\u0195'), Character.valueOf('\u1eb7'), Character.valueOf('\u1ed3'), Character.valueOf('\u1ec3'), Character.valueOf('\u1eaf'), Character.valueOf('\u01c5'), Character.valueOf('\u1e3e'), Character.valueOf('\u01ec'), Character.valueOf('\u0237'), Character.valueOf('\u1e2b'), Character.valueOf('\u0228'), Character.valueOf('\u1e10'), Character.valueOf('\u0203'), Character.valueOf('\u24e5'), Character.valueOf('\u24d5'), Character.valueOf('\u24c5'), Character.valueOf('\u2473'), Character.valueOf('\u2463'), Character.valueOf('\u1ee1'), Character.valueOf('\u1eaa'), Character.valueOf('\u1eac'), Character.valueOf('\u1edc'), Character.valueOf('\u1ec8'), Character.valueOf('\u1ea4'), Character.valueOf('\u01c6'), Character.valueOf('\u1e3f'), Character.valueOf('\u01ed'), Character.valueOf('\u01e8'), Character.valueOf('\u021e'), Character.valueOf('\u0229'), Character.valueOf('\u1e11'), Character.valueOf('\u0226'), Character.valueOf('\u24e6'), Character.valueOf('\u24d6'), Character.valueOf('\u24c6'), Character.valueOf('\u24b6'), Character.valueOf('\u2464'), Character.valueOf('\u1eee'), Character.valueOf('\u1eab'), Character.valueOf('\u1ead'), Character.valueOf('\u1edd'), Character.valueOf('\u1ec9'), Character.valueOf('\u1ea5'), Character.valueOf('\u01c7'), Character.valueOf('\u1e42'), Character.valueOf('\u022c'), Character.valueOf('\u01e9'), Character.valueOf('\u021f'), Character.valueOf('\u1e1a'), Character.valueOf('\u1e12'), Character.valueOf('\u0227'), Character.valueOf('\u24e7'), Character.valueOf('\u24d7'), Character.valueOf('\u24c7'), Character.valueOf('\u24b7'), Character.valueOf('\u2465'), Character.valueOf('\u1ef8'), Character.valueOf('\u1ed6'), Character.valueOf('\u1eb8'), Character.valueOf('\u1eea'), Character.valueOf('\u1ece'), Character.valueOf('\u1ebe'), Character.valueOf('\u01c8'), Character.valueOf('\u1e43'), Character.valueOf('\u022d'), Character.valueOf('\u1e32'), Character.valueOf('\u1e24'), Character.valueOf('\u1e1b'), Character.valueOf('\u1e13'), Character.valueOf('\u01e0'), Character.valueOf('\u24e8'), Character.valueOf('\u24d8'), Character.valueOf('\u24c8'), Character.valueOf('\u24b8'), Character.valueOf('\u2466'), Character.valueOf('\u1ef9'), Character.valueOf('\u1ed7'), Character.valueOf('\u1eb9'), Character.valueOf('\u1eeb'), Character.valueOf('\u1ecf'), Character.valueOf('\u1ebf'), Character.valueOf('\u01ca'), Character.valueOf('\u1d6f'), Character.valueOf('\u1e4c'), Character.valueOf('\u1e33'), Character.valueOf('\u1e96'), Character.valueOf('\u0204'), Character.valueOf('\u1e0e'), Character.valueOf('\u01e1'), Character.valueOf('\u24e9'), Character.valueOf('\u24d9'), Character.valueOf('\u24c9'), Character.valueOf('\u24b9'), Character.valueOf('\u2467'), Character.valueOf('\u0498'), Character.valueOf('\u1eef'), Character.valueOf('\u1ec6'), Character.valueOf('\u1ea2'), Character.valueOf('\u1ed4'), Character.valueOf('\u1ed1'), Character.valueOf('\u01cb'), Character.valueOf('\u1e44'), Character.valueOf('\u1e4d'), Character.valueOf('\u1e34'), Character.valueOf('\u1e2e'), Character.valueOf('\u0205'), Character.valueOf('\u1e0f'), Character.valueOf('\u1e00'), Character.valueOf('\u0327'), Character.valueOf('\u24da'), Character.valueOf('\u24ca'), Character.valueOf('\u24ba'), Character.valueOf('\u2468'), Character.valueOf('\u0499'), Character.valueOf('\u261e'), Character.valueOf('\u1ec7'), Character.valueOf('\u1ea3'), Character.valueOf('\u1edf'), Character.valueOf('\u1eda'), Character.valueOf('\u01cc'), Character.valueOf('\u0518'), Character.valueOf('\u04c4'), Character.valueOf('\ua68c'), Character.valueOf('\u04cd'), Character.valueOf('\u0504'), Character.valueOf('\u04f5'), Character.valueOf('\u04df'), Character.valueOf('\u04f7'), Character.valueOf('\u01a3'), Character.valueOf('\u01a4'), Character.valueOf('\u0182'), Character.valueOf('\u02a5'), Character.valueOf('\u1e93'), Character.valueOf('\u01d8'), Character.valueOf('\u1e88'), Character.valueOf('\u1e6c'), Character.valueOf('\u020c'), Character.valueOf('\u1e5a'), Character.valueOf('\u1e4e'), Character.valueOf('\u051c'), Character.valueOf('\u049f'), Character.valueOf('\u050e'), Character.valueOf('\u04c9'), Character.valueOf('\u0510'), Character.valueOf('\u04f8'), Character.valueOf('\u04e2'), Character.valueOf('\u0494'), Character.valueOf('\u0222'), Character.valueOf('\u01a5'), Character.valueOf('\u0183'), Character.valueOf('\u02a4'), Character.valueOf('\u1d76'), Character.valueOf('\u01d9'), Character.valueOf('\u1e89'), Character.valueOf('\u1e97'), Character.valueOf('\u020d'), Character.valueOf('\u1d73'), Character.valueOf('\u1e4f'), Character.valueOf('\u04d5'), Character.valueOf('\u049d'), Character.valueOf('\u04b2'), Character.valueOf('\u0528'), Character.valueOf('\u04e0'), Character.valueOf('\u04f9'), Character.valueOf('\u04e3'), Character.valueOf('\u0495'), Character.valueOf('\u0223'), Character.valueOf('\u027d'), Character.valueOf('\u0187'), Character.valueOf('\u02a9'), Character.valueOf('\u01ee'), Character.valueOf('\u01da'), Character.valueOf('\u1e98'), Character.valueOf('\u1d75'), Character.valueOf('\u01ea'), Character.valueOf('\u1d72'), Character.valueOf('\u1e50'), Character.valueOf('\u04fb'), Character.valueOf('\u051f'), Character.valueOf('\u04fc'), Character.valueOf('\u04c7'), Character.valueOf('\u0506'), Character.valueOf('\u04ec'), Character.valueOf('\u04e4'), Character.valueOf('\u04d6'), Character.valueOf('\u02ad'), Character.valueOf('\u01a6'), Character.valueOf('\u0188'), Character.valueOf('\u02aa'), Character.valueOf('\u01ef'), Character.valueOf('\u01db'), Character.valueOf('\u1e8c'), Character.valueOf('\u1e72'), Character.valueOf('\u1e54'), Character.valueOf('\u1e64'), Character.valueOf('\u1e51'), Character.valueOf('\u0503'), Character.valueOf('\u051b'), Character.valueOf('\u04fe'), Character.valueOf('\u04a4'), Character.valueOf('\u048a'), Character.valueOf('\u04ed'), Character.valueOf('\u04e5'), Character.valueOf('\u04d7'), Character.valueOf('\u02ae'), Character.valueOf('\u01ac'), Character.valueOf('\u018a'), Character.valueOf('\u02ab'), Character.valueOf('\u1e9b'), Character.valueOf('\u01dc'), Character.valueOf('\u1e8d'), Character.valueOf('\u1e73'), Character.valueOf('\u1e55'), Character.valueOf('\u1e65'), Character.valueOf('\u1e52'), Character.valueOf('\ua683'), Character.valueOf('\u04c6'), Character.valueOf('\u0526'), Character.valueOf('\u0522'), Character.valueOf('\u04c3'), Character.valueOf('\u0476'), Character.valueOf('\u04e6'), Character.valueOf('\u04bc'), Character.valueOf('\u02af'), Character.valueOf('\u01ad'), Character.valueOf('\u018b'), Character.valueOf('\u0239'), Character.valueOf('\ua73e'), Character.valueOf('\u1e74'), Character.valueOf('\u1e8a'), Character.valueOf('\u1e76'), Character.valueOf('\u1d71'), Character.valueOf('\u1e66'), Character.valueOf('\u1e53'), Character.valueOf('\ua681'), Character.valueOf('\u052f'), Character.valueOf('\ua694'), Character.valueOf('\u050a'), Character.valueOf('\u049e'), Character.valueOf('\u0477'), Character.valueOf('\u04e7'), Character.valueOf('\u04bd'), Character.valueOf('\ufb14'), Character.valueOf('\u01ab'), Character.valueOf('\u018c'), Character.valueOf('\u02a8'), Character.valueOf('\ua73f'), Character.valueOf('\u1e75'), Character.valueOf('\u1e8b'), Character.valueOf('\u1e77'), Character.valueOf('\u0212'), Character.valueOf('\u1e67'), Character.valueOf('\u020e'), Character.valueOf('\ua689'), Character.valueOf('\u0513'), Character.valueOf('\u04b4'), Character.valueOf('\u04a8'), Character.valueOf('\u049c'), Character.valueOf('\u04d4'), Character.valueOf('\u04ea'), Character.valueOf('\u04be'), Character.valueOf('\ufb15'), Character.valueOf('\u01ae'), Character.valueOf('\u0193'), Character.valueOf('\u02a6'), Character.valueOf('\u01e2'), Character.valueOf('\u0214'), Character.valueOf('\u0232'), Character.valueOf('\u1e78'), Character.valueOf('\u0213'), Character.valueOf('\u1e62'), Character.valueOf('\u020f'), Character.valueOf('\u052b'), Character.valueOf('\u0521'), Character.valueOf('\ua68e'), Character.valueOf('\u0524'), Character.valueOf('\u051e'), Character.valueOf('\u04fa'), Character.valueOf('\u04eb'), Character.valueOf('\u04bf'), Character.valueOf('\ufb17'), Character.valueOf('\u0217'), Character.valueOf('\u01e4'), Character.valueOf('\u02a7'), Character.valueOf('\u01e3'), Character.valueOf('\u0215'), Character.valueOf('\u0233'), Character.valueOf('\u1e79'), Character.valueOf('\u1e58'), Character.valueOf('\u1e63'), Character.valueOf('\u022a'), Character.valueOf('\u052d'), Character.valueOf('\u0509'), Character.valueOf('\u04b6'), Character.valueOf('\u04a6'), Character.valueOf('\u051a'), Character.valueOf('\u0502'), Character.valueOf('\u04f0'), Character.valueOf('\u04da'), Character.valueOf('\ufb16'), Character.valueOf('\u01b1'), Character.valueOf('\u01e5'), Character.valueOf('\uab50'), Character.valueOf('\u1d7a'), Character.valueOf('\u0216'), Character.valueOf('\u1e8e'), Character.valueOf('\u1e7a'), Character.valueOf('\u1e59'), Character.valueOf('\u1e68'), Character.valueOf('\u022b'), Character.valueOf('\ua685'), Character.valueOf('\u0515'), Character.valueOf('\u04cb'), Character.valueOf('\u048e'), Character.valueOf('\u04c5'), Character.valueOf('\ua682'), Character.valueOf('\u04f1'), Character.valueOf('\u04db'), Character.valueOf('\ufb13'), Character.valueOf('\u019c'), Character.valueOf('\u0197'), Character.valueOf('\uab51'), Character.valueOf('\u1efb'), Character.valueOf('\u1e7e'), Character.valueOf('\u1e8f'), Character.valueOf('\u1e7b'), Character.valueOf('\u1e5c'), Character.valueOf('\u1e69'), Character.valueOf('\u01d1'), Character.valueOf('\u0505'), Character.valueOf('\u04ce'), Character.valueOf('\u04b8'), Character.valueOf('\u0516'), Character.valueOf('\u052e'), Character.valueOf('\ua680'), Character.valueOf('\u04ee'), Character.valueOf('\u04dc'), Character.valueOf('\u04d0'), Character.valueOf('\u01b3'), Character.valueOf('\u0196'), Character.valueOf('\u20a7'), Character.valueOf('\u1d02'), Character.valueOf('\u1e7f'), Character.valueOf('\u1e99'), Character.valueOf('\u01d3'), Character.valueOf('\u1e5d'), Character.valueOf('\u1d74'), Character.valueOf('\u01d2'), Character.valueOf('\u0511'), Character.valueOf('\u04ca'), Character.valueOf('\ua692'), Character.valueOf('\u050c'), Character.valueOf('\u0512'), Character.valueOf('\ua688'), Character.valueOf('\u04ef'), Character.valueOf('\u04dd'), Character.valueOf('\u04d1'), Character.valueOf('\u01b4'), Character.valueOf('\u0269'), Character.valueOf('\u1efa'), Character.valueOf('\u1d14'), Character.valueOf('\u1e7c'), Character.valueOf('\u1e94'), Character.valueOf('\u01d4'), Character.valueOf('\u1e5e'), Character.valueOf('\u1e70'), Character.valueOf('\u022e'), Character.valueOf('\u04e1'), Character.valueOf('\u0529'), Character.valueOf('\ua696'), Character.valueOf('\ua690'), Character.valueOf('\u0520'), Character.valueOf('\u052a'), Character.valueOf('\u04f2'), Character.valueOf('\u04c1'), Character.valueOf('\u04d2'), Character.valueOf('\u01b5'), Character.valueOf('\u0198'), Character.valueOf('\ufb2e'), Character.valueOf('\uab63'), Character.valueOf('\u1e7d'), Character.valueOf('\u1e95'), Character.valueOf('\u01d5'), Character.valueOf('\u1e5f'), Character.valueOf('\u1e71'), Character.valueOf('\u022f'), Character.valueOf('\u0507'), Character.valueOf('\u04c8'), Character.valueOf('\ua686'), Character.valueOf('\u04ac'), Character.valueOf('\u0508'), Character.valueOf('\u052c'), Character.valueOf('\u04f3'), Character.valueOf('\u04c2'), Character.valueOf('\u04d3'), Character.valueOf('\u01b6'), Character.valueOf('\u0199'), Character.valueOf('\ufb2f'), Character.valueOf('\u0238'), Character.valueOf('\u1e86'), Character.valueOf('\u1e90'), Character.valueOf('\u01d6'), Character.valueOf('\u0210'), Character.valueOf('\u1e6e'), Character.valueOf('\u0230'), Character.valueOf('\u048b'), Character.valueOf('\u04a5'), Character.valueOf('\u048c'), Character.valueOf('\ua68a'), Character.valueOf('\u0514'), Character.valueOf('\ua684'), Character.valueOf('\u04f4'), Character.valueOf('\u04de'), Character.valueOf('\u04f6'), Character.valueOf('\u01a2'), Character.valueOf('\u019d'), Character.valueOf('\u0180'), Character.valueOf('\u02a3'), Character.valueOf('\u1e87'), Character.valueOf('\u1e91'), Character.valueOf('\u01d7'), Character.valueOf('\u0211'), Character.valueOf('\u1e6f'), Character.valueOf('\u0231'), Character.valueOf('\u0523'), Character.valueOf('\u0527'), Character.valueOf('\u1f01'), Character.valueOf('\u1fb0'), Character.valueOf('\u1ffb'), Character.valueOf('\u1f6f'), Character.valueOf('\u1faf'), Character.valueOf('\u2c7f'), Character.valueOf('\u1d8b'), Character.valueOf('\u1e9a'), Character.valueOf('\u1fe8'), Character.valueOf('\u1f45'), Character.valueOf('\u1fd7'), Character.valueOf('\u1f33'), Character.valueOf('\u1fc3'), Character.valueOf('\u1f91'), Character.valueOf('\u050b'), Character.valueOf('\ua695'), Character.valueOf('\u1f0a'), Character.valueOf('\u1fb9'), Character.valueOf('\u1f7d'), Character.valueOf('\u1f67'), Character.valueOf('\u1fa7'), Character.valueOf('\u0240'), Character.valueOf('\u1d8c'), Character.valueOf('\u2152'), Character.valueOf('\u1fe0'), Character.valueOf('\u1fec'), Character.valueOf('\u1ff8'), Character.valueOf('\u1f3c'), Character.valueOf('\u1fc2'), Character.valueOf('\u1f9a'), Character.valueOf('\u04a9'), Character.valueOf('\u04b5'), Character.valueOf('\u1f02'), Character.valueOf('\u1fb1'), Character.valueOf('\u1f68'), Character.valueOf('\u1fa8'), Character.valueOf('\u1ffc'), Character.valueOf('\u1d80'), Character.valueOf('\u1d8d'), Character.valueOf('\u2158'), Character.valueOf('\u1fe9'), Character.valueOf('\u1fe4'), Character.valueOf('\u1f78'), Character.valueOf('\u1f34'), Character.valueOf('\u1fc4'), Character.valueOf('\u1f92'), Character.valueOf('\u0525'), Character.valueOf('\ua68f'), Character.valueOf('\u1f0b'), Character.valueOf('\u1fbb'), Character.valueOf('\u1f60'), Character.valueOf('\u1fa0'), Character.valueOf('\u1ff3'), Character.valueOf('\ua7c4'), Character.valueOf('\ua7c6'), Character.valueOf('\u20a8'), Character.valueOf('\u1fe1'), Character.valueOf('\u1fe5'), Character.valueOf('\u1ff9'), Character.valueOf('\u1f3d'), Character.valueOf('\u1fc6'), Character.valueOf('\u1f9b'), Character.valueOf('\u04a7'), Character.valueOf('\u04b7'), Character.valueOf('\u1f03'), Character.valueOf('\u1f71'), Character.valueOf('\u1f69'), Character.valueOf('\u1fa9'), Character.valueOf('\u1ff2'), Character.valueOf('\ua794'), Character.valueOf('\u1d8e'), Character.valueOf('\u20af'), Character.valueOf('\u03d3'), Character.valueOf('\u1fea'), Character.valueOf('\u1f79'), Character.valueOf('\u1f35'), Character.valueOf('\u1fc7'), Character.valueOf('\u1f93'), Character.valueOf('\u048f'), Character.valueOf('\u04cc'), Character.valueOf('\u1f0c'), Character.valueOf('\u1f88'), Character.valueOf('\u1f61'), Character.valueOf('\u1fa1'), Character.valueOf('\u1ff4'), Character.valueOf('\u1d81'), Character.valueOf('\u1d8f'), Character.valueOf('\u0000'), Character.valueOf('\u03d4'), Character.valueOf('\u1f7a'), Character.valueOf('\u1f48'), Character.valueOf('\u1f3e'), Character.valueOf('\u1fda'), Character.valueOf('\u1f9c'), Character.valueOf('\u0517'), Character.valueOf('\u04b9'), Character.valueOf('\u1f04'), Character.valueOf('\u1f80'), Character.valueOf('\u1f6a'), Character.valueOf('\u1faa'), Character.valueOf('\u1ff6'), Character.valueOf('\u1d82'), Character.valueOf('\u1d90'), Character.valueOf('\u0000'), Character.valueOf('\u1fe2'), Character.valueOf('\u1feb'), Character.valueOf('\u1f40'), Character.valueOf('\u1f36'), Character.valueOf('\u1f76'), Character.valueOf('\u1f94'), Character.valueOf('\u050d'), Character.valueOf('\ua693'), Character.valueOf('\u1f0d'), Character.valueOf('\u1f89'), Character.valueOf('\u1f62'), Character.valueOf('\u1fa2'), Character.valueOf('\u1ff7'), Character.valueOf('\u1d83'), Character.valueOf('\u1d92'), Character.valueOf('\u0000'), Character.valueOf('\u1fe3'), Character.valueOf('\u1f7b'), Character.valueOf('\u1f49'), Character.valueOf('\u1f3f'), Character.valueOf('\u1fdb'), Character.valueOf('\u1f9d'), Character.valueOf('\ua691'), Character.valueOf('\ua697'), Character.valueOf('\u1f05'), Character.valueOf('\u1f81'), Character.valueOf('\u1f6b'), Character.valueOf('\u1fab'), Character.valueOf('\u262f'), Character.valueOf('\ua795'), Character.valueOf('\u1d93'), Character.valueOf('\u0000'), Character.valueOf('\u1fe7'), Character.valueOf('\u1f59'), Character.valueOf('\u1f41'), Character.valueOf('\u1f37'), Character.valueOf('\u1f77'), Character.valueOf('\u1f95'), Character.valueOf('\u04ad'), Character.valueOf('\ua687'), Character.valueOf('\u1f0e'), Character.valueOf('\u1f8a'), Character.valueOf('\u1f63'), Character.valueOf('\u1fa3'), Character.valueOf('\u2610'), Character.valueOf('\u1d84'), Character.valueOf('\u1d94'), Character.valueOf('\u0000'), Character.valueOf('\u1f50'), Character.valueOf('\u1f51'), Character.valueOf('\u1f4a'), Character.valueOf('\u1fd8'), Character.valueOf('\u1f38'), Character.valueOf('\u1f9e'), Character.valueOf('\ua68b'), Character.valueOf('\u048d'), Character.valueOf('\u1f06'), Character.valueOf('\u1f82'), Character.valueOf('\u1f6c'), Character.valueOf('\u1fac'), Character.valueOf('\u2611'), Character.valueOf('\u1d85'), Character.valueOf('\u1d95'), Character.valueOf('\u0000'), Character.valueOf('\u1f52'), Character.valueOf('\u1f5b'), Character.valueOf('\u1f42'), Character.valueOf('\u1fd0'), Character.valueOf('\u1f30'), Character.valueOf('\u1f96'), Character.valueOf('\ua68d'), Character.valueOf('\u0519'), Character.valueOf('\u1f0f'), Character.valueOf('\u1f8b'), Character.valueOf('\u1f64'), Character.valueOf('\u1fa4'), Character.valueOf('\u2612'), Character.valueOf('\u1d86'), Character.valueOf('\u1d96'), Character.valueOf('\u0000'), Character.valueOf('\u1f54'), Character.valueOf('\u1f53'), Character.valueOf('\u1f4b'), Character.valueOf('\u1fd9'), Character.valueOf('\u1f39'), Character.valueOf('\u1f9f'), Character.valueOf('\u050f'), Character.valueOf('\u051d'), Character.valueOf('\u1f07'), Character.valueOf('\u1f83'), Character.valueOf('\u1f6d'), Character.valueOf('\u1fad'), Character.valueOf('\u018d'), Character.valueOf('\u1d87'), Character.valueOf('\u1d97'), Character.valueOf('\u0000'), Character.valueOf('\u1fe6'), Character.valueOf('\u1f5d'), Character.valueOf('\u1f43'), Character.valueOf('\u1fd1'), Character.valueOf('\u1f31'), Character.valueOf('\u1f97'), Character.valueOf('\u04b3'), Character.valueOf('\u1f08'), Character.valueOf('\u1fba'), Character.valueOf('\u1f8c'), Character.valueOf('\u1f65'), Character.valueOf('\u1fa5'), Character.valueOf('\u01ba'), Character.valueOf('\u1d88'), Character.valueOf('\u1d98'), Character.valueOf('\u0000'), Character.valueOf('\u1f56'), Character.valueOf('\u1f55'), Character.valueOf('\u1f4c'), Character.valueOf('\u1fd2'), Character.valueOf('\u1f3a'), Character.valueOf('\u1fcb'), Character.valueOf('\u04fd'), Character.valueOf('\u1f00'), Character.valueOf('\u1f70'), Character.valueOf('\u1f84'), Character.valueOf('\u1f6e'), Character.valueOf('\u1fae'), Character.valueOf('\u2c7e'), Character.valueOf('\u1d89'), Character.valueOf('\u1d99'), Character.valueOf('\u0000'), Character.valueOf('\u1ffa'), Character.valueOf('\u1f5f'), Character.valueOf('\u1f44'), Character.valueOf('\u1fd3'), Character.valueOf('\u1f32'), Character.valueOf('\u1f75'), Character.valueOf('\u04ff'), Character.valueOf('\u1f09'), Character.valueOf('\u1fb8'), Character.valueOf('\u1f8d'), Character.valueOf('\u1f66'), Character.valueOf('\u1fa6'), Character.valueOf('\u023f'), Character.valueOf('\u1d8a'), Character.valueOf('\u1d9a'), Character.valueOf('\u0000'), Character.valueOf('\u1f7c'), Character.valueOf('\u1f57'), Character.valueOf('\u1f4d'), Character.valueOf('\u1fd6'), Character.valueOf('\u1f3b'), Character.valueOf('\u1fcc')};
        accentedCharacters = SetsKt.hashSetOf(serializableArray);
        serializableArray = new Character[]{Character.valueOf('\u00ad'), Character.valueOf('\u0394'), Character.valueOf('\u03a4'), Character.valueOf('\u03ba'), Character.valueOf('\u03c9'), Character.valueOf('\u0417'), Character.valueOf('\u0427'), Character.valueOf('\u0436'), Character.valueOf('\u0446'), Character.valueOf('\u045a'), Character.valueOf('\uff0b'), Character.valueOf('\u20bd'), Character.valueOf('\u2077'), Character.valueOf('\u049a'), Character.valueOf('\u05d2'), Character.valueOf('\u05e2'), Character.valueOf('\u00bd'), Character.valueOf('\udf0a'), Character.valueOf('\u2606'), Character.valueOf('\u00b7'), Character.valueOf('\u0395'), Character.valueOf('\u03a5'), Character.valueOf('\u03bb'), Character.valueOf('\u0402'), Character.valueOf('\u0418'), Character.valueOf('\u0428'), Character.valueOf('\u0437'), Character.valueOf('\u0447'), Character.valueOf('\u2013'), Character.valueOf('\u018f'), Character.valueOf('\u20ac'), Character.valueOf('\u2078'), Character.valueOf('\u049b'), Character.valueOf('\u05d3'), Character.valueOf('\u05e4'), Character.valueOf('\u00be'), Character.valueOf('\u2150'), Character.valueOf('\u2605'), Character.valueOf('\u20b4'), Character.valueOf('\u0396'), Character.valueOf('\u03a6'), Character.valueOf('\u03bc'), Character.valueOf('\u0405'), Character.valueOf('\u041a'), Character.valueOf('\u0429'), Character.valueOf('\u0438'), Character.valueOf('\u0448'), Character.valueOf('\u2014'), Character.valueOf('\u0259'), Character.valueOf('\u0462'), Character.valueOf('\u2079'), Character.valueOf('\u0492'), Character.valueOf('\u05d4'), Character.valueOf('\u05e3'), Character.valueOf('\u0387'), Character.valueOf('\u2151'), Character.valueOf('\u2718'), Character.valueOf('\u2260'), Character.valueOf('\u0397'), Character.valueOf('\u03a7'), Character.valueOf('\u03bd'), Character.valueOf('\u0406'), Character.valueOf('\u041b'), Character.valueOf('\u042a'), Character.valueOf('\u043a'), Character.valueOf('\u0449'), Character.valueOf('\u2018'), Character.valueOf('\u025b'), Character.valueOf('\u0463'), Character.valueOf('\u207a'), Character.valueOf('\u0493'), Character.valueOf('\u05d5'), Character.valueOf('\u05e6'), Character.valueOf('\u2010'), Character.valueOf('\u2155'), Character.valueOf('\u2080'), Character.valueOf('\u00bf'), Character.valueOf('\u0398'), Character.valueOf('\u03a8'), Character.valueOf('\u03be'), Character.valueOf('\u0408'), Character.valueOf('\u041c'), Character.valueOf('\u042b'), Character.valueOf('\u043b'), Character.valueOf('\u044a'), Character.valueOf('\u2019'), Character.valueOf('\u026a'), Character.valueOf('\u0474'), Character.valueOf('\u207b'), Character.valueOf('\u04b0'), Character.valueOf('\u05d6'), Character.valueOf('\u05e5'), Character.valueOf('\u201a'), Character.valueOf('\u2156'), Character.valueOf('\u2081'), Character.valueOf('\u00d7'), Character.valueOf('\u0399'), Character.valueOf('\u03a9'), Character.valueOf('\u03bf'), Character.valueOf('\u0409'), Character.valueOf('\u041d'), Character.valueOf('\u042c'), Character.valueOf('\u043c'), Character.valueOf('\u044b'), Character.valueOf('\u201c'), Character.valueOf('\u04ae'), Character.valueOf('\u0475'), Character.valueOf('\u207c'), Character.valueOf('\u04b1'), Character.valueOf('\u05d7'), Character.valueOf('\u05e7'), Character.valueOf('\u2020'), Character.valueOf('\u2157'), Character.valueOf('\u2082'), Character.valueOf('\u00d8'), Character.valueOf('\u039a'), Character.valueOf('\u03b1'), Character.valueOf('\u03c0'), Character.valueOf('\u040a'), Character.valueOf('\u041e'), Character.valueOf('\u042d'), Character.valueOf('\u043d'), Character.valueOf('\u044c'), Character.valueOf('\u201d'), Character.valueOf('\u04af'), Character.valueOf('\u04c0'), Character.valueOf('\u207d'), Character.valueOf('\u04d8'), Character.valueOf('\u05d8'), Character.valueOf('\u05e8'), Character.valueOf('\u2021'), Character.valueOf('\u2159'), Character.valueOf('\u2083'), Character.valueOf('\u00de'), Character.valueOf('\u039b'), Character.valueOf('\u03b2'), Character.valueOf('\u03c1'), Character.valueOf('\u040b'), Character.valueOf('\u041f'), Character.valueOf('\u042e'), Character.valueOf('\u043e'), Character.valueOf('\u044d'), Character.valueOf('\u201e'), Character.valueOf('\u04e8'), Character.valueOf('\u0472'), Character.valueOf('\u207e'), Character.valueOf('\u04d9'), Character.valueOf('\u05d9'), Character.valueOf('\u00a2'), Character.valueOf('\u2022'), Character.valueOf('\u215a'), Character.valueOf('\u2084'), Character.valueOf('\u04bb'), Character.valueOf('\u039c'), Character.valueOf('\u03b3'), Character.valueOf('\u03c2'), Character.valueOf('\u0410'), Character.valueOf('\u0420'), Character.valueOf('\u042f'), Character.valueOf('\u043f'), Character.valueOf('\u044e'), Character.valueOf('\u2026'), Character.valueOf('\u04e9'), Character.valueOf('\u0473'), Character.valueOf('\u2071'), Character.valueOf('\u0496'), Character.valueOf('\u05db'), Character.valueOf('\u00a4'), Character.valueOf('\u2031'), Character.valueOf('\u215f'), Character.valueOf('\u2085'), Character.valueOf('\u00f0'), Character.valueOf('\u039d'), Character.valueOf('\u03b4'), Character.valueOf('\u03c3'), Character.valueOf('\u0411'), Character.valueOf('\u0421'), Character.valueOf('\u0430'), Character.valueOf('\u0440'), Character.valueOf('\u044f'), Character.valueOf('\u204a'), Character.valueOf('\u02bb'), Character.valueOf('\u2070'), Character.valueOf('\u2122'), Character.valueOf('\u0497'), Character.valueOf('\u05dc'), Character.valueOf('\u00a5'), Character.valueOf('\u2032'), Character.valueOf('\u2189'), Character.valueOf('\u2086'), Character.valueOf('\u00f8'), Character.valueOf('\u039e'), Character.valueOf('\u03b5'), Character.valueOf('\u03c4'), Character.valueOf('\u0412'), Character.valueOf('\u0422'), Character.valueOf('\u0431'), Character.valueOf('\u0441'), Character.valueOf('\u0454'), Character.valueOf('\u2190'), Character.valueOf('\u02cc'), Character.valueOf('\u00b9'), Character.valueOf('\u0294'), Character.valueOf('\u04a2'), Character.valueOf('\u05de'), Character.valueOf('\u00a9'), Character.valueOf('\u2033'), Character.valueOf('\ud83d'), Character.valueOf('\u2087'), Character.valueOf('\u00fe'), Character.valueOf('\u039f'), Character.valueOf('\u03b6'), Character.valueOf('\u03c5'), Character.valueOf('\u0413'), Character.valueOf('\u0423'), Character.valueOf('\u0432'), Character.valueOf('\u0442'), Character.valueOf('\u0455'), Character.valueOf('\u2191'), Character.valueOf('\u037e'), Character.valueOf('\u00b3'), Character.valueOf('\u0295'), Character.valueOf('\u04a3'), Character.valueOf('\u05dd'), Character.valueOf('\u00ae'), Character.valueOf('\u2034'), Character.valueOf('\udde1'), Character.valueOf('\u2088'), Character.valueOf('\u0391'), Character.valueOf('\u03a0'), Character.valueOf('\u03b7'), Character.valueOf('\u03c6'), Character.valueOf('\u0414'), Character.valueOf('\u0424'), Character.valueOf('\u0433'), Character.valueOf('\u0443'), Character.valueOf('\u0456'), Character.valueOf('\u2192'), Character.valueOf('\u0138'), Character.valueOf('\u2074'), Character.valueOf('\u29c8'), Character.valueOf('\u04ba'), Character.valueOf('\u05e0'), Character.valueOf('\u00b5'), Character.valueOf('\u2035'), Character.valueOf('\ud83c'), Character.valueOf('\u2089'), Character.valueOf('\u0392'), Character.valueOf('\u03a1'), Character.valueOf('\u03b8'), Character.valueOf('\u03c7'), Character.valueOf('\u0415'), Character.valueOf('\u0425'), Character.valueOf('\u0434'), Character.valueOf('\u0444'), Character.valueOf('\u0458'), Character.valueOf('\u2193'), Character.valueOf('\u1e9e'), Character.valueOf('\u2075'), Character.valueOf('\u2694'), Character.valueOf('\u05d0'), Character.valueOf('\u05df'), Character.valueOf('\u00b6'), Character.valueOf('\u2036'), Character.valueOf('\udff9'), Character.valueOf('\u208a'), Character.valueOf('\u0393'), Character.valueOf('\u03a3'), Character.valueOf('\u03b9'), Character.valueOf('\u03c8'), Character.valueOf('\u0416'), Character.valueOf('\u0426'), Character.valueOf('\u0435'), Character.valueOf('\u0445'), Character.valueOf('\u0459'), Character.valueOf('\u21c4'), Character.valueOf('\u00df'), Character.valueOf('\u2076'), Character.valueOf('\u2620'), Character.valueOf('\u05d1'), Character.valueOf('\u05e1'), Character.valueOf('\u00bc'), Character.valueOf('\u2037'), Character.valueOf('\ud83e'), Character.valueOf('\u208b'), Character.valueOf('\u2039'), Character.valueOf('\u2212'), Character.valueOf('\u2665'), Character.valueOf('\u02ac'), Character.valueOf('\u1614'), Character.valueOf('\ua779'), Character.valueOf('\u053b'), Character.valueOf('\u054b'), Character.valueOf('\u0563'), Character.valueOf('\u0572'), Character.valueOf('\u0581'), Character.valueOf('\u055f'), Character.valueOf('\ua75a'), Character.valueOf('\u23f9'), Character.valueOf('\u0132'), Character.valueOf('\u16a0'), Character.valueOf('\u16b0'), Character.valueOf('\u16c0'), Character.valueOf('\ua781'), Character.valueOf('\u203a'), Character.valueOf('\u2213'), Character.valueOf('\u2666'), Character.valueOf('\u26a1'), Character.valueOf('\u0190'), Character.valueOf('\u1d1a'), Character.valueOf('\u053c'), Character.valueOf('\u054c'), Character.valueOf('\u0564'), Character.valueOf('\u0573'), Character.valueOf('\u0582'), Character.valueOf('\u0560'), Character.valueOf('\ua75b'), Character.valueOf('\u23fa'), Character.valueOf('\u0133'), Character.valueOf('\u16a2'), Character.valueOf('\u16b1'), Character.valueOf('\u16c1'), Character.valueOf('\u026f'), Character.valueOf('\u203b'), Character.valueOf('\u221e'), Character.valueOf('\u2669'), Character.valueOf('\u26cf'), Character.valueOf('\u07c8'), Character.valueOf('\u27d8'), Character.valueOf('\u053d'), Character.valueOf('\u054d'), Character.valueOf('\u0565'), Character.valueOf('\u0574'), Character.valueOf('\u0583'), Character.valueOf('\u0588'), Character.valueOf('\u2011'), Character.valueOf('\u23fb'), Character.valueOf('\u01c9'), Character.valueOf('\u16a3'), Character.valueOf('\u16b2'), Character.valueOf('\u16c2'), Character.valueOf('\u0279'), Character.valueOf('\u203c'), Character.valueOf('\u2600'), Character.valueOf('\u266a'), Character.valueOf('\u2714'), Character.valueOf('\u03db'), Character.valueOf('\u2229'), Character.valueOf('\u053e'), Character.valueOf('\u054e'), Character.valueOf('\u0566'), Character.valueOf('\u0575'), Character.valueOf('\u0584'), Character.valueOf('\u058f'), Character.valueOf('\u214b'), Character.valueOf('\u23fc'), Character.valueOf('\ua728'), Character.valueOf('\u16a4'), Character.valueOf('\u16b3'), Character.valueOf('\u16c3'), Character.valueOf('\u0287'), Character.valueOf('\u203d'), Character.valueOf('\u2601'), Character.valueOf('\u266b'), Character.valueOf('\u2744'), Character.valueOf('\u3125'), Character.valueOf('\u0245'), Character.valueOf('\u053f'), Character.valueOf('\u054f'), Character.valueOf('\u0567'), Character.valueOf('\u0576'), Character.valueOf('\u0585'), Character.valueOf('\u00af'), Character.valueOf('\u23cf'), Character.valueOf('\u23fd'), Character.valueOf('\ua729'), Character.valueOf('\u16a5'), Character.valueOf('\u16b4'), Character.valueOf('\u16c4'), Character.valueOf('\u028c'), Character.valueOf('\u2042'), Character.valueOf('\u2608'), Character.valueOf('\u266c'), Character.valueOf('\u274c'), Character.valueOf('\u2c6f'), Character.valueOf('\u2144'), Character.valueOf('\u0540'), Character.valueOf('\u0550'), Character.valueOf('\u0568'), Character.valueOf('\u0577'), Character.valueOf('\u0586'), Character.valueOf('\u017f'), Character.valueOf('\u23e9'), Character.valueOf('\u2b58'), Character.valueOf('\ua739'), Character.valueOf('\u16a6'), Character.valueOf('\u16b6'), Character.valueOf('\u16c5'), Character.valueOf('\u028d'), Character.valueOf('\u2048'), Character.valueOf('\u0404'), Character.valueOf('\u266d'), Character.valueOf('\u2764'), Character.valueOf('\u15fa'), Character.valueOf('\u0250'), Character.valueOf('\u0541'), Character.valueOf('\u0551'), Character.valueOf('\u0569'), Character.valueOf('\u0578'), Character.valueOf('\u0587'), Character.valueOf('\u01b7'), Character.valueOf('\u23ea'), Character.valueOf('\u25b2'), Character.valueOf('\ua73b'), Character.valueOf('\u16a7'), Character.valueOf('\u16b7'), Character.valueOf('\u16c6'), Character.valueOf('\u028e'), Character.valueOf('\u2049'), Character.valueOf('\u2632'), Character.valueOf('\u266e'), Character.valueOf('\u2b50'), Character.valueOf('\u0186'), Character.valueOf('\u0254'), Character.valueOf('\u0542'), Character.valueOf('\u0552'), Character.valueOf('\u056a'), Character.valueOf('\u0579'), Character.valueOf('\u05e9'), Character.valueOf('\u0292'), Character.valueOf('\u23ed'), Character.valueOf('\u25b6'), Character.valueOf('\ufb00'), Character.valueOf('\u16a8'), Character.valueOf('\u16b8'), Character.valueOf('\u16c7'), Character.valueOf('\u0531'), Character.valueOf('\u204b'), Character.valueOf('\u2635'), Character.valueOf('\u266f'), Character.valueOf('\u2e18'), Character.valueOf('\u15e1'), Character.valueOf('\u01dd'), Character.valueOf('\u0543'), Character.valueOf('\u0553'), Character.valueOf('\u056b'), Character.valueOf('\u057a'), Character.valueOf('\u05ea'), Character.valueOf('\u01f7'), Character.valueOf('\u23ee'), Character.valueOf('\u25bc'), Character.valueOf('\ufb01'), Character.valueOf('\u16a9'), Character.valueOf('\u16b9'), Character.valueOf('\u16c8'), Character.valueOf('\u0532'), Character.valueOf('\u204e'), Character.valueOf('\u263d'), Character.valueOf('\u2680'), Character.valueOf('\u2e2e'), Character.valueOf('\u018e'), Character.valueOf('\u025f'), Character.valueOf('\u0544'), Character.valueOf('\u0554'), Character.valueOf('\u056c'), Character.valueOf('\u057b'), Character.valueOf('\u0538'), Character.valueOf('\u01bf'), Character.valueOf('\u23ef'), Character.valueOf('\u25c0'), Character.valueOf('\ufb02'), Character.valueOf('\u16aa'), Character.valueOf('\u16ba'), Character.valueOf('\u16c9'), Character.valueOf('\u0533'), Character.valueOf('\u204f'), Character.valueOf('\u2640'), Character.valueOf('\u2681'), Character.valueOf('\u2e35'), Character.valueOf('\u2132'), Character.valueOf('\u1d77'), Character.valueOf('\u0545'), Character.valueOf('\u0555'), Character.valueOf('\u056d'), Character.valueOf('\u057c'), Character.valueOf('\u055a'), Character.valueOf('\u021c'), Character.valueOf('\u23f4'), Character.valueOf('\u25cf'), Character.valueOf('\ufb03'), Character.valueOf('\u16ab'), Character.valueOf('\u16bb'), Character.valueOf('\u16ca'), Character.valueOf('\u0534'), Character.valueOf('\u2051'), Character.valueOf('\u2642'), Character.valueOf('\u2682'), Character.valueOf('\u2e38'), Character.valueOf('\u2141'), Character.valueOf('\u0265'), Character.valueOf('\u0546'), Character.valueOf('\u0556'), Character.valueOf('\u056e'), Character.valueOf('\u057d'), Character.valueOf('\u055b'), Character.valueOf('\u021d'), Character.valueOf('\u23f5'), Character.valueOf('\u25e6'), Character.valueOf('\ufb05'), Character.valueOf('\u16ac'), Character.valueOf('\u16bc'), Character.valueOf('\u16cb'), Character.valueOf('\u0536'), Character.valueOf('\u2052'), Character.valueOf('\u26a5'), Character.valueOf('\u2683'), Character.valueOf('\u2e41'), Character.valueOf('\ua7b0'), Character.valueOf('\u1d09'), Character.valueOf('\u0547'), Character.valueOf('\u0559'), Character.valueOf('\u056f'), Character.valueOf('\u057e'), Character.valueOf('\u055c'), Character.valueOf('\u0224'), Character.valueOf('\u23f6'), Character.valueOf('\u25d8'), Character.valueOf('\ufffd'), Character.valueOf('\u16ad'), Character.valueOf('\u16bd'), Character.valueOf('\u16cc'), Character.valueOf('\u0537'), Character.valueOf('\u2057'), Character.valueOf('\u2660'), Character.valueOf('\u2684'), Character.valueOf('\u2e4b'), Character.valueOf('\ua780'), Character.valueOf('\u027e'), Character.valueOf('\u0548'), Character.valueOf('\u0561'), Character.valueOf('\u0570'), Character.valueOf('\u057f'), Character.valueOf('\u055d'), Character.valueOf('\u0225'), Character.valueOf('\u23f7'), Character.valueOf('\u2693'), Character.valueOf('\u0535'), Character.valueOf('\u16ae'), Character.valueOf('\u16be'), Character.valueOf('\u16cd'), Character.valueOf('\u0539'), Character.valueOf('\u2117'), Character.valueOf('\u2663'), Character.valueOf('\u2685'), Character.valueOf('\u295d'), Character.valueOf('\u0500'), Character.valueOf('\u029e'), Character.valueOf('\u0549'), Character.valueOf('\u0562'), Character.valueOf('\u0571'), Character.valueOf('\u0580'), Character.valueOf('\u055e'), Character.valueOf('\u02d9'), Character.valueOf('\u23f8'), Character.valueOf('\u26e8'), Character.valueOf('\u054a'), Character.valueOf('\u16af'), Character.valueOf('\u16bf'), Character.valueOf('\u16ce'), Character.valueOf('\u053a'), Character.valueOf('\u16cf'), Character.valueOf('\u16de'), Character.valueOf('\u16ed'), Character.valueOf('\u2639'), Character.valueOf('\u1d05'), Character.valueOf('\u1d1b'), Character.valueOf('\u0291'), Character.valueOf('\u01c1'), Character.valueOf('\u025c'), Character.valueOf('\u10a4'), Character.valueOf('\u10b3'), Character.valueOf('\u10c2'), Character.valueOf('\u10d9'), Character.valueOf('\u10e8'), Character.valueOf('\u10f7'), Character.valueOf('\ufb1d'), Character.valueOf('\u0285'), Character.valueOf('\u2d07'), Character.valueOf('\u2d14'), Character.valueOf('\u16d0'), Character.valueOf('\u16df'), Character.valueOf('\u16ee'), Character.valueOf('\u05da'), Character.valueOf('\u1d07'), Character.valueOf('\u1d1c'), Character.valueOf('\u0278'), Character.valueOf('\u0253'), Character.valueOf('\u025e'), Character.valueOf('\u10a5'), Character.valueOf('\u10b4'), Character.valueOf('\u10c3'), Character.valueOf('\u10da'), Character.valueOf('\u10e9'), Character.valueOf('\u10f8'), Character.valueOf('\ufb4b'), Character.valueOf('\u0286'), Character.valueOf('\u2d08'), Character.valueOf('\u2d15'), Character.valueOf('\u16d1'), Character.valueOf('\u16e0'), Character.valueOf('\u16ef'), Character.valueOf('\u05f3'), Character.valueOf('\ua730'), Character.valueOf('\u1d20'), Character.valueOf('\u029d'), Character.valueOf('\u0257'), Character.valueOf('\u0251'), Character.valueOf('\u10a6'), Character.valueOf('\u10b5'), Character.valueOf('\u10c4'), Character.valueOf('\u10db'), Character.valueOf('\u10ea'), Character.valueOf('\u10f9'), Character.valueOf('\ufb35'), Character.valueOf('\u0293'), Character.valueOf('\u2d09'), Character.valueOf('\u2d16'), Character.valueOf('\u16d2'), Character.valueOf('\u16e1'), Character.valueOf('\u16f0'), Character.valueOf('\u05f4'), Character.valueOf('\u0262'), Character.valueOf('\u1d21'), Character.valueOf('\u02a2'), Character.valueOf('\u1d91'), Character.valueOf('\u0252'), Character.valueOf('\u10a7'), Character.valueOf('\u10b6'), Character.valueOf('\u10c5'), Character.valueOf('\u10dc'), Character.valueOf('\u10eb'), Character.valueOf('\u10fa'), Character.valueOf('\ufb4c'), Character.valueOf('\u029a'), Character.valueOf('\u2d0a'), Character.valueOf('\u2d17'), Character.valueOf('\u16d3'), Character.valueOf('\u16e2'), Character.valueOf('\u16f1'), Character.valueOf('\u05f0'), Character.valueOf('\u029c'), Character.valueOf('\u028f'), Character.valueOf('\u027b'), Character.valueOf('\u0284'), Character.valueOf('\u025a'), Character.valueOf('\u10a8'), Character.valueOf('\u10b7'), Character.valueOf('\u10c7'), Character.valueOf('\u10dd'), Character.valueOf('\u10ec'), Character.valueOf('\u10fb'), Character.valueOf('\ufb31'), Character.valueOf('\u20aa'), Character.valueOf('\u2d0b'), Character.valueOf('\u2d18'), Character.valueOf('\u16d4'), Character.valueOf('\u16e3'), Character.valueOf('\u16f2'), Character.valueOf('\u05f1'), Character.valueOf('\u1d0a'), Character.valueOf('\u1d22'), Character.valueOf('\u0281'), Character.valueOf('\u0260'), Character.valueOf('\u025d'), Character.valueOf('\u10a9'), Character.valueOf('\u10b8'), Character.valueOf('\u10cd'), Character.valueOf('\u10de'), Character.valueOf('\u10ed'), Character.valueOf('\u10fc'), Character.valueOf('\ua727'), Character.valueOf('\u20be'), Character.valueOf('\u2d0c'), Character.valueOf('\u2d19'), Character.valueOf('\u16d5'), Character.valueOf('\u16e4'), Character.valueOf('\u16f3'), Character.valueOf('\u05f2'), Character.valueOf('\u1d0b'), Character.valueOf('\u00a7'), Character.valueOf('\u0266'), Character.valueOf('\u029b'), Character.valueOf('\u0181'), Character.valueOf('\u10aa'), Character.valueOf('\u10b9'), Character.valueOf('\u10d0'), Character.valueOf('\u10df'), Character.valueOf('\u10ee'), Character.valueOf('\u10fd'), Character.valueOf('\ua726'), Character.valueOf('\u058a'), Character.valueOf('\u2d22'), Character.valueOf('\u2d1a'), Character.valueOf('\u16d6'), Character.valueOf('\u16e5'), Character.valueOf('\u16f4'), Character.valueOf('\u05be'), Character.valueOf('\u029f'), Character.valueOf('\u0271'), Character.valueOf('\u028b'), Character.valueOf('\u0267'), Character.valueOf('\u0189'), Character.valueOf('\u10ab'), Character.valueOf('\u10ba'), Character.valueOf('\u10d1'), Character.valueOf('\u10e0'), Character.valueOf('\u10ef'), Character.valueOf('\u10fe'), Character.valueOf('\u027a'), Character.valueOf('\u2d00'), Character.valueOf('\u2d0d'), Character.valueOf('\u2d1b'), Character.valueOf('\u16d7'), Character.valueOf('\u16e6'), Character.valueOf('\u16f5'), Character.valueOf('\u05c3'), Character.valueOf('\u1d0d'), Character.valueOf('\u0273'), Character.valueOf('\u0270'), Character.valueOf('\u026b'), Character.valueOf('\u0191'), Character.valueOf('\u10ac'), Character.valueOf('\u10bb'), Character.valueOf('\u10d2'), Character.valueOf('\u10e1'), Character.valueOf('\u10f0'), Character.valueOf('\u10ff'), Character.valueOf('\u2c71'), Character.valueOf('\u2d01'), Character.valueOf('\u2d0e'), Character.valueOf('\u2d1c'), Character.valueOf('\u16d8'), Character.valueOf('\u16e7'), Character.valueOf('\u16f6'), Character.valueOf('\u05c6'), Character.valueOf('\u0274'), Character.valueOf('\u0272'), Character.valueOf('\u026c'), Character.valueOf('\u0268'), Character.valueOf('\u01a9'), Character.valueOf('\u10ad'), Character.valueOf('\u10bc'), Character.valueOf('\u10d3'), Character.valueOf('\u10e2'), Character.valueOf('\u10f1'), Character.valueOf('\ufb4a'), Character.valueOf('\u02a0'), Character.valueOf('\u2d02'), Character.valueOf('\u2d0f'), Character.valueOf('\u2d1d'), Character.valueOf('\u16d9'), Character.valueOf('\u16e8'), Character.valueOf('\u16f7'), Character.valueOf('\u00b4'), Character.valueOf('\u1d0f'), Character.valueOf('\u0288'), Character.valueOf('\u026e'), Character.valueOf('\u0289'), Character.valueOf('\u01b2'), Character.valueOf('\u10ae'), Character.valueOf('\u10bd'), Character.valueOf('\u10d4'), Character.valueOf('\u10e3'), Character.valueOf('\u10f2'), Character.valueOf('\ufb2b'), Character.valueOf('\u0297'), Character.valueOf('\u2d03'), Character.valueOf('\u2d10'), Character.valueOf('\u2d1e'), Character.valueOf('\u16da'), Character.valueOf('\u16e9'), Character.valueOf('\u16f8'), Character.valueOf('\u00a8'), Character.valueOf('\u1d18'), Character.valueOf('\u0256'), Character.valueOf('\u0298'), Character.valueOf('\u028a'), Character.valueOf('\u10a0'), Character.valueOf('\u10af'), Character.valueOf('\u10be'), Character.valueOf('\u10d5'), Character.valueOf('\u10e4'), Character.valueOf('\u10f3'), Character.valueOf('\ufb4e'), Character.valueOf('\u0296'), Character.valueOf('\u2d04'), Character.valueOf('\u2d11'), Character.valueOf('\u2d24'), Character.valueOf('\u16db'), Character.valueOf('\u16ea'), Character.valueOf('\u263a'), Character.valueOf('\u1d00'), Character.valueOf('\ua7af'), Character.valueOf('\u0261'), Character.valueOf('\u01c0'), Character.valueOf('\u0258'), Character.valueOf('\u10a1'), Character.valueOf('\u10b0'), Character.valueOf('\u10bf'), Character.valueOf('\u10d6'), Character.valueOf('\u10e5'), Character.valueOf('\u10f4'), Character.valueOf('\ufb44'), Character.valueOf('\u026d'), Character.valueOf('\u2d05'), Character.valueOf('\u2d12'), Character.valueOf('\u2d1f'), Character.valueOf('\u16dc'), Character.valueOf('\u16eb'), Character.valueOf('\u263b'), Character.valueOf('\u0299'), Character.valueOf('\u0280'), Character.valueOf('\u02a1'), Character.valueOf('\u01c3'), Character.valueOf('\u0275'), Character.valueOf('\u10a2'), Character.valueOf('\u10b1'), Character.valueOf('\u10c0'), Character.valueOf('\u10d7'), Character.valueOf('\u10e6'), Character.valueOf('\u10f5'), Character.valueOf('\ufb3b'), Character.valueOf('\u0277'), Character.valueOf('\u2d06'), Character.valueOf('\u2d23'), Character.valueOf('\u2d20'), Character.valueOf('\u16dd'), Character.valueOf('\u16ec'), Character.valueOf('\u00a6'), Character.valueOf('\u1d04'), Character.valueOf('\ua731'), Character.valueOf('\u0255'), Character.valueOf('\u01c2'), Character.valueOf('\u0264'), Character.valueOf('\u10a3'), Character.valueOf('\u10b2'), Character.valueOf('\u10c1'), Character.valueOf('\u10d8'), Character.valueOf('\u10e7'), Character.valueOf('\u10f6'), Character.valueOf('\ufb1f'), Character.valueOf('\u027f'), Character.valueOf('\u2d21'), Character.valueOf('\u2d13'), Character.valueOf('\u2d25'), Character.valueOf('\u215b'), Character.valueOf('\u270e'), Character.valueOf('\u21cf'), Character.valueOf('\u22bb'), Character.valueOf('\u221b'), Character.valueOf('\u208c'), Character.valueOf('\u019a'), Character.valueOf('\u0234'), Character.valueOf('\u0248'), Character.valueOf('\ua7a9'), Character.valueOf('\ud800'), Character.valueOf('\udf3e'), Character.valueOf('\ud800'), Character.valueOf('\ude93'), Character.valueOf('\udf56'), Character.valueOf('\u20ab'), Character.valueOf('\u20bf'), Character.valueOf('\u00a1'), Character.valueOf('\u215c'), Character.valueOf('\u2763'), Character.valueOf('\u21d4'), Character.valueOf('\u22bc'), Character.valueOf('\u221c'), Character.valueOf('\u208d'), Character.valueOf('\u019b'), Character.valueOf('\u0235'), Character.valueOf('\u0249'), Character.valueOf('\ud800'), Character.valueOf('\udf37'), Character.valueOf('\ud800'), Character.valueOf('\udf46'), Character.valueOf('\ud83d'), Character.valueOf('\ud83e'), Character.valueOf('\u20ad'), Character.valueOf('\u0000'), Character.valueOf('\u2030'), Character.valueOf('\u215d'), Character.valueOf('\u2664'), Character.valueOf('\u21f5'), Character.valueOf('\u22bd'), Character.valueOf('\u2202'), Character.valueOf('\u208e'), Character.valueOf('\u0220'), Character.valueOf('\u0236'), Character.valueOf('\u024a'), Character.valueOf('\udf30'), Character.valueOf('\ud800'), Character.valueOf('\udf3f'), Character.valueOf('\ud800'), Character.valueOf('\udd31'), Character.valueOf('\udea3'), Character.valueOf('\u20ae'), Character.valueOf('\u0000'), Character.valueOf('\u215e'), Character.valueOf('\u2667'), Character.valueOf('\u2200'), Character.valueOf('\u2225'), Character.valueOf('\u22c3'), Character.valueOf('\u222b'), Character.valueOf('\u019e'), Character.valueOf('\u023a'), Character.valueOf('\u024b'), Character.valueOf('\ud800'), Character.valueOf('\udf38'), Character.valueOf('\ud800'), Character.valueOf('\udf47'), Character.valueOf('\ud83c'), Character.valueOf('\ud83d'), Character.valueOf('\u20b0'), Character.valueOf('\u0000'), Character.valueOf('\u2153'), Character.valueOf('\u2661'), Character.valueOf('\u2203'), Character.valueOf('\u2262'), Character.valueOf('\u2286'), Character.valueOf('\u222e'), Character.valueOf('\u019f'), Character.valueOf('\u2c65'), Character.valueOf('\u024c'), Character.valueOf('\udf31'), Character.valueOf('\ud800'), Character.valueOf('\udf40'), Character.valueOf('\ud800'), Character.valueOf('\udfa3'), Character.valueOf('\udd14'), Character.valueOf('\u20b1'), Character.valueOf('\u0000'), Character.valueOf('\u2154'), Character.valueOf('\u2662'), Character.valueOf('\u2204'), Character.valueOf('\u22c6'), Character.valueOf('\u2287'), Character.valueOf('\u221d'), Character.valueOf('\u01a7'), Character.valueOf('\u023b'), Character.valueOf('\u024d'), Character.valueOf('\ud800'), Character.valueOf('\udf39'), Character.valueOf('\ud800'), Character.valueOf('\udf48'), Character.valueOf('\ud83e'), Character.valueOf('\u23f3'), Character.valueOf('\u20b2'), Character.valueOf('\u0000'), Character.valueOf('\u2709'), Character.valueOf('\u26c8'), Character.valueOf('\u2209'), Character.valueOf('\u2211'), Character.valueOf('\u25a1'), Character.valueOf('\u2300'), Character.valueOf('\u01a8'), Character.valueOf('\u023c'), Character.valueOf('\u024e'), Character.valueOf('\udf32'), Character.valueOf('\ud800'), Character.valueOf('\udf41'), Character.valueOf('\ud800'), Character.valueOf('\uddea'), Character.valueOf('\u2691'), Character.valueOf('\u20b3'), Character.valueOf('\u0000'), Character.valueOf('\u2602'), Character.valueOf('\u2630'), Character.valueOf('\u220b'), Character.valueOf('\u22a4'), Character.valueOf('\u25b3'), Character.valueOf('\u2302'), Character.valueOf('\u01aa'), Character.valueOf('\u0246'), Character.valueOf('\u024f'), Character.valueOf('\ud800'), Character.valueOf('\udf3a'), Character.valueOf('\ud800'), Character.valueOf('\udf49'), Character.valueOf('\u2697'), Character.valueOf('\u20a0'), Character.valueOf('\u20b5'), Character.valueOf('\u0000'), Character.valueOf('\u2614'), Character.valueOf('\u2631'), Character.valueOf('\u220c'), Character.valueOf('\u22a5'), Character.valueOf('\u25b7'), Character.valueOf('\u2318'), Character.valueOf('\u01b8'), Character.valueOf('\u0247'), Character.valueOf('\u1e9c'), Character.valueOf('\udf33'), Character.valueOf('\ud800'), Character.valueOf('\udf42'), Character.valueOf('\ud800'), Character.valueOf('\u2bea'), Character.valueOf('\u20a1'), Character.valueOf('\u20b6'), Character.valueOf('\u0000'), Character.valueOf('\u2604'), Character.valueOf('\u2633'), Character.valueOf('\u2282'), Character.valueOf('\u22a2'), Character.valueOf('\u25bd'), Character.valueOf('\u3012'), Character.valueOf('\u01b9'), Character.valueOf('\u023e'), Character.valueOf('\u1e9d'), Character.valueOf('\ud800'), Character.valueOf('\udf3b'), Character.valueOf('\ud800'), Character.valueOf('\udf4a'), Character.valueOf('\u2beb'), Character.valueOf('\u20a2'), Character.valueOf('\u20b7'), Character.valueOf('\u0000'), Character.valueOf('\u26c4'), Character.valueOf('\u2634'), Character.valueOf('\u2283'), Character.valueOf('\u22a8'), Character.valueOf('\u25c1'), Character.valueOf('\u027c'), Character.valueOf('\u01bb'), Character.valueOf('\u2c66'), Character.valueOf('\u1efc'), Character.valueOf('\udf34'), Character.valueOf('\ud800'), Character.valueOf('\udf43'), Character.valueOf('\ud83c'), Character.valueOf('\u2c6d'), Character.valueOf('\u20a3'), Character.valueOf('\u20b8'), Character.valueOf('\u0000'), Character.valueOf('\u2603'), Character.valueOf('\u2636'), Character.valueOf('\u2284'), Character.valueOf('\u2254'), Character.valueOf('\u25c6'), Character.valueOf('\u0184'), Character.valueOf('\u01bc'), Character.valueOf('\u0241'), Character.valueOf('\u1efd'), Character.valueOf('\ud800'), Character.valueOf('\udf3c'), Character.valueOf('\ud800'), Character.valueOf('\udf27'), Character.valueOf('\ud83d'), Character.valueOf('\u20a4'), Character.valueOf('\u20b9'), Character.valueOf('\u0000'), Character.valueOf('\u231b'), Character.valueOf('\u2637'), Character.valueOf('\u2285'), Character.valueOf('\u2201'), Character.valueOf('\u25c7'), Character.valueOf('\u0185'), Character.valueOf('\u01bd'), Character.valueOf('\u0242'), Character.valueOf('\u1efe'), Character.valueOf('\udf35'), Character.valueOf('\ud800'), Character.valueOf('\udf44'), Character.valueOf('\ud83d'), Character.valueOf('\udee1'), Character.valueOf('\u20a5'), Character.valueOf('\u20ba'), Character.valueOf('\u0000'), Character.valueOf('\u231a'), Character.valueOf('\u2194'), Character.valueOf('\u2227'), Character.valueOf('\u2234'), Character.valueOf('\u25cb'), Character.valueOf('\u1e9f'), Character.valueOf('\u01be'), Character.valueOf('\u0243'), Character.valueOf('\u1eff'), Character.valueOf('\ud800'), Character.valueOf('\udf3d'), Character.valueOf('\ud800'), Character.valueOf('\udd25'), Character.valueOf('\u2702'), Character.valueOf('\u20a6'), Character.valueOf('\u20bb'), Character.valueOf('\u0000'), Character.valueOf('\u2690'), Character.valueOf('\u21d2'), Character.valueOf('\u2228'), Character.valueOf('\u2235'), Character.valueOf('\u25ce'), Character.valueOf('\u023d'), Character.valueOf('\u0221'), Character.valueOf('\u0244'), Character.valueOf('\ua7a8'), Character.valueOf('\udf36'), Character.valueOf('\ud800'), Character.valueOf('\udf45'), Character.valueOf('\ud83c'), Character.valueOf('\ud83c'), Character.valueOf('\u20a9'), Character.valueOf('\u20bc'), Character.valueOf('\u0000')};
        nonLatinCharacters = SetsKt.hashSetOf(serializableArray);
        serializableArray = new Pair[]{TuplesKt.to(Character.valueOf('A'), 5), TuplesKt.to(Character.valueOf('a'), 5), TuplesKt.to(Character.valueOf('B'), 5), TuplesKt.to(Character.valueOf('b'), 5), TuplesKt.to(Character.valueOf('C'), 5), TuplesKt.to(Character.valueOf('c'), 5), TuplesKt.to(Character.valueOf('D'), 5), TuplesKt.to(Character.valueOf('d'), 5), TuplesKt.to(Character.valueOf('E'), 5), TuplesKt.to(Character.valueOf('e'), 5), TuplesKt.to(Character.valueOf('F'), 5), TuplesKt.to(Character.valueOf('f'), 4), TuplesKt.to(Character.valueOf('G'), 5), TuplesKt.to(Character.valueOf('g'), 5), TuplesKt.to(Character.valueOf('H'), 5), TuplesKt.to(Character.valueOf('h'), 5), TuplesKt.to(Character.valueOf('I'), 3), TuplesKt.to(Character.valueOf('i'), 1), TuplesKt.to(Character.valueOf('J'), 5), TuplesKt.to(Character.valueOf('j'), 5), TuplesKt.to(Character.valueOf('K'), 5), TuplesKt.to(Character.valueOf('k'), 4), TuplesKt.to(Character.valueOf('L'), 5), TuplesKt.to(Character.valueOf('l'), 2), TuplesKt.to(Character.valueOf('M'), 5), TuplesKt.to(Character.valueOf('m'), 5), TuplesKt.to(Character.valueOf('N'), 5), TuplesKt.to(Character.valueOf('n'), 5), TuplesKt.to(Character.valueOf('O'), 5), TuplesKt.to(Character.valueOf('o'), 5), TuplesKt.to(Character.valueOf('P'), 5), TuplesKt.to(Character.valueOf('p'), 5), TuplesKt.to(Character.valueOf('Q'), 5), TuplesKt.to(Character.valueOf('q'), 5), TuplesKt.to(Character.valueOf('R'), 5), TuplesKt.to(Character.valueOf('r'), 5), TuplesKt.to(Character.valueOf('S'), 5), TuplesKt.to(Character.valueOf('s'), 5), TuplesKt.to(Character.valueOf('T'), 5), TuplesKt.to(Character.valueOf('t'), 3), TuplesKt.to(Character.valueOf('U'), 5), TuplesKt.to(Character.valueOf('u'), 5), TuplesKt.to(Character.valueOf('V'), 5), TuplesKt.to(Character.valueOf('v'), 5), TuplesKt.to(Character.valueOf('W'), 5), TuplesKt.to(Character.valueOf('w'), 5), TuplesKt.to(Character.valueOf('X'), 5), TuplesKt.to(Character.valueOf('x'), 5), TuplesKt.to(Character.valueOf('Y'), 5), TuplesKt.to(Character.valueOf('y'), 5), TuplesKt.to(Character.valueOf('Z'), 5), TuplesKt.to(Character.valueOf('z'), 5), TuplesKt.to(Character.valueOf('1'), 5), TuplesKt.to(Character.valueOf('2'), 5), TuplesKt.to(Character.valueOf('3'), 5), TuplesKt.to(Character.valueOf('4'), 5), TuplesKt.to(Character.valueOf('5'), 5), TuplesKt.to(Character.valueOf('6'), 5), TuplesKt.to(Character.valueOf('7'), 5), TuplesKt.to(Character.valueOf('8'), 5), TuplesKt.to(Character.valueOf('9'), 5), TuplesKt.to(Character.valueOf('0'), 5), TuplesKt.to(Character.valueOf('$'), 5), TuplesKt.to(Character.valueOf('|'), 1), TuplesKt.to(Character.valueOf('~'), 5), TuplesKt.to(Character.valueOf('`'), 2), TuplesKt.to(Character.valueOf(','), 1), TuplesKt.to(Character.valueOf('.'), 1), TuplesKt.to(Character.valueOf('!'), 1), TuplesKt.to(Character.valueOf('?'), 5), TuplesKt.to(Character.valueOf(' '), 3), TuplesKt.to(Character.valueOf(';'), 1), TuplesKt.to(Character.valueOf(':'), 1), TuplesKt.to(Character.valueOf('_'), 5), TuplesKt.to(Character.valueOf('-'), 5), TuplesKt.to(Character.valueOf('+'), 5), TuplesKt.to(Character.valueOf('='), 5), TuplesKt.to(Character.valueOf('*'), 3), TuplesKt.to(Character.valueOf('\"'), 3), TuplesKt.to(Character.valueOf('\''), 1), TuplesKt.to(Character.valueOf('%'), 5), TuplesKt.to(Character.valueOf('&'), 5), TuplesKt.to(Character.valueOf('^'), 5), TuplesKt.to(Character.valueOf('#'), 5), TuplesKt.to(Character.valueOf('<'), 4), TuplesKt.to(Character.valueOf('>'), 4), TuplesKt.to(Character.valueOf('('), 3), TuplesKt.to(Character.valueOf(')'), 3), TuplesKt.to(Character.valueOf('/'), 5), TuplesKt.to(Character.valueOf('\\'), 5), TuplesKt.to(Character.valueOf('{'), 3), TuplesKt.to(Character.valueOf('}'), 3), TuplesKt.to(Character.valueOf('['), 3), TuplesKt.to(Character.valueOf(']'), 3), TuplesKt.to(Character.valueOf('@'), 6)};
        asciiCharacters = MapsKt.hashMapOf(serializableArray);
    }
}

