/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.system.products.data;

import com.mcmlr.blocks.api.Resources;
import com.mcmlr.system.dagger.EnvironmentScope;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@EnvironmentScope
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/mcmlr/system/products/data/VaultRepository;", "", "resources", "Lcom/mcmlr/blocks/api/Resources;", "<init>", "(Lcom/mcmlr/blocks/api/Resources;)V", "economy", "Lnet/milkbowl/vault/economy/Economy;", "getEconomy", "()Lnet/milkbowl/vault/economy/Economy;", "permissions", "Lnet/milkbowl/vault/permission/Permission;", "getPermissions", "()Lnet/milkbowl/vault/permission/Permission;", "chat", "Lnet/milkbowl/vault/chat/Chat;", "getChat", "()Lnet/milkbowl/vault/chat/Chat;", "system"})
public final class VaultRepository {
    @Nullable
    private final Economy economy;
    @Nullable
    private final Permission permissions;
    @Nullable
    private final Chat chat;

    @Inject
    public VaultRepository(@NotNull Resources resources) {
        Intrinsics.checkNotNullParameter(resources, "resources");
        if (resources.server().getPluginManager().getPlugin("Vault") != null) {
            RegisteredServiceProvider economyProvider = resources.server().getServicesManager().getRegistration(Economy.class);
            RegisteredServiceProvider permissionProvider = resources.server().getServicesManager().getRegistration(Permission.class);
            RegisteredServiceProvider chatProvider = resources.server().getServicesManager().getRegistration(Chat.class);
            RegisteredServiceProvider registeredServiceProvider = economyProvider;
            this.economy = registeredServiceProvider != null ? (Economy)registeredServiceProvider.getProvider() : null;
            RegisteredServiceProvider registeredServiceProvider2 = permissionProvider;
            this.permissions = registeredServiceProvider2 != null ? (Permission)registeredServiceProvider2.getProvider() : null;
            RegisteredServiceProvider registeredServiceProvider3 = chatProvider;
            this.chat = registeredServiceProvider3 != null ? (Chat)registeredServiceProvider3.getProvider() : null;
        } else {
            this.economy = null;
            this.permissions = null;
            this.chat = null;
        }
    }

    @Nullable
    public final Economy getEconomy() {
        return this.economy;
    }

    @Nullable
    public final Permission getPermissions() {
        return this.permissions;
    }

    @Nullable
    public final Chat getChat() {
        return this.chat;
    }
}

