/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.system.products.kits;

import com.mcmlr.apps.app.block.data.Bundle;
import com.mcmlr.blocks.api.block.Interactor;
import com.mcmlr.system.IconSelectionBlock;
import com.mcmlr.system.products.kits.AddKitContentBlock;
import com.mcmlr.system.products.kits.CreateKitPresenter;
import com.mcmlr.system.products.kits.KitItem;
import com.mcmlr.system.products.kits.KitModel;
import com.mcmlr.system.products.kits.KitRepository;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/mcmlr/system/products/kits/CreateKitInteractor;", "Lcom/mcmlr/blocks/api/block/Interactor;", "presenter", "Lcom/mcmlr/system/products/kits/CreateKitPresenter;", "iconSelectionBlock", "Lcom/mcmlr/system/IconSelectionBlock;", "addKitContentBlock", "Lcom/mcmlr/system/products/kits/AddKitContentBlock;", "kitRepository", "Lcom/mcmlr/system/products/kits/KitRepository;", "<init>", "(Lcom/mcmlr/system/products/kits/CreateKitPresenter;Lcom/mcmlr/system/IconSelectionBlock;Lcom/mcmlr/system/products/kits/AddKitContentBlock;Lcom/mcmlr/system/products/kits/KitRepository;)V", "onCreate", "", "system"})
@SourceDebugExtension(value={"SMAP\nCreateKitBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateKitBlock.kt\ncom/mcmlr/system/products/kits/CreateKitInteractor\n+ 2 Bundle.kt\ncom/mcmlr/apps/app/block/data/Bundle\n*L\n1#1,596:1\n14#2:597\n13#2,4:598\n*S KotlinDebug\n*F\n+ 1 CreateKitBlock.kt\ncom/mcmlr/system/products/kits/CreateKitInteractor\n*L\n589#1:597\n589#1:598,4\n*E\n"})
public final class CreateKitInteractor
extends Interactor {
    @NotNull
    private final CreateKitPresenter presenter;
    @NotNull
    private final IconSelectionBlock iconSelectionBlock;
    @NotNull
    private final AddKitContentBlock addKitContentBlock;
    @NotNull
    private final KitRepository kitRepository;

    public CreateKitInteractor(@NotNull CreateKitPresenter presenter, @NotNull IconSelectionBlock iconSelectionBlock, @NotNull AddKitContentBlock addKitContentBlock, @NotNull KitRepository kitRepository) {
        Intrinsics.checkNotNullParameter(presenter, "presenter");
        Intrinsics.checkNotNullParameter(iconSelectionBlock, "iconSelectionBlock");
        Intrinsics.checkNotNullParameter(addKitContentBlock, "addKitContentBlock");
        Intrinsics.checkNotNullParameter(kitRepository, "kitRepository");
        super(presenter);
        this.presenter = presenter;
        this.iconSelectionBlock = iconSelectionBlock;
        this.addKitContentBlock = addKitContentBlock;
        this.kitRepository = kitRepository;
    }

    @Override
    public void onCreate() {
        String it;
        super.onCreate();
        this.presenter.setIsEditing(this.kitRepository.getBuilder().getUuid() != null);
        this.presenter.setCreateKitListener(() -> CreateKitInteractor.onCreate$lambda$0(this));
        this.presenter.setUpdateKitListener(() -> CreateKitInteractor.onCreate$lambda$1(this));
        this.presenter.setDeleteKitListener(() -> CreateKitInteractor.onCreate$lambda$2(this));
        this.presenter.addBackListener(() -> CreateKitInteractor.onCreate$lambda$3(this));
        this.presenter.setAddItemListener(() -> CreateKitInteractor.onCreate$lambda$4(this));
        this.presenter.setAddCommandListener(() -> CreateKitInteractor.onCreate$lambda$5(this));
        if (!((Collection)this.kitRepository.getBuilder().getItems()).isEmpty() || !((Collection)this.kitRepository.getBuilder().getCommands()).isEmpty()) {
            this.presenter.setKitContents(this.kitRepository.getBuilder().getItems(), this.kitRepository.getBuilder().getCommands());
        }
        this.presenter.setKitCallbacks(arg_0 -> CreateKitInteractor.onCreate$lambda$6(this, arg_0), arg_0 -> CreateKitInteractor.onCreate$lambda$7(this, arg_0));
        String string = this.kitRepository.getBuilder().getIcon();
        if (string != null) {
            it = string;
            boolean bl = false;
            this.presenter.setIcon(Material.valueOf((String)it));
        }
        String string2 = this.kitRepository.getBuilder().getName();
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            this.presenter.setName(it);
        }
        this.presenter.setNameListener(arg_0 -> CreateKitInteractor.onCreate$lambda$10(this, arg_0));
        Integer n = this.kitRepository.getBuilder().getKitPrice();
        if (n != null) {
            int it2 = ((Number)n).intValue();
            boolean bl = false;
            String string3 = "%.2f";
            Object[] objectArray = new Object[]{Float.valueOf((float)it2 / 100.0f)};
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string4, "format(...)");
            this.presenter.setPrice("$" + string4);
        }
        this.presenter.setPriceListener(arg_0 -> CreateKitInteractor.onCreate$lambda$12(this, arg_0));
        Integer n2 = this.kitRepository.getBuilder().getKitCooldown();
        if (n2 != null) {
            int it3 = ((Number)n2).intValue();
            boolean bl = false;
            if (it3 < 0) {
                this.presenter.setCooldown("Single Use");
            } else {
                this.presenter.setCooldown(it3 + " Seconds");
            }
        }
        this.presenter.setCooldownListener(arg_0 -> CreateKitInteractor.onCreate$lambda$14(this, arg_0));
        String string5 = this.kitRepository.getBuilder().getDescription();
        if (string5 != null) {
            String it4 = string5;
            boolean bl = false;
            this.presenter.setDescription(it4);
        }
        this.presenter.setDescriptionListener(arg_0 -> CreateKitInteractor.onCreate$lambda$16(this, arg_0));
        this.presenter.setIconListener(() -> CreateKitInteractor.onCreate$lambda$18(this));
    }

    private static final Unit onCreate$lambda$0(CreateKitInteractor this$0) {
        String validCheckMessage = this$0.kitRepository.getBuilder().checkValid();
        if (validCheckMessage != null) {
            this$0.presenter.setErrorMessage(ChatColor.RED + validCheckMessage);
            return Unit.INSTANCE;
        }
        KitModel kitModel = this$0.kitRepository.getBuilder().build();
        if (kitModel == null) {
            return Unit.INSTANCE;
        }
        KitModel kit = kitModel;
        this$0.kitRepository.addKit(kit);
        this$0.routeBack();
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$1(CreateKitInteractor this$0) {
        String validCheckMessage = this$0.kitRepository.getBuilder().checkValid();
        if (validCheckMessage != null) {
            this$0.presenter.setErrorMessage(ChatColor.RED + validCheckMessage);
            return Unit.INSTANCE;
        }
        KitModel kitModel = this$0.kitRepository.getBuilder().build();
        if (kitModel == null) {
            return Unit.INSTANCE;
        }
        KitModel kit = kitModel;
        this$0.kitRepository.updateKit(kit);
        this$0.routeBack();
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$2(CreateKitInteractor this$0) {
        this$0.kitRepository.deleteKit();
        this$0.routeBack();
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$3(CreateKitInteractor this$0) {
        this$0.kitRepository.getBuilder().reset();
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$4(CreateKitInteractor this$0) {
        this$0.addKitContentBlock.addItemContent();
        Interactor.routeTo$default(this$0, this$0.addKitContentBlock, null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$5(CreateKitInteractor this$0) {
        this$0.addKitContentBlock.addCommandContent();
        Interactor.routeTo$default(this$0, this$0.addKitContentBlock, null, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$6(CreateKitInteractor this$0, KitItem it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.kitRepository.getBuilder().getItems().remove(it);
        this$0.presenter.setKitContents(this$0.kitRepository.getBuilder().getItems(), this$0.kitRepository.getBuilder().getCommands());
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$7(CreateKitInteractor this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.kitRepository.getBuilder().getCommands().remove(it);
        this$0.presenter.setKitContents(this$0.kitRepository.getBuilder().getItems(), this$0.kitRepository.getBuilder().getCommands());
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$10(CreateKitInteractor this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.kitRepository.getBuilder().setName(it);
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$12(CreateKitInteractor this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Double price = StringsKt.toDoubleOrNull(it);
        if (price == null) {
            this$0.presenter.setPrice("Set Kit Price");
            this$0.kitRepository.getBuilder().setKitPrice(null);
            return Unit.INSTANCE;
        }
        int convertedPrice = (int)(price * (double)100 + 0.5);
        CreateKitPresenter createKitPresenter = this$0.presenter;
        String string = "%.2f";
        Object[] objectArray = new Object[]{Float.valueOf((float)convertedPrice / 100.0f)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        createKitPresenter.setPrice("$" + string2);
        this$0.kitRepository.getBuilder().setKitPrice(convertedPrice);
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$14(CreateKitInteractor this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Integer cooldown = StringsKt.toIntOrNull(it);
        if (cooldown == null) {
            this$0.presenter.setCooldown("Set Kit Cooldown");
            this$0.kitRepository.getBuilder().setKitCooldown(null);
            return Unit.INSTANCE;
        }
        if (cooldown < 0) {
            this$0.presenter.setCooldown("Single Use");
        } else {
            this$0.presenter.setCooldown(cooldown + " Seconds");
        }
        this$0.kitRepository.getBuilder().setKitCooldown(cooldown);
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$16(CreateKitInteractor this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.kitRepository.getBuilder().setDescription(it);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit onCreate$lambda$18$lambda$17(CreateKitInteractor this$0, Bundle bundle) {
        Material material;
        Material material2;
        void this_$iv;
        Intrinsics.checkNotNullParameter(bundle, "bundle");
        Bundle bundle2 = bundle;
        String key$iv = "material";
        boolean $i$f$getData = false;
        Object object = this_$iv.getMap().get(key$iv);
        if (object == null) {
            material2 = null;
        } else {
            Object datum$iv = object;
            Object object2 = datum$iv;
            if (!(object2 instanceof ItemStack)) {
                object2 = null;
            }
            ItemStack itemStack = (ItemStack)object2;
            if (itemStack != null) {
                ItemStack it$iv = itemStack;
                boolean bl = false;
                material2 = it$iv;
            } else {
                material2 = null;
            }
        }
        Material icon = material2;
        this$0.kitRepository.getBuilder().setIcon((material = icon) != null && (material = material.getType()) != null ? material.name() : null);
        Material material3 = icon;
        this$0.presenter.setIcon((Material)(material3 != null ? material3.getType() : null));
        return Unit.INSTANCE;
    }

    private static final Unit onCreate$lambda$18(CreateKitInteractor this$0) {
        this$0.iconSelectionBlock.resetInventory();
        this$0.routeTo(this$0.iconSelectionBlock, arg_0 -> CreateKitInteractor.onCreate$lambda$18$lambda$17(this$0, arg_0));
        return Unit.INSTANCE;
    }
}

