/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.apps;

import com.mcmlr.blocks.api.CursorEvent;
import com.mcmlr.blocks.api.CursorModel;
import com.mcmlr.blocks.api.data.CursorRepository;
import com.mcmlr.blocks.api.data.InputRepository;
import com.mcmlr.blocks.api.data.PlayerChatRepository;
import com.mcmlr.system.CommandModel;
import com.mcmlr.system.CommandRepository;
import com.mcmlr.system.PlayerEventRepository;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B1\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ5\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001fH\u0007J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"H\u0007J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020$H\u0007J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020&H\u0007J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020(H\u0007J\u0010\u0010)\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020*H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/mcmlr/apps/EventHandlerFactory;", "Lorg/bukkit/event/Listener;", "Lorg/bukkit/command/CommandExecutor;", "commandRepository", "Lcom/mcmlr/system/CommandRepository;", "cursorRepository", "Lcom/mcmlr/blocks/api/data/CursorRepository;", "playerChatRepository", "Lcom/mcmlr/blocks/api/data/PlayerChatRepository;", "playerEventRepository", "Lcom/mcmlr/system/PlayerEventRepository;", "inputRepository", "Lcom/mcmlr/blocks/api/data/InputRepository;", "<init>", "(Lcom/mcmlr/system/CommandRepository;Lcom/mcmlr/blocks/api/data/CursorRepository;Lcom/mcmlr/blocks/api/data/PlayerChatRepository;Lcom/mcmlr/system/PlayerEventRepository;Lcom/mcmlr/blocks/api/data/InputRepository;)V", "onCommand", "", "sender", "Lorg/bukkit/command/CommandSender;", "command", "Lorg/bukkit/command/Command;", "label", "", "args", "", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Z", "playerClickEvent", "", "e", "Lorg/bukkit/event/player/PlayerInteractEvent;", "playerMovedEvent", "Lorg/bukkit/event/player/PlayerMoveEvent;", "onPlayerChangedHeldItem", "event", "Lorg/bukkit/event/player/PlayerItemHeldEvent;", "onPlayerChat", "Lorg/bukkit/event/player/AsyncPlayerChatEvent;", "onPlayerQuit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "onPlayerJoined", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onPlayerDeath", "Lorg/bukkit/event/entity/PlayerDeathEvent;", "apps"})
public final class EventHandlerFactory
implements Listener,
CommandExecutor {
    @NotNull
    private final CommandRepository commandRepository;
    @NotNull
    private final CursorRepository cursorRepository;
    @NotNull
    private final PlayerChatRepository playerChatRepository;
    @NotNull
    private final PlayerEventRepository playerEventRepository;
    @NotNull
    private final InputRepository inputRepository;

    @Inject
    public EventHandlerFactory(@NotNull CommandRepository commandRepository, @NotNull CursorRepository cursorRepository, @NotNull PlayerChatRepository playerChatRepository, @NotNull PlayerEventRepository playerEventRepository, @NotNull InputRepository inputRepository) {
        Intrinsics.checkNotNullParameter(commandRepository, "commandRepository");
        Intrinsics.checkNotNullParameter(cursorRepository, "cursorRepository");
        Intrinsics.checkNotNullParameter(playerChatRepository, "playerChatRepository");
        Intrinsics.checkNotNullParameter(playerEventRepository, "playerEventRepository");
        Intrinsics.checkNotNullParameter(inputRepository, "inputRepository");
        this.commandRepository = commandRepository;
        this.cursorRepository = cursorRepository;
        this.playerChatRepository = playerChatRepository;
        this.playerEventRepository = playerEventRepository;
        this.inputRepository = inputRepository;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command2, @NotNull String label, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command2, "command");
        Intrinsics.checkNotNullParameter(label, "label");
        Intrinsics.checkNotNullParameter(args, "args");
        this.commandRepository.emitCommand(new CommandModel(sender, command2, label, args));
        return true;
    }

    @EventHandler
    public final void playerClickEvent(@NotNull PlayerInteractEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        UUID uUID = e.getPlayer().getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        Location location = e.getPlayer().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        if (this.inputRepository.updateStream(new CursorModel(uUID, location, CursorEvent.CLICK)) && (e.getAction() == Action.LEFT_CLICK_BLOCK || e.getAction() == Action.LEFT_CLICK_AIR || e.getAction() == Action.RIGHT_CLICK_AIR || e.getAction() == Action.RIGHT_CLICK_BLOCK)) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public final void playerMovedEvent(@NotNull PlayerMoveEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        this.inputRepository.updateMoveStream(e);
    }

    @EventHandler
    public final void onPlayerChangedHeldItem(@NotNull PlayerItemHeldEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.inputRepository.updateScrollStream(event);
    }

    @EventHandler
    public final void onPlayerChat(@NotNull AsyncPlayerChatEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.inputRepository.chat(event);
    }

    @EventHandler
    public final void onPlayerQuit(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player2 = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player2, "getPlayer(...)");
        this.inputRepository.onPlayerQuit(player2);
    }

    @EventHandler
    public final void onPlayerJoined(@NotNull PlayerJoinEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player2 = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player2, "getPlayer(...)");
        this.inputRepository.onPlayerJoined(player2);
    }

    @EventHandler
    public final void onPlayerDeath(@NotNull PlayerDeathEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player2 = event.getEntity();
        Intrinsics.checkNotNullExpressionValue(player2, "getEntity(...)");
        this.inputRepository.onPlayerDeath(player2);
    }
}

