/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.system;

import com.mcmlr.blocks.api.Resources;
import com.mcmlr.blocks.api.app.App;
import com.mcmlr.blocks.api.app.BaseEnvironment;
import com.mcmlr.blocks.api.app.Environment;
import com.mcmlr.blocks.api.data.InputRepository;
import com.mcmlr.system.DefaultEventHandlerFactory;
import com.mcmlr.system.SystemApp;
import com.mcmlr.system.SystemConfigRepository;
import com.mcmlr.system.dagger.DaggerSystemEnvironmentComponent;
import com.mcmlr.system.dagger.SystemEnvironmentComponent;
import com.mcmlr.system.products.data.ApplicationsRepository;
import com.mcmlr.system.products.market.MarketRepository;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010.\u001a\u00020/2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u00100\u001a\u000201J\b\u00102\u001a\u00020/H\u0016J\u0018\u00103\u001a\u00020/2\u0006\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u000107J\u0010\u00108\u001a\u0002092\u0006\u00104\u001a\u000205H\u0002J\u0014\u0010:\u001a\u00020/2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<J\u0006\u0010>\u001a\u00020/J\u000e\u0010?\u001a\u00020/2\u0006\u00104\u001a\u000205J\u0010\u0010@\u001a\u00020\u00022\u0006\u00104\u001a\u000205H\u0016J\b\u0010A\u001a\u000207H\u0016J\b\u0010B\u001a\u000207H\u0016J\b\u0010C\u001a\u000207H\u0016J\n\u0010D\u001a\u0004\u0018\u000107H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u00020\u00178\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001c\u001a\u00020\u001d8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001e\u0010\"\u001a\u00020#8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001e\u0010(\u001a\u00020)8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-\u00a8\u0006E"}, d2={"Lcom/mcmlr/system/SystemEnvironment;", "Lcom/mcmlr/blocks/api/app/BaseEnvironment;", "Lcom/mcmlr/system/SystemApp;", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "<init>", "(Lorg/bukkit/plugin/java/JavaPlugin;)V", "appMap", "Ljava/util/HashMap;", "Ljava/util/UUID;", "environmentComponent", "Lcom/mcmlr/system/dagger/SystemEnvironmentComponent;", "getEnvironmentComponent", "()Lcom/mcmlr/system/dagger/SystemEnvironmentComponent;", "setEnvironmentComponent", "(Lcom/mcmlr/system/dagger/SystemEnvironmentComponent;)V", "inputRepository", "Lcom/mcmlr/blocks/api/data/InputRepository;", "getInputRepository", "()Lcom/mcmlr/blocks/api/data/InputRepository;", "setInputRepository", "(Lcom/mcmlr/blocks/api/data/InputRepository;)V", "marketRepository", "Lcom/mcmlr/system/products/market/MarketRepository;", "getMarketRepository", "()Lcom/mcmlr/system/products/market/MarketRepository;", "setMarketRepository", "(Lcom/mcmlr/system/products/market/MarketRepository;)V", "systemConfigRepository", "Lcom/mcmlr/system/SystemConfigRepository;", "getSystemConfigRepository", "()Lcom/mcmlr/system/SystemConfigRepository;", "setSystemConfigRepository", "(Lcom/mcmlr/system/SystemConfigRepository;)V", "applicationsRepository", "Lcom/mcmlr/system/products/data/ApplicationsRepository;", "getApplicationsRepository", "()Lcom/mcmlr/system/products/data/ApplicationsRepository;", "setApplicationsRepository", "(Lcom/mcmlr/system/products/data/ApplicationsRepository;)V", "defaultEventHandlerFactory", "Lcom/mcmlr/system/DefaultEventHandlerFactory;", "getDefaultEventHandlerFactory", "()Lcom/mcmlr/system/DefaultEventHandlerFactory;", "setDefaultEventHandlerFactory", "(Lcom/mcmlr/system/DefaultEventHandlerFactory;)V", "configure", "", "resources", "Lcom/mcmlr/blocks/api/Resources;", "build", "launch", "player", "Lorg/bukkit/entity/Player;", "deeplink", "", "origin", "Lorg/bukkit/Location;", "register", "app", "Lcom/mcmlr/blocks/api/app/Environment;", "Lcom/mcmlr/blocks/api/app/App;", "onDisable", "shutdown", "getInstance", "name", "icon", "summary", "permission", "system"})
@SourceDebugExtension(value={"SMAP\nSystemEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SystemEnvironment.kt\ncom/mcmlr/system/SystemEnvironment\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1869#2,2:106\n*S KotlinDebug\n*F\n+ 1 SystemEnvironment.kt\ncom/mcmlr/system/SystemEnvironment\n*L\n87#1:106,2\n*E\n"})
public final class SystemEnvironment
extends BaseEnvironment<SystemApp> {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final HashMap<UUID, SystemApp> appMap;
    public SystemEnvironmentComponent environmentComponent;
    public InputRepository inputRepository;
    @Inject
    public MarketRepository marketRepository;
    @Inject
    public SystemConfigRepository systemConfigRepository;
    @Inject
    public ApplicationsRepository applicationsRepository;
    @Inject
    public DefaultEventHandlerFactory defaultEventHandlerFactory;

    public SystemEnvironment(@NotNull JavaPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
        this.appMap = new HashMap();
    }

    @NotNull
    public final SystemEnvironmentComponent getEnvironmentComponent() {
        SystemEnvironmentComponent systemEnvironmentComponent = this.environmentComponent;
        if (systemEnvironmentComponent != null) {
            return systemEnvironmentComponent;
        }
        Intrinsics.throwUninitializedPropertyAccessException("environmentComponent");
        return null;
    }

    public final void setEnvironmentComponent(@NotNull SystemEnvironmentComponent systemEnvironmentComponent) {
        Intrinsics.checkNotNullParameter(systemEnvironmentComponent, "<set-?>");
        this.environmentComponent = systemEnvironmentComponent;
    }

    @NotNull
    public final InputRepository getInputRepository() {
        InputRepository inputRepository = this.inputRepository;
        if (inputRepository != null) {
            return inputRepository;
        }
        Intrinsics.throwUninitializedPropertyAccessException("inputRepository");
        return null;
    }

    public final void setInputRepository(@NotNull InputRepository inputRepository) {
        Intrinsics.checkNotNullParameter(inputRepository, "<set-?>");
        this.inputRepository = inputRepository;
    }

    @NotNull
    public final MarketRepository getMarketRepository() {
        MarketRepository marketRepository = this.marketRepository;
        if (marketRepository != null) {
            return marketRepository;
        }
        Intrinsics.throwUninitializedPropertyAccessException("marketRepository");
        return null;
    }

    public final void setMarketRepository(@NotNull MarketRepository marketRepository) {
        Intrinsics.checkNotNullParameter(marketRepository, "<set-?>");
        this.marketRepository = marketRepository;
    }

    @NotNull
    public final SystemConfigRepository getSystemConfigRepository() {
        SystemConfigRepository systemConfigRepository = this.systemConfigRepository;
        if (systemConfigRepository != null) {
            return systemConfigRepository;
        }
        Intrinsics.throwUninitializedPropertyAccessException("systemConfigRepository");
        return null;
    }

    public final void setSystemConfigRepository(@NotNull SystemConfigRepository systemConfigRepository) {
        Intrinsics.checkNotNullParameter(systemConfigRepository, "<set-?>");
        this.systemConfigRepository = systemConfigRepository;
    }

    @NotNull
    public final ApplicationsRepository getApplicationsRepository() {
        ApplicationsRepository applicationsRepository = this.applicationsRepository;
        if (applicationsRepository != null) {
            return applicationsRepository;
        }
        Intrinsics.throwUninitializedPropertyAccessException("applicationsRepository");
        return null;
    }

    public final void setApplicationsRepository(@NotNull ApplicationsRepository applicationsRepository) {
        Intrinsics.checkNotNullParameter(applicationsRepository, "<set-?>");
        this.applicationsRepository = applicationsRepository;
    }

    @NotNull
    public final DefaultEventHandlerFactory getDefaultEventHandlerFactory() {
        DefaultEventHandlerFactory defaultEventHandlerFactory = this.defaultEventHandlerFactory;
        if (defaultEventHandlerFactory != null) {
            return defaultEventHandlerFactory;
        }
        Intrinsics.throwUninitializedPropertyAccessException("defaultEventHandlerFactory");
        return null;
    }

    public final void setDefaultEventHandlerFactory(@NotNull DefaultEventHandlerFactory defaultEventHandlerFactory) {
        Intrinsics.checkNotNullParameter(defaultEventHandlerFactory, "<set-?>");
        this.defaultEventHandlerFactory = defaultEventHandlerFactory;
    }

    public final void configure(@NotNull InputRepository inputRepository, @NotNull Resources resources) {
        Intrinsics.checkNotNullParameter(inputRepository, "inputRepository");
        Intrinsics.checkNotNullParameter(resources, "resources");
        this.setInputRepository(inputRepository);
        this.setResources(resources);
    }

    @Override
    public void build() {
        this.setEnvironmentComponent(DaggerSystemEnvironmentComponent.builder().environment(this).build());
        this.getEnvironmentComponent().inject(this);
        this.getMarketRepository().loadOrders();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this.getDefaultEventHandlerFactory(), (Plugin)this.plugin);
    }

    public final void launch(@NotNull Player player2, @Nullable String deeplink) {
        Intrinsics.checkNotNullParameter(player2, "player");
        SystemApp app = this.getInstance(player2);
        app.configure(this, deeplink, this.origin(player2), this.getInputRepository());
        if (this.appMap.containsKey(app.getPlayer().getUniqueId())) {
            SystemApp systemApp = this.appMap.get(app.getPlayer().getUniqueId());
            if (systemApp != null) {
                systemApp.shutdown();
            }
        }
        app.create(this.getResources());
        ((Map)this.appMap).put(app.getPlayer().getUniqueId(), app);
    }

    private final Location origin(Player player2) {
        Location location = player2.getEyeLocation().clone();
        Intrinsics.checkNotNullExpressionValue(location, "clone(...)");
        Location o = location;
        o.setPitch(0.0f);
        Vector vector = o.getDirection().normalize();
        Intrinsics.checkNotNullExpressionValue(vector, "normalize(...)");
        Vector direction = vector;
        Location location2 = o.add(direction.multiply(0.15));
        Intrinsics.checkNotNullExpressionValue(location2, "add(...)");
        return location2;
    }

    public final void register(@NotNull Environment<? extends App> app) {
        Intrinsics.checkNotNullParameter(app, "app");
        this.getApplicationsRepository().register(app);
    }

    public final void onDisable() {
        Collection<SystemApp> collection = this.appMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SystemApp it = (SystemApp)element$iv;
            boolean bl = false;
            it.shutdown();
        }
    }

    public final void shutdown(@NotNull Player player2) {
        block0: {
            Intrinsics.checkNotNullParameter(player2, "player");
            SystemApp systemApp = this.appMap.get(player2.getUniqueId());
            if (systemApp == null) break block0;
            systemApp.shutdown();
        }
    }

    @Override
    @NotNull
    public SystemApp getInstance(@NotNull Player player2) {
        Intrinsics.checkNotNullParameter(player2, "player");
        return new SystemApp(player2);
    }

    @Override
    @NotNull
    public String name() {
        return "System";
    }

    @Override
    @NotNull
    public String icon() {
        return "";
    }

    @Override
    @NotNull
    public String summary() {
        return "The system level application responsible for handling players' home screens and launching applications.";
    }

    @Override
    @Nullable
    public String permission() {
        return null;
    }
}

