/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.system.products.homes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mcmlr.blocks.api.Resources;
import com.mcmlr.blocks.api.data.HomeConfigModel;
import com.mcmlr.blocks.core.DudeDispatcher;
import com.mcmlr.system.dagger.AppScope;
import com.mcmlr.system.products.data.CooldownRepository;
import com.mcmlr.system.products.homes.HomeModel;
import com.mcmlr.system.products.homes.HomesConfigRepository;
import com.mcmlr.system.products.homes.PlayerHomesModel;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@AppScope
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010\u001a\u001a\u0010\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\r0\r0\u001b2\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\rH\u0002J\u0010\u0010 \u001a\u00020\u00122\b\u0010!\u001a\u0004\u0018\u00010\u0010J\b\u0010\"\u001a\u0004\u0018\u00010#J\u0016\u0010$\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0010J\u0016\u0010%\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/mcmlr/system/products/homes/HomesRepository;", "", "resources", "Lcom/mcmlr/blocks/api/Resources;", "cooldownRepository", "Lcom/mcmlr/system/products/data/CooldownRepository;", "homesConfigRepository", "Lcom/mcmlr/system/products/homes/HomesConfigRepository;", "<init>", "(Lcom/mcmlr/blocks/api/Resources;Lcom/mcmlr/system/products/data/CooldownRepository;Lcom/mcmlr/system/products/homes/HomesConfigRepository;)V", "playerHomesMap", "Ljava/util/HashMap;", "Ljava/util/UUID;", "Lcom/mcmlr/system/products/homes/PlayerHomesModel;", "Lkotlin/collections/HashMap;", "updatingHome", "Lcom/mcmlr/system/products/homes/HomeModel;", "teleport", "", "player", "Lorg/bukkit/entity/Player;", "location", "Lorg/bukkit/Location;", "canTeleport", "", "latest", "getHomes", "Lkotlinx/coroutines/flow/Flow;", "kotlin.jvm.PlatformType", "cachePlayerHomes", "playerId", "playerHomesModel", "updateHome", "homeModel", "getUpdateBuilder", "Lcom/mcmlr/system/products/homes/HomeModel$Builder;", "saveHome", "deleteHome", "system"})
@SourceDebugExtension(value={"SMAP\nHomesRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HomesRepository.kt\ncom/mcmlr/system/products/homes/HomesRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,218:1\n774#2:219\n865#2,2:220\n774#2:222\n865#2,2:223\n*S KotlinDebug\n*F\n+ 1 HomesRepository.kt\ncom/mcmlr/system/products/homes/HomesRepository\n*L\n120#1:219\n120#1:220,2\n142#1:222\n142#1:223,2\n*E\n"})
public final class HomesRepository {
    @NotNull
    private final Resources resources;
    @NotNull
    private final CooldownRepository cooldownRepository;
    @NotNull
    private final HomesConfigRepository homesConfigRepository;
    @NotNull
    private final HashMap<UUID, PlayerHomesModel> playerHomesMap;
    @Nullable
    private HomeModel updatingHome;

    @Inject
    public HomesRepository(@NotNull Resources resources, @NotNull CooldownRepository cooldownRepository, @NotNull HomesConfigRepository homesConfigRepository) {
        Intrinsics.checkNotNullParameter(resources, "resources");
        Intrinsics.checkNotNullParameter(cooldownRepository, "cooldownRepository");
        Intrinsics.checkNotNullParameter(homesConfigRepository, "homesConfigRepository");
        this.resources = resources;
        this.cooldownRepository = cooldownRepository;
        this.homesConfigRepository = homesConfigRepository;
        this.playerHomesMap = new HashMap();
    }

    public final void teleport(@NotNull Player player2, @NotNull Location location) {
        Intrinsics.checkNotNullParameter(player2, "player");
        Intrinsics.checkNotNullParameter(location, "location");
        player2.teleport(location);
        this.cooldownRepository.addPlayerLastHomeTime(player2);
    }

    public final long canTeleport(@NotNull Player player2) {
        Intrinsics.checkNotNullParameter(player2, "player");
        long lastTeleport = this.cooldownRepository.getPlayerLastHomeTime(player2);
        return lastTeleport + (long)(((HomeConfigModel)this.homesConfigRepository.getModel()).getCooldown() * 1000) - new Date().getTime();
    }

    @Nullable
    public final PlayerHomesModel latest(@NotNull Player player2) {
        Intrinsics.checkNotNullParameter(player2, "player");
        if (!this.playerHomesMap.containsKey(player2.getUniqueId())) {
            ((Map)this.playerHomesMap).put(player2.getUniqueId(), new PlayerHomesModel(CollectionsKt.emptyList()));
        }
        return this.playerHomesMap.get(player2.getUniqueId());
    }

    @NotNull
    public final Flow<PlayerHomesModel> getHomes(@NotNull Player player2) {
        Intrinsics.checkNotNullParameter(player2, "player");
        return FlowKt.flow((Function2)new Function2<FlowCollector<? super PlayerHomesModel>, Continuation<? super Unit>, Object>(this, player2, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ HomesRepository this$0;
            final /* synthetic */ Player $player;
            {
                this.this$0 = $receiver;
                this.$player = $player;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                InputStream homeInputStream;
                void $this$flow;
                File homes;
                FlowCollector flowCollector = (FlowCollector)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        homes = new File(HomesRepository.access$getResources$p(this.this$0).dataFolder(), "Homes/Players/" + this.$player.getUniqueId() + ".json");
                        if (homes.exists()) break;
                        this.L$0 = SpillingKt.nullOutSpilledVariable($this$flow);
                        this.L$1 = SpillingKt.nullOutSpilledVariable(homes);
                        this.label = 1;
                        Object object2 = $this$flow.emit(new PlayerHomesModel(CollectionsKt.emptyList()), this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        File homes2 = (File)this.L$1;
                        ResultKt.throwOnFailure($result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                InputStream inputStream = homeInputStream = (InputStream)new FileInputStream(homes);
                Object object3 = Charsets.UTF_8;
                Object object4 = new InputStreamReader(inputStream, (Charset)object3);
                int n = 8192;
                Closeable closeable = object4 instanceof BufferedReader ? (BufferedReader)object4 : new BufferedReader((Reader)object4, n);
                object3 = null;
                try {
                    BufferedReader it = (BufferedReader)closeable;
                    boolean bl = false;
                    object4 = TextStreamsKt.readText(it);
                }
                catch (Throwable throwable) {
                    object3 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally(closeable, (Throwable)object3);
                }
                Object homeInputString = object4;
                PlayerHomesModel playerHomesModel = (PlayerHomesModel)new Gson().fromJson((String)homeInputString, PlayerHomesModel.class);
                UUID uUID = this.$player.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                Intrinsics.checkNotNull(playerHomesModel);
                HomesRepository.access$cachePlayerHomes(this.this$0, uUID, playerHomesModel);
                this.L$0 = SpillingKt.nullOutSpilledVariable($this$flow);
                this.L$1 = SpillingKt.nullOutSpilledVariable(homes);
                this.L$2 = SpillingKt.nullOutSpilledVariable(homeInputStream);
                this.L$3 = SpillingKt.nullOutSpilledVariable(homeInputString);
                this.L$4 = SpillingKt.nullOutSpilledVariable(playerHomesModel);
                this.label = 2;
                Object object5 = $this$flow.emit(playerHomesModel, this);
                if (object5 != object) return Unit.INSTANCE;
                return object;
                {
                    case 2: {
                        PlayerHomesModel playerHomesModel2 = (PlayerHomesModel)this.L$4;
                        String homeInputString2 = (String)this.L$3;
                        homeInputStream = (InputStream)this.L$2;
                        homes = (File)this.L$1;
                        ResultKt.throwOnFailure($result);
                        object5 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return var3_3;
            }

            public final Object invoke(FlowCollector<? super PlayerHomesModel> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private final void cachePlayerHomes(UUID playerId, PlayerHomesModel playerHomesModel) {
        BuildersKt.launch$default(CoroutineScopeKt.CoroutineScope(new DudeDispatcher()), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, playerId, playerHomesModel, null){
            int label;
            final /* synthetic */ HomesRepository this$0;
            final /* synthetic */ UUID $playerId;
            final /* synthetic */ PlayerHomesModel $playerHomesModel;
            {
                this.this$0 = $receiver;
                this.$playerId = $playerId;
                this.$playerHomesModel = $playerHomesModel;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        ((Map)HomesRepository.access$getPlayerHomesMap$p(this.this$0)).put(this.$playerId, this.$playerHomesModel);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    public final void updateHome(@Nullable HomeModel homeModel) {
        this.updatingHome = homeModel;
    }

    @Nullable
    public final HomeModel.Builder getUpdateBuilder() {
        HomeModel homeModel = this.updatingHome;
        if (homeModel == null) {
            return null;
        }
        HomeModel update = homeModel;
        return new HomeModel.Builder().name(update.getName()).icon(update.getIcon()).uuid(update.getUuid()).location(new Location(Bukkit.getWorld((String)update.getWorld()), update.getX(), update.getY(), update.getZ(), update.getYaw(), update.getPitch()));
    }

    /*
     * WARNING - void declaration
     */
    public final void saveHome(@NotNull Player player2, @NotNull HomeModel homeModel) {
        List list;
        Intrinsics.checkNotNullParameter(player2, "player");
        Intrinsics.checkNotNullParameter(homeModel, "homeModel");
        File homes = new File(this.resources.dataFolder(), "Homes/Players");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Object object = this.playerHomesMap.get(player2.getUniqueId());
        if (object != null && (object = ((PlayerHomesModel)object).getHomes()) != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = (Iterable)object;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                HomeModel it = (HomeModel)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual(it.getUuid(), homeModel.getUuid()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List existingHomes = list;
        HomeModel[] homeModelArray = new HomeModel[]{homeModel};
        List<HomeModel> homesList = CollectionsKt.mutableListOf(homeModelArray);
        List list2 = existingHomes;
        homesList.addAll(list2 != null ? (Collection)list2 : (Collection)CollectionsKt.emptyList());
        PlayerHomesModel newPlayerHomesModel = new PlayerHomesModel(homesList);
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        this.cachePlayerHomes(uUID, newPlayerHomesModel);
        String homeConfigString = gson.toJson((Object)newPlayerHomesModel);
        if (!homes.exists()) {
            homes.mkdirs();
        }
        FileWriter homeWriter = new FileWriter(new File(homes.getPath(), player2.getUniqueId() + ".json"));
        homeWriter.append(homeConfigString);
        homeWriter.close();
    }

    /*
     * WARNING - void declaration
     */
    public final void deleteHome(@NotNull Player player2, @NotNull HomeModel homeModel) {
        Collection destination$iv$iv;
        Intrinsics.checkNotNullParameter(player2, "player");
        Intrinsics.checkNotNullParameter(homeModel, "homeModel");
        File homes = new File(this.resources.dataFolder(), "Homes/Players");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Object object = this.playerHomesMap.get(player2.getUniqueId());
        if (object != null && (object = ((PlayerHomesModel)object).getHomes()) != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = (Iterable)object;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                HomeModel it = (HomeModel)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual(it.getUuid(), homeModel.getUuid()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
        } else {
            return;
        }
        List updatedHomes = (List)destination$iv$iv;
        PlayerHomesModel newPlayerHomesModel = new PlayerHomesModel(updatedHomes);
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        this.cachePlayerHomes(uUID, newPlayerHomesModel);
        String homeConfigString = gson.toJson((Object)newPlayerHomesModel);
        FileWriter homeWriter = new FileWriter(new File(homes.getPath(), player2.getUniqueId() + ".json"));
        homeWriter.append(homeConfigString);
        homeWriter.close();
    }

    public static final /* synthetic */ Resources access$getResources$p(HomesRepository $this) {
        return $this.resources;
    }

    public static final /* synthetic */ void access$cachePlayerHomes(HomesRepository $this, UUID playerId, PlayerHomesModel playerHomesModel) {
        $this.cachePlayerHomes(playerId, playerHomesModel);
    }

    public static final /* synthetic */ HashMap access$getPlayerHomesMap$p(HomesRepository $this) {
        return $this.playerHomesMap;
    }
}

