/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.system.products.settings;

import com.mcmlr.blocks.api.block.Interactor;
import com.mcmlr.blocks.core.DudeDispatcher;
import com.mcmlr.blocks.core.FlowExtKt;
import com.mcmlr.blocks.core.StringExtKt;
import com.mcmlr.system.products.data.LocationModel;
import com.mcmlr.system.products.kits.KitModel;
import com.mcmlr.system.products.kits.KitRepository;
import com.mcmlr.system.products.settings.PriorityDirection;
import com.mcmlr.system.products.settings.SpawnConfigPresenter;
import com.mcmlr.system.products.settings.SpawnConfigState;
import com.mcmlr.system.products.settings.SpawnKitPagerAdapter;
import com.mcmlr.system.products.spawn.RespawnType;
import com.mcmlr.system.products.spawn.SpawnModel;
import com.mcmlr.system.products.spawn.SpawnRepository;
import java.util.Arrays;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0002J\b\u0010\u0015\u001a\u00020\u0011H\u0002J\b\u0010\u0016\u001a\u00020\u0011H\u0002J\b\u0010\u0017\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/mcmlr/system/products/settings/SpawnConfigInteractor;", "Lcom/mcmlr/blocks/api/block/Interactor;", "player", "Lorg/bukkit/entity/Player;", "presenter", "Lcom/mcmlr/system/products/settings/SpawnConfigPresenter;", "spawnRepository", "Lcom/mcmlr/system/products/spawn/SpawnRepository;", "kitRepository", "Lcom/mcmlr/system/products/kits/KitRepository;", "<init>", "(Lorg/bukkit/entity/Player;Lcom/mcmlr/system/products/settings/SpawnConfigPresenter;Lcom/mcmlr/system/products/spawn/SpawnRepository;Lcom/mcmlr/system/products/kits/KitRepository;)V", "state", "Lcom/mcmlr/system/products/settings/SpawnConfigState;", "newSpawn", "Lorg/bukkit/Location;", "onCreate", "", "onResume", "newOrigin", "setBlockState", "setLocationState", "setSettingsState", "countdown", "system"})
@SourceDebugExtension(value={"SMAP\nSpawnConfigBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpawnConfigBlock.kt\ncom/mcmlr/system/products/settings/SpawnConfigInteractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1090:1\n1869#2,2:1091\n1#3:1093\n*S KotlinDebug\n*F\n+ 1 SpawnConfigBlock.kt\ncom/mcmlr/system/products/settings/SpawnConfigInteractor\n*L\n916#1:1091,2\n*E\n"})
public final class SpawnConfigInteractor
extends Interactor {
    @NotNull
    private final Player player;
    @NotNull
    private final SpawnConfigPresenter presenter;
    @NotNull
    private final SpawnRepository spawnRepository;
    @NotNull
    private final KitRepository kitRepository;
    @NotNull
    private SpawnConfigState state;
    @Nullable
    private Location newSpawn;

    public SpawnConfigInteractor(@NotNull Player player2, @NotNull SpawnConfigPresenter presenter, @NotNull SpawnRepository spawnRepository, @NotNull KitRepository kitRepository) {
        Intrinsics.checkNotNullParameter(player2, "player");
        Intrinsics.checkNotNullParameter(presenter, "presenter");
        Intrinsics.checkNotNullParameter(spawnRepository, "spawnRepository");
        Intrinsics.checkNotNullParameter(kitRepository, "kitRepository");
        super(presenter);
        this.player = player2;
        this.presenter = presenter;
        this.spawnRepository = spawnRepository;
        this.kitRepository = kitRepository;
        this.state = SpawnConfigState.SETTINGS;
    }

    @Override
    public void onCreate() {
        super.onCreate();
        this.setBlockState();
    }

    @Override
    public void onResume(@Nullable Location newOrigin) {
        if (this.state == SpawnConfigState.CAPTURE) {
            return;
        }
        super.onResume(newOrigin);
        this.setBlockState();
    }

    private final void setBlockState() {
        if (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()] == 1) {
            this.setLocationState();
        } else {
            this.setSettingsState();
        }
    }

    private final void setLocationState() {
        this.presenter.setLocationDirectionsState(this.newSpawn);
        this.presenter.setCaptureSpawnListener(() -> SpawnConfigInteractor.setLocationState$lambda$0(this));
        this.presenter.setTryAgainListener(() -> SpawnConfigInteractor.setLocationState$lambda$1(this));
        this.presenter.setCancelListener(() -> SpawnConfigInteractor.setLocationState$lambda$2(this));
        this.presenter.setConfirmLocationListener(() -> SpawnConfigInteractor.setLocationState$lambda$3(this));
    }

    private final void setSettingsState() {
        Object v6;
        block5: {
            this.newSpawn = null;
            this.presenter.setSettingsState();
            this.presenter.setEnabledText(StringExtKt.titlecase(String.valueOf(((SpawnModel)this.spawnRepository.getModel()).getEnabled())));
            this.presenter.updateSetWelcomeMessageText(((SpawnModel)this.spawnRepository.getModel()).getWelcomeMessage());
            this.presenter.updateSpawnOnJoinText(StringExtKt.titlecase(String.valueOf(((SpawnModel)this.spawnRepository.getModel()).getSpawnOnJoin())));
            this.presenter.setJoinMessageText(((SpawnModel)this.spawnRepository.getModel()).getJoinMessage());
            this.presenter.setQuitMessageText(((SpawnModel)this.spawnRepository.getModel()).getQuitMessage());
            this.presenter.setCooldownText(((SpawnModel)this.spawnRepository.getModel()).getCooldown() + " Second" + (((SpawnModel)this.spawnRepository.getModel()).getCooldown() != 1 ? "s" : ""));
            this.presenter.setDelayText(((SpawnModel)this.spawnRepository.getModel()).getDelay() + " Second" + (((SpawnModel)this.spawnRepository.getModel()).getCooldown() != 1 ? "s" : ""));
            StringBuilder respawnOrderList = new StringBuilder();
            Iterable $this$forEach$iv = ((SpawnModel)this.spawnRepository.getModel()).getRespawnLocation();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RespawnType it = (RespawnType)((Object)element$iv);
                boolean bl = false;
                respawnOrderList.append(it.getTitle() + "\n");
            }
            String string = respawnOrderList.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            this.presenter.updateRespawnLocationListText(((Object)StringsKt.trim((CharSequence)string)).toString());
            LocationModel locationModel = ((SpawnModel)this.spawnRepository.getModel()).getSpawnLocation();
            if (locationModel != null) {
                LocationModel it = locationModel;
                boolean bl = false;
                Object object = Bukkit.getServer().getWorld(it.getWorldUUID());
                if (object == null || (object = object.getName()) == null) {
                    object = "";
                }
                Object object2 = "%.2f";
                Object[] objectArray = new Object[]{it.getX()};
                String string2 = String.format((String)object2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                object2 = "%.2f";
                objectArray = new Object[]{it.getY()};
                String string3 = String.format((String)object2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
                object2 = "%.2f";
                objectArray = new Object[]{it.getZ()};
                String string4 = String.format((String)object2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string4, "format(...)");
                String locationString = ChatColor.BOLD + (String)object + "\n" + ChatColor.GOLD + string2 + " " + string3 + " " + string4;
                this.presenter.updateSetSpawnText(locationString);
            }
            UUID spawnKitUuid = ((SpawnModel)this.spawnRepository.getModel()).getSpawnKit();
            boolean bl = false;
            Iterable iterable = this.kitRepository.getKits();
            for (Object e : iterable) {
                KitModel it = (KitModel)e;
                boolean bl2 = false;
                if (!Intrinsics.areEqual(it.getUuid(), spawnKitUuid)) continue;
                v6 = e;
                break block5;
            }
            v6 = null;
        }
        KitModel kitModel = v6;
        if (kitModel != null) {
            KitModel kit = kitModel;
            this.presenter.updateSetFirstKitText(kit.getName());
        }
        this.presenter.setEnableSpawnListener(() -> SpawnConfigInteractor.setSettingsState$lambda$8(this));
        this.presenter.setJoinMessageListener(arg_0 -> SpawnConfigInteractor.setSettingsState$lambda$9(this, arg_0));
        this.presenter.setQuitMessageListener(arg_0 -> SpawnConfigInteractor.setSettingsState$lambda$10(this, arg_0));
        this.presenter.setCooldownListener(arg_0 -> SpawnConfigInteractor.setSettingsState$lambda$11(this, arg_0));
        this.presenter.setDelayListener(arg_0 -> SpawnConfigInteractor.setSettingsState$lambda$12(this, arg_0));
        this.presenter.setSpawnLocationListener(() -> SpawnConfigInteractor.setSettingsState$lambda$13(this));
        this.presenter.setSetWelcomeMessageListener(arg_0 -> SpawnConfigInteractor.setSettingsState$lambda$14(this, arg_0));
        this.presenter.setSetFirstKitListener(() -> SpawnConfigInteractor.setSettingsState$lambda$17(this));
        this.presenter.setRespawnLocationListListener(() -> SpawnConfigInteractor.setSettingsState$lambda$19(this));
        this.presenter.setSpawnOnJoinListener(() -> SpawnConfigInteractor.setSettingsState$lambda$20(this));
        this.presenter.setRespawnCallbacks((arg_0, arg_1) -> SpawnConfigInteractor.setSettingsState$lambda$22(this, arg_0, arg_1), (arg_0, arg_1) -> SpawnConfigInteractor.setSettingsState$lambda$24(this, arg_0, arg_1));
    }

    private final void countdown() {
        this.minimize();
        this.state = SpawnConfigState.CAPTURE;
        Job countdownJob2 = BuildersKt.launch$default(CoroutineScopeKt.CoroutineScope(Dispatchers.getIO()), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ SpawnConfigInteractor this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        countdown = new Ref.IntRef();
                        countdown.element = 3;
lbl7:
                        // 2 sources

                        while (countdown.element > 0) {
                            BuildersKt.launch$default(CoroutineScopeKt.CoroutineScope(new DudeDispatcher()), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, countdown, null){
                                int label;
                                final /* synthetic */ SpawnConfigInteractor this$0;
                                final /* synthetic */ Ref.IntRef $countdown;
                                {
                                    this.this$0 = $receiver;
                                    this.$countdown = $countdown;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure($result);
                                            SpawnConfigInteractor.access$getPlayer$p(this.this$0).sendTitle("" + ChatColor.GREEN + this.$countdown.element, null, 0, 10, 8);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 3, null);
                            this.L$0 = countdown;
                            this.label = 1;
                            v0 = DelayKt.delay-VtjQ1oo(DurationKt.toDuration(1, DurationUnit.SECONDS), this);
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl22
                        }
                        break;
                    }
                    case 1: {
                        countdown = (Ref.IntRef)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl22:
                        // 2 sources

                        var3_4 = countdown.element;
                        countdown.element = var3_4 + -1;
                        ** GOTO lbl7
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
        countdownJob2.invokeOnCompletion(arg_0 -> SpawnConfigInteractor.countdown$lambda$25(this, arg_0));
        FlowExtKt.disposeOn$default(countdownJob2, null, this, 1, null);
    }

    private static final Unit setLocationState$lambda$0(SpawnConfigInteractor this$0) {
        this$0.state = SpawnConfigState.LOCATION;
        this$0.countdown();
        return Unit.INSTANCE;
    }

    private static final Unit setLocationState$lambda$1(SpawnConfigInteractor this$0) {
        this$0.state = SpawnConfigState.LOCATION;
        this$0.countdown();
        return Unit.INSTANCE;
    }

    private static final Unit setLocationState$lambda$2(SpawnConfigInteractor this$0) {
        this$0.state = SpawnConfigState.SETTINGS;
        this$0.newSpawn = null;
        this$0.setSettingsState();
        return Unit.INSTANCE;
    }

    private static final Unit setLocationState$lambda$3(SpawnConfigInteractor this$0) {
        Location location = this$0.newSpawn;
        if (location == null) {
            return Unit.INSTANCE;
        }
        Location newSpawn = location;
        this$0.spawnRepository.setSpawn(newSpawn);
        this$0.state = SpawnConfigState.SETTINGS;
        this$0.newSpawn = null;
        this$0.setSettingsState();
        return Unit.INSTANCE;
    }

    private static final Unit setSettingsState$lambda$8(SpawnConfigInteractor this$0) {
        boolean isEnabled = !((SpawnModel)this$0.spawnRepository.getModel()).getEnabled();
        this$0.spawnRepository.setEnabled(isEnabled);
        this$0.presenter.setEnabledText(StringExtKt.titlecase(String.valueOf(isEnabled)));
        return Unit.INSTANCE;
    }

    private static final Unit setSettingsState$lambda$9(SpawnConfigInteractor this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String newJoinMessage = StringExtKt.colorize(it);
        this$0.spawnRepository.setPlayerJoinMessage(newJoinMessage);
        this$0.presenter.setJoinMessageText(newJoinMessage);
        return Unit.INSTANCE;
    }

    private static final Unit setSettingsState$lambda$10(SpawnConfigInteractor this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String newQuitMessage = StringExtKt.colorize(it);
        this$0.spawnRepository.setPlayerQuitMessage(newQuitMessage);
        this$0.presenter.setQuitMessageText(newQuitMessage);
        return Unit.INSTANCE;
    }

    private static final Unit setSettingsState$lambda$11(SpawnConfigInteractor this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Integer cooldown = StringsKt.toIntOrNull(it);
        if (cooldown == null) {
            this$0.presenter.setMessage(ChatColor.RED + "Teleport cooldown values must be whole numbers!");
            this$0.presenter.setCooldownText("0 Seconds");
            return Unit.INSTANCE;
        }
        this$0.spawnRepository.setCooldown(cooldown);
        return Unit.INSTANCE;
    }

    private static final Unit setSettingsState$lambda$12(SpawnConfigInteractor this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Integer delay2 = StringsKt.toIntOrNull(it);
        if (delay2 == null) {
            this$0.presenter.setMessage(ChatColor.RED + "Teleport delay values must be whole numbers!");
            this$0.presenter.setDelayText("0 Seconds");
            return Unit.INSTANCE;
        }
        this$0.spawnRepository.setDelay(delay2);
        return Unit.INSTANCE;
    }

    private static final Unit setSettingsState$lambda$13(SpawnConfigInteractor this$0) {
        this$0.setLocationState();
        return Unit.INSTANCE;
    }

    private static final Unit setSettingsState$lambda$14(SpawnConfigInteractor this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String newMessage = StringExtKt.colorize(it);
        this$0.presenter.updateSetWelcomeMessageText(newMessage);
        this$0.spawnRepository.setWelcomeMessage(newMessage);
        return Unit.INSTANCE;
    }

    private static final Unit setSettingsState$lambda$17$lambda$15(Ref.ObjectRef $selectedKit, SpawnConfigInteractor this$0, int it) {
        $selectedKit.element = this$0.kitRepository.getKits().get(it);
        this$0.presenter.setKitTitle(((KitModel)$selectedKit.element).getName());
        return Unit.INSTANCE;
    }

    private static final Unit setSettingsState$lambda$17$lambda$16(SpawnConfigInteractor this$0, Ref.ObjectRef $selectedKit) {
        this$0.spawnRepository.setSpawnKit((KitModel)$selectedKit.element);
        this$0.setSettingsState();
        return Unit.INSTANCE;
    }

    private static final Unit setSettingsState$lambda$17(SpawnConfigInteractor this$0) {
        this$0.presenter.setKitState();
        this$0.presenter.setKitAdapter(new SpawnKitPagerAdapter(this$0.kitRepository));
        Ref.ObjectRef selectedKit = new Ref.ObjectRef();
        KitModel kitModel = CollectionsKt.firstOrNull(this$0.kitRepository.getKits());
        if (kitModel == null) {
            return Unit.INSTANCE;
        }
        selectedKit.element = kitModel;
        this$0.presenter.setKitTitle(((KitModel)selectedKit.element).getName());
        this$0.presenter.setPagerListener(arg_0 -> SpawnConfigInteractor.setSettingsState$lambda$17$lambda$15(selectedKit, this$0, arg_0));
        this$0.presenter.setSelectKitListener(() -> SpawnConfigInteractor.setSettingsState$lambda$17$lambda$16(this$0, selectedKit));
        return Unit.INSTANCE;
    }

    private static final Unit setSettingsState$lambda$19$lambda$18(SpawnConfigInteractor this$0) {
        this$0.setSettingsState();
        return Unit.INSTANCE;
    }

    private static final Unit setSettingsState$lambda$19(SpawnConfigInteractor this$0) {
        this$0.presenter.setRespawnListState(((SpawnModel)this$0.spawnRepository.getModel()).getRespawnLocation(), () -> SpawnConfigInteractor.setSettingsState$lambda$19$lambda$18(this$0));
        return Unit.INSTANCE;
    }

    private static final Unit setSettingsState$lambda$20(SpawnConfigInteractor this$0) {
        boolean newValue = !((SpawnModel)this$0.spawnRepository.getModel()).getSpawnOnJoin();
        this$0.presenter.updateSpawnOnJoinText(StringExtKt.titlecase(String.valueOf(newValue)));
        this$0.spawnRepository.setSpawnOnJoin(newValue);
        return Unit.INSTANCE;
    }

    private static final Unit setSettingsState$lambda$22$lambda$21(SpawnConfigInteractor this$0) {
        this$0.setSettingsState();
        return Unit.INSTANCE;
    }

    private static final Unit setSettingsState$lambda$22(SpawnConfigInteractor this$0, RespawnType respawn, PriorityDirection priority) {
        Intrinsics.checkNotNullParameter((Object)respawn, "respawn");
        Intrinsics.checkNotNullParameter((Object)priority, "priority");
        if (this$0.spawnRepository.updateRespawnPriority(respawn, priority)) {
            this$0.presenter.setRespawnListState(((SpawnModel)this$0.spawnRepository.getModel()).getRespawnLocation(), () -> SpawnConfigInteractor.setSettingsState$lambda$22$lambda$21(this$0));
        }
        return Unit.INSTANCE;
    }

    private static final Unit setSettingsState$lambda$24$lambda$23(SpawnConfigInteractor this$0) {
        this$0.setSettingsState();
        return Unit.INSTANCE;
    }

    private static final Unit setSettingsState$lambda$24(SpawnConfigInteractor this$0, RespawnType respawn, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)respawn, "respawn");
        Job job = enabled ? this$0.spawnRepository.addRespawnLocation(respawn) : this$0.spawnRepository.removeRespawnLocation(respawn);
        this$0.presenter.setRespawnListState(((SpawnModel)this$0.spawnRepository.getModel()).getRespawnLocation(), () -> SpawnConfigInteractor.setSettingsState$lambda$24$lambda$23(this$0));
        return Unit.INSTANCE;
    }

    private static final Unit countdown$lambda$25(SpawnConfigInteractor this$0, Throwable it) {
        BuildersKt.launch$default(CoroutineScopeKt.CoroutineScope(new DudeDispatcher()), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            final /* synthetic */ SpawnConfigInteractor this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        SpawnConfigInteractor.access$setNewSpawn$p(this.this$0, SpawnConfigInteractor.access$getPlayer$p(this.this$0).getLocation().clone());
                        SpawnConfigInteractor.access$setState$p(this.this$0, SpawnConfigState.LOCATION);
                        this.this$0.maximize();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Player access$getPlayer$p(SpawnConfigInteractor $this) {
        return $this.player;
    }

    public static final /* synthetic */ void access$setNewSpawn$p(SpawnConfigInteractor $this, Location location) {
        $this.newSpawn = location;
    }

    public static final /* synthetic */ void access$setState$p(SpawnConfigInteractor $this, SpawnConfigState spawnConfigState) {
        $this.state = spawnConfigState;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SpawnConfigState.values().length];
            try {
                nArray[SpawnConfigState.LOCATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

