/*
 * Decompiled with CFR 0.152.
 */
package com.mcmlr.system.products.teleport;

import com.mcmlr.blocks.api.Resources;
import com.mcmlr.blocks.api.data.ConfigModel;
import com.mcmlr.blocks.api.data.Repository;
import com.mcmlr.blocks.core.DudeDispatcher;
import com.mcmlr.system.dagger.EnvironmentScope;
import com.mcmlr.system.placeholder.PlaceholderAPIWrapperKt;
import com.mcmlr.system.products.data.LocationModel;
import com.mcmlr.system.products.data.LocationModelKt;
import com.mcmlr.system.products.homes.HomeListRepository;
import com.mcmlr.system.products.homes.HomeModel;
import com.mcmlr.system.products.homes.PlayerHomesModel;
import com.mcmlr.system.products.kits.KitModel;
import com.mcmlr.system.products.kits.KitRepository;
import com.mcmlr.system.products.spawn.RespawnType;
import com.mcmlr.system.products.spawn.SpawnModel;
import com.mcmlr.system.products.spawn.SpawnRepository;
import com.mcmlr.system.products.teleport.PlayerTeleportModel;
import com.mcmlr.system.products.teleport.TeleportBackModel;
import java.util.Date;
import java.util.UUID;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.jetbrains.annotations.NotNull;

@EnvironmentScope
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B)\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/mcmlr/system/products/teleport/GlobalTeleportRepository;", "Lcom/mcmlr/blocks/api/data/Repository;", "Lcom/mcmlr/system/products/teleport/PlayerTeleportModel;", "resources", "Lcom/mcmlr/blocks/api/Resources;", "spawnRepository", "Lcom/mcmlr/system/products/spawn/SpawnRepository;", "kitRepository", "Lcom/mcmlr/system/products/kits/KitRepository;", "homeRepository", "Lcom/mcmlr/system/products/homes/HomeListRepository;", "<init>", "(Lcom/mcmlr/blocks/api/Resources;Lcom/mcmlr/system/products/spawn/SpawnRepository;Lcom/mcmlr/system/products/kits/KitRepository;Lcom/mcmlr/system/products/homes/HomeListRepository;)V", "playerJoinedServer", "", "e", "Lorg/bukkit/event/player/PlayerJoinEvent;", "playerLeftServer", "Lorg/bukkit/event/player/PlayerQuitEvent;", "playerRespawn", "Lorg/bukkit/event/player/PlayerRespawnEvent;", "setBackLocation", "player", "Lorg/bukkit/entity/Player;", "backLocation", "Lorg/bukkit/Location;", "system"})
@SourceDebugExtension(value={"SMAP\nPlayerTeleportRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerTeleportRepository.kt\ncom/mcmlr/system/products/teleport/GlobalTeleportRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n1869#2,2:154\n*S KotlinDebug\n*F\n+ 1 PlayerTeleportRepository.kt\ncom/mcmlr/system/products/teleport/GlobalTeleportRepository\n*L\n111#1:154,2\n*E\n"})
public final class GlobalTeleportRepository
extends Repository<PlayerTeleportModel> {
    @NotNull
    private final SpawnRepository spawnRepository;
    @NotNull
    private final KitRepository kitRepository;
    @NotNull
    private final HomeListRepository homeRepository;

    @Inject
    public GlobalTeleportRepository(@NotNull Resources resources, @NotNull SpawnRepository spawnRepository, @NotNull KitRepository kitRepository, @NotNull HomeListRepository homeRepository) {
        Intrinsics.checkNotNullParameter(resources, "resources");
        Intrinsics.checkNotNullParameter(spawnRepository, "spawnRepository");
        Intrinsics.checkNotNullParameter(kitRepository, "kitRepository");
        Intrinsics.checkNotNullParameter(homeRepository, "homeRepository");
        super(resources.dataFolder());
        this.spawnRepository = spawnRepository;
        this.kitRepository = kitRepository;
        this.homeRepository = homeRepository;
    }

    public final void playerJoinedServer(@NotNull PlayerJoinEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        if (!((SpawnModel)this.spawnRepository.getModel()).getEnabled()) {
            return;
        }
        String string = ((SpawnModel)this.spawnRepository.getModel()).getJoinMessage();
        Player player2 = e.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player2, "getPlayer(...)");
        e.setJoinMessage(PlaceholderAPIWrapperKt.placeholders(string, player2));
        this.loadModel("Spawn/Players", String.valueOf(e.getPlayer().getUniqueId()), (ConfigModel)new PlayerTeleportModel(false, null, 3, null), arg_0 -> GlobalTeleportRepository.playerJoinedServer$lambda$3(this, e, arg_0));
    }

    public final void playerLeftServer(@NotNull PlayerQuitEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        if (!((SpawnModel)this.spawnRepository.getModel()).getEnabled()) {
            return;
        }
        String string = ((SpawnModel)this.spawnRepository.getModel()).getQuitMessage();
        Player player2 = e.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player2, "getPlayer(...)");
        e.setQuitMessage(PlaceholderAPIWrapperKt.placeholders(string, player2));
    }

    public final void playerRespawn(@NotNull PlayerRespawnEvent e) {
        Intrinsics.checkNotNullParameter(e, "e");
        if (!((SpawnModel)this.spawnRepository.getModel()).getEnabled()) {
            return;
        }
        Iterable $this$forEach$iv = ((SpawnModel)this.spawnRepository.getModel()).getRespawnLocation();
        boolean $i$f$forEach = false;
        block6: for (Object element$iv : $this$forEach$iv) {
            RespawnType it = (RespawnType)((Object)element$iv);
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
                case 1: {
                    if (!e.isAnchorSpawn()) continue block6;
                    return;
                }
                case 2: {
                    if (!e.isBedSpawn()) continue block6;
                    return;
                }
                case 3: {
                    Player player2 = e.getPlayer();
                    Intrinsics.checkNotNullExpressionValue(player2, "getPlayer(...)");
                    Object object = this.homeRepository.getHomes(player2);
                    if (object == null || (object = ((PlayerHomesModel)object).getHomes()) == null || (object = (HomeModel)CollectionsKt.firstOrNull(object)) == null) continue block6;
                    Object home = object;
                    Location location = new Location(Bukkit.getWorld((String)((HomeModel)home).getWorld()), ((HomeModel)home).getX(), ((HomeModel)home).getY(), ((HomeModel)home).getZ(), ((HomeModel)home).getYaw(), ((HomeModel)home).getPitch());
                    e.setRespawnLocation(location);
                    return;
                }
                case 4: {
                    LocationModel locationModel = ((SpawnModel)this.spawnRepository.getModel()).getSpawnLocation();
                    if (locationModel == null || (locationModel = locationModel.toLocation()) == null) continue block6;
                    LocationModel spawn = locationModel;
                    e.setRespawnLocation((Location)spawn);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    public final void setBackLocation(@NotNull Player player2, @NotNull Location backLocation) {
        Intrinsics.checkNotNullParameter(player2, "player");
        Intrinsics.checkNotNullParameter(backLocation, "backLocation");
        String string = player2.getUniqueId().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        this.generateModel("Spawn/Players", string, (ConfigModel)new PlayerTeleportModel(false, null, 3, null), (Function2)new Function2<PlayerTeleportModel, Continuation<? super Unit>, Object>(backLocation, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ Location $backLocation;
            {
                this.$backLocation = $backLocation;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                PlayerTeleportModel playerTeleportModel = (PlayerTeleportModel)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void teleportModel;
                        ResultKt.throwOnFailure($result);
                        LocationModel locationModel = LocationModelKt.toLocationModel(this.$backLocation);
                        if (locationModel == null) {
                            return Unit.INSTANCE;
                        }
                        LocationModel back = locationModel;
                        teleportModel.setBackLocation(new TeleportBackModel(new Date().getTime(), back));
                        ConfigModel.save$default((ConfigModel)teleportModel, null, 1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return var3_3;
            }

            public final Object invoke(PlayerTeleportModel p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private static final Unit playerJoinedServer$lambda$3$lambda$2(PlayerTeleportModel $model) {
        $model.setFirstSpawn(false);
        return Unit.INSTANCE;
    }

    private static final Unit playerJoinedServer$lambda$3(GlobalTeleportRepository this$0, PlayerJoinEvent $e, PlayerTeleportModel model) {
        Intrinsics.checkNotNullParameter(model, "model");
        if (model.getFirstSpawn()) {
            LocationModel locationModel = ((SpawnModel)this$0.spawnRepository.getModel()).getSpawnLocation();
            if (locationModel != null && (locationModel = locationModel.toLocation()) != null) {
                LocationModel it = locationModel;
                boolean bl = false;
                BuildersKt.launch$default(CoroutineScopeKt.CoroutineScope(new DudeDispatcher()), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>($e, (Location)it, null){
                    int label;
                    final /* synthetic */ PlayerJoinEvent $e;
                    final /* synthetic */ Location $it;
                    {
                        this.$e = $e;
                        this.$it = $it;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure($result);
                                this.$e.getPlayer().teleport(this.$it);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 3, null);
                String string = ((SpawnModel)this$0.spawnRepository.getModel()).getWelcomeMessage();
                Player player2 = $e.getPlayer();
                Intrinsics.checkNotNullExpressionValue(player2, "getPlayer(...)");
                Bukkit.broadcastMessage((String)PlaceholderAPIWrapperKt.placeholders(string, player2));
            }
            UUID uUID = ((SpawnModel)this$0.spawnRepository.getModel()).getSpawnKit();
            if (uUID != null) {
                UUID it = uUID;
                boolean bl = false;
                KitModel kitModel = this$0.kitRepository.getKit(it);
                if (kitModel != null) {
                    KitModel kit = kitModel;
                    KitRepository kitRepository = this$0.kitRepository;
                    Player player3 = $e.getPlayer();
                    Intrinsics.checkNotNullExpressionValue(player3, "getPlayer(...)");
                    kitRepository.givePlayerKit(player3, kit, true);
                }
            }
            this$0.save(() -> GlobalTeleportRepository.playerJoinedServer$lambda$3$lambda$2(model));
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RespawnType.values().length];
            try {
                nArray[RespawnType.RESPAWN_ANCHOR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RespawnType.BED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RespawnType.HOME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RespawnType.SPAWN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

