/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudios.awesomedungeonnether;

import com.jtorleonstudios.awesomedungeonnether.AwesomeStructure;
import com.jtorleonstudios.awesomedungeonnether.AwsConfig;
import com.jtorleonstudios.awesomedungeonnether.Main;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.jetbrains.annotations.NotNull;

interface AwsStructure {
    public static final MapCodec<AwesomeDungeonStructure> CODEC = AwesomeDungeonStructure.getDefaultCodec(10, 10, uniqueResourceLocationStartPool -> AwsConfig.get(uniqueResourceLocationStartPool).isEnabled(), AwesomeDungeonStructure::new);

    public static class AwesomeDungeonStructure
    extends AwesomeStructure {
        int BIOME_RANGE = 1;

        public AwesomeDungeonStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, String uniqueIdentifier, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
            super(config, startPool, uniqueIdentifier, startJigsawName, size, startHeight, projectStartToHeightmap, maxDistanceFromCenter);
        }

        @NotNull
        public StructureType<?> type() {
            return (StructureType)Main.AWS_STRUCTURE_TYPE.get();
        }

        private static List<BlockPos.MutableBlockPos> getPotentialPosition(Structure.GenerationContext ctx) {
            BlockPos centerOfChunk = ctx.chunkPos().getMiddleBlockPosition(0);
            int landHeight = ctx.chunkGenerator().getFirstOccupiedHeight(centerOfChunk.getX(), centerOfChunk.getZ(), Heightmap.Types.WORLD_SURFACE_WG, ctx.heightAccessor(), ctx.randomState()) - 50;
            BlockPos.MutableBlockPos bpm = new BlockPos.MutableBlockPos(centerOfChunk.getX(), 0, centerOfChunk.getZ());
            NoiseColumn columnOfBlocks = ctx.chunkGenerator().getBaseColumn(centerOfChunk.getX(), centerOfChunk.getZ(), ctx.heightAccessor(), ctx.randomState());
            ArrayList<BlockPos.MutableBlockPos> data = new ArrayList<BlockPos.MutableBlockPos>();
            for (int i = 0; i < landHeight; ++i) {
                BlockState beforeMoveState = columnOfBlocks.getBlock(bpm.getY());
                boolean beforeMoveIsGround = !beforeMoveState.isAir() && beforeMoveState.getFluidState().isEmpty();
                bpm.move(Direction.UP);
                if (!beforeMoveIsGround || !columnOfBlocks.getBlock(bpm.getY()).isAir()) continue;
                data.add(bpm.mutable());
            }
            return data;
        }

        @Override
        protected boolean canGenerate(Structure.GenerationContext ctx) {
            return !AwesomeDungeonStructure.getPotentialPosition(ctx).isEmpty();
        }

        @Override
        protected BlockPos getInitialStartPosition(Structure.GenerationContext ctx) {
            List<BlockPos.MutableBlockPos> data = AwesomeDungeonStructure.getPotentialPosition(ctx);
            return (BlockPos)data.get(new Random().nextInt(data.size()));
        }
    }
}

