/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft;

import com.g4mesoft.GSExtensionInfoList;
import com.g4mesoft.GSExtensionUID;
import com.g4mesoft.GSIExtension;
import com.g4mesoft.GSIExtensionListener;
import com.g4mesoft.core.GSCoreExtension;
import com.g4mesoft.core.GSCoreOverride;
import com.g4mesoft.core.compat.GSTweakerooCompat;
import com.g4mesoft.packet.GSPacketManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.ModMetadata;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class G4mespeedMod
implements ModInitializer {
    public static final GSExtensionUID INVALID_EXTENSION_UID = new GSExtensionUID(-1);
    public static final Logger GS_LOGGER = LogManager.getLogger((String)"G4mespeed Core");
    private static G4mespeedMod instance = null;
    private static boolean initialized = false;
    private GSPacketManager packetManager;
    private GSTweakerooCompat tweakerooCompat;
    private static final List<GSIExtension> extensions = new ArrayList<GSIExtension>();
    private static final Set<GSExtensionUID> extensionIds = new HashSet<GSExtensionUID>();
    private static final List<GSIExtensionListener> extensionListeners = new ArrayList<GSIExtensionListener>();
    private static final GSExtensionInfoList extensionInfoList = new GSExtensionInfoList();

    @GSCoreOverride
    public void onInitialize() {
        instance = this;
        this.packetManager = new GSPacketManager();
        this.tweakerooCompat = new GSTweakerooCompat();
        this.tweakerooCompat.detect();
        FabricLoader.getInstance().getEntrypointContainers("g4mespeed", GSIExtension.class).forEach(container -> {
            ModMetadata metadata = container.getProvider().getMetadata();
            String modid = metadata.getId();
            try {
                GSIExtension extension = (GSIExtension)container.getEntrypoint();
                String name = extension.getInfo().getName();
                G4mespeedMod.addExtension(extension);
                GS_LOGGER.info("Added extension '{}' provided by '{}'", (Object)name, (Object)modid);
            }
            catch (Throwable e) {
                GS_LOGGER.error("Mod '{}' provides a broken implementation of GSIExtension", (Object)modid, (Object)e);
            }
        });
        for (GSIExtension extension : extensions) {
            extension.init();
        }
        this.packetManager.init();
        initialized = true;
        GS_LOGGER.info("G4mespeed {} initialized!", (Object)GSCoreExtension.VERSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addExtension(GSIExtension extension) {
        if (extension == null) {
            throw new IllegalArgumentException("extension is null");
        }
        List<GSIExtension> list = extensions;
        synchronized (list) {
            GSExtensionUID uid = extension.getInfo().getUniqueId();
            if (INVALID_EXTENSION_UID.equals(uid)) {
                throw new IllegalArgumentException("Invalid extension ID: " + String.valueOf(uid));
            }
            if (!extensionIds.add(uid)) {
                throw new IllegalArgumentException("Duplicate extension ID: " + String.valueOf(uid));
            }
            extensions.add(extension);
            extensionInfoList.addInfo(extension.getInfo());
        }
        if (initialized) {
            extension.init();
            G4mespeedMod.dispatchExtensionAddedEvent(extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addExtensionListener(GSIExtensionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null!");
        }
        List<GSIExtensionListener> list = extensionListeners;
        synchronized (list) {
            extensionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeExtensionListener(GSIExtensionListener listener) {
        List<GSIExtensionListener> list = extensionListeners;
        synchronized (list) {
            extensionListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dispatchExtensionAddedEvent(GSIExtension extension) {
        List<GSIExtensionListener> list = extensionListeners;
        synchronized (list) {
            for (GSIExtensionListener listener : extensionListeners) {
                listener.extensionAdded(extension);
            }
        }
    }

    public static List<GSIExtension> getExtensions() {
        return Collections.unmodifiableList(extensions);
    }

    public static GSExtensionInfoList getExtensionInfoList() {
        return extensionInfoList;
    }

    public static GSPacketManager getPacketManager() {
        return G4mespeedMod.getInstance().packetManager;
    }

    public static GSTweakerooCompat getTweakerooCompat() {
        return G4mespeedMod.getInstance().tweakerooCompat;
    }

    private static G4mespeedMod getInstance() {
        return instance;
    }
}

