/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft;

import com.g4mesoft.GSExtensionInfo;
import com.g4mesoft.GSExtensionUID;
import com.g4mesoft.core.GSCoreExtension;
import com.g4mesoft.core.GSVersion;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GSExtensionInfoList {
    private static final String UNKNOWN_NAME = "Unknown";
    private Map<GSExtensionUID, GSExtensionInfo> extensionInfo = new LinkedHashMap<GSExtensionUID, GSExtensionInfo>();

    public GSExtensionInfoList() {
        this.clearInfo();
    }

    public GSExtensionInfo getInfo(GSExtensionUID extensionUid) {
        GSExtensionInfo info = this.extensionInfo.get(extensionUid);
        if (info == null) {
            return new GSExtensionInfo(UNKNOWN_NAME, extensionUid, GSVersion.INVALID);
        }
        return info;
    }

    public Collection<GSExtensionInfo> getAllInfo() {
        return Collections.unmodifiableCollection(this.extensionInfo.values());
    }

    public void addInfo(GSExtensionInfo info) {
        this.extensionInfo.put(info.getUniqueId(), info);
    }

    public boolean isExtensionInstalled(GSExtensionUID extensionUid) {
        return this.isExtensionInstalled(extensionUid, GSVersion.MINIMUM_VERSION);
    }

    public boolean isExtensionInstalled(GSExtensionUID extensionUid, GSVersion minimumVersion) {
        return this.getInfo(extensionUid).getVersion().isGreaterThanOrEqualTo(minimumVersion);
    }

    public void clearInfo() {
        this.extensionInfo.clear();
        this.addInfo(GSCoreExtension.INVALID_VERSION_INFO);
    }

    public void addAllInfo(GSExtensionInfo[] infoArray) {
        for (GSExtensionInfo info : infoArray) {
            this.addInfo(info);
        }
    }

    public void addAllExtensionInfo(List<GSExtensionInfo> infoList) {
        infoList.forEach(this::addInfo);
    }
}

