/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft;

import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;

public final class GSExtensionUID {
    private final int value;

    public GSExtensionUID(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static void write(GSEncodeBuffer buf, GSExtensionUID uid) throws IOException {
        buf.writeInt(uid.getValue());
    }

    public static GSExtensionUID read(GSDecodeBuffer buf) throws IOException {
        return new GSExtensionUID(buf.readInt());
    }

    public static GSExtensionUID parseUID(String str) {
        int value;
        try {
            value = Integer.parseInt(str, 16);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return new GSExtensionUID(value);
    }

    public static String toString(GSExtensionUID uid) {
        return Integer.toHexString(uid.getValue());
    }

    public int hashCode() {
        return Integer.hashCode(this.value);
    }

    public boolean equals(Object other) {
        if (!(other instanceof GSExtensionUID)) {
            return false;
        }
        return this.value == ((GSExtensionUID)other).value;
    }

    public String toString() {
        return GSExtensionUID.toString(this);
    }
}

