/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.core;

import com.g4mesoft.G4mespeedMod;
import com.g4mesoft.GSIExtension;
import com.g4mesoft.GSIExtensionListener;
import com.g4mesoft.core.GSIModule;
import com.g4mesoft.core.GSIModuleManager;
import com.g4mesoft.module.tps.GSTpsModule;
import com.g4mesoft.module.translation.GSTranslationModule;
import com.g4mesoft.setting.GSSettingManager;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2596;

public abstract class GSController
implements GSIModuleManager,
GSIExtensionListener {
    protected static final String SETTINGS_FILE_NAME = "settings.cfg";
    protected static final String CACHE_DIR_NAME = "g4mespeed/cache";
    protected static final String INTEGRATED_CACHE_DIR_NAME = "g4mespeed/integrated/cache";
    private static final Set<GSController> INSTANCES = new HashSet<GSController>();
    protected final GSSettingManager settings = new GSSettingManager();
    protected final List<GSIModule> modules = new ArrayList<GSIModule>();
    protected final Map<Class<? extends GSIModule>, GSIModule> clazzToModule = new IdentityHashMap<Class<? extends GSIModule>, GSIModule>();
    protected final GSTpsModule tpsModule = new GSTpsModule();
    protected final GSTranslationModule translationModule = new GSTranslationModule();

    protected void onStart() {
        INSTANCES.add(this);
        this.settings.loadSettings(this.getSettingsFile());
        this.initModules();
        G4mespeedMod.addExtensionListener(this);
    }

    protected void onStop() {
        INSTANCES.remove(this);
        for (GSIModule module : this.modules) {
            module.onClose();
        }
        this.settings.saveSettings(this.getSettingsFile());
        this.settings.clearSettings();
        this.modules.clear();
        this.clazzToModule.clear();
        G4mespeedMod.removeExtensionListener(this);
    }

    protected void initModules() {
        this.addModule(this.tpsModule);
        this.addModule(this.translationModule);
        G4mespeedMod.getExtensions().forEach(this::addExtensionModules);
    }

    @Override
    public void addModule(GSIModule module) {
        Class<?> clazz = module.getClass();
        if (this.clazzToModule.put(clazz, module) != null) {
            throw new IllegalStateException("Module of class " + clazz.getName() + " already exists");
        }
        this.modules.add(module);
        module.init(this);
    }

    public void tick(boolean paused) {
        for (GSIModule module : this.modules) {
            module.tick(paused);
        }
    }

    public GSTpsModule getTpsModule() {
        return this.tpsModule;
    }

    public GSTranslationModule getTranslationModule() {
        return this.translationModule;
    }

    @Override
    public <M extends GSIModule> M getModule(Class<M> moduleClazz) {
        GSIModule module = this.clazzToModule.get(moduleClazz);
        return (M)module;
    }

    @Override
    public List<GSIModule> getModules() {
        return this.modules;
    }

    private File getSettingsFile() {
        return new File(this.getCacheFile(), SETTINGS_FILE_NAME);
    }

    @Override
    public GSSettingManager getSettingManager() {
        return this.settings;
    }

    public static GSController getInstanceOnThread() {
        for (GSController controller : INSTANCES) {
            if (!controller.isThreadOwner()) continue;
            return controller;
        }
        return null;
    }

    @Override
    public void extensionAdded(GSIExtension extension) {
        this.addExtensionModules(extension);
    }

    protected abstract void addExtensionModules(GSIExtension var1);

    public abstract boolean isThreadOwner();

    public abstract class_2596<?> createCustomPayload(ByteBuf var1);

    @Override
    public abstract boolean isClient();
}

