/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.core;

import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;

public final class GSVersion
implements Comparable<GSVersion> {
    public static final GSVersion INVALID = new GSVersion(-1, -1, -1);
    public static final GSVersion MINIMUM_VERSION = new GSVersion(0, 0, 0);
    private static final String RELEASE_FORMAT = "%d.%d.%d";
    private static final String BETA_FORMAT = "%d.%d.%d-beta";
    private static final String ALPHA_FORMAT = "%d.%d.%d-alpha";
    private final int majorVersion;
    private final int minorVersion;
    private final int patchVersion;
    private String versionStringCache;

    public GSVersion(String versionString) throws IllegalArgumentException {
        String[] args;
        int dashIndex = versionString.indexOf(45);
        if (dashIndex != -1) {
            versionString = versionString.substring(0, dashIndex);
        }
        if ((args = versionString.split("\\.")).length != 3) {
            throw new IllegalArgumentException("Invalid version string");
        }
        try {
            this.majorVersion = Integer.parseInt(args[0]);
            this.minorVersion = Integer.parseInt(args[1]);
            this.patchVersion = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid version string");
        }
        this.versionStringCache = null;
    }

    public GSVersion(int majorVersion, int minorVersion, int patchVersion) {
        this.majorVersion = GSVersion.checkVersion(majorVersion);
        this.minorVersion = GSVersion.checkVersion(minorVersion);
        this.patchVersion = GSVersion.checkVersion(patchVersion);
        this.versionStringCache = null;
    }

    private static int checkVersion(int version) {
        if (version < -1 || version > Short.MAX_VALUE) {
            throw new IllegalArgumentException("version must be between -1 (invalid) and 0x7FFF.");
        }
        return version;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getPatchVersion() {
        return this.patchVersion;
    }

    public String getVersionString() {
        if (this.versionStringCache == null) {
            String format = this.majorVersion != 0 ? RELEASE_FORMAT : (this.minorVersion != 0 ? BETA_FORMAT : ALPHA_FORMAT);
            this.versionStringCache = String.format(format, this.majorVersion, this.minorVersion, this.patchVersion);
        }
        return this.versionStringCache;
    }

    public boolean isInvalid() {
        return this.majorVersion < 0 || this.minorVersion < 0 || this.patchVersion < 0;
    }

    public boolean isGreaterThanOrEqualTo(GSVersion other) {
        if (this.isInvalid()) {
            return other.isInvalid();
        }
        if (other.isInvalid()) {
            return true;
        }
        if (this.majorVersion > other.majorVersion) {
            return true;
        }
        if (this.majorVersion == other.majorVersion) {
            if (this.minorVersion > other.minorVersion) {
                return true;
            }
            if (this.minorVersion == other.minorVersion) {
                return this.patchVersion >= other.patchVersion;
            }
        }
        return false;
    }

    public boolean isLessThanOrEqualTo(GSVersion other) {
        return other.isGreaterThanOrEqualTo(this);
    }

    public boolean isGreaterThan(GSVersion other) {
        return !this.isLessThanOrEqualTo(other);
    }

    public boolean isLessThan(GSVersion other) {
        return !this.isGreaterThanOrEqualTo(other);
    }

    public boolean isEqual(GSVersion other) {
        if (this.isInvalid()) {
            return other.isInvalid();
        }
        return this.majorVersion == other.majorVersion && this.minorVersion == other.minorVersion && this.patchVersion == other.patchVersion;
    }

    public static GSVersion read(GSDecodeBuffer buf) {
        short major = buf.readShort();
        short minor = buf.readShort();
        short patch = buf.readShort();
        return new GSVersion(major, minor, patch);
    }

    public static void write(GSEncodeBuffer buf, GSVersion version) {
        buf.writeShort((short)version.majorVersion);
        buf.writeShort((short)version.minorVersion);
        buf.writeShort((short)version.patchVersion);
    }

    @Override
    public int compareTo(GSVersion other) {
        return this.isEqual(other) ? 0 : (this.isGreaterThan(other) ? 1 : -1);
    }

    public int hashCode() {
        int hash = 0;
        hash += 31 * hash + this.majorVersion;
        hash += 31 * hash + this.minorVersion;
        hash += 31 * hash + this.patchVersion;
        return hash;
    }

    public boolean equals(Object other) {
        if (!(other instanceof GSVersion)) {
            return false;
        }
        return this.isEqual((GSVersion)other);
    }

    public String toString() {
        return this.getVersionString();
    }
}

