/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.core.compat;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

public final class GSCompatUtil {
    private GSCompatUtil() {
    }

    static Class<?> findClassByName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    static Field findDeclaredField(Class<?> clazz, String name) {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException | SecurityException exception) {
            return null;
        }
    }

    static Field findField(Class<?> clazz, String name) {
        try {
            return clazz.getField(name);
        }
        catch (NoSuchFieldException | SecurityException exception) {
            return null;
        }
    }

    static Method findDeclaredMethod(Class<?> clazz, String name, Class<?> ... args) {
        try {
            return clazz.getDeclaredMethod(name, args);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            return null;
        }
    }

    static Method findMethod(Class<?> clazz, String name, Class<?> ... args) {
        try {
            return clazz.getMethod(name, args);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            return null;
        }
    }

    static boolean invokeStatic(Method method, Object ... args) {
        return GSCompatUtil.invoke(null, method, args);
    }

    static boolean invoke(Object instance, Method method, Object ... args) {
        try {
            method.invoke(instance, args);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static <T> T getStatic(Method method, Object ... args) {
        return GSCompatUtil.get(null, method, args);
    }

    static <T> T get(Object instance, Method method, Object ... args) {
        try {
            return (T)method.invoke(instance, args);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static <T> T getStaticField(Field field) {
        return GSCompatUtil.getField(null, field);
    }

    static <T> T getField(Object instance, Field field) {
        try {
            return (T)field.get(instance);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static boolean setStaticField(Field field, Object newValue) {
        return GSCompatUtil.setField(null, field, newValue);
    }

    static boolean setField(Object instance, Field field, Object newValue) {
        try {
            field.set(instance, newValue);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

