/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.gui;

import com.g4mesoft.gui.GSHotkeyElementGUI;
import com.g4mesoft.hotkey.GSIKeyBindingRegisterListener;
import com.g4mesoft.hotkey.GSKeyBinding;
import com.g4mesoft.hotkey.GSKeyManager;
import com.g4mesoft.ui.panel.GSDimension;
import com.g4mesoft.ui.panel.GSPanel;
import com.g4mesoft.ui.panel.GSPanelContext;
import com.g4mesoft.ui.panel.GSParentPanel;
import com.g4mesoft.ui.panel.legacy.GSButtonPanel;
import com.g4mesoft.ui.panel.scroll.GSIScrollable;
import com.g4mesoft.ui.renderer.GSIRenderer2D;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2561;

public class GSHotkeyGUI
extends GSParentPanel
implements GSIScrollable,
GSIKeyBindingRegisterListener {
    private static final int HOTKEY_MARGIN = 1;
    private static final int CATEGORY_MARGIN = 5;
    private static final int CATEGORY_TITLE_BOTTOM_MARGIN = 2;
    private static final int CATEGORY_TITLE_COLOR = -1;
    private static final int BUTTON_WIDTH = 96;
    private static final class_2561 RESET_ALL_TEXT = class_2561.method_43471((String)"gui.hotkey.resetAll");
    private static final class_2561 UNBIND_ALL_TEXT = class_2561.method_43471((String)"gui.hotkey.unbindAll");
    private final Map<String, GSHotkeyCategoryGUI> hotkeyCategories = new LinkedHashMap<String, GSHotkeyCategoryGUI>();
    private final GSButtonPanel resetAllButton = new GSButtonPanel(RESET_ALL_TEXT, () -> {
        for (GSHotkeyCategoryGUI category : this.hotkeyCategories.values()) {
            category.resetAll();
        }
    });
    private final GSButtonPanel unbindAllButton = new GSButtonPanel(UNBIND_ALL_TEXT, () -> {
        for (GSHotkeyCategoryGUI category : this.hotkeyCategories.values()) {
            category.unbindAll();
        }
    });
    private GSHotkeyElementGUI changingElement;

    public GSHotkeyGUI(GSKeyManager keyManager) {
        this.add((GSPanel)this.resetAllButton);
        this.add((GSPanel)this.unbindAllButton);
        keyManager.getKeyBindings().forEach(this::addKeyEntry);
        keyManager.setKeyRegisterListener(this);
    }

    public void layout() {
        int w = 0;
        for (GSHotkeyCategoryGUI gSHotkeyCategoryGUI : this.hotkeyCategories.values()) {
            int prefWidth = gSHotkeyCategoryGUI.getPreferredWidth();
            if (prefWidth <= w) continue;
            w = prefWidth;
        }
        if (this.width < w) {
            w = this.width;
        }
        int y = 0;
        for (GSHotkeyCategoryGUI hotkeyCategory : this.hotkeyCategories.values()) {
            y = hotkeyCategory.layoutHotkeys(0, y, w);
        }
        int n = w - 192;
        int bw = Math.min(96, 96 + n / 2);
        this.resetAllButton.setPreferredBounds(0, y += 5, bw);
        this.unbindAllButton.setPreferredBounds(bw + n, y, bw);
        y += 20;
    }

    public void render(GSIRenderer2D renderer) {
        super.render(renderer);
        for (GSHotkeyCategoryGUI hotkeyCategory : this.hotkeyCategories.values()) {
            hotkeyCategory.renderTitle(renderer);
        }
    }

    @Override
    public void onKeyRegistered(GSKeyBinding keyBinding) {
        this.addKeyEntry(keyBinding);
    }

    private void addKeyEntry(GSKeyBinding keyBinding) {
        GSHotkeyCategoryGUI category = this.hotkeyCategories.get(keyBinding.getCategory());
        if (category == null) {
            category = new GSHotkeyCategoryGUI(keyBinding.getCategory());
            this.hotkeyCategories.put(keyBinding.getCategory(), category);
        }
        category.addKeyBinding(keyBinding);
        this.invalidate();
    }

    protected GSDimension calculatePreferredSize() {
        int w = 0;
        int h = 0;
        for (GSHotkeyCategoryGUI hotkeyCategory : this.hotkeyCategories.values()) {
            w = Math.max(w, hotkeyCategory.getPreferredWidth());
            h += hotkeyCategory.getPreferredHeight();
        }
        return new GSDimension(w, h += 30);
    }

    public void setChangingElement(GSHotkeyElementGUI element) {
        if (this.changingElement != null && element != null) {
            throw new IllegalStateException("Can not change multiple elements at once!");
        }
        this.changingElement = element;
    }

    public GSHotkeyElementGUI getChangingElement() {
        return this.changingElement;
    }

    public boolean isScrollableWidthFilled() {
        return true;
    }

    private class GSHotkeyCategoryGUI {
        private final class_2561 categoryNameText;
        private final List<GSHotkeyElementGUI> elements;
        private int x;
        private int y;
        private int w;

        public GSHotkeyCategoryGUI(String name) {
            this.categoryNameText = class_2561.method_43471((String)("hotkey." + name + ".title"));
            this.elements = new ArrayList<GSHotkeyElementGUI>();
        }

        public void addKeyBinding(GSKeyBinding keyBinding) {
            GSHotkeyElementGUI hotkeyElement = new GSHotkeyElementGUI(GSHotkeyGUI.this, keyBinding);
            this.elements.add(hotkeyElement);
            GSHotkeyGUI.this.add((GSPanel)hotkeyElement);
        }

        public int getPreferredWidth() {
            int prefWidth = 0;
            for (GSHotkeyElementGUI hotkeyElement : this.elements) {
                int pw = hotkeyElement.getPreferredWidth();
                if (pw <= prefWidth) continue;
                prefWidth = pw;
            }
            return prefWidth;
        }

        public int getPreferredHeight() {
            int prefHeight = 0;
            GSIRenderer2D renderer = GSPanelContext.getRenderer();
            prefHeight += 5 + renderer.getTextHeight() + 2;
            for (GSHotkeyElementGUI hotkeyElement : this.elements) {
                prefHeight += hotkeyElement.getPreferredHeight() + 2;
            }
            return prefHeight;
        }

        public int layoutHotkeys(int x, int y, int w) {
            this.x = x;
            this.y = y;
            this.w = w;
            GSIRenderer2D renderer = GSPanelContext.getRenderer();
            y += 5 + renderer.getTextHeight() + 2;
            for (GSHotkeyElementGUI hotkeyElement : this.elements) {
                int h = hotkeyElement.getPreferredHeight();
                hotkeyElement.setBounds(x, y, w, h);
                y += h + 2;
            }
            return y;
        }

        public void renderTitle(GSIRenderer2D renderer) {
            int tx = this.x + this.w / 2;
            int ty = this.y + 5;
            renderer.drawCenteredText(this.categoryNameText, tx, ty, -1);
        }

        public void resetAll() {
            this.elements.forEach(GSHotkeyElementGUI::resetKeyCode);
        }

        public void unbindAll() {
            this.elements.forEach(GSHotkeyElementGUI::unbindKeyCode);
        }
    }
}

