/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.gui;

import com.g4mesoft.G4mespeedMod;
import com.g4mesoft.GSExtensionInfo;
import com.g4mesoft.GSExtensionInfoList;
import com.g4mesoft.core.GSVersion;
import com.g4mesoft.core.client.GSClientController;
import com.g4mesoft.ui.panel.GSParentPanel;
import com.g4mesoft.ui.renderer.GSIRenderer2D;
import java.util.Collection;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class GSInfoGUI
extends GSParentPanel {
    private static final int TEXT_COLOR = -1;
    private static final int EXTENSION_NAME_COLOR = -5592406;
    private static final int VERSION_COLOR = -14483678;
    private static final int LESS_THAN_VERSION_COLOR = -256;
    private static final int INVALID_VERSION_COLOR = -43691;
    private static final int TEXT_SPACING = 5;
    private static final class_2561 SERVER_EXTENSIONS_TITLE = class_2561.method_43471((String)"gui.info.serverExtensionsTitle");
    private static final class_2561 CLIENT_EXTENSIONS_TITLE = class_2561.method_43471((String)"gui.info.clientExtensionsTitle");
    private static final class_2561 INVALID_VERSION_TEXT = class_2561.method_43471((String)"gui.info.invalidVersion");
    private static final String EXTENSION_NAME_TRANSLATION_KEY = "gui.info.extensionName";
    private final GSClientController client;

    public GSInfoGUI(GSClientController client) {
        this.client = client;
    }

    public void render(GSIRenderer2D renderer) {
        super.render(renderer);
        Collection<GSExtensionInfo> serverInfoList = this.client.getServerExtensionInfoList().getAllInfo();
        Collection<GSExtensionInfo> clientInfoList = G4mespeedMod.getExtensionInfoList().getAllInfo();
        int lineCount = 3 + serverInfoList.size() + clientInfoList.size();
        int xc = this.width / 2;
        int y = this.height / 2 - renderer.getLineHeight() * lineCount / 2 - 10;
        if (this.client.isConnectedToServer()) {
            y = this.drawExtensionList(renderer, xc, y, SERVER_EXTENSIONS_TITLE, serverInfoList);
            y += renderer.getLineHeight();
        }
        y = this.drawExtensionList(renderer, xc, y, CLIENT_EXTENSIONS_TITLE, clientInfoList);
    }

    private int drawExtensionList(GSIRenderer2D renderer, int xc, int y, class_2561 title, Collection<GSExtensionInfo> infoList) {
        renderer.drawCenteredText(title, xc, y, -1);
        y += renderer.getLineHeight();
        for (GSExtensionInfo info : infoList) {
            this.drawExtensionInfo(renderer, info, xc, y);
            y += renderer.getLineHeight();
        }
        return y;
    }

    private void drawExtensionInfo(GSIRenderer2D renderer, GSExtensionInfo info, int xc, int y) {
        int versionColor;
        class_2561 versionText;
        GSVersion version = info.getVersion();
        if (!version.isInvalid()) {
            versionText = class_2561.method_43470((String)version.toString());
            GSExtensionInfoList clientInfoList = G4mespeedMod.getExtensionInfoList();
            GSExtensionInfo clientInfo = clientInfoList.getInfo(info.getUniqueId());
            versionColor = version.isLessThan(clientInfo.getVersion()) ? -256 : -14483678;
        } else {
            versionText = INVALID_VERSION_TEXT;
            versionColor = -43691;
        }
        class_5250 prefix = class_2561.method_43469((String)EXTENSION_NAME_TRANSLATION_KEY, (Object[])new Object[]{info.getName()});
        float pw = renderer.getTextWidth((class_2561)prefix) + 5.0f;
        float tw = pw + renderer.getTextWidth(versionText);
        int tx = xc - (int)(tw / 2.0f);
        renderer.drawText((class_2561)prefix, tx, y, -5592406);
        renderer.drawText(versionText, tx + (int)Math.ceil(pw), y, versionColor);
    }
}

