/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.gui.setting;

import com.g4mesoft.gui.setting.GSSettingPanel;
import com.g4mesoft.setting.GSSetting;
import com.g4mesoft.setting.GSSettingCategory;
import com.g4mesoft.ui.panel.GSPanel;
import com.g4mesoft.ui.panel.field.GSTextField;
import com.g4mesoft.ui.panel.legacy.GSButtonPanel;
import com.g4mesoft.ui.panel.legacy.GSSliderPanel;
import com.g4mesoft.ui.renderer.GSIRenderer2D;
import net.minecraft.class_2561;

public abstract class GSAbstractNumberSettingPanel<T extends GSSetting<?>>
extends GSSettingPanel<T> {
    private static final int SETTING_HEIGHT = 16;
    private static final int TEXT_FIELD_HEIGHT = 20;
    private static final int TEXT_FIELD_MAX_WIDTH = 196;
    private static final class_2561 SET_VALUE_TEXT = class_2561.method_43471((String)"setting.button.set");
    private static final int TEXT_MAX_WIDTH = 96;
    protected GSSliderPanel slider;
    protected GSTextField textField;
    protected GSButtonPanel valueSetButton;
    protected GSButtonPanel resetButton;
    protected String prevTextFieldValue;

    public GSAbstractNumberSettingPanel(GSSettingCategory category, T setting) {
        super(category, setting);
    }

    @Override
    public void setPreferredBounds(int x, int y, int width) {
        int prefHeight = this.isSingleLine(width) ? Math.max(super.getPreferredHeight(), 20) : this.getPreferredHeight();
        this.setBounds(x, y, width, prefHeight);
    }

    private boolean isSingleLine(int width) {
        if (this.isSliderActive()) {
            return width >= this.getPreferredWidth() + 4 + 200;
        }
        return width >= this.getPreferredWidth() + 6 + 196 + 48;
    }

    @Override
    public void render(GSIRenderer2D renderer) {
        super.render(renderer);
        int ty = (this.getSettingHeight() - renderer.getTextHeight()) / 2;
        renderer.drawText(this.nameText, 2, ty, this.getTextColor());
    }

    @Override
    public int getPreferredWidth() {
        return super.getPreferredWidth() + 96 + 4;
    }

    @Override
    public int getPreferredHeight() {
        int prefHeight = Math.max(super.getPreferredHeight(), 20);
        prefHeight = this.slider != null ? (prefHeight += 22) : (prefHeight += 22);
        return prefHeight;
    }

    public void onResized(int oldWidth, int oldHeight) {
        if (this.shouldUseSlider()) {
            if (this.textField != null) {
                this.remove((GSPanel)this.textField);
                this.textField = null;
            }
            if (this.valueSetButton != null) {
                this.remove((GSPanel)this.valueSetButton);
                this.valueSetButton = null;
            }
            if (this.slider == null) {
                this.slider = new GSSliderPanel("", this::onValueChanged);
                this.add((GSPanel)this.slider);
            }
            this.updateSliderBounds();
        } else {
            if (this.slider != null) {
                this.remove((GSPanel)this.slider);
                this.slider = null;
            }
            if (this.textField == null) {
                this.textField = new GSTextField();
                this.add((GSPanel)this.textField);
            }
            if (this.valueSetButton == null) {
                this.valueSetButton = new GSButtonPanel(SET_VALUE_TEXT, this::onValueChanged);
                this.add((GSPanel)this.valueSetButton);
            }
            this.updateTextFieldBounds();
        }
        this.updateFieldValue();
    }

    private void updateSliderBounds() {
        int sy;
        int sx;
        int sw = Math.min(200, this.width - 4);
        int sh = 20;
        if (this.isSingleLine(this.width)) {
            sx = this.width - 2 - 48 - 2 - sw;
            sy = (this.height - sh) / 2;
        } else {
            sx = (this.width - sw) / 2;
            sy = this.height - 2 - sh;
        }
        this.slider.setBounds(sx, sy, sw, sh);
        this.slider.setEnabled(this.isSettingEnabled());
    }

    private void updateTextFieldBounds() {
        int ty;
        int tx;
        int tw = Math.min(196, this.width - 2 - 48 - 4);
        if (this.isSingleLine(this.width)) {
            tx = this.width - 2 - 96 - 4 - tw;
            ty = (this.height - 20) / 2;
        } else {
            tx = (this.width - tw - 2 - 48) / 2;
            ty = this.height - 2 - 20;
        }
        this.textField.setBounds(tx, ty, tw, 20);
        this.textField.setEditable(this.isSettingEnabled());
        int bx = this.textField.getX() + this.textField.getWidth() + 2;
        int by = ty + 0;
        this.valueSetButton.setBounds(bx, by, 48, 20);
    }

    private void onValueChanged() {
        if (this.isSliderActive()) {
            this.setValueFromSlider(this.slider.getValue());
            this.updateFieldValue();
        } else {
            String str = this.textField.getText();
            if (!str.equals(this.prevTextFieldValue)) {
                if (this.setValueFromTextField(str)) {
                    this.prevTextFieldValue = str;
                    this.updateFieldValue();
                } else {
                    this.textField.setText(this.prevTextFieldValue);
                }
            }
        }
    }

    protected abstract void setValueFromSlider(float var1);

    protected abstract boolean setValueFromTextField(String var1);

    protected abstract boolean shouldUseSlider();

    protected abstract void updateFieldValue();

    public void setSliderValue(float value) {
        if (this.slider != null) {
            this.slider.setValue(value);
        }
    }

    public void setSliderText(class_2561 text) {
        if (this.slider != null) {
            this.slider.setText(text);
        }
    }

    public void setTextFieldValue(String text) {
        if (this.textField != null) {
            this.prevTextFieldValue = text;
            this.textField.setText(this.prevTextFieldValue);
        }
    }

    @Override
    protected int getSettingHeight() {
        int h = super.getSettingHeight();
        if (!this.isSingleLine(this.width)) {
            h -= 2;
            h -= this.isSliderActive() ? 20 : 20;
        }
        return h;
    }

    @Override
    public void onSettingChanged() {
        super.onSettingChanged();
        this.updateFieldValue();
        if (this.slider != null) {
            this.slider.setEnabled(this.isSettingEnabled());
        }
        if (this.textField != null) {
            this.textField.setEditable(this.isSettingEnabled());
        }
        if (this.valueSetButton != null) {
            this.valueSetButton.setEnabled(this.isSettingEnabled());
        }
    }

    private boolean isSliderActive() {
        return this.slider != null;
    }
}

