/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.gui.setting;

import com.g4mesoft.gui.setting.GSSettingPanel;
import com.g4mesoft.setting.GSSettingCategory;
import com.g4mesoft.setting.types.GSBooleanSetting;
import com.g4mesoft.ui.panel.GSPanel;
import com.g4mesoft.ui.panel.legacy.GSToggleSwitchPanel;
import com.g4mesoft.ui.renderer.GSIRenderer2D;
import net.minecraft.class_124;
import net.minecraft.class_2561;

public class GSBooleanSettingPanel
extends GSSettingPanel<GSBooleanSetting> {
    private static final int SETTING_HEIGHT = Math.max(16, 16);
    private static final int TEXT_MAX_WIDTH = 140;
    private static final int TOGGLE_WIDTH = 30;
    private static final class_2561 ENABLED_TEXT = class_2561.method_43470((String)"enabled").method_27692(class_124.field_1060);
    private static final class_2561 DISABLED_TEXT = class_2561.method_43470((String)"disabled").method_27692(class_124.field_1061);
    private final GSToggleSwitchPanel switchWidget;

    public GSBooleanSettingPanel(GSSettingCategory category, GSBooleanSetting setting) {
        super(category, setting);
        this.switchWidget = new GSToggleSwitchPanel(this::updateSettingValue, setting.get().booleanValue());
        this.add((GSPanel)this.switchWidget);
    }

    public void updateSettingValue() {
        ((GSBooleanSetting)this.setting).set(this.switchWidget.isToggled());
    }

    @Override
    public void render(GSIRenderer2D renderer) {
        super.render(renderer);
        int ty = (this.getSettingHeight() - renderer.getTextHeight()) / 2;
        renderer.drawText(this.nameText, 2, ty, this.getTextColor());
    }

    @Override
    public int getPreferredWidth() {
        return super.getPreferredWidth() + 140 + 30 + 4;
    }

    @Override
    public int getPreferredHeight() {
        return Math.max(super.getPreferredHeight(), SETTING_HEIGHT + 4);
    }

    public void onResized(int oldWidth, int oldHeight) {
        int sx = this.width - 30 - 2 - 48 - 2;
        int sy = (this.height - 16) / 2;
        this.switchWidget.setPreferredBounds(sx, sy);
        this.switchWidget.setEnabled(this.isSettingEnabled());
    }

    @Override
    public void onSettingChanged() {
        super.onSettingChanged();
        this.switchWidget.setToggled(((GSBooleanSetting)this.setting).get().booleanValue());
        this.switchWidget.setEnabled(this.isSettingEnabled());
    }

    @Override
    public class_2561 getFormattedDefault() {
        return (Boolean)((GSBooleanSetting)this.setting).getDefault() != false ? ENABLED_TEXT : DISABLED_TEXT;
    }
}

