/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.gui.setting;

import com.g4mesoft.gui.setting.GSSettingPanel;
import com.g4mesoft.setting.GSISettingChangeListener;
import com.g4mesoft.setting.GSISettingPanelSupplier;
import com.g4mesoft.setting.GSSetting;
import com.g4mesoft.setting.GSSettingCategory;
import com.g4mesoft.setting.GSSettingManager;
import com.g4mesoft.setting.GSSettingMap;
import com.g4mesoft.ui.panel.GSDimension;
import com.g4mesoft.ui.panel.GSPanel;
import com.g4mesoft.ui.panel.GSPanelContext;
import com.g4mesoft.ui.panel.GSPanelUtil;
import com.g4mesoft.ui.panel.GSParentPanel;
import com.g4mesoft.ui.panel.scroll.GSIScrollable;
import com.g4mesoft.ui.renderer.GSIRenderer2D;
import com.g4mesoft.ui.util.GSMathUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5481;

@Environment(value=EnvType.CLIENT)
public class GSSettingsGUI
extends GSParentPanel
implements GSIScrollable,
GSISettingChangeListener {
    private static final int SETTING_CATEGORY_MARGIN = 5;
    private static final int CATEGORY_TITLE_MARGIN_BOTTOM = 2;
    private static final int CATEGORY_TITLE_COLOR = -1;
    private static final int DESC_BACKGROUND_COLOR = Integer.MIN_VALUE;
    private static final int DESC_LINE_SPACING = 5;
    private static final int DESC_LINE_MARGIN = 10;
    private static final int DESC_TEXT_COLOR = -1;
    private static final float DESC_ANIMATION_TIME = 500.0f;
    private final Map<GSSettingCategory, GSSettingCategoryElement> settingCategories = new LinkedHashMap<GSSettingCategory, GSSettingCategoryElement>();
    private int settingsWidth;
    private GSSettingPanel<?> hoveredElement;
    private List<class_5481> descLines;
    private int startDescHeight;
    private int targetDescHeight;
    private long descAnimStart;

    public GSSettingsGUI(GSSettingManager settingManager) {
        for (GSSettingMap settingCategory : settingManager.getSettings()) {
            for (GSSetting<?> setting : settingCategory.getSettings()) {
                this.addSettingElement(settingCategory.getCategory(), setting);
            }
        }
        settingManager.addChangeListener(this);
    }

    private <T extends GSSetting<?>> void addSettingElement(GSSettingCategory category, T setting) {
        GSISettingPanelSupplier<T> supplier;
        if (setting.isActive() && setting.isVisibleInGui() && (supplier = GSSettingManager.getPanelSupplier(setting)) != null) {
            GSSettingCategoryElement categoryElement = this.settingCategories.get(category);
            if (categoryElement == null) {
                categoryElement = new GSSettingCategoryElement(category);
                this.settingCategories.put(category, categoryElement);
            }
            categoryElement.addSettingPanel(supplier.create(category, setting));
            this.invalidate();
        }
    }

    @Override
    public void onSettingChanged(GSSettingCategory category, GSSetting<?> setting) {
        GSSettingCategoryElement categoryElement = this.settingCategories.get(category);
        if (categoryElement != null) {
            categoryElement.onSettingChanged(setting);
        }
    }

    @Override
    public void onSettingAdded(GSSettingCategory category, GSSetting<?> setting) {
        this.addSettingElement(category, setting);
    }

    @Override
    public void onSettingRemoved(GSSettingCategory category, GSSetting<?> setting) {
        GSSettingCategoryElement categoryElement = this.settingCategories.get(category);
        if (categoryElement != null) {
            categoryElement.removeSetting(setting);
            if (categoryElement.isEmpty()) {
                this.settingCategories.remove(category);
            }
        }
        this.invalidate();
    }

    public void layout() {
        this.settingsWidth = this.width / 2;
        for (GSSettingCategoryElement element : this.settingCategories.values()) {
            int minElementWidth = element.getPreferredWidth();
            if (minElementWidth <= this.settingsWidth) continue;
            this.settingsWidth = minElementWidth;
        }
        int y = 0;
        for (GSSettingCategoryElement element : this.settingCategories.values()) {
            y += 5;
            y = element.layoutElements(0, y, this.settingsWidth);
            y += 5;
        }
    }

    public void render(GSIRenderer2D renderer) {
        int mouseX = renderer.getMouseX();
        int mouseY = renderer.getMouseY();
        GSSettingPanel<?> hoveredElement = null;
        for (GSSettingCategoryElement element : this.settingCategories.values()) {
            if (hoveredElement == null) {
                hoveredElement = element.getHoveredElement(mouseX, mouseY);
            }
            element.render(renderer);
        }
        super.render(renderer);
        if (hoveredElement != this.hoveredElement) {
            this.hoveredElement = hoveredElement;
            if (hoveredElement != null) {
                int descTextWidth = this.width - this.settingsWidth - 20;
                class_5250 desc = class_2561.method_43471((String)(hoveredElement.getNameTextKey() + ".desc"));
                class_5250 def = class_2561.method_43469((String)"setting.default", (Object[])new Object[]{hoveredElement.getFormattedDefault()});
                this.descLines = renderer.splitToLines((class_2561)desc.method_27693(" ").method_10852((class_2561)def), descTextWidth);
                int lineCount = this.descLines.size();
                int minimumDescHeight = lineCount * renderer.getTextHeight() + (lineCount - 1) * 5 + 20;
                this.targetDescHeight = Math.max(minimumDescHeight, hoveredElement.height);
                this.startDescHeight = hoveredElement.height;
                this.descAnimStart = class_156.method_658();
            } else {
                this.descLines = null;
            }
        }
        if (this.hoveredElement != null) {
            this.renderHoveredDesc(renderer, this.hoveredElement);
        }
    }

    private void renderHoveredDesc(GSIRenderer2D renderer, GSSettingPanel<?> hoveredElement) {
        long delta = class_156.method_658() - this.descAnimStart;
        float progress = Math.min(1.0f, (float)delta / 500.0f);
        progress = 1.0f - (float)Math.pow(1.0 - (double)progress, 3.0);
        int descHeight = this.startDescHeight + Math.round((float)(this.targetDescHeight - this.startDescHeight) * progress);
        int descWidth = this.width - this.settingsWidth;
        int descX = this.settingsWidth;
        int scrollOffset = GSPanelUtil.getScrollY((GSPanel)this);
        int viewHeight = GSPanelUtil.getViewportSize((GSPanel)this).getHeight();
        int descY = GSMathUtil.clamp((int)hoveredElement.y, (int)scrollOffset, (int)(viewHeight + scrollOffset - descHeight));
        if (descWidth > 0 && descHeight > 0 && this.targetDescHeight != 0) {
            renderer.fillRect(descX, descY, descWidth, descHeight, Integer.MIN_VALUE);
            int alpha = GSMathUtil.clamp((int)((int)(progress * 128.0f + 127.0f)), (int)0, (int)255) << 24;
            int y = descY + 10;
            for (class_5481 line : this.descLines) {
                if (y + renderer.getTextHeight() > descY + descHeight) break;
                renderer.drawText(line, descX + 10, y, 0xFFFFFF | alpha);
                y += renderer.getTextHeight() + 5;
            }
        }
    }

    protected GSDimension calculatePreferredSize() {
        int w = 0;
        int h = 0;
        for (GSSettingCategoryElement element : this.settingCategories.values()) {
            w = Math.max(w, element.getPreferredWidth());
            h += element.getPreferredHeight() + 10;
        }
        return new GSDimension(w, h);
    }

    public boolean isScrollableWidthFilled() {
        return true;
    }

    private class GSSettingCategoryElement {
        private final class_2561 titleText;
        private final List<GSSettingPanel<?>> settings;
        private int x;
        private int y;
        private int width;
        private int height;

        public GSSettingCategoryElement(GSSettingCategory category) {
            this.titleText = class_2561.method_43471((String)("setting." + category.getName()));
            this.settings = new LinkedList();
        }

        public int getPreferredWidth() {
            int minimumWidth = 0;
            for (GSSettingPanel<?> element : this.settings) {
                if (element.getPreferredWidth() <= minimumWidth) continue;
                minimumWidth = element.getPreferredWidth();
            }
            return minimumWidth;
        }

        public int getPreferredHeight() {
            GSIRenderer2D renderer = GSPanelContext.getRenderer();
            int h = 0;
            h += renderer.getTextHeight();
            h += 2;
            for (GSSettingPanel<?> element : this.settings) {
                h += element.getPreferredHeight();
            }
            return h;
        }

        public void addSettingPanel(GSSettingPanel<?> panel) {
            this.settings.add(panel);
            GSSettingsGUI.this.add((GSPanel)panel);
        }

        public void removeSetting(GSSetting<?> setting) {
            Iterator<GSSettingPanel<?>> settingItr = this.settings.iterator();
            while (settingItr.hasNext()) {
                GSSettingPanel<?> panel = settingItr.next();
                if (panel.getSetting() != setting) continue;
                GSSettingsGUI.this.remove((GSPanel)panel);
                settingItr.remove();
            }
        }

        public void onSettingChanged(GSSetting<?> setting) {
            for (GSSettingPanel<?> element : this.settings) {
                if (!element.getSetting().getName().equals(setting.getName())) continue;
                element.onSettingChanged();
                break;
            }
        }

        public int layoutElements(int x, int y, int width) {
            this.x = x;
            this.y = y;
            this.width = width;
            GSIRenderer2D renderer = GSPanelContext.getRenderer();
            y += renderer.getTextHeight();
            y += 2;
            for (GSSettingPanel<?> element : this.settings) {
                element.setPreferredBounds(x, y, width);
                y += element.height;
            }
            this.height = y - this.y;
            return y;
        }

        public GSSettingPanel<?> getHoveredElement(int mouseX, int mouseY) {
            if (!this.isHovered(mouseX, mouseY)) {
                return null;
            }
            for (GSSettingPanel<?> element : this.settings) {
                if (!element.isInBounds(mouseX, mouseY)) continue;
                return element;
            }
            return null;
        }

        public boolean isHovered(int mouseX, int mouseY) {
            return mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height;
        }

        public void render(GSIRenderer2D renderer) {
            renderer.drawCenteredText(this.titleText, this.x + this.width / 2, this.y, -1);
        }

        public boolean isEmpty() {
            return this.settings.isEmpty();
        }
    }
}

