/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.hotkey;

import com.g4mesoft.hotkey.GSEKeyEventType;
import com.g4mesoft.hotkey.GSIKeyBindingListener;
import com.g4mesoft.hotkey.GSKeyCode;
import com.g4mesoft.hotkey.GSKeyManager;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3675;

public class GSKeyBinding {
    private final GSKeyManager manager;
    private final String name;
    private final String category;
    private final GSKeyCode defaultKeyCode;
    private final boolean allowDisabled;
    private int priority;
    private GSKeyCode keyCode;
    private boolean[] keyStates;
    private int pressedCount;
    private GSIKeyBindingListener listener;

    public GSKeyBinding(GSKeyManager manager, String name, String category, GSKeyCode defaultKeyCode, boolean allowDisabled, int priority) {
        this.manager = manager;
        this.name = name;
        this.category = category;
        this.defaultKeyCode = defaultKeyCode;
        this.allowDisabled = allowDisabled;
        this.priority = priority;
        this.keyCode = defaultKeyCode;
        this.keyStates = new boolean[this.keyCode.getKeyCount()];
        this.pressedCount = 0;
        this.listener = null;
    }

    public void setKeyListener(GSIKeyBindingListener listener) {
        if (this.listener != null) {
            throw new IllegalStateException("The listener for this key binding is already set!");
        }
        this.listener = listener;
    }

    void reset() {
        for (int i = 0; i < this.keyStates.length; ++i) {
            this.keyStates[i] = false;
        }
        this.pressedCount = 0;
    }

    void onKeyPressed(class_3675.class_306 key) {
        int count = 0;
        for (int i = 0; i < this.keyCode.getKeyCount(); ++i) {
            if (this.keyCode.get(i) == key) {
                this.keyStates[i] = true;
            }
            if (!this.keyStates[i]) continue;
            ++count;
        }
        this.onKeyStateChanged(count);
    }

    void onKeyReleased(class_3675.class_306 key) {
        int count = 0;
        for (int i = 0; i < this.keyCode.getKeyCount(); ++i) {
            if (this.keyCode.get(i) == key) {
                this.keyStates[i] = false;
            }
            if (!this.keyStates[i]) continue;
            ++count;
        }
        this.onKeyStateChanged(count);
    }

    private void onKeyStateChanged(int count) {
        boolean wasPressed = this.isPressed();
        this.pressedCount = count;
        if (this.isPressed() != wasPressed) {
            this.manager.scheduleEvent(this);
        }
    }

    void dispatchKeyEvent(GSEKeyEventType eventType) {
        GSIKeyBindingListener listener = this.listener;
        if (listener != null) {
            class_310 client = class_310.method_1551();
            if (client.method_18854()) {
                listener.onKeyStateChanged(this, eventType);
            } else {
                client.execute(() -> listener.onKeyStateChanged(this, eventType));
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getCategory() {
        return this.category;
    }

    public GSKeyCode getDefaultKeyCode() {
        return this.defaultKeyCode;
    }

    public GSKeyCode getKeyCode() {
        return this.keyCode;
    }

    public void setKeyCode(GSKeyCode keyCode) {
        if (!this.allowDisabled && keyCode == GSKeyCode.UNKNOWN_KEY) {
            keyCode = this.defaultKeyCode;
        }
        GSKeyCode oldKeyCode = this.keyCode;
        this.keyCode = keyCode;
        this.keyStates = new boolean[keyCode.getKeyCount()];
        this.reset();
        this.manager.onKeyCodeChanged(this, oldKeyCode, keyCode);
    }

    public class_2561 getLocalizedName() {
        return this.keyCode.getLocalizedText();
    }

    public boolean isAnyPressed() {
        return this.pressedCount != 0;
    }

    public boolean isPressed() {
        return this.pressedCount == this.keyCode.getKeyCount();
    }

    public void setPriority(int priority) {
        if (priority < 0) {
            throw new IllegalArgumentException("priority must be non-negative");
        }
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }
}

