/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.hotkey;

import com.g4mesoft.hotkey.GSEKeyEventType;
import com.g4mesoft.hotkey.GSIKeyBindingListener;
import com.g4mesoft.hotkey.GSIKeyBindingRegisterListener;
import com.g4mesoft.hotkey.GSKeyBinding;
import com.g4mesoft.hotkey.GSKeyCode;
import com.g4mesoft.util.GSFileUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11908;
import net.minecraft.class_11910;
import net.minecraft.class_3675;

@Environment(value=EnvType.CLIENT)
public class GSKeyManager {
    private final Map<String, Map<String, GSKeyCode>> keySettings = new HashMap<String, Map<String, GSKeyCode>>();
    private final List<GSKeyBinding> keyBindings = new ArrayList<GSKeyBinding>();
    private final Map<class_3675.class_306, LinkedList<GSKeyBinding>> codeToKeys = new HashMap<class_3675.class_306, LinkedList<GSKeyBinding>>();
    private final LinkedList<GSKeyBinding> eventQueue = new LinkedList();
    private int queuePriority = 0;
    private GSIKeyBindingRegisterListener registerListener;

    public void dispose() {
        this.keySettings.clear();
        this.keyBindings.clear();
        this.codeToKeys.clear();
    }

    public void loadKeys(File keySettingsFile) {
        try (BufferedReader br = new BufferedReader(new FileReader(keySettingsFile));){
            String line;
            block9: while ((line = br.readLine()) != null) {
                String[] keyArgs;
                String[] args = line.split(":");
                if (args.length != 3 || (keyArgs = args[2].split(",")).length == 0) continue;
                class_3675.class_306[] keys = new class_3675.class_306[keyArgs.length];
                for (int i = 0; i < keyArgs.length; ++i) {
                    try {
                        keys[i] = class_3675.method_15981((String)keyArgs[i]);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        continue block9;
                    }
                }
                this.setKeySetting(args[0], args[1], GSKeyCode.fromKeys(keys));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void saveKeys(File keySettingsFile) {
        try {
            GSFileUtil.ensureFileExists(keySettingsFile);
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(keySettingsFile));){
                for (Map.Entry<String, Map<String, GSKeyCode>> categorySettings : this.keySettings.entrySet()) {
                    String category = categorySettings.getKey();
                    for (Map.Entry<String, GSKeyCode> setting : categorySettings.getValue().entrySet()) {
                        bw.write(category);
                        bw.write(58);
                        bw.write(setting.getKey());
                        bw.write(58);
                        GSKeyCode keyCode = setting.getValue();
                        for (int i = 0; i < keyCode.getKeyCount(); ++i) {
                            if (i != 0) {
                                bw.write(44);
                            }
                            bw.write(keyCode.get(i).method_1441());
                        }
                        bw.newLine();
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GSKeyCode getKeySetting(String category, String keyName) {
        Map<String, Map<String, GSKeyCode>> map = this.keySettings;
        synchronized (map) {
            Map<String, GSKeyCode> categorySettings = this.keySettings.get(category);
            return categorySettings == null ? null : categorySettings.get(keyName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setKeySetting(String category, String keyName, GSKeyCode keyCode) {
        Map<String, Map<String, GSKeyCode>> map = this.keySettings;
        synchronized (map) {
            Map<String, GSKeyCode> categorySettings = this.keySettings.get(category);
            if (categorySettings == null) {
                categorySettings = new HashMap<String, GSKeyCode>();
                this.keySettings.put(category, categorySettings);
            }
            categorySettings.put(keyName, keyCode);
        }
    }

    public GSKeyBinding registerKey(String name, String category, int keyCode, Runnable listener, GSEKeyEventType eventType) {
        return this.registerKey(name, category, keyCode, listener, eventType, true);
    }

    public GSKeyBinding registerKey(String name, String category, int keyCode, Runnable listener, GSEKeyEventType eventType, boolean allowDisabled) {
        return this.registerKey(name, category, GSKeyCode.fromType(class_3675.class_307.field_1668, keyCode), listener, eventType, allowDisabled);
    }

    public GSKeyBinding registerKey(String name, String category, GSKeyCode keyCode, Runnable listener, GSEKeyEventType eventType) {
        return this.registerKey(name, category, keyCode, listener, eventType, true);
    }

    public GSKeyBinding registerKey(String name, String category, GSKeyCode keyCode, Runnable listener, GSEKeyEventType eventType, boolean allowDisabled) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        return this.registerKeyImpl(name, category, keyCode, (key, type) -> {
            if (type == eventType) {
                listener.run();
            }
        }, allowDisabled);
    }

    public <T> GSKeyBinding registerKey(String name, String category, int keyCode, T listenerData, Consumer<T> listener, GSEKeyEventType eventType) {
        return this.registerKey(name, category, keyCode, listenerData, listener, eventType, true);
    }

    public <T> GSKeyBinding registerKey(String name, String category, int keyCode, T listenerData, Consumer<T> listener, GSEKeyEventType eventType, boolean allowDisabled) {
        return this.registerKey(name, category, GSKeyCode.fromType(class_3675.class_307.field_1668, keyCode), listenerData, listener, eventType, allowDisabled);
    }

    public <T> GSKeyBinding registerKey(String name, String category, GSKeyCode keyCode, T listenerData, Consumer<T> listener, GSEKeyEventType eventType) {
        return this.registerKey(name, category, keyCode, listenerData, listener, eventType, true);
    }

    public <T> GSKeyBinding registerKey(String name, String category, GSKeyCode keyCode, T listenerData, Consumer<T> listener, GSEKeyEventType eventType, boolean allowDisabled) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        return this.registerKeyImpl(name, category, keyCode, (key, type) -> {
            if (type == eventType) {
                listener.accept(listenerData);
            }
        }, allowDisabled);
    }

    public GSKeyBinding registerKey(String name, String category, GSKeyCode keyCode) {
        return this.registerKey(name, category, keyCode, true);
    }

    public GSKeyBinding registerKey(String name, String category, GSKeyCode keyCode, boolean allowDisabled) {
        return this.registerKeyImpl(name, category, keyCode, null, allowDisabled);
    }

    private GSKeyBinding registerKeyImpl(String name, String category, GSKeyCode keyCode, GSIKeyBindingListener listener, boolean allowDisabled) {
        if (name.contains(":") || category.contains(":")) {
            throw new IllegalArgumentException("Invalid name or category! It must not contains ':'!");
        }
        GSKeyBinding keyBinding = new GSKeyBinding(this, name, category, keyCode, allowDisabled, 0);
        keyBinding.setKeyListener(listener);
        this.addKeyBinding(keyBinding);
        if (this.registerListener != null) {
            this.registerListener.onKeyRegistered(keyBinding);
        }
        return keyBinding;
    }

    private void addKeyBinding(GSKeyBinding keyBinding) {
        this.keyBindings.add(keyBinding);
        this.addKeyCodeMapping(keyBinding);
        GSKeyCode keyCodeSetting = this.getKeySetting(keyBinding.getCategory(), keyBinding.getName());
        if (keyCodeSetting != null) {
            keyBinding.setKeyCode(keyCodeSetting);
        } else {
            this.setKeySetting(keyBinding.getCategory(), keyBinding.getName(), keyBinding.getKeyCode());
        }
    }

    public void setKeyRegisterListener(GSIKeyBindingRegisterListener registerListener) {
        this.registerListener = registerListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleKeyEvent(class_3675.class_306 key, BiConsumer<GSKeyBinding, class_3675.class_306> eventMethod) {
        Map<class_3675.class_306, LinkedList<GSKeyBinding>> map = this.codeToKeys;
        synchronized (map) {
            List keyBindings = this.codeToKeys.get(key);
            if (keyBindings != null) {
                for (GSKeyBinding keyBinding : keyBindings) {
                    eventMethod.accept(keyBinding, key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onKeyCodeChanged(GSKeyBinding keyBinding, GSKeyCode oldKeyCode, GSKeyCode keyCode) {
        Map<class_3675.class_306, LinkedList<GSKeyBinding>> map = this.codeToKeys;
        synchronized (map) {
            for (int i = 0; i < oldKeyCode.getKeyCount(); ++i) {
                class_3675.class_306 key = oldKeyCode.get(i);
                List keysWithOldCode = this.codeToKeys.get(key);
                if (keysWithOldCode == null) continue;
                keysWithOldCode.remove(keyBinding);
                if (!keysWithOldCode.isEmpty()) continue;
                this.codeToKeys.remove(key);
            }
        }
        this.addKeyCodeMapping(keyBinding);
        this.setKeySetting(keyBinding.getCategory(), keyBinding.getName(), keyCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addKeyCodeMapping(GSKeyBinding keyBinding) {
        Map<class_3675.class_306, LinkedList<GSKeyBinding>> map = this.codeToKeys;
        synchronized (map) {
            GSKeyCode keyCode = keyBinding.getKeyCode();
            for (int i = 0; i < keyCode.getKeyCount(); ++i) {
                class_3675.class_306 key = keyCode.get(i);
                LinkedList<GSKeyBinding> keysWithCode = this.codeToKeys.get(key);
                if (keysWithCode == null) {
                    keysWithCode = new LinkedList();
                    this.codeToKeys.put(key, keysWithCode);
                }
                keysWithCode.add(keyBinding);
            }
        }
    }

    public void onKeyPressed(class_11908 input) {
        this.handleKeyEvent(class_3675.method_15985((class_11908)input), GSKeyBinding::onKeyPressed);
    }

    public void onKeyReleased(class_11908 input) {
        this.handleKeyEvent(class_3675.method_15985((class_11908)input), GSKeyBinding::onKeyReleased);
    }

    public void onMousePressed(class_11910 input) {
        this.handleKeyEvent(class_3675.class_307.field_1672.method_1447(input.comp_4801()), GSKeyBinding::onKeyPressed);
    }

    public void onMouseReleased(class_11910 input) {
        this.handleKeyEvent(class_3675.class_307.field_1672.method_1447(input.comp_4801()), GSKeyBinding::onKeyReleased);
    }

    public void clearEventQueue() {
        this.eventQueue.clear();
        this.queuePriority = 0;
    }

    public void scheduleEvent(GSKeyBinding keyBinding) {
        int priority = keyBinding.getPriority();
        if (priority >= this.queuePriority) {
            if (priority > this.queuePriority) {
                this.eventQueue.clear();
            }
            this.eventQueue.add(keyBinding);
            this.queuePriority = priority;
        }
    }

    public void dispatchEvents(GSEKeyEventType eventType) {
        GSKeyBinding keyBinding;
        while ((keyBinding = this.eventQueue.poll()) != null) {
            keyBinding.dispatchKeyEvent(eventType);
        }
        this.clearEventQueue();
    }

    public List<GSKeyBinding> getKeyBindings() {
        return this.keyBindings;
    }
}

